/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.gene.Attrib;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;

public class AttribTable
implements PogoDefs {
    public Vector vect = new Vector();

    public AttribTable() {
    }

    public AttribTable(Vector v_in) {
        int i = 0;
        while (i < v_in.size()) {
            this.vect.addElement(v_in.elementAt(i));
            ++i;
        }
    }

    public AttribTable(String filename, int lang) throws FileNotFoundException, SecurityException, IOException, PogoException {
        FileInputStream fidin = new FileInputStream(filename);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        int start = pgs.str.indexOf("attribute_factory(");
        if (start < 0) {
            return;
        }
        PogoString block = new PogoString(pgs.extractMethodCore(start));
        start = 0;
        String patern = "Attr(\"";
        while ((start = block.str.indexOf(patern, start)) >= 0) {
            Attrib attr;
            int xSize;
            start = block.str.lastIndexOf("\n", start);
            int end = block.str.indexOf("(", start) + 1;
            String constructor = block.str.substring(start, end);
            start = end;
            end = block.str.indexOf(")", start);
            PogoString s = new PogoString(block.str.substring(start, end));
            String[] params = s.getParams();
            if (constructor.indexOf("Image") >= 0) {
                xSize = new Integer(params[2]);
                int ySize = new Integer(params[3]);
                attr = new Attrib(params[0], 2, params[1], xSize, ySize);
            } else if (constructor.indexOf("Spectrum") >= 0) {
                xSize = new Integer(params[2]);
                attr = new Attrib(params[0], 1, params[1], xSize);
            } else {
                int type = 0;
                int i = 0;
                while (i < PogoDefs.AttrRWtypeArray.length) {
                    String target = lang == 1 ? new String("AttrWriteType." + PogoDefs.AttrRWtypeArray[i]) : new String(PogoDefs.cppNameSpace + PogoDefs.AttrRWtypeArray[i]);
                    if (params[2].equals(target)) {
                        type = i;
                    }
                    ++i;
                }
                attr = params.length == 4 && type == 3 ? new Attrib(params[0], 0, params[1], type, params[3]) : new Attrib(params[0], 0, params[1], type, "");
            }
            attr.getDefaultProperties(block);
            this.vect.addElement(attr);
        }
    }

    public void addElement(Attrib st) {
        this.vect.addElement(st);
    }

    public Attrib elementAt(int idx) {
        return (Attrib)this.vect.elementAt(idx);
    }

    public int size() {
        return this.vect.size();
    }

    public String buildFactory(int lang) {
        String tab = lang == 1 ? "\t" : "";
        StringBuffer sb = new StringBuffer(tab + "{\n");
        String addKeyWord = lang == 1 ? PogoDefs.javaAddAttrib : PogoDefs.cppAddAttrib;
        int i = 0;
        while (i < this.size()) {
            Attrib attr = this.elementAt(i);
            sb.append(tab + "\t" + "//\tAttribute : " + attr.name + "\n");
            sb.append(attr.buitCodeForAttributeConstructor(lang));
            sb.append(attr.buitCodeForDefaultProperties(lang));
            sb.append(tab + "\t" + addKeyWord + "(" + attr.getLowerName() + ");\n\n");
            ++i;
        }
        sb.append(tab + "}\n");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < this.vect.size()) {
            Attrib attr = (Attrib)this.vect.elementAt(i);
            sb.append(attr.name + "\t");
            sb.append(attr.dataType.cpp_code_str + "\n");
            ++i;
        }
        return sb.toString();
    }
}

