/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.Tango.DispLevel;
import pogo.gene.PogoDefs;
import pogo.gene.PogoString;
import pogo.gene.TangoTypes;

public class Attrib
implements PogoDefs {
    public String name;
    public int attrType;
    public TangoTypes dataType;
    public int rwType;
    public String assAttr;
    public int xSize;
    public int ySize;
    public DispLevel disp_level = DispLevel.OPERATOR;
    public int polled_period = 0;
    public String[] properties;
    private String[] def_prop_method = new String[]{"set_label", "set_unit", "set_standard_unit", "set_display_unit", "set_format", "set_max_value", "set_min_value", "set_max_alarm", "set_min_alarm", "set_description"};
    private String set_def_prop_method = "set_default_properties";

    public String getLowerName() {
        PogoString pgs = new PogoString(this.name);
        return pgs.toLowerString();
    }

    public Attrib(String name, String dataType, int rwType) {
        this.name = new String(name);
        this.dataType = new TangoTypes(dataType, "");
        this.rwType = rwType;
        this.properties = new String[10];
    }

    public Attrib(String name, int attrType, String dataType, int rwType, String assAttr) {
        if (attrType == 0) {
            this.name = new String(name);
            this.attrType = attrType;
            this.dataType = new TangoTypes(dataType, "");
            this.rwType = rwType;
            this.assAttr = new String(assAttr);
            this.xSize = 1;
            this.ySize = 1;
            this.properties = new String[10];
        } else {
            System.out.println("BAD USAGE OF SCALAR ATTRIBUTE CONSTRUCTOR");
        }
    }

    public Attrib(String name, int attrType, String dataType, int xSize) {
        if (attrType == 1) {
            this.name = new String(name);
            this.attrType = attrType;
            this.dataType = new TangoTypes(dataType, "");
            this.rwType = 0;
            this.xSize = xSize;
            this.ySize = 1;
            this.assAttr = "";
            this.properties = new String[10];
        } else {
            System.out.println("BAD USAGE OF SPECTRUM ATTRIBUTE CONSTRUCTOR");
        }
    }

    public Attrib(String name, int attrType, String dataType, int xSize, int ySize) {
        if (attrType == 2) {
            this.name = new String(name);
            this.attrType = attrType;
            this.dataType = new TangoTypes(dataType, "");
            this.rwType = 0;
            this.xSize = xSize;
            this.ySize = ySize;
            this.assAttr = "";
            this.properties = new String[10];
        } else {
            System.out.println("BAD USAGE OF IMAGE ATTRIBUTE CONSTRUCTOR");
        }
    }

    public void setDataType(String dataType) {
        this.dataType = new TangoTypes(dataType, "");
    }

    public void setDataType(String dataType, int lang) {
        this.dataType = new TangoTypes(dataType);
    }

    public boolean getWritable() {
        return this.attrType == 0 && this.rwType != 0 && this.rwType != 3;
    }

    public String cppMemberData() {
        StringBuffer sb = new StringBuffer("\t\t" + this.dataType.cpp);
        sb.append("\t*attr_" + this.name + "_read;\n");
        if (this.attrType == 0 && this.rwType != 0 && this.rwType != 3) {
            sb.append("\t\t" + this.dataType.cpp + "\tattr_" + this.name + "_write;\n");
        }
        return sb.toString();
    }

    public String javaMemberData() {
        StringBuffer sb = new StringBuffer("\tprotected " + this.dataType.java + "[]");
        sb.append("\tattr_" + this.name + "_read " + "= new " + this.dataType.java);
        switch (this.attrType) {
            case 0: {
                sb.append("[1];\n");
                break;
            }
            case 1: {
                sb.append("[" + this.xSize + "];\n");
                break;
            }
            case 2: {
                sb.append("[" + this.xSize * this.ySize + "];\n");
            }
        }
        if (this.attrType == 0 && this.rwType != 0 && this.rwType != 3) {
            sb.append("\tprotected " + this.dataType.java + "\tattr_" + this.name + "_write;\n");
        }
        return sb.toString();
    }

    public String buitCodeForAttributeConstructor(int lang) {
        String[] att_type = new String[]{"Attr", "SpectrumAttr", "ImageAttr"};
        String namespace = lang == 1 ? "" : PogoDefs.cppNameSpace;
        String tab = lang == 1 ? "\t" : "";
        String pointer = lang == 1 ? "" : "*";
        String argtype = lang == 1 ? this.dataType.java_code_str : this.dataType.cpp_code_str;
        StringBuffer sb = new StringBuffer("\t" + tab + namespace);
        sb.append(att_type[this.attrType] + "\t" + pointer + this.getLowerName() + " = \n");
        sb.append(tab + "\t\t" + "new " + namespace + att_type[this.attrType] + "(");
        sb.append("\"" + this.name + "\", " + argtype + ", ");
        switch (this.attrType) {
            case 0: {
                if (lang == 1) {
                    namespace = "AttrWriteType.";
                }
                sb.append(namespace + PogoDefs.AttrRWtypeArray[this.rwType]);
                if (this.rwType != 3) break;
                sb.append(", \"" + this.assAttr + "\"");
                break;
            }
            case 1: {
                sb.append(this.xSize);
                break;
            }
            case 2: {
                sb.append(this.xSize + ", " + this.ySize);
            }
        }
        sb.append(");\n");
        return sb.toString();
    }

    public String buitCodeForDefaultProperties(int lang) {
        String pointer;
        String tab = lang == 1 ? "\t" : "";
        boolean has_been_set = false;
        int i = 0;
        while (i < this.properties.length) {
            if (this.properties[i] != null && this.properties[i].length() > 0) {
                has_been_set = true;
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer("");
        String string = pointer = lang == 1 ? "." : "->";
        if (has_been_set) {
            String namespace = lang == 1 ? "" : PogoDefs.cppNameSpace;
            sb.append(tab + "\t" + namespace + "UserDefaultAttrProp\t" + this.getLowerName() + "_prop");
            if (lang == 1) {
                sb.append(" = new UserDefaultAttrProp()");
            }
            sb.append(";\n");
            int i2 = 0;
            while (i2 < this.def_prop_method.length) {
                if (this.properties[i2] != null && this.properties[i2].length() > 0) {
                    sb.append(tab + "\t" + this.getLowerName() + "_prop." + this.def_prop_method[i2] + "(\"" + this.properties[i2] + "\");\n");
                }
                ++i2;
            }
            sb.append(tab + "\t" + this.getLowerName() + pointer + this.set_def_prop_method + "(" + this.getLowerName() + "_prop);\n");
        }
        if (lang != 1) {
            if (this.polled_period > 0) {
                sb.append(tab + "\t" + this.getLowerName() + pointer + "set_polling_period(" + this.polled_period + ");\n");
            }
            if (this.disp_level == DispLevel.EXPERT) {
                sb.append(tab + "\t" + this.getLowerName() + pointer + "set_disp_level(Tango::EXPERT);\n");
            }
        }
        return sb.toString();
    }

    public void getDefaultProperties(PogoString block) {
        String method;
        String prop_def = new String(this.getLowerName() + "_prop.");
        int start = 0;
        int end = 0;
        while ((start = block.str.indexOf(prop_def, end)) > 0) {
            end = block.nextCr(start);
            int start1 = start + prop_def.length();
            int end1 = block.str.indexOf("(", start1);
            method = block.str.substring(start1, end1);
            start1 = block.str.indexOf("\"", end1) + 1;
            end1 = block.str.indexOf("\"", start1);
            String value = block.str.substring(start1, end1);
            int i = 0;
            while (i < this.def_prop_method.length) {
                if (method.equals(this.def_prop_method[i])) {
                    this.properties[i] = value;
                }
                ++i;
            }
        }
        String code = block.str;
        method = this.getLowerName() + "->set_polling_period(";
        start = code.indexOf(method);
        if (start > 0) {
            this.polled_period = Integer.parseInt(code.substring(start += method.length(), code.indexOf(")", start)));
        }
        if ((start = code.indexOf(method = this.getLowerName() + "->set_disp_level(")) > 0) {
            String strlevel;
            this.disp_level = (strlevel = code.substring(start += method.length(), code.indexOf(")", start))).indexOf("EXPERT") > 0 ? DispLevel.EXPERT : DispLevel.OPERATOR;
        }
    }

    public String toString() {
        return this.name;
    }
}

