/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pogo.appli.PogoAppliDefs;
import pogo.appli.StateDialog;
import pogo.gene.PogoDefs;
import pogo.gene.Property;

public class PropertyDialog
extends JDialog
implements PogoAppliDefs,
PogoDefs {
    private static int returnStatus = 0;
    private JPanel jPanel1;
    private JButton okBtn;
    private JButton cancelBtn;
    private JPanel jPanel2;
    private JLabel nameLbl;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JTextArea descText;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JTextField nameText;

    public PropertyDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        int i = 1;
        while (i < PogoAppliDefs.TangoPropertyTypesArray.length) {
            this.jComboBox1.addItem(PogoAppliDefs.TangoPropertyTypesArray[i]);
            ++i;
        }
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.nameLbl = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.descText = new JTextArea();
        this.jComboBox1 = new JComboBox();
        this.jLabel1 = new JLabel();
        this.nameText = new JTextField();
        this.setBackground(new Color(198, 178, 168));
        this.setTitle("Edit Property Window");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PropertyDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2, 5, 5));
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertyDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new GridBagLayout());
        this.nameLbl.setText("Property type");
        this.nameLbl.setForeground(Color.black);
        this.nameLbl.setFont(new Font("Dialog", 1, 11));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.nameLbl, gridBagConstraints1);
        this.jLabel5.setText(" ");
        this.jLabel5.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 6;
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints1);
        this.jLabel6.setText("Property Description:  ");
        this.jLabel6.setForeground(Color.black);
        this.jLabel6.setFont(new Font("Dialog", 1, 11));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 8;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints1);
        this.descText.setPreferredSize(new Dimension(450, 200));
        this.descText.setMinimumSize(new Dimension(0, 100));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 9;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.gridheight = 5;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weighty = 5.0;
        this.jPanel2.add((Component)this.descText, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 2;
        this.jPanel2.add((Component)this.jComboBox1, gridBagConstraints1);
        this.jLabel1.setText("Property name");
        this.jLabel1.setForeground(Color.black);
        this.jLabel1.setFont(new Font("Dialog", 1, 11));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        this.jPanel2.add((Component)this.nameText, gridBagConstraints1);
        this.getContentPane().add((Component)this.jPanel2, "Center");
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        if (this.nameText.getText().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Property's name must be filled in !", "Error Window", 0);
        } else {
            this.doClose(1);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    public int showDialog(Property property) {
        if (property.type.code == 8) {
            property.type.cpp_code_str = new String("string");
        }
        this.nameText.setText(property.name);
        int i = 1;
        while (i < PogoAppliDefs.TangoPropertyTypesArray.length) {
            if (PogoAppliDefs.TangoPropertyTypesArray[i].equals(property.type.cpp_code_str)) {
                this.jComboBox1.setSelectedIndex(i - 1);
            }
            ++i;
        }
        if (property.description != null) {
            this.descText.setText(property.description);
        }
        this.setVisible(true);
        return returnStatus;
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public Property getInput() {
        StringTokenizer stk = new StringTokenizer(this.nameText.getText());
        String name = stk.nextToken();
        if (name.charAt(0) >= 'a' || name.charAt(0) >= 'z') {
            char car = (char)(name.charAt(0) - 32);
            name = new String(car + name.substring(1));
        }
        return new Property(name, this.jComboBox1.getSelectedItem().toString(), this.descText.getText());
    }

    public static void main(String[] args) {
        new StateDialog(new Frame(), false).show();
    }
}

