/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import pogo.appli.AttributeDialog;
import pogo.appli.ClassDialog;
import pogo.appli.CommandDialog;
import pogo.appli.EditPogoCode;
import pogo.appli.PogoAppliDefs;
import pogo.appli.PogoRenderer;
import pogo.appli.PropertyDialog;
import pogo.appli.StateDialog;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.DevState;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.Property;

public class PogoTree
extends JPanel
implements PogoAppliDefs,
PogoDefs {
    static String[] collec = new String[]{"Class  Properties", "Device Properties", "Commands", "Attributes", "States"};
    private JFrame frame;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private Vector cmdNodesVector;
    private Vector stNodesVector;
    private Vector attrNodesVector;
    private Vector devPropNodesVector;
    private Vector classPropNodesVector;
    private Vector cmdVector;
    private Vector stVector;
    private Vector attrVector;
    private Vector devPropVector;
    private Vector classPropVector;
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode cmdNode;
    private DefaultMutableTreeNode attrNode;
    private DefaultMutableTreeNode stNode;
    private DefaultMutableTreeNode devPropNode;
    private DefaultMutableTreeNode classPropNode;
    private TreePath selectedPath;
    private String class_name;
    private String classDesc;
    private String projTitle;
    private Object objCut;
    private String collecObjCut;
    private String homeDir;
    private int language;
    private boolean modified;
    private JPopupMenu pMenu = null;
    private JLabel[] mouseUsage;
    private Color background;

    public PogoTree(JFrame parent) {
        this.frame = parent;
        this.modified = false;
        this.root = new DefaultMutableTreeNode("Tango Device Server Super Class");
        this.classPropNode = new DefaultMutableTreeNode(collec[0]);
        this.devPropNode = new DefaultMutableTreeNode(collec[1]);
        this.cmdNode = new DefaultMutableTreeNode(collec[2]);
        this.attrNode = new DefaultMutableTreeNode(collec[3]);
        this.stNode = new DefaultMutableTreeNode(collec[4]);
        this.root.add(this.classPropNode);
        this.root.add(this.devPropNode);
        this.root.add(this.cmdNode);
        this.root.add(this.attrNode);
        this.root.add(this.stNode);
        this.background = new Color(255, 255, 204);
        this.setBackground(this.background);
        this.tree = new JTree(this.root);
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree.setModel(this.treeModel);
        this.tree.setBackground(this.background);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setFont(new Font("helvetica", 1, 12));
        this.setLayout(new FlowLayout());
        this.classPropNodesVector = new Vector();
        this.devPropNodesVector = new Vector();
        this.cmdNodesVector = new Vector();
        this.attrNodesVector = new Vector();
        this.stNodesVector = new Vector();
        this.classPropVector = new Vector();
        this.devPropVector = new Vector();
        this.cmdVector = new Vector();
        this.attrVector = new Vector();
        this.stVector = new Vector();
        this.tree.setCellRenderer(new PogoRenderer(collec, this.background, this.cmdVector, this.attrVector));
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PogoTree.this.treeMouseClicked(evt);
            }
        });
        this.add(this.tree);
        this.setVisible(true);
        this.pMenu = new JPopupMenu();
        this.pMenu.add("Create a new item of:");
        this.pMenu.add(new JPopupMenu.Separator());
        int i = 0;
        while (i < collec.length) {
            JMenuItem btn = new JMenuItem(collec[i]);
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    PogoTree.this.createActionPerformed(evt);
                }
            });
            this.pMenu.add(btn);
            ++i;
        }
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                PogoTree.this.frameMouseClicked(evt);
            }
        });
        this.frame.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                PogoTree.this.frameMouseClicked(evt);
            }
        });
    }

    public void setMouseUsageListener(JLabel leftLabel, JLabel rightLabel) {
        this.tree.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                PogoTree.this.treeMouseMoved(evt);
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent evt) {
                PogoTree.this.treeMouseExited(evt);
            }
        });
        this.mouseUsage = new JLabel[3];
        this.mouseUsage[0] = leftLabel;
        this.mouseUsage[1] = null;
        this.mouseUsage[2] = rightLabel;
    }

    private void treeMouseExited(MouseEvent evt) {
        this.mouseUsage[0].setText("  ");
        this.mouseUsage[2].setText("  ");
    }

    private int getCollectionNum(String collecName) {
        int i = 0;
        while (i < collec.length) {
            if (collecName.equals(collec[i].toString())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private void treeMouseMoved(MouseEvent evt) {
        Object[] path = this.tree.getClosestPathForLocation(evt.getX(), evt.getY()).getPath();
        String collName = null;
        int collNum = 0;
        if (path.length - 1 >= 1) {
            collName = path[1].toString();
            collNum = this.getCollectionNum(collName);
        }
        block0 : switch (path.length - 1) {
            case 0: {
                this.mouseUsage[0].setText("Open/Close Tree");
                this.mouseUsage[2].setText("Edit Class");
                break;
            }
            case 1: {
                if (this.getCollectionVector(collName).size() < 1) {
                    this.mouseUsage[0].setText("Not Available");
                } else {
                    this.mouseUsage[0].setText("Open/Close Collection");
                }
                this.mouseUsage[2].setText("Create a new item");
                break;
            }
            case 2: {
                switch (collNum) {
                    case 0: {
                        this.mouseUsage[0].setText("Edit Device Property");
                        this.mouseUsage[2].setText("Edit source code");
                        break block0;
                    }
                    case 1: {
                        this.mouseUsage[0].setText("Edit Device Property");
                        this.mouseUsage[2].setText("Edit source code");
                        break block0;
                    }
                    case 2: {
                        this.mouseUsage[0].setText("Edit Command");
                        this.mouseUsage[2].setText("Edit source code");
                        break block0;
                    }
                    case 3: {
                        this.mouseUsage[0].setText("Edit Attribute");
                        this.mouseUsage[2].setText("Edit source code");
                        break block0;
                    }
                    case 4: {
                        this.mouseUsage[0].setText("Edit State");
                        this.mouseUsage[2].setText("Not Available");
                        break block0;
                    }
                }
                this.mouseUsage[0].setText("  ");
                this.mouseUsage[2].setText("  ");
                break;
            }
            default: {
                this.mouseUsage[0].setText("  ");
                this.mouseUsage[2].setText("  ");
            }
        }
    }

    private void popupMessage(String mess) {
        JOptionPane.showMessageDialog(this.frame, mess, "Error Window", 0);
    }

    protected Vector getCollectionVector(String s) {
        int i = 0;
        while (i < collec.length) {
            if (s.equals(collec[i].toString())) {
                switch (i) {
                    case 0: {
                        return this.classPropNodesVector;
                    }
                    case 1: {
                        return this.devPropNodesVector;
                    }
                    case 2: {
                        return this.cmdNodesVector;
                    }
                    case 3: {
                        return this.attrNodesVector;
                    }
                    case 4: {
                        return this.stNodesVector;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    protected Vector getDataVector(String s) {
        int i = 0;
        while (i < collec.length) {
            if (s.equals(collec[i].toString())) {
                switch (i) {
                    case 0: {
                        return this.classPropVector;
                    }
                    case 1: {
                        return this.devPropVector;
                    }
                    case 2: {
                        return this.cmdVector;
                    }
                    case 3: {
                        return this.attrVector;
                    }
                    case 4: {
                        return this.stVector;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    protected DefaultMutableTreeNode getCollectionNode(String s) {
        int i = 0;
        while (i < collec.length) {
            if (s.equals(collec[i].toString())) {
                switch (i) {
                    case 0: {
                        return this.classPropNode;
                    }
                    case 1: {
                        return this.devPropNode;
                    }
                    case 2: {
                        return this.cmdNode;
                    }
                    case 3: {
                        return this.attrNode;
                    }
                    case 4: {
                        return this.stNode;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private int getItemInCollection(Vector leafVector, String s) {
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)leafVector.elementAt(0);
        int i = 0;
        while (i < leafVector.size()) {
            selNode = (DefaultMutableTreeNode)leafVector.elementAt(i);
            if (s.equals(selNode.toString())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void createNewLeaf(String colName, Object obj) {
        Vector leafVector = this.getCollectionVector(colName);
        Vector dataVector = this.getDataVector(colName);
        int idx = dataVector.size();
        if (leafVector != null && dataVector != null) {
            String name = obj.toString();
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(name);
            leafVector.addElement(node);
            dataVector.addElement(obj);
            this.treeModel.insertNodeInto(node, this.getCollectionNode(colName), idx);
            this.modified = true;
        } else {
            System.err.println("Couln't create leaf for\nCollection " + colName + ". Data: " + obj);
        }
    }

    public void removeLeaf(Vector leafVector, Vector dataVector, int vIdx) {
        this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)leafVector.elementAt(vIdx));
        leafVector.removeElementAt(vIdx);
        dataVector.removeElementAt(vIdx);
        this.tree.clearSelection();
        this.selectedPath = null;
        this.modified = true;
    }

    public void clear() {
        int i = 0;
        while (i < collec.length) {
            Vector leafVector = this.getCollectionVector(collec[i]);
            Vector dataVector = this.getDataVector(collec[i]);
            while (leafVector.size() > 0) {
                this.removeLeaf(leafVector, dataVector, 0);
            }
            ++i;
        }
        this.root.setUserObject("");
        this.classDesc = "";
        this.projTitle = "";
        this.modified = false;
    }

    private void modifyRootLeaf(String name, String desc, String title) {
        this.root.setUserObject(name);
        this.classDesc = new String(desc);
        this.projTitle = new String(title);
        this.modified = true;
    }

    public void editClassObject() {
        ClassDialog classDialog = new ClassDialog((Frame)this.frame, true);
        if (classDialog.showClassDialog(this.root.toString(), this.classDesc, this.projTitle) == 1) {
            this.classDesc = classDialog.getDescription();
            this.projTitle = classDialog.getProjectTitle();
            this.modifyRootLeaf(classDialog.getClassName(), this.classDesc, this.projTitle);
            this.modified = true;
        }
    }

    public void changeLeaf(Vector dataVector, Vector leafVector, int vIdx, Object newData) {
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)leafVector.elementAt(vIdx);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(newData);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent();
        this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)leafVector.elementAt(vIdx));
        leafVector.removeElementAt(vIdx);
        dataVector.removeElementAt(vIdx);
        this.treeModel.insertNodeInto(node, parent, vIdx);
        leafVector.insertElementAt(node, vIdx);
        dataVector.insertElementAt(newData, vIdx);
        this.modified = true;
    }

    private void editCollection() {
        Object[] path = this.selectedPath.getPath();
        if (path.length < 3) {
            return;
        }
        String collec = path[1].toString();
        Vector dataVector = this.getDataVector(collec);
        Vector leafVector = this.getCollectionVector(collec);
        if (leafVector == null) {
            System.err.println("--------> Parent's Node not found");
            return;
        }
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)leafVector.elementAt(0);
        String s1 = path[2].toString();
        int vIdx = 0;
        int i = 0;
        while (i < leafVector.size()) {
            selNode = (DefaultMutableTreeNode)leafVector.elementAt(i);
            if (s1.equals(selNode.toString())) {
                vIdx = i;
                break;
            }
            ++i;
        }
        if (dataVector == this.cmdVector) {
            Cmd cmd = (Cmd)this.cmdVector.elementAt(vIdx);
            if (cmd.virtual_method) {
                if (cmd.override_method == 2) {
                    JOptionPane.showMessageDialog(this.tree, "This command's method override a method from DeviceImpl class !\nYou cannot change it's signature !", "Info Window", 1);
                } else {
                    cmd.override_method = JOptionPane.showConfirmDialog(this, "This command's method is already defined in the DeviceImpl class !\n\nAre you sure to want to override it ?", "Info Window", 0) == 0 ? 1 : 0;
                }
            } else {
                this.editCommand(dataVector, leafVector, vIdx);
            }
        } else if (dataVector == this.attrVector) {
            this.editAttribute(dataVector, leafVector, vIdx);
        } else if (dataVector == this.stVector) {
            this.editState(dataVector, leafVector, vIdx);
        } else if (dataVector == this.devPropVector || dataVector == this.classPropVector) {
            this.editProperty(dataVector, leafVector, vIdx);
        }
    }

    private void editProperty(Vector dataVector, Vector leafVector, int vIdx) {
        Property newProp;
        PropertyDialog propDialog = new PropertyDialog((Frame)this.frame, true);
        Property property = (Property)dataVector.elementAt(vIdx);
        if (propDialog.showDialog(property) == 1 && !property.equals(newProp = propDialog.getInput())) {
            this.changeLeaf(dataVector, leafVector, vIdx, newProp);
            this.modified = true;
        }
    }

    private void editCommand(Vector dataVector, Vector leafVector, int vIdx) {
        Cmd newCmd;
        CommandDialog dialog = new CommandDialog((Frame)this.frame, true, this.stVector, this.cmdVector);
        Cmd cmd = (Cmd)dataVector.elementAt(vIdx);
        if (dialog.showDialog(cmd, vIdx) == 1 && !cmd.equals(newCmd = dialog.getInputCommand())) {
            if (cmd.command.equals(newCmd.command)) {
                newCmd.cmd_class = new String(cmd.cmd_class);
            }
            this.changeLeaf(dataVector, leafVector, vIdx, newCmd);
            this.modified = true;
        }
    }

    private void editAttribute(Vector dataVector, Vector leafVector, int vIdx) {
        Attrib newAttr;
        AttributeDialog dialog = new AttributeDialog((Frame)this.frame, true);
        Attrib attr = (Attrib)dataVector.elementAt(vIdx);
        if (dialog.showDialog(attr) == 1 && !attr.equals(newAttr = dialog.getInput())) {
            this.changeLeaf(dataVector, leafVector, vIdx, newAttr);
            this.modified = true;
        }
    }

    private void editState(Vector dataVector, Vector leafVector, int vIdx) {
        DevState newState;
        StateDialog dialog = new StateDialog((Frame)this.frame, true);
        DevState state = (DevState)dataVector.elementAt(vIdx);
        if (dialog.showStateDialog(state) == 1 && !state.equals(newState = dialog.getInput())) {
            this.changeLeaf(dataVector, leafVector, vIdx, newState);
            this.modified = true;
        }
    }

    public boolean isLeafSelected() {
        Vector leafVector;
        int vIdx;
        if (this.tree.isSelectionEmpty()) {
            return false;
        }
        if (this.selectedPath == null) {
            return false;
        }
        if (this.selectedPath.getPathCount() < 3) {
            return false;
        }
        Object[] path = this.selectedPath.getPath();
        String collName = path[1].toString();
        int collNum = this.getCollectionNum(collName);
        return collNum != 2 || (vIdx = this.getItemInCollection(leafVector = this.getCollectionVector(collName), path[2].toString())) >= 2;
    }

    private boolean isCollectionSelected() {
        if (this.selectedPath == null) {
            return false;
        }
        return this.selectedPath.getPathCount() == 2;
    }

    private boolean isRootSelected() {
        if (this.selectedPath == null) {
            return false;
        }
        return this.selectedPath.getPathCount() == 1;
    }

    public void copySelection() {
        if (!this.isLeafSelected()) {
            return;
        }
        Object[] path = this.selectedPath.getPath();
        this.collecObjCut = path[1].toString();
        Vector dataVector = this.getDataVector(this.collecObjCut);
        Vector leafVector = this.getCollectionVector(this.collecObjCut);
        int vIdx = this.getItemInCollection(leafVector, path[2].toString());
        this.objCut = dataVector.elementAt(vIdx);
    }

    public void cutSelection() {
        if (!this.isLeafSelected()) {
            return;
        }
        Object[] path = this.selectedPath.getPath();
        this.collecObjCut = path[1].toString();
        Vector dataVector = this.getDataVector(this.collecObjCut);
        Vector leafVector = this.getCollectionVector(this.collecObjCut);
        int vIdx = this.getItemInCollection(leafVector, path[2].toString());
        this.objCut = dataVector.elementAt(vIdx);
        this.removeLeaf(leafVector, dataVector, vIdx);
        this.modified = true;
    }

    public boolean objToBePasted() {
        return this.objCut != null;
    }

    public void paste() {
        if (this.objCut != null) {
            this.createNewLeaf(this.collecObjCut, this.objCut);
            this.modified = true;
        }
    }

    public void moveUpSelection() {
        if (!this.isLeafSelected()) {
            return;
        }
        Object[] path = this.selectedPath.getPath();
        String collec = path[1].toString();
        Vector dataVector = this.getDataVector(collec);
        Vector leafVector = this.getCollectionVector(collec);
        int vIdx = this.getItemInCollection(leafVector, path[2].toString());
        if (vIdx > 0) {
            Object data0 = dataVector.elementAt(vIdx - 1);
            Object data1 = dataVector.elementAt(vIdx);
            this.changeLeaf(dataVector, leafVector, vIdx, data0);
            this.changeLeaf(dataVector, leafVector, vIdx - 1, data1);
            this.modified = true;
        }
    }

    public void moveDownSelection() {
        if (!this.isLeafSelected()) {
            return;
        }
        Object[] path = this.selectedPath.getPath();
        String collec = path[1].toString();
        Vector dataVector = this.getDataVector(collec);
        Vector leafVector = this.getCollectionVector(collec);
        int vIdx = this.getItemInCollection(leafVector, path[2].toString());
        if (vIdx < dataVector.size() - 1) {
            Object data0 = dataVector.elementAt(vIdx + 1);
            Object data1 = dataVector.elementAt(vIdx);
            this.changeLeaf(dataVector, leafVector, vIdx, data0);
            this.changeLeaf(dataVector, leafVector, vIdx + 1, data1);
            this.modified = true;
        }
    }

    public void removeSelectedLeaf() {
        if (!this.isLeafSelected()) {
            return;
        }
        Object[] path = this.selectedPath.getPath();
        String collec = path[1].toString();
        Vector dataVector = this.getDataVector(collec);
        Vector leafVector = this.getCollectionVector(collec);
        int vIdx = this.getItemInCollection(leafVector, path[2].toString());
        String itemName = new String(collec + " item:  " + path[2].toString());
        if (JOptionPane.showConfirmDialog(this, "Delete the " + itemName, "Warning", 0) == 0) {
            int colNum = this.getCollectionNum(collec);
            String infoMessage = null;
            switch (colNum) {
                case 2: {
                    Cmd cmd = (Cmd)dataVector.elementAt(vIdx);
                    infoMessage = new String("The " + itemName + " has been taken off the command factory.\n\n" + "But, for safety reason, if this command has been already generated,\nthe '" + cmd.exec_method + "' method will not be automaticaly removed !!!\n" + "Please do it by yourself.");
                }
            }
            this.removeLeaf(leafVector, dataVector, vIdx);
            this.modified = true;
            if (infoMessage != null) {
                JOptionPane.showMessageDialog(this.tree, infoMessage, "Info Window", 1);
            }
        }
    }

    public void createNewCollectionObject(String collName) {
        if (collName.equals(collec[2].toString())) {
            CommandDialog cmdDialog = new CommandDialog((Frame)this.frame, true, this.stVector, this.cmdVector);
            if (cmdDialog.showDialog() == 1) {
                Cmd cmd = cmdDialog.getInputCommand();
                this.createNewLeaf(collName, cmd);
            }
        } else if (collName.equals(collec[3].toString())) {
            AttributeDialog dialog = new AttributeDialog((Frame)this.frame, true);
            Attrib tmpAttr = new Attrib("", 0, PogoDefs.AttrDataArray[0], 0, "");
            if (dialog.showDialog(tmpAttr) == 1) {
                Attrib attr = dialog.getInput();
                this.createNewLeaf(collName, attr);
                this.modified = true;
            }
        } else if (collName.equals(collec[4].toString())) {
            StateDialog stateDialog = new StateDialog((Frame)this.frame, true);
            String defState = PogoDefs.TangoStatesArray[13];
            DevState state = new DevState(defState, "");
            if (stateDialog.showStateDialog(state) == 1) {
                state = stateDialog.getInput();
                this.createNewLeaf(collName, state);
                this.modified = true;
            }
        } else if (collName.equals(collec[1].toString()) || collName.equals(collec[0].toString())) {
            PropertyDialog propDialog = new PropertyDialog((Frame)this.frame, true);
            if (propDialog.showDialog(new Property("", "Tango::DEV_SHORT", "")) == 1) {
                this.createNewLeaf(collName, propDialog.getInput());
            }
        } else {
            this.popupMessage("Not yet available !");
        }
    }

    private void editCmdCode(String cmdName) {
        String mess = null;
        try {
            EditPogoCode ed = new EditPogoCode(this.getPogoClass());
            ed.setCommandTarget(cmdName);
            ed.start();
        }
        catch (FileNotFoundException e) {
            mess = "Source File Not Found !";
        }
        catch (IOException e) {
            mess = e.toString();
        }
        catch (PogoException e) {
            mess = e.toString();
        }
        if (mess != null) {
            this.popupMessage(mess);
        }
    }

    private void editAttributesCode() {
        String mess = null;
        try {
            EditPogoCode ed = new EditPogoCode(this.getPogoClass());
            ed.setAttributeTarget();
            ed.start();
        }
        catch (FileNotFoundException e) {
            mess = "Source File Not Found";
        }
        catch (IOException e) {
            mess = e.toString();
        }
        catch (PogoException e) {
            mess = e.toString();
        }
        if (mess != null) {
            this.popupMessage(mess);
        }
    }

    private void editPropertiesCode(int type) {
        String mess = null;
        try {
            EditPogoCode ed = new EditPogoCode(this.getPogoClass());
            ed.setPropertiesTarget(type);
            ed.start();
        }
        catch (FileNotFoundException e) {
            mess = "Source File Not Found";
        }
        catch (IOException e) {
            mess = e.toString();
        }
        catch (PogoException e) {
            mess = e.toString();
        }
        if (mess != null) {
            this.popupMessage(mess);
        }
    }

    private void treeMouseClicked(MouseEvent evt) {
        int mask;
        int selRow = this.tree.getRowForLocation(evt.getX(), evt.getY());
        this.selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
        if (evt.getClickCount() != 2) {
            return;
        }
        if (this.pMenu != null) {
            this.pMenu.setVisible(false);
        }
        if (((mask = evt.getModifiers()) & 8) != 0) {
            System.out.println(" BTN 2");
            return;
        }
        if (selRow == -1) {
            System.out.println(" No Cell selected");
            return;
        }
        if ((mask & 4) != 0) {
            if (this.isRootSelected()) {
                this.editClassObject();
                return;
            }
            Object[] path = this.selectedPath.getPath();
            String collName = path[1].toString();
            if (this.isCollectionSelected()) {
                this.createNewCollectionObject(collName);
                return;
            }
            if (path.length > 2) {
                if (collName.equals(collec[2].toString())) {
                    this.editCmdCode(path[2].toString());
                } else if (collName.equals(collec[3].toString())) {
                    this.editAttributesCode();
                } else if (collName.equals(collec[1].toString())) {
                    this.editPropertiesCode(1);
                } else if (collName.equals(collec[0].toString())) {
                    this.editPropertiesCode(0);
                }
            }
        } else if ((mask & 0x10) != 0) {
            this.editCollection();
        }
    }

    private void createActionPerformed(ActionEvent evt) {
        this.createNewCollectionObject(evt.getActionCommand());
        this.pMenu.setVisible(false);
    }

    private void frameMouseClicked(MouseEvent evt) {
        int mask = evt.getModifiers();
        if ((mask & 4) == 0 || (mask & 1) == 0) {
            this.pMenu.setVisible(false);
            return;
        }
        if (this.pMenu.isVisible()) {
            this.pMenu.setVisible(false);
            return;
        }
        Object o = evt.getSource();
        Point p = ((Component)o).getLocationOnScreen();
        p.x += evt.getX();
        p.y += evt.getY();
        if ((mask & 1) != 0) {
            this.pMenu.setLocation(p.x, p.y);
            this.pMenu.setVisible(true);
        }
    }

    public void setPogoTree(PogoClass pogo) {
        int nb_rows = collec.length;
        this.clear();
        this.root.setUserObject(pogo.class_name);
        this.class_name = new String(pogo.class_name);
        this.classDesc = new String(pogo.class_desc);
        this.projTitle = new String(pogo.title);
        if (pogo.class_properties != null) {
            int i = 0;
            while (i < pogo.class_properties.size()) {
                Property prop = pogo.class_properties.elementAt(i);
                this.createNewLeaf(collec[0], prop);
                ++i;
                ++nb_rows;
            }
        }
        if (pogo.dev_properties != null) {
            int i = 0;
            while (i < pogo.dev_properties.size()) {
                Property prop = pogo.dev_properties.elementAt(i);
                this.createNewLeaf(collec[1], prop);
                ++i;
                ++nb_rows;
            }
        }
        if (pogo.commands != null) {
            int i = 0;
            while (i < pogo.commands.size()) {
                Cmd cmd = pogo.commands.cmdIdx(i);
                this.createNewLeaf(collec[2], cmd);
                ++i;
                ++nb_rows;
            }
        }
        if (pogo.attributes != null) {
            int i = 0;
            while (i < pogo.attributes.size()) {
                Attrib attr = pogo.attributes.elementAt(i);
                this.createNewLeaf(collec[3], attr);
                ++i;
                ++nb_rows;
            }
        }
        if (pogo.states != null) {
            int i = 0;
            while (i < pogo.states.size()) {
                DevState state = pogo.states.elementAt(i);
                this.createNewLeaf(collec[4], state);
                ++i;
                ++nb_rows;
            }
        }
        int i = 0;
        while (i < nb_rows) {
            this.tree.expandRow(i);
            ++i;
        }
        this.modified = false;
    }

    public PogoClass getPogoClass() {
        String name = this.root.getUserObject().toString();
        try {
            PogoClass pogo = new PogoClass(name, this.classDesc, this.classPropVector, this.devPropVector, this.cmdVector, this.attrVector, this.stVector);
            int i = 0;
            while (i < pogo.commands.size()) {
                Cmd cmd = pogo.commands.cmdIdx(i);
                if (!cmd.virtual_method) {
                    int j = 0;
                    while (j < cmd.notAllowedFor.size()) {
                        DevState st = cmd.notAllowedFor.elementAt(j);
                        boolean exist = false;
                        int k = 0;
                        while (k < pogo.states.size()) {
                            DevState state = pogo.states.elementAt(k);
                            if (st.name.equals(state.name)) {
                                exist = true;
                            }
                            ++k;
                        }
                        if (!exist) {
                            cmd.removeNotAllowedFor(st);
                            System.out.println(st.name + "Does Not Exist !");
                        }
                        ++j;
                    }
                }
                ++i;
            }
            pogo.title = this.projTitle;
            pogo.language = this.language;
            pogo.output_files = new String(this.homeDir);
            return pogo;
        }
        catch (PogoException ex) {
            this.popupMessage(ex.toString());
            return null;
        }
    }

    public boolean hasBeenModified() {
        return this.modified;
    }

    public void setModified(boolean state) {
        this.modified = state;
    }

    public void setHomeDir(String path) {
        this.homeDir = new String(path);
    }

    public void setLanguage(int lang) {
        this.language = lang;
    }
}

