/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.PogoException;

class PogoRenderer
extends DefaultTreeCellRenderer {
    private String[] collec;
    private String classname = null;
    private Vector cmdVector;
    private Vector attrVector;

    public PogoRenderer(String[] collec, Color background, Vector cmdVector, Vector attrVector) {
        this.collec = collec;
        this.cmdVector = cmdVector;
        this.attrVector = attrVector;
        this.setTextSelectionColor(Color.black);
        this.setBorderSelectionColor(Color.red);
        this.setBackgroundSelectionColor(Color.lightGray);
        this.setTextNonSelectionColor(Color.blue);
        this.setBackgroundNonSelectionColor(background);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/pogo/img/arrow02.gif"));
        this.setClosedIcon(icon);
        this.setOpenIcon(icon);
        this.setLeafIcon(new ImageIcon(this.getClass().getResource("/pogo/img/or_diam.gif")));
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (leaf && value != null) {
            TreePath tp = tree.getPathForRow(row);
            if (tp == null) {
                return this;
            }
            tp = tp.getParentPath();
            this.classname = tp.getPathComponent(0).toString();
            String collectionName = ((DefaultMutableTreeNode)tp.getPathComponent(tp.getPathCount() - 1)).toString();
            try {
                String txt = this.buildToolTipText(collectionName, value.toString());
                this.setToolTipText(txt);
            }
            catch (PogoException e) {
                this.setToolTipText(null);
            }
        } else {
            this.setToolTipText(null);
        }
        return this;
    }

    private int getCollByname(String collname) throws PogoException {
        int idx = -1;
        int i = 0;
        while (i < this.collec.length) {
            if (collname.equals(this.collec[i])) {
                idx = i;
            }
            ++i;
        }
        if (idx == -1) {
            throw new PogoException("Collection not found !");
        }
        return idx;
    }

    private Object getObjectByName(Vector vect, String name) throws PogoException {
        Object obj = null;
        int i = 0;
        while (i < vect.size()) {
            Object tmp = vect.elementAt(i);
            if (tmp.toString().equals(name)) {
                obj = tmp;
            }
            ++i;
        }
        if (obj == null) {
            System.out.println("Object '" + name + "' not found !");
            throw new PogoException("Object '" + name + "' not found !");
        }
        return obj;
    }

    private String buildToolTipText(String collname, String item) throws PogoException {
        String tooltip;
        int collection = this.getCollByname(collname);
        switch (collection) {
            case 2: {
                Cmd cmd = (Cmd)this.getObjectByName(this.cmdVector, item);
                tooltip = cmd.buildCppExecCmdMethodSignature(this.classname);
                break;
            }
            case 3: {
                String[] att_type = new String[]{"Scalar", "Spectrum", "Image"};
                Attrib attr = (Attrib)this.getObjectByName(this.attrVector, item);
                tooltip = new String(attr.dataType.cpp + "  " + attr.toString() + "  (" + att_type[attr.attrType] + ")");
                break;
            }
            default: {
                tooltip = new String("Edit the " + item + " " + this.collec[collection]);
            }
        }
        return tooltip;
    }
}

