/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import pogo.appli.ClassDialog;
import pogo.appli.GenerateThread;
import pogo.appli.PogoAppliDefs;
import pogo.appli.PogoFileFilter;
import pogo.appli.PogoHelp;
import pogo.appli.PogoTree;
import pogo.appli.PrefGeneDialog;
import pogo.gene.Cmd;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.Taco2Tango;
import utilities.RcsId;
import utilities.TangoWindow;

public class PogoAppli
extends JFrame
implements PogoAppliDefs,
PogoDefs {
    private static String rcsString = "$Header: /segfs/tango/tools/pogo/appli/RCS/PogoAppli.java,v 1.32 2002/10/03 13:54:27 verdier Exp verdier $";
    private PogoTree tree;
    private PogoClass pogo;
    private String homeDir;
    private JFileChooser chooser;
    private static String[] palette = new String[]{"Edit Class", null, "Class  Property", "Device Property", "Command", "Attribute", "State"};
    JLabel versionLabel;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem newMenuItem;
    private JMenuItem openMenuItem;
    private JMenuItem importMenuItem;
    private JSeparator jSeparator1;
    private JMenuItem geneSrcBtn;
    private JMenuItem geneDocBtn;
    private JSeparator jSeparator2;
    private JMenuItem exitMenuItem;
    private JMenu editMenu;
    private JMenuItem cutMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem pasteMenuItem;
    private JSeparator jSeparator3;
    private JMenuItem deleteMenuItem;
    private JMenuItem moveUpItem;
    private JMenuItem moveDownItem;
    private JMenu paletteMenu;
    private JMenu prefMenu;
    private JMenuItem jMenuItem1;
    private JMenu helpMenu;
    private JMenuItem contentsMenuItem;
    private JSeparator jSeparator4;
    private JMenuItem aboutMenuItem;
    private JScrollPane jScrollPane1;
    private JPanel southPanel;
    private JPanel mousePanel;
    private JLabel leftBtnLabel;
    private JLabel rightBtnLabel;
    private JPanel jPanel1;
    private JLabel jLabel1;
    private JRadioButton cppBtn;
    private JRadioButton javaBtn;

    public PogoAppli() {
        this.initComponents();
        this.tree = new PogoTree(this);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 450));
        this.jScrollPane1.setViewportView(this.tree);
        this.jScrollPane1.setBackground(this.tree.getBackground());
        this.customMenu();
        this.setPogoDefined(false);
        this.setTitle(new RcsId(rcsString).toString());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/utilities/img/tango_icon.jpg"));
        this.setIconImage(icon.getImage());
        this.pack();
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenuItem = new JMenuItem();
        this.openMenuItem = new JMenuItem();
        this.importMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.geneSrcBtn = new JMenuItem();
        this.geneDocBtn = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.deleteMenuItem = new JMenuItem();
        this.moveUpItem = new JMenuItem();
        this.moveDownItem = new JMenuItem();
        this.paletteMenu = new JMenu();
        this.prefMenu = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.aboutMenuItem = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.southPanel = new JPanel();
        this.mousePanel = new JPanel();
        this.leftBtnLabel = new JLabel();
        this.rightBtnLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.cppBtn = new JRadioButton();
        this.javaBtn = new JRadioButton();
        this.fileMenu.setText("File");
        this.fileMenu.setName("File");
        this.newMenuItem.setText("New Class");
        this.newMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.newMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newMenuItem);
        this.openMenuItem.setToolTipText("Open Class File");
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.importMenuItem.setToolTipText("import TACO server");
        this.importMenuItem.setText("Import");
        this.importMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.importMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.importMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.geneSrcBtn.setText("Generate Source");
        this.geneSrcBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.generateAP(evt);
            }
        });
        this.fileMenu.add(this.geneSrcBtn);
        this.geneDocBtn.setText("Generate Doc.");
        this.geneDocBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.generateAP(evt);
            }
        });
        this.fileMenu.add(this.geneDocBtn);
        this.fileMenu.add(this.jSeparator2);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                PogoAppli.this.editAP(evt);
            }
        });
        this.cutMenuItem.setText("Cut");
        this.cutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.cutMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.copyMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.pasteMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.pasteMenuItem);
        this.editMenu.add(this.jSeparator3);
        this.deleteMenuItem.setText("Delete");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.deleteMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.deleteMenuItem);
        this.moveUpItem.setText("Move Up");
        this.moveUpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.moveActionPerformed(evt);
            }
        });
        this.editMenu.add(this.moveUpItem);
        this.moveDownItem.setText("Move Down");
        this.moveDownItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.moveActionPerformed(evt);
            }
        });
        this.editMenu.add(this.moveDownItem);
        this.menuBar.add(this.editMenu);
        this.paletteMenu.setText("Palette");
        this.menuBar.add(this.paletteMenu);
        this.prefMenu.setText("Preferences");
        this.jMenuItem1.setText("On Generation");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.genePrefActionPerformed(evt);
            }
        });
        this.prefMenu.add(this.jMenuItem1);
        this.menuBar.add(this.prefMenu);
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setText("Shortcuts");
        this.contentsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.helpAP(evt);
            }
        });
        this.helpMenu.add(this.contentsMenuItem);
        this.helpMenu.add(this.jSeparator4);
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.helpAP(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setTitle("Pogo Appli");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PogoAppli.this.exitForm(evt);
            }
        });
        this.jScrollPane1.setBackground(Color.white);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.southPanel.setLayout(new BorderLayout());
        this.mousePanel.setLayout(new BorderLayout());
        this.leftBtnLabel.setHorizontalTextPosition(2);
        this.mousePanel.add((Component)this.leftBtnLabel, "West");
        this.mousePanel.add((Component)this.rightBtnLabel, "East");
        this.southPanel.add((Component)this.mousePanel, "North");
        this.jLabel1.setBackground(Color.white);
        this.jLabel1.setText("Language Generated: ");
        this.jPanel1.add(this.jLabel1);
        this.cppBtn.setToolTipText("The device server will be generated in C++");
        this.cppBtn.setText("C++");
        this.cppBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.languageBtnAP(evt);
            }
        });
        this.jPanel1.add(this.cppBtn);
        this.javaBtn.setToolTipText("The device server will be generated in Java");
        this.javaBtn.setText("Java");
        this.javaBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.languageBtnAP(evt);
            }
        });
        this.jPanel1.add(this.javaBtn);
        this.southPanel.add((Component)this.jPanel1, "South");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.setJMenuBar(this.menuBar);
    }

    private void pasteMenuItemActionPerformed(ActionEvent evt) {
        this.tree.paste();
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
        this.tree.copySelection();
    }

    private void cutMenuItemActionPerformed(ActionEvent evt) {
        this.tree.cutSelection();
    }

    private void moveActionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.indexOf("Up") >= 0) {
            this.tree.moveUpSelection();
        } else {
            this.tree.moveDownSelection();
        }
    }

    private void genePrefActionPerformed(ActionEvent evt) {
        PrefGeneDialog dialog;
        if (this.homeDir == null && (this.homeDir = System.getProperty("HOME_GENE")) == null) {
            this.homeDir = new File("").getAbsolutePath();
        }
        if ((dialog = new PrefGeneDialog((Frame)this, true)).showDialog(this.homeDir) == 1) {
            this.homeDir = dialog.getInput();
        }
        this.tree.setHomeDir(this.homeDir);
    }

    private void editAP(MenuEvent evt) {
        boolean state = this.tree.isLeafSelected();
        this.copyMenuItem.setEnabled(state);
        this.cutMenuItem.setEnabled(state);
        this.pasteMenuItem.setEnabled(this.tree.objToBePasted());
        this.deleteMenuItem.setEnabled(state);
        this.moveUpItem.setEnabled(state);
        this.moveDownItem.setEnabled(state);
    }

    private void helpAP(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        String message = null;
        if (cmd.equals("About")) {
            message = new String(new RcsId(rcsString).toString() + "\n\n\n" + "POGO application.\nThe Program Obviously used to Generate tango Object.");
        } else {
            PogoHelp.displayMessage(this, cmd);
        }
        if (message != null) {
            JOptionPane.showMessageDialog(this, message, "Help Window", 1);
        }
    }

    private void newMenuItemActionPerformed(ActionEvent evt) {
        ClassDialog classDialog;
        Object[] options;
        if (this.tree != null && this.tree.hasBeenModified() && JOptionPane.showOptionDialog(this.tree, "This project has not been saved !\n\nDiscard modifications ?", "Warning", -1, 2, null, options = new Object[]{"OK", "CANCEL"}, options[0]) != 0) {
            return;
        }
        if (this.homeDir == null && (this.homeDir = System.getProperty("HOME_GENE")) == null) {
            this.homeDir = new File("").getAbsolutePath();
        }
        if ((classDialog = new ClassDialog((Frame)this, true)).showClassDialog(null, null, null) == 1) {
            if (this.tree != null) {
                this.tree.clear();
                this.setPogoDefined(false);
                this.versionLabel.setText("");
                this.pogo = null;
            }
            try {
                this.pogo = new PogoClass(classDialog.getClassName(), classDialog.getDescription(), new Vector(), new Vector(), new Vector(), new Vector(), new Vector());
                this.pogo.title = classDialog.getProjectTitle();
                this.tree.setPogoTree(this.pogo);
                this.setPogoDefined(true);
                this.resetLanguage();
                this.tree.setHomeDir(this.homeDir);
            }
            catch (PogoException ex) {
                JOptionPane.showMessageDialog(this, ex + ex.str[0], "Error Window", 0);
            }
        }
    }

    private void generateAP(ActionEvent evt) {
        String type = evt.getActionCommand();
        if (type.indexOf("Source") > 0) {
            this.generateSource(1);
        } else if (type.indexOf("Doc.") > 0 && this.tree != null) {
            if (this.tree.hasBeenModified()) {
                Object[] options = new Object[]{"Generate Source\n Before", "Generate Only\n Documentation", "CANCEL"};
                switch (JOptionPane.showOptionDialog(this.tree, "The source files have not been generated !\nThe programmer's guide generation use source files.\n\n\n", "Warning", -1, 2, null, options, options[0])) {
                    case 0: {
                        this.generateSource(1);
                        this.generateSource(2);
                        break;
                    }
                    case 1: {
                        this.generateSource(2);
                    }
                }
            } else {
                this.generateSource(2);
            }
        }
    }

    private void languageBtnAP(ActionEvent evt) {
        String lang = evt.getActionCommand();
        if (lang.equals("Java")) {
            this.cppBtn.setSelected(false);
            this.javaBtn.setSelected(true);
        } else {
            this.cppBtn.setSelected(true);
            this.javaBtn.setSelected(false);
        }
        try {
            this.tree.setLanguage(this.getLanguage());
        }
        catch (PogoException pogoException) {
            // empty catch block
        }
    }

    private void generateSource(int item) {
        this.generateSource(item, 1);
    }

    private void generateSource(int item, int exiting) {
        GenerateThread gt;
        PogoClass pogoTree;
        if (this.homeDir == null && (this.homeDir = System.getProperty("HOME_GENE")) == null) {
            this.homeDir = new File("").getAbsolutePath();
        }
        if ((pogoTree = this.tree.getPogoClass()) == null) {
            return;
        }
        if (item == 1) {
            PrefGeneDialog dialog = new PrefGeneDialog((Frame)this, true);
            if (dialog.showDialog(this.homeDir) != 1) {
                return;
            }
            this.homeDir = dialog.getInput();
            this.tree.setHomeDir(this.homeDir);
        }
        int lang = 0;
        try {
            lang = this.getLanguage();
        }
        catch (PogoException e) {
            // empty catch block
        }
        if (lang == 1) {
            Object[] options;
            StringTokenizer st = new StringTokenizer(this.homeDir, "/");
            String dir = null;
            while (st.countTokens() > 0) {
                dir = st.nextToken().toString();
            }
            if (!this.pogo.class_name.equals(dir) && JOptionPane.showOptionDialog(this, new String("The Class name will be used as package name.\n\nBut the directory does not have the Class name !\n\nProblem will occur when you try to compile.\n"), "Warning", -1, 2, null, options = new String[]{"Generate Source", "CANCEL"}, options[1]) == 1) {
                return;
            }
        }
        pogoTree.output_files = this.homeDir;
        pogoTree.author = this.pogo.author;
        pogoTree.revision = this.pogo.revision;
        try {
            pogoTree.language = pogoTree.in_language = this.getLanguage();
            gt = new GenerateThread(this, pogoTree, item, this.homeDir, exiting);
            gt.start();
            this.tree.setModified(false);
        }
        catch (PogoException ex) {
            if (exiting == 1) {
                JOptionPane.showMessageDialog(this, ex.toString(), "Error Window", 0);
            } else {
                System.out.println(ex.toString());
            }
            ex.printStackTrace();
            return;
        }
        try {
            this.tree.setLanguage(this.getLanguage());
        }
        catch (PogoException e) {
            // empty catch block
        }
        if (exiting == 0) {
            try {
                gt.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void customMenu() {
        String templates_dir = System.getProperty("TEMPL_HOME");
        if (templates_dir != null) {
            this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/pogo/img/pogo.jpg")));
            this.jLabel1.setDisabledIcon(null);
        }
        this.jLabel1.setBackground(Color.black);
        this.versionLabel = new JLabel();
        this.versionLabel.setText("");
        this.versionLabel.setBackground(Color.black);
        this.getContentPane().add((Component)this.versionLabel, "North");
        this.tree.setMouseUsageListener(this.leftBtnLabel, this.rightBtnLabel);
        this.fileMenu.setMnemonic('F');
        this.editMenu.setMnemonic('E');
        this.helpMenu.setMnemonic('H');
        this.newMenuItem.setMnemonic('N');
        this.openMenuItem.setMnemonic('O');
        this.importMenuItem.setMnemonic('I');
        this.exitMenuItem.setMnemonic('E');
        this.deleteMenuItem.setMnemonic('D');
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.importMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.geneSrcBtn.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.geneDocBtn.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.paletteMenu.setMnemonic('P');
        int i = 0;
        while (i < palette.length) {
            if (palette[i] != null) {
                JMenuItem menuItem = new JMenuItem();
                menuItem.setText(palette[i]);
                menuItem.setMnemonic(palette[i].charAt(0));
                menuItem.setAccelerator(KeyStroke.getKeyStroke((int)palette[i].charAt(0), 1));
                this.paletteMenu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        PogoAppli.this.paletteItemAP(evt);
                    }
                });
            } else {
                this.paletteMenu.addSeparator();
                this.paletteMenu.addSeparator();
                JLabel lbl = new JLabel(" Create a New:");
                this.paletteMenu.add(lbl);
            }
            ++i;
        }
        this.resetLanguage();
    }

    private void setLanguage() {
        switch (this.pogo.language) {
            case 1: {
                this.cppBtn.setSelected(false);
                this.javaBtn.setSelected(true);
                break;
            }
            case 2: {
                this.cppBtn.setSelected(true);
                this.javaBtn.setSelected(false);
                break;
            }
            default: {
                this.cppBtn.setSelected(false);
                this.javaBtn.setSelected(false);
            }
        }
    }

    private void resetLanguage() {
        boolean cpp = true;
        String inLang = System.getProperty("IN_LANG");
        if (inLang != null && inLang.indexOf("java") >= 0) {
            cpp = false;
        }
        this.cppBtn.setSelected(cpp);
        this.javaBtn.setSelected(!cpp);
    }

    private int getLanguage() throws PogoException {
        if (this.javaBtn.getSelectedObjects() != null) {
            return 1;
        }
        if (this.cppBtn.getSelectedObjects() != null) {
            return 2;
        }
        throw new PogoException("Output Language NOT Selected !");
    }

    private void deleteMenuItemActionPerformed(ActionEvent evt) {
        this.tree.removeSelectedLeaf();
    }

    private void tracePogo() {
        System.out.println("\n\n");
        System.out.println("-----------------------------------------------");
        System.out.println("Class Name:  " + this.pogo.class_name);
        System.out.println("States:");
        System.out.println(this.pogo.states);
        System.out.println("Commands:");
        System.out.println(this.pogo.commands);
        System.out.println("Output Files:  " + this.pogo.output_files);
        System.out.println("From templates:  " + this.pogo.templates_dir);
        System.out.println("-----------------------------------------------");
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            System.out.println(cmd.command + " -> " + cmd.exec_method);
            ++i;
        }
    }

    private void readSourceFile(String filename, int action) {
        try {
            if (action == 0) {
                this.pogo = new PogoClass(filename);
            } else {
                Taco2Tango t2t = new Taco2Tango(filename);
                this.pogo = t2t.getPogoClass();
            }
            this.tree.setPogoTree(this.pogo);
            this.setPogoDefined(true);
            String message = this.pogo.commands.checkArgsType();
            if (message != null) {
                JOptionPane.showMessageDialog(this, message, "Error Window", 0);
            }
            if (action == 1 && this.pogo.states != null && this.pogo.states.size() > 0) {
                JOptionPane.showMessageDialog(this, "WARNING:\nDevice States have been created \n   BUT Not\nthe allowed state command !!!", "Error Window", 2);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.toString(), "Error Window", 0);
            ex.printStackTrace();
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        this.buildPogoFromFile(0);
    }

    private void importMenuItemActionPerformed(ActionEvent evt) {
        this.buildPogoFromFile(1);
    }

    private void buildPogoFromFile(int action) {
        Object[] options;
        String defaultfile = System.getProperty("POGO_FILE");
        if (defaultfile != null && defaultfile.length() == 0) {
            defaultfile = null;
        }
        if (this.tree.hasBeenModified() && JOptionPane.showOptionDialog(this.tree, "This project has not been saved !\n\nDiscard modifications ?", "Warning", -1, 2, null, options = new Object[]{"OK", "CANCEL"}, options[0]) != 0) {
            return;
        }
        PogoFileFilter cppFF = new PogoFileFilter("Cpp", "Class Name");
        PogoFileFilter javaFF = new PogoFileFilter("java", "Class Name");
        PogoFileFilter tacoFF = new PogoFileFilter("c", "TACO 'C' Class");
        if (this.chooser == null) {
            this.homeDir = System.getProperty("HOME_GENE");
            if (this.homeDir == null) {
                this.homeDir = new File("").getAbsolutePath();
            }
            this.chooser = new JFileChooser(this.homeDir);
            this.chooser.addChoosableFileFilter(tacoFF);
            this.chooser.addChoosableFileFilter(javaFF);
            this.chooser.addChoosableFileFilter(cppFF);
            if (action == 0) {
                String inLang = System.getProperty("IN_LANG");
                if (inLang != null && inLang.indexOf("java") >= 0) {
                    this.chooser.setFileFilter(javaFF);
                }
            } else {
                this.chooser.setFileFilter(tacoFF);
            }
        } else if (action == 0) {
            PogoFileFilter ff = (PogoFileFilter)this.chooser.getFileFilter();
            if (ff.getDescription().indexOf("TACO") >= 0) {
                this.chooser.setFileFilter(cppFF);
                String inLang = System.getProperty("IN_LANG");
                if (inLang != null && inLang.indexOf("java") >= 0) {
                    this.chooser.setFileFilter(javaFF);
                }
            }
        } else {
            this.chooser.setFileFilter(tacoFF);
        }
        this.chooser.setDialogTitle(action == 0 ? "Open" : "Import");
        this.chooser.setCurrentDirectory(new File(this.homeDir));
        int retval = defaultfile == null ? this.chooser.showOpenDialog(this) : 0;
        if (retval == 0) {
            File file;
            if (this.tree != null) {
                this.tree.clear();
                this.setPogoDefined(false);
                this.versionLabel.setText("");
                this.pogo = null;
            }
            if ((file = defaultfile == null ? this.chooser.getSelectedFile() : new File(defaultfile)) != null && !file.isDirectory()) {
                this.readSourceFile(file.getAbsolutePath(), action);
                this.homeDir = file.getParentFile().toString();
                if (this.pogo == null) {
                    return;
                }
                this.versionLabel.setText("  Author: " + this.pogo.author + "  - Revision: " + this.pogo.revision);
                if (file.getAbsolutePath().indexOf(PogoDefs.cppExtention) > 0) {
                    this.cppBtn.setSelected(true);
                    this.javaBtn.setSelected(false);
                } else if (file.getAbsolutePath().indexOf(PogoDefs.javaExtention) > 0) {
                    this.cppBtn.setSelected(false);
                    this.javaBtn.setSelected(true);
                }
                try {
                    this.tree.setLanguage(this.getLanguage());
                }
                catch (PogoException e) {
                    // empty catch block
                }
                this.tree.setHomeDir(this.homeDir);
            }
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        if (this.tree != null && this.tree.hasBeenModified()) {
            Object[] options = new Object[]{"Yes", "No", "Cancel"};
            int choice = JOptionPane.showOptionDialog(this, "This project has not been saved !\n\nWould you like to generate modifications ?", "Warning", -1, 2, null, options, options[0]);
            switch (choice) {
                case 0: {
                    this.generateSource(1, 0);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        System.exit(0);
    }

    private void exitForm(WindowEvent evt) {
        if (this.tree != null && this.tree.hasBeenModified() && JOptionPane.showConfirmDialog(this, "This project has not been saved !\n\nWould you like to generate modifications ?", "information", 0) == 0) {
            this.generateSource(1, 0);
        }
        System.exit(0);
    }

    private void paletteItemAP(ActionEvent evt) {
        String itemCmd = evt.getActionCommand();
        int idx = 0;
        int i = 0;
        while (i < palette.length) {
            if (itemCmd.equals(palette[i])) {
                idx = i;
            }
            ++i;
        }
        switch (idx) {
            case 0: {
                this.tree.editClassObject();
                break;
            }
            case 2: {
                this.tree.createNewCollectionObject("Class  Properties");
                break;
            }
            case 3: {
                this.tree.createNewCollectionObject("Device Properties");
                break;
            }
            case 4: {
                this.tree.createNewCollectionObject("Commands");
                break;
            }
            case 5: {
                this.tree.createNewCollectionObject("Attributes");
                break;
            }
            case 6: {
                this.tree.createNewCollectionObject("States");
            }
        }
    }

    private void setPogoDefined(boolean state) {
        this.tree.setVisible(state);
        this.geneSrcBtn.setEnabled(state);
        this.geneDocBtn.setEnabled(state);
        this.cutMenuItem.setEnabled(false);
        this.copyMenuItem.setEnabled(false);
        this.pasteMenuItem.setEnabled(false);
        this.paletteMenu.setEnabled(state);
        this.prefMenu.setEnabled(state);
        if (state) {
            this.setLanguage();
        }
    }

    public static void main(String[] args) {
        TangoWindow tw = new TangoWindow("POGO  Tango code generator");
        tw.setVisible(true);
        try {
            PogoAppli pogoAppli = new PogoAppli();
            pogoAppli.show();
            tw.toFront();
            if (System.getProperty("POGO_FILE") != null) {
                pogoAppli.buildPogoFromFile(0);
            }
        }
        catch (Exception e) {
            System.out.println("POGO Startup Failed.");
            System.out.println(e);
        }
        tw.setVisible(false);
    }
}

