/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.awt.Frame;
import javax.swing.JOptionPane;
import pogo.appli.GenerateDialog;
import pogo.appli.PogoAppli;
import pogo.appli.PogoAppliDefs;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoGeneCpp;
import pogo.gene.PogoGeneDoc;
import pogo.gene.PogoGeneJava;

public class GenerateThread
extends Thread
implements PogoDefs,
PogoAppliDefs {
    private PogoClass pogo;
    private int item;
    private String homeDir;
    private PogoAppli parent;
    private GenerateDialog dialog;
    private int exiting;

    public GenerateThread(PogoAppli parent, PogoClass pogo, int item, String path, int exiting) {
        this.parent = parent;
        this.pogo = pogo;
        this.item = item;
        this.homeDir = path;
        this.exiting = exiting;
        int ratio = item == 2 && pogo.language == 1 ? 7 : 20;
        this.dialog = new GenerateDialog((Frame)parent, ratio);
    }

    public void run() {
        try {
            switch (this.item) {
                case 1: {
                    if (this.pogo.language == 1) {
                        PogoGeneJava gene = new PogoGeneJava(this.pogo);
                        gene.generate();
                        this.dialog.stop();
                        if (this.exiting == 1) {
                            JOptionPane.showMessageDialog(this.parent, gene.getTrace(), "Message Window", 1);
                        }
                    } else {
                        PogoGeneCpp gene = new PogoGeneCpp(this.pogo);
                        gene.generate();
                        this.dialog.stop();
                        if (this.exiting == 1) {
                            JOptionPane.showMessageDialog(this.parent, gene.getTrace(), "Message Window", 1);
                        }
                    }
                    break;
                }
                case 2: {
                    new PogoGeneDoc(this.pogo).generate();
                    this.dialog.stop();
                    if (this.exiting != 1) break;
                    JOptionPane.showMessageDialog(this.parent, "Html Documentation Generated in :\n" + this.pogo.output_files + "/doc_html", "Message Window", 1);
                }
            }
        }
        catch (Exception ex) {
            this.dialog.stop();
            if (this.exiting == 1) {
                JOptionPane.showMessageDialog(this.parent, ex.toString(), "Error Window", 0);
            }
            ex.printStackTrace();
        }
    }
}

