/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import pogo.gene.Cmd;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;

public class EditPogoCode
extends Thread
implements PogoDefs {
    private PogoClass pogo;
    private String srcFilename;
    private String editor;
    private int lineNum;

    public EditPogoCode(PogoClass pogo) {
        this.pogo = pogo;
        this.srcFilename = pogo.language == 2 ? new String(pogo.output_files + "/" + pogo.class_name + PogoDefs.cppExtention) : new String(pogo.output_files + "/" + pogo.class_name + PogoDefs.javaExtention);
        String nedit = "nc -noask";
        this.editor = System.getProperty("EDITOR");
        if (this.editor == null) {
            this.editor = nedit;
        } else if (this.editor.length() == 0) {
            this.editor = nedit;
        } else if (this.editor.equals("nedit")) {
            this.editor = nedit;
        } else if (this.editor.equals("vi")) {
            this.editor = "xterm -e vi";
        }
    }

    private int searchLineNumber(String target) throws FileNotFoundException, IOException, PogoException {
        FileInputStream fidin = new FileInputStream(this.srcFilename);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        String srcCode = new String(inStr);
        int end = srcCode.indexOf(target);
        if (end < 0) {
            throw new PogoException(target + "\nMethod not found");
        }
        int line = 0;
        int i = 0;
        while (i < end) {
            if (srcCode.charAt(i) == '\n') {
                ++line;
            }
            ++i;
        }
        return ++line;
    }

    public void setCommandTarget(String cmdName) throws FileNotFoundException, IOException, PogoException {
        Cmd cmd = this.pogo.commands.cmdIdx(0);
        int i = 0;
        while (i < this.pogo.commands.size()) {
            cmd = this.pogo.commands.cmdIdx(i);
            if (cmd.command.equals(cmdName)) break;
            ++i;
        }
        String target = this.pogo.language == 2 ? cmd.buildCppExecCmdMethodSignature(this.pogo.class_name) : cmd.buildJavaExecCmdMethodSignature(0);
        target = target.substring(0, target.indexOf("(") + 1);
        this.lineNum = this.searchLineNumber(target);
    }

    public void setAttributeTarget() throws FileNotFoundException, IOException, PogoException {
        String target = this.pogo.language == 2 ? "void " + this.pogo.class_name + "::read_attr_hardware(vector<long> &attr_list)" : "public void read_attr_hardware(Vector attr_list)";
        this.lineNum = this.searchLineNumber(target);
    }

    public void setPropertiesTarget(int type) throws FileNotFoundException, IOException, PogoException {
        String[] method_name = new String[]{"get_class_property()", "get_device_property()"};
        if (type == 0) {
            int idx = this.srcFilename.lastIndexOf(".", this.srcFilename.length() - 1);
            this.srcFilename = this.srcFilename.substring(0, idx) + "Class" + this.srcFilename.substring(idx);
        }
        String s = type == 0 ? "Class" : "";
        String target = this.pogo.language == 2 ? "void " + this.pogo.class_name + s + "::" + method_name[type] : "public void " + method_name[type];
        this.lineNum = this.searchLineNumber(target);
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        try {
            String str1;
            String cmdStr = new String(this.editor + " +" + this.lineNum + " " + this.srcFilename);
            Process proc = Runtime.getRuntime().exec(cmdStr);
            InputStream istr = proc.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(istr));
            StringBuffer sb = new StringBuffer(cmdStr + "\n\n");
            while ((str1 = br.readLine()) != null) {
                void var6_8;
                sb.append((String)var6_8 + "\n");
            }
            int retVal = proc.waitFor();
            if (retVal != 0) {
                System.out.println(cmdStr + "\nproc.waitFor() : " + retVal + " !");
            }
            if ((retVal = proc.exitValue()) != 0) {
                System.out.println(cmdStr + "\nproc.exitValue() : " + retVal + " !");
            }
        }
        catch (InterruptedException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

