/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import fr.esrf.Tango.DispLevel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import pogo.appli.NotAllowedDialog;
import pogo.appli.PogoAppliDefs;
import pogo.gene.Cmd;
import pogo.gene.DevStateTable;
import utilities.PopupError;

public class CommandDialog
extends JDialog
implements PogoAppliDefs {
    private static String cmd_gotten = "";
    private Frame parent;
    private Vector stVector;
    private Vector existingCmd;
    private int editingIdx = 0;
    private DevStateTable notAllowedFor;
    private int returnStatus = 0;
    private int poll_period = 0;
    private JPanel jPanel1;
    private JButton okBtn;
    private JButton cancelBtn;
    private JPanel jPanel2;
    private JLabel nameLbl;
    private JLabel jLabel1;
    private JComboBox arginComboBox;
    private JLabel jLabel2;
    private JComboBox argoutComboBox;
    private JLabel jLabel8;
    private JTextField arginDescText;
    private JLabel jLabel4;
    private JTextField argoutDescText;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JButton allowedBtn;
    private JScrollPane jScrollPane1;
    private JTextArea cmdDescText;
    private JComboBox nameComboBox;
    private JLabel jLabel3;
    private JRadioButton levelBtn;
    private JRadioButton polledBtn;
    private JLabel periodLabel;
    private JLabel periodUnitLabel;
    private JTextField periodText;

    private void addElements() {
        this.levelBtn = new JRadioButton();
        this.levelBtn.setToolTipText("Display Level (expert or operator)");
        this.levelBtn.setText(" Expert Only  ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.jPanel2.add((Component)new JLabel("  "), gbc);
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.levelBtn, gbc);
        this.polledBtn = new JRadioButton();
        this.polledBtn.setToolTipText("Command polled.");
        this.polledBtn.setText(" Polled  ");
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.polledBtn, gbc);
        this.polledBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.polledBtnActionPerformed(evt);
            }
        });
        this.arginComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.arginCBActionPerformed(evt);
            }
        });
        this.periodLabel = new JLabel("Period :");
        this.periodLabel.setHorizontalAlignment(4);
        gbc.gridx = 2;
        gbc.gridy = 3;
        this.jPanel2.add((Component)this.periodLabel, gbc);
        this.periodText = new JTextField();
        gbc.gridx = 4;
        gbc.gridy = 3;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.periodText, gbc);
        this.periodText.setRequestFocusEnabled(true);
        this.periodUnitLabel = new JLabel(" ms  ");
        gbc.gridx = 5;
        gbc.gridy = 3;
        this.jPanel2.add((Component)this.periodUnitLabel, gbc);
    }

    private void setPeriodEnabled(boolean state) {
        this.periodLabel.setVisible(state);
        this.periodText.setVisible(state);
        this.periodUnitLabel.setVisible(state);
        if (state) {
            String txt = this.poll_period == 0 ? "2000" : "" + this.poll_period;
            this.periodText.setText(txt);
        }
    }

    public CommandDialog(Frame parent, boolean modal, Vector stVect, Vector cmdVect) {
        super(parent, modal);
        this.parent = parent;
        this.stVector = stVect;
        this.existingCmd = cmdVect;
        this.initComponents();
        this.addElements();
        int i = 0;
        while (i < PogoAppliDefs.standardCommandNames.length) {
            this.nameComboBox.addItem(PogoAppliDefs.standardCommandNames[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < PogoAppliDefs.TangoTypesArray.length) {
            this.arginComboBox.addItem(PogoAppliDefs.TangoTypesArray[i2]);
            this.argoutComboBox.addItem(PogoAppliDefs.TangoTypesArray[i2]);
            ++i2;
        }
        this.arginComboBox.setMaximumRowCount(12);
        this.argoutComboBox.setMaximumRowCount(12);
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.nameLbl = new JLabel();
        this.jLabel1 = new JLabel();
        this.arginComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.argoutComboBox = new JComboBox();
        this.jLabel8 = new JLabel();
        this.arginDescText = new JTextField();
        this.jLabel4 = new JLabel();
        this.argoutDescText = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.allowedBtn = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.cmdDescText = new JTextArea();
        this.nameComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.setBackground(new Color(198, 178, 168));
        this.setTitle("Command Window");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CommandDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2, 5, 5));
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new GridBagLayout());
        this.nameLbl.setText("Command Name:");
        this.nameLbl.setForeground(Color.black);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.nameLbl, gridBagConstraints1);
        this.nameComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.nameComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        this.jPanel2.add((Component)this.nameComboBox, gridBagConstraints1);
        this.jLabel1.setText("Argin Type:");
        this.jLabel1.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.jPanel2.add((Component)this.arginComboBox, gridBagConstraints1);
        this.jLabel8.setText("Argin Description:");
        this.jLabel8.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel8, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.jPanel2.add((Component)this.arginDescText, gridBagConstraints1);
        this.jLabel2.setText("Argout Type:");
        this.jLabel2.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 10;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 10;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.jPanel2.add((Component)this.argoutComboBox, gridBagConstraints1);
        this.jLabel4.setText("Argout Description:  ");
        this.jLabel4.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 11;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 11;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.jPanel2.add((Component)this.argoutDescText, gridBagConstraints1);
        this.jLabel5.setText(" ");
        this.jLabel5.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 15;
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints1);
        this.allowedBtn.setPreferredSize(new Dimension(167, 30));
        this.allowedBtn.setBorder(new BevelBorder(0));
        this.allowedBtn.setText("Command Allowed For States....");
        this.allowedBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.allowedBtnActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 16;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.fill = 2;
        this.jPanel2.add((Component)this.allowedBtn, gridBagConstraints1);
        this.jLabel6.setText("Command Description:  ");
        this.jLabel6.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 20;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints1);
        this.jScrollPane1.setPreferredSize(new Dimension(103, 150));
        this.jScrollPane1.setForeground(Color.lightGray);
        this.cmdDescText.setPreferredSize(new Dimension(100, 400));
        this.cmdDescText.setMinimumSize(new Dimension(0, 100));
        this.jScrollPane1.setViewportView(this.cmdDescText);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 21;
        gridBagConstraints1.gridwidth = 4;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 2.0;
        gridBagConstraints1.weighty = 7.0;
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints1);
        this.jLabel3.setText("    ");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints1);
        this.getContentPane().add((Component)this.jPanel2, "Center");
    }

    private void polledBtnActionPerformed(ActionEvent evt) {
        boolean state = this.polledBtn.getSelectedObjects() != null;
        this.setPeriodEnabled(state);
        if (state) {
            this.periodText.selectAll();
            this.periodText.requestFocus();
        }
    }

    private void arginCBActionPerformed(ActionEvent evt) {
        switch (this.arginComboBox.getSelectedIndex()) {
            case 0: {
                this.polledBtn.setEnabled(true);
                break;
            }
            default: {
                this.polledBtn.setEnabled(false);
                this.polledBtn.setSelected(false);
                this.setPeriodEnabled(false);
            }
        }
    }

    private void nameComboBoxActionPerformed(ActionEvent evt) {
        String cmd_name = this.nameComboBox.getSelectedItem().toString();
        if (cmd_name.equals(PogoAppliDefs.specif_cmd)) {
            String newCmd = null;
            do {
                if ((newCmd = (String)JOptionPane.showInputDialog(this.parent, "Command Name", "Input Dialog", 1, null, null, cmd_gotten)) == null) {
                    this.nameComboBox.setSelectedIndex(this.editingIdx);
                    return;
                }
                if ((newCmd = this.checkCommandName(newCmd)) == null) continue;
                cmd_gotten = newCmd;
            } while (newCmd == null);
            this.initializeCmdComboBox(newCmd);
        }
    }

    public void initializeCmdComboBox(String cmd) {
        boolean std_cmd = false;
        int i = 0;
        while (i < PogoAppliDefs.standardCommandNames.length) {
            if (PogoAppliDefs.standardCommandNames[i].equals(cmd)) {
                std_cmd = true;
                this.nameComboBox.setSelectedIndex(i);
            }
            ++i;
        }
        if (!std_cmd) {
            this.nameComboBox.addItem(cmd);
            this.nameComboBox.setSelectedIndex(this.nameComboBox.getItemCount() - 1);
        }
    }

    public int showDialog(Cmd cmd, int idx) {
        this.editingIdx = idx;
        if (cmd != null) {
            this.initializeCmdComboBox(cmd.command);
            int i = 0;
            while (i < PogoAppliDefs.TangoTypesArray.length) {
                if (PogoAppliDefs.TangoTypesArray[i].equals(cmd.argin.cpp_code_str)) {
                    this.arginComboBox.setSelectedIndex(i);
                }
                if (PogoAppliDefs.TangoTypesArray[i].equals(cmd.argout.cpp_code_str)) {
                    this.argoutComboBox.setSelectedIndex(i);
                }
                ++i;
            }
            if (cmd.argin.description != null) {
                this.arginDescText.setText(cmd.argin.description);
            }
            if (cmd.argout.description != null) {
                this.argoutDescText.setText(cmd.argout.description);
            }
            if (cmd.description != null) {
                this.cmdDescText.setText(cmd.description);
            }
            this.notAllowedFor = new DevStateTable(cmd.notAllowedFor.vect);
            if (cmd.level == DispLevel.EXPERT) {
                this.levelBtn.setSelected(true);
            }
            if ((this.poll_period = cmd.polled_period) > 0) {
                this.polledBtn.setSelected(true);
                this.setPeriodEnabled(true);
            } else {
                this.setPeriodEnabled(false);
            }
        }
        this.setVisible(true);
        return this.returnStatus;
    }

    public int showDialog() {
        return this.showDialog(null, -1);
    }

    private void allowedBtnActionPerformed(ActionEvent evt) {
        NotAllowedDialog dialog = new NotAllowedDialog(this.parent, true, this.stVector);
        int ret = dialog.showDialog(this.notAllowedFor);
        if (ret == 1) {
            this.notAllowedFor = dialog.getInput();
        }
    }

    private void nameTextActionPerformed(ActionEvent evt) {
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private String checkCommandName(String cmd_name) {
        if (cmd_name.length() <= 0) {
            JOptionPane.showMessageDialog(this, "Command's name must be filled in !", "Message Window", 1);
            return null;
        }
        StringTokenizer stk = new StringTokenizer(cmd_name);
        StringBuffer sb = new StringBuffer();
        while (stk.hasMoreTokens()) {
            String word = stk.nextToken();
            word = new String(word.substring(0, 1).toUpperCase() + word.substring(1));
            sb.append(word);
        }
        cmd_name = sb.toString();
        int i = 0;
        while (i < cmd_name.length()) {
            char c = cmd_name.charAt(i);
            if (c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z') {
                JOptionPane.showMessageDialog(this, "Syntax error in command's name !\nDo not use '" + c + "' char.", "Message Window", 1);
                return null;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.existingCmd.size()) {
            if (i2 != this.editingIdx) {
                Cmd cmd = (Cmd)this.existingCmd.elementAt(i2);
                if (cmd_name.equals(cmd.command)) {
                    JOptionPane.showMessageDialog(this, "Command " + cmd_name + " already exists !", "Message Window", 1);
                    return null;
                }
            }
            ++i2;
        }
        return cmd_name;
    }

    private int controlPeriodText() {
        if (this.polledBtn.getSelectedObjects() != null) {
            String s = this.periodText.getText();
            try {
                this.poll_period = Integer.parseInt(s);
                if (this.poll_period < 20) {
                    PopupError.show((Frame)this.parent, (String)"The polling period minimum value is  20 ms");
                    return -1;
                }
                return 1;
            }
            catch (Exception e) {
                PopupError.show((Frame)this.parent, (String)(e.toString() + "\n\nBad Value in Polling period field !"));
                return -1;
            }
        }
        return 1;
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        if (this.controlPeriodText() == 1) {
            this.doClose(1);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public Cmd getInputCommand() {
        String cmd_name = this.nameComboBox.getSelectedItem().toString();
        DispLevel level = this.levelBtn.getSelectedObjects() == null ? DispLevel.OPERATOR : DispLevel.EXPERT;
        Cmd cmd = new Cmd(cmd_name, cmd_name + "Cmd", this.arginComboBox.getSelectedItem().toString(), this.argoutComboBox.getSelectedItem().toString(), this.arginDescText.getText(), this.argoutDescText.getText(), this.cmdDescText.getText(), level);
        if (this.notAllowedFor == null) {
            this.notAllowedFor = new DevStateTable();
        }
        cmd.setNotAllowedFor(this.notAllowedFor);
        cmd.polled_period = this.polledBtn.getSelectedObjects() != null ? this.poll_period : 0;
        return cmd;
    }
}

