/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import fr.esrf.Tango.DispLevel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import pogo.appli.PogoAppliDefs;
import pogo.gene.Attrib;
import pogo.gene.PogoDefs;

public class AttributeDialog
extends JDialog
implements PogoAppliDefs,
PogoDefs {
    private static int returnStatus = 0;
    private String name;
    private String assAttr;
    private int attrType;
    private int xSize;
    private int ySize;
    private Vector prop_txt;
    private int poll_period = 0;
    private JRadioButton levelBtn;
    private JRadioButton polledBtn;
    private JLabel periodLabel;
    private JLabel periodUnitLabel;
    private JTextField periodText;
    private final int EMPTY_FIELD = -1;
    private final int NEGATIVE_FIELD = -2;
    private JPanel jPanel2;
    private JLabel nameLbl;
    private JComboBox attrTypeCB;
    private JLabel jLabel1;
    private JTextField nameText;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JComboBox dataTypeCB;
    private JLabel xDataLBL;
    private JLabel yDataLBL;
    private JTextField xDataTF;
    private JTextField yDataTF;
    private JComboBox rwTypeCB;
    private JLabel jLabel5;
    private JLabel assAttrLBL;
    private JTextField assAttrTF;
    private JLabel rwTypeLBL;
    private JPanel propertyPanel;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JTextField attrPropLabel;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabel10;
    private JTextField attrPropUnit;
    private JTextField attrPropStdUnit;
    private JTextField attrPropDispUnit;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JTextField attrPropFormat;
    private JTextField attrPropMaxValue;
    private JTextField attrPropMinValue;
    private JTextField attrPropMaxAlarm;
    private JTextField attrPropMinAlarm;
    private JLabel jLabel16;
    private JScrollPane jScrollPane1;
    private JTextArea attrPropDescription;
    private JPanel jPanel1;
    private JButton propertyBtn;
    private JButton okBtn;
    private JButton cancelBtn;

    private void addElements() {
        int i = 0;
        while (i < PogoDefs.AttrTypeArray.length) {
            this.attrTypeCB.addItem(PogoDefs.AttrTypeArray[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < PogoDefs.AttrDataArray.length) {
            this.dataTypeCB.addItem(PogoDefs.AttrDataArray[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < PogoDefs.AttrRWtypeArray.length) {
            this.rwTypeCB.addItem(new String(PogoDefs.cppNameSpace + PogoDefs.AttrRWtypeArray[i3]));
            ++i3;
        }
        this.propertyPanel.setVisible(false);
        this.prop_txt = new Vector();
        boolean i4 = false;
        this.prop_txt.addElement(this.attrPropLabel);
        this.prop_txt.addElement(this.attrPropUnit);
        this.prop_txt.addElement(this.attrPropStdUnit);
        this.prop_txt.addElement(this.attrPropDispUnit);
        this.prop_txt.addElement(this.attrPropFormat);
        this.prop_txt.addElement(this.attrPropMaxValue);
        this.prop_txt.addElement(this.attrPropMinValue);
        this.prop_txt.addElement(this.attrPropMaxAlarm);
        this.prop_txt.addElement(this.attrPropMinAlarm);
        this.prop_txt.addElement(this.attrPropDescription);
        this.levelBtn = new JRadioButton();
        this.levelBtn.setToolTipText("Display Level (expert or operator)");
        this.levelBtn.setText(" Expert Only  ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 15;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.levelBtn, gbc);
        this.polledBtn = new JRadioButton();
        this.polledBtn.setToolTipText("Command polled.");
        this.polledBtn.setText(" Polled  ");
        gbc.gridx = 1;
        gbc.gridy = 16;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.polledBtn, gbc);
        this.polledBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.polledBtnActionPerformed(evt);
            }
        });
        this.periodLabel = new JLabel("  Period :");
        this.periodLabel.setHorizontalAlignment(4);
        gbc.gridx = 1;
        gbc.gridy = 17;
        this.jPanel2.add((Component)this.periodLabel, gbc);
        this.periodText = new JTextField();
        gbc.gridx = 2;
        gbc.gridy = 17;
        gbc.fill = 2;
        this.jPanel2.add((Component)this.periodText, gbc);
        this.periodText.setRequestFocusEnabled(true);
        this.periodUnitLabel = new JLabel(" ms  ");
        gbc.gridx = 3;
        gbc.gridy = 17;
        this.jPanel2.add((Component)this.periodUnitLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 18;
        this.jPanel2.add((Component)new JLabel(" "), gbc);
        this.setPeriodEnabled(false);
    }

    private void setPeriodEnabled(boolean state) {
        this.periodLabel.setVisible(state);
        this.periodText.setVisible(state);
        this.periodUnitLabel.setVisible(state);
        if (state) {
            String txt = this.poll_period == 0 ? "2000" : "" + this.poll_period;
            this.periodText.setText(txt);
            this.pack();
        }
    }

    private void polledBtnActionPerformed(ActionEvent evt) {
        boolean state = this.polledBtn.getSelectedObjects() != null;
        this.setPeriodEnabled(state);
        if (state) {
            this.periodText.selectAll();
            this.periodText.requestFocus();
        }
    }

    public AttributeDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.addElements();
        this.pack();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.nameLbl = new JLabel();
        this.attrTypeCB = new JComboBox();
        this.jLabel1 = new JLabel();
        this.nameText = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.dataTypeCB = new JComboBox();
        this.xDataLBL = new JLabel();
        this.yDataLBL = new JLabel();
        this.xDataTF = new JTextField();
        this.yDataTF = new JTextField();
        this.rwTypeCB = new JComboBox();
        this.jLabel5 = new JLabel();
        this.assAttrLBL = new JLabel();
        this.assAttrTF = new JTextField();
        this.rwTypeLBL = new JLabel();
        this.propertyPanel = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.attrPropLabel = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.attrPropUnit = new JTextField();
        this.attrPropStdUnit = new JTextField();
        this.attrPropDispUnit = new JTextField();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.attrPropFormat = new JTextField();
        this.attrPropMaxValue = new JTextField();
        this.attrPropMinValue = new JTextField();
        this.attrPropMaxAlarm = new JTextField();
        this.attrPropMinAlarm = new JTextField();
        this.jLabel16 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.attrPropDescription = new JTextArea();
        this.jPanel1 = new JPanel();
        this.propertyBtn = new JButton();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.setBackground(new Color(198, 178, 168));
        this.setTitle("Edit Attribute Window");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AttributeDialog.this.closeDialog(evt);
            }
        });
        this.jPanel2.setLayout(new GridBagLayout());
        this.nameLbl.setText("Attribute Type: ");
        this.nameLbl.setForeground(Color.black);
        this.nameLbl.setFont(new Font("Arial", 1, 12));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.nameLbl, gridBagConstraints1);
        this.attrTypeCB.setFont(new Font("Arial", 1, 12));
        this.attrTypeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.attrTypeCBActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = 2;
        this.jPanel2.add((Component)this.attrTypeCB, gridBagConstraints1);
        this.jLabel1.setText("Attribute Name: ");
        this.jLabel1.setForeground(Color.black);
        this.jLabel1.setFont(new Font("Arial", 1, 12));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints1);
        this.nameText.setFont(new Font("Arial", 1, 12));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        this.jPanel2.add((Component)this.nameText, gridBagConstraints1);
        this.jLabel2.setPreferredSize(new Dimension(50, 50));
        this.jLabel2.setMinimumSize(new Dimension(50, 50));
        this.jLabel2.setText(" ");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 10;
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints1);
        this.jLabel3.setPreferredSize(new Dimension(20, 15));
        this.jLabel3.setMinimumSize(new Dimension(20, 15));
        this.jLabel3.setText(" ");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 2;
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints1);
        this.jLabel4.setText("Data Type: ");
        this.jLabel4.setForeground(Color.black);
        this.jLabel4.setFont(new Font("Arial", 1, 12));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints1);
        this.dataTypeCB.setFont(new Font("Arial", 1, 12));
        this.dataTypeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.dataTypeCBActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = 2;
        this.jPanel2.add((Component)this.dataTypeCB, gridBagConstraints1);
        this.xDataLBL.setText("Maximum X data size");
        this.xDataLBL.setForeground(Color.black);
        this.xDataLBL.setFont(new Font("Arial", 1, 12));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.xDataLBL, gridBagConstraints1);
        this.yDataLBL.setText("Maximum Y data size: ");
        this.yDataLBL.setForeground(Color.black);
        this.yDataLBL.setFont(new Font("Arial", 1, 12));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 7;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.yDataLBL, gridBagConstraints1);
        this.xDataTF.setPreferredSize(new Dimension(100, 20));
        this.xDataTF.setMinimumSize(new Dimension(100, 20));
        this.xDataTF.setFont(new Font("Arial", 1, 12));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.fill = 2;
        this.jPanel2.add((Component)this.xDataTF, gridBagConstraints1);
        this.yDataTF.setPreferredSize(new Dimension(100, 20));
        this.yDataTF.setMinimumSize(new Dimension(100, 20));
        this.yDataTF.setFont(new Font("Arial", 1, 12));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 7;
        gridBagConstraints1.fill = 2;
        this.jPanel2.add((Component)this.yDataTF, gridBagConstraints1);
        this.rwTypeCB.setFont(new Font("Arial", 1, 12));
        this.rwTypeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.rwTypeCBActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.fill = 2;
        this.jPanel2.add((Component)this.rwTypeCB, gridBagConstraints1);
        this.jLabel5.setText(" ");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 5;
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints1);
        this.assAttrLBL.setText("Associated Attribute:");
        this.assAttrLBL.setForeground(Color.black);
        this.assAttrLBL.setFont(new Font("Arial", 1, 12));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 8;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.assAttrLBL, gridBagConstraints1);
        this.assAttrTF.setPreferredSize(new Dimension(100, 20));
        this.assAttrTF.setMinimumSize(new Dimension(100, 20));
        this.assAttrTF.setFont(new Font("Arial", 1, 12));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 8;
        gridBagConstraints1.fill = 2;
        this.jPanel2.add((Component)this.assAttrTF, gridBagConstraints1);
        this.rwTypeLBL.setText("Read/Write Type: ");
        this.rwTypeLBL.setForeground(Color.black);
        this.rwTypeLBL.setFont(new Font("Arial", 1, 12));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.rwTypeLBL, gridBagConstraints1);
        this.propertyPanel.setLayout(new GridBagLayout());
        this.jLabel6.setText("Default Attribute Properties");
        this.jLabel6.setForeground(Color.black);
        this.jLabel6.setFont(new Font("Dialog", 0, 12));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 1;
        this.propertyPanel.add((Component)this.jLabel6, gridBagConstraints2);
        this.jLabel7.setText("Label");
        this.jLabel7.setForeground(Color.black);
        this.jLabel7.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.jLabel7, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.attrPropLabel, gridBagConstraints2);
        this.jLabel8.setText("Unit");
        this.jLabel8.setForeground(Color.black);
        this.jLabel8.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.jLabel8, gridBagConstraints2);
        this.jLabel9.setText("Standard Unit");
        this.jLabel9.setForeground(Color.black);
        this.jLabel9.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.jLabel9, gridBagConstraints2);
        this.jLabel10.setText("Display Unit");
        this.jLabel10.setForeground(Color.black);
        this.jLabel10.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 6;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.jLabel10, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.attrPropUnit, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.attrPropStdUnit, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 6;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.attrPropDispUnit, gridBagConstraints2);
        this.jLabel11.setText("Display Format       ");
        this.jLabel11.setForeground(Color.black);
        this.jLabel11.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 7;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.jLabel11, gridBagConstraints2);
        this.jLabel12.setText("Max. Value");
        this.jLabel12.setForeground(Color.black);
        this.jLabel12.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 8;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.jLabel12, gridBagConstraints2);
        this.jLabel13.setText("Min. Value");
        this.jLabel13.setForeground(Color.black);
        this.jLabel13.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 9;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.jLabel13, gridBagConstraints2);
        this.jLabel14.setText("Max. Alarm");
        this.jLabel14.setForeground(Color.black);
        this.jLabel14.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 10;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.jLabel14, gridBagConstraints2);
        this.jLabel15.setText("Min. Alarm");
        this.jLabel15.setForeground(Color.black);
        this.jLabel15.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 11;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.jLabel15, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 7;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.attrPropFormat, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 8;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.attrPropMaxValue, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 9;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.attrPropMinValue, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 10;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.attrPropMaxAlarm, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 11;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.attrPropMinAlarm, gridBagConstraints2);
        this.jLabel16.setText("Description :");
        this.jLabel16.setForeground(Color.black);
        this.jLabel16.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 12;
        gridBagConstraints2.fill = 2;
        this.propertyPanel.add((Component)this.jLabel16, gridBagConstraints2);
        this.jScrollPane1.setPreferredSize(new Dimension(250, 100));
        this.jScrollPane1.setViewportView(this.attrPropDescription);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 13;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridheight = 6;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 2.0;
        gridBagConstraints2.weighty = 6.0;
        this.propertyPanel.add((Component)this.jScrollPane1, gridBagConstraints2);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 20;
        gridBagConstraints1.gridwidth = 2;
        this.jPanel2.add((Component)this.propertyPanel, gridBagConstraints1);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel1.setLayout(new FlowLayout(2, 5, 5));
        this.propertyBtn.setText("Default Properties");
        this.propertyBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.propertyBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.propertyBtn);
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
    }

    private void rwTypeCBActionPerformed(ActionEvent evt) {
        this.updateWindow();
    }

    private void dataTypeCBActionPerformed(ActionEvent evt) {
        this.updateWindow();
    }

    private void attrTypeCBActionPerformed(ActionEvent evt) {
        this.updateWindow();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private int checkIntField(String s) {
        int end = s.indexOf(46);
        if (end >= 0) {
            s = s.substring(0, end);
        }
        if (s.length() == 0) {
            return -1;
        }
        int value = new Integer(s);
        if (value < 0) {
            return -2;
        }
        return value;
    }

    private void propertyBtnActionPerformed(ActionEvent evt) {
        this.propertyPanel.setVisible(!this.propertyPanel.isVisible());
        this.propertyBtn.setVisible(false);
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        String message = null;
        this.name = this.nameText.getText();
        if (this.name.length() == 0) {
            message = "The attribute needs a name to be defined";
        } else {
            StringTokenizer stk = new StringTokenizer(this.nameText.getText());
            String name = stk.nextToken();
            if (name.charAt(0) >= 'a' || name.charAt(0) >= 'z') {
                char car = (char)(name.charAt(0) - 32);
                name = new String(car + name.substring(1));
            }
            this.nameText.setText(name);
            this.attrType = this.attrTypeCB.getSelectedIndex();
            block1 : switch (this.attrType) {
                case 0: {
                    if (this.rwTypeCB.getSelectedIndex() == 3) {
                        this.assAttr = this.assAttrTF.getText();
                        break;
                    }
                    this.assAttr = "";
                    break;
                }
                case 1: {
                    this.xSize = this.checkIntField(this.xDataTF.getText());
                    switch (this.xSize) {
                        case -1: {
                            message = "Spectrum Attribute needs an X length of data";
                            break;
                        }
                        case -2: {
                            message = "Spectrum Attribute needs a POSITIVE X length of data";
                        }
                    }
                    break;
                }
                case 2: {
                    this.xSize = this.checkIntField(this.xDataTF.getText());
                    switch (this.xSize) {
                        case -1: {
                            message = "Image Attribute needs an X length of data";
                            break;
                        }
                        case -2: {
                            message = "Image Attribute needs a POSITIVE X length of data";
                        }
                    }
                    this.ySize = this.checkIntField(this.yDataTF.getText());
                    switch (this.ySize) {
                        case -1: {
                            message = "Image Attribute needs an Y length of data";
                            break block1;
                        }
                        case -2: {
                            message = "Image Attribute needs a POSITIVE Y length of data";
                        }
                    }
                }
            }
        }
        if (this.polledBtn.getSelectedObjects() != null) {
            String strval = this.periodText.getText();
            try {
                this.poll_period = Integer.parseInt(strval);
                if (this.poll_period < 20) {
                    message = new String("The polling period minimum value is  20 ms");
                }
            }
            catch (NumberFormatException e) {
                message = new String(e.toString() + "\n\nBad Value in Polling period field !");
            }
        }
        if (message != null) {
            JOptionPane.showMessageDialog(this, message, "Error Window", 0);
        } else {
            this.doClose(1);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    public int showDialog(Attrib attr) {
        this.nameText.setText(attr.name);
        this.xDataTF.setText(new Integer(attr.xSize).toString());
        this.yDataTF.setText(new Integer(attr.ySize).toString());
        this.assAttrTF.setText(attr.assAttr);
        this.attrTypeCB.setSelectedIndex(attr.attrType);
        this.rwTypeCB.setSelectedIndex(attr.rwType);
        int i = 0;
        while (i < PogoDefs.AttrDataArray.length) {
            if (PogoDefs.AttrDataArray[i].equals(attr.dataType.cpp_code_str)) {
                this.dataTypeCB.setSelectedIndex(i);
            }
            ++i;
        }
        if (attr.properties != null) {
            int i2 = 0;
            while (i2 <= 9) {
                JTextComponent txt = (JTextComponent)this.prop_txt.elementAt(i2);
                String value = attr.properties[i2];
                if (value != null) {
                    if (i2 == 9) {
                        StringBuffer sb = new StringBuffer();
                        int j = 0;
                        while (j < value.length()) {
                            if (value.charAt(j) == '\\' && value.charAt(j + 1) == 'n') {
                                sb.append("\n");
                                ++j;
                            } else {
                                sb.append(value.charAt(j));
                            }
                            ++j;
                        }
                        txt.setText(sb.toString());
                    } else {
                        txt.setText(value);
                    }
                }
                ++i2;
            }
        }
        this.updateWindow();
        if (attr.disp_level == DispLevel.EXPERT) {
            this.levelBtn.setSelected(true);
        }
        if ((this.poll_period = attr.polled_period) > 0) {
            this.polledBtn.setSelected(true);
            this.setPeriodEnabled(true);
        } else {
            this.setPeriodEnabled(false);
        }
        this.setVisible(true);
        return returnStatus;
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public Attrib getInput() {
        Attrib attr = null;
        switch (this.attrTypeCB.getSelectedIndex()) {
            case 0: {
                attr = new Attrib(this.name, 0, this.dataTypeCB.getSelectedItem().toString(), this.rwTypeCB.getSelectedIndex(), this.assAttr);
                break;
            }
            case 1: {
                attr = new Attrib(this.name, 1, this.dataTypeCB.getSelectedItem().toString(), this.xSize);
                break;
            }
            case 2: {
                attr = new Attrib(this.name, 2, this.dataTypeCB.getSelectedItem().toString(), this.xSize, this.ySize);
            }
        }
        if (this.polledBtn.getSelectedObjects() != null) {
            String strval = this.periodText.getText();
            attr.polled_period = Integer.parseInt(strval);
        }
        if (this.levelBtn.getSelectedObjects() != null) {
            attr.disp_level = DispLevel.EXPERT;
        }
        int i = 0;
        while (i <= 9) {
            JTextComponent txt = (JTextComponent)this.prop_txt.elementAt(i);
            String value = txt.getText();
            if (i == 9) {
                StringBuffer sb = new StringBuffer();
                int j = 0;
                while (j < value.length()) {
                    if (value.charAt(j) == '\n') {
                        sb.append("\\n");
                    } else {
                        sb.append(value.charAt(j));
                    }
                    ++j;
                }
                attr.properties[i] = sb.toString();
            } else {
                attr.properties[i] = value;
            }
            ++i;
        }
        return attr;
    }

    private void updateWindow() {
        block0 : switch (this.attrTypeCB.getSelectedIndex()) {
            case 0: {
                this.rwTypeCB.setVisible(true);
                this.rwTypeLBL.setVisible(true);
                this.xDataTF.setVisible(false);
                this.yDataTF.setVisible(false);
                this.xDataLBL.setVisible(false);
                this.yDataLBL.setVisible(false);
                switch (this.rwTypeCB.getSelectedIndex()) {
                    case 3: {
                        this.assAttrTF.setVisible(true);
                        this.assAttrLBL.setVisible(true);
                        break block0;
                    }
                }
                this.assAttrTF.setVisible(false);
                this.assAttrLBL.setVisible(false);
                break;
            }
            case 1: {
                this.rwTypeCB.setVisible(false);
                this.rwTypeLBL.setVisible(false);
                this.xDataTF.setVisible(true);
                this.yDataTF.setVisible(false);
                this.xDataLBL.setVisible(true);
                this.yDataLBL.setVisible(false);
                this.assAttrTF.setVisible(false);
                this.assAttrLBL.setVisible(false);
                break;
            }
            case 2: {
                this.rwTypeCB.setVisible(false);
                this.rwTypeLBL.setVisible(false);
                this.xDataTF.setVisible(true);
                this.yDataTF.setVisible(true);
                this.xDataLBL.setVisible(true);
                this.yDataLBL.setVisible(true);
                this.assAttrTF.setVisible(false);
                this.assAttrLBL.setVisible(false);
            }
        }
        this.pack();
    }

    public static void main(String[] args) {
        new AttributeDialog(new Frame(), false).show();
    }
}

