/*
 * Decompiled with CFR 0.152.
 */
package jive;

import atkpanel.MainPanel;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jive.Clipboard;
import jive.DetailsDlg;
import jive.FindInfo;
import jive.JiveMenu;
import jive.RenameDlg;
import jive.ServerDlg;
import jive.ThreadDlg;

public class TangoTreeNode
extends DefaultMutableTreeNode {
    private boolean areChildrenDefined = false;
    private int numChildren;
    public int type;
    public int level;
    private String value;
    private Database db;
    public static int nbAction = 16;
    public static RenameDlg dlg = null;
    public static String[] att_prop_default = new String[]{"description", "label", "unit", "standard_unit", "display_unit", "format", "min_value", "max_value", "min_alarm", "max_alarm"};
    public static Clipboard the_clipboard = new Clipboard();
    public static Frame parent = null;
    public static MainPanel atkdlg = null;
    public static boolean error_report = true;
    public static int scan_progress;
    public static Stack searchStack;
    public static String searchText;
    public static boolean searchIngoreCase;
    public static boolean searchValues;
    public static boolean searchAttributes;
    public static boolean searchUseRegexp;
    public static boolean searchOnlyLeaf;
    public static boolean searchStopflag;
    public static TreePath searchResult;
    public static TreePath[] searchResults;
    public static ThreadDlg searchDlg;

    public TangoTreeNode(int n, int n2, String string, Database database) {
        this.level = n;
        this.type = n2;
        this.value = string;
        this.db = database;
    }

    public boolean isLeaf() {
        switch (this.type) {
            case 1: {
                if (this.level == 4 && this.getParent().toString().equals("PROPERTY")) {
                    return true;
                }
                return this.level == 5 && this.getParent().getParent().toString().equals("ATTRIBUTE");
            }
            case 2: {
                return this.level >= 4;
            }
            case 3: {
                if (this.level == 6 && this.getParent().toString().equals("PROPERTY")) {
                    return true;
                }
                return this.level == 7 && this.getParent().getParent().toString().equals("ATTRIBUTE");
            }
            case 4: {
                return this.level == 3;
            }
            case 5: {
                return this.level >= 2;
            }
        }
        return false;
    }

    public int getChildCount() {
        if (!this.areChildrenDefined) {
            this.defineChildNodes();
        }
        return super.getChildCount();
    }

    private void defineChildNodes() {
        this.areChildrenDefined = true;
        if (this.level == 0) {
            this.numChildren = 5;
            this.add(new TangoTreeNode(1, 1, "CLASS", this.db));
            this.add(new TangoTreeNode(1, 2, "SERVER", this.db));
            this.add(new TangoTreeNode(1, 3, "DEVICE", this.db));
            this.add(new TangoTreeNode(1, 4, "PROPERTY", this.db));
            this.add(new TangoTreeNode(1, 5, "TAGS", this.db));
        } else if (this.db != null) {
            String[] stringArray = new String[]{};
            try {
                block5 : switch (this.type) {
                    case 1: {
                        DbAttribute[] dbAttributeArray;
                        DeviceProxy deviceProxy;
                        try {
                            switch (this.level) {
                                case 1: {
                                    stringArray = this.db.get_class_list("*");
                                    break block5;
                                }
                                case 2: {
                                    stringArray = new String[]{"PROPERTY", "ATTRIBUTE"};
                                    break block5;
                                }
                                case 3: {
                                    if (this.toString().equals("PROPERTY")) {
                                        stringArray = this.db.get_class_property_list(this.getParent().toString(), "*");
                                        break block5;
                                    }
                                    stringArray = this.db.get_class_attribute_list(this.getParent().toString(), "*");
                                    break block5;
                                }
                                case 4: {
                                    deviceProxy = new DeviceProxy[]{this.toString()};
                                    dbAttributeArray = this.db.get_class_attribute_property(this.getParent().getParent().toString(), (String[])deviceProxy);
                                    if (dbAttributeArray.length <= 0) break;
                                    stringArray = dbAttributeArray[0].get_property_list();
                                }
                            }
                        }
                        catch (DevFailed devFailed) {
                            TangoTreeNode.showTangoError(devFailed);
                        }
                        break;
                    }
                    case 2: {
                        DeviceProxy deviceProxy;
                        try {
                            switch (this.level) {
                                case 1: {
                                    stringArray = this.db.get_server_list();
                                    break block5;
                                }
                                case 2: {
                                    deviceProxy = new DbServer(this.toString());
                                    stringArray = deviceProxy.get_class_list();
                                    break block5;
                                }
                                case 3: {
                                    deviceProxy = new DbServer(this.getParent().toString());
                                    stringArray = deviceProxy.get_device_name(this.toString());
                                }
                            }
                        }
                        catch (DevFailed devFailed) {
                            TangoTreeNode.showTangoError(devFailed);
                        }
                        break;
                    }
                    case 3: {
                        DbAttribute[] dbAttributeArray;
                        DeviceProxy deviceProxy;
                        try {
                            switch (this.level) {
                                case 1: {
                                    stringArray = this.db.get_device_domain("*");
                                    break block5;
                                }
                                case 2: {
                                    stringArray = this.db.get_device_family(this.toString() + "/*");
                                    break block5;
                                }
                                case 3: {
                                    stringArray = this.db.get_device_member(this.getParent().toString() + "/" + this.toString() + "/*");
                                    break block5;
                                }
                                case 4: {
                                    stringArray = new String[]{"PROPERTY", "ATTRIBUTE"};
                                    break block5;
                                }
                                case 5: {
                                    String string = TangoTreeNode.getDevname(this, 1);
                                    if (this.toString().equals("PROPERTY")) {
                                        stringArray = this.db.get_device_property_list(string, "*");
                                        break block5;
                                    }
                                    deviceProxy = new DeviceProxy(string);
                                    stringArray = deviceProxy.get_attribute_list();
                                    break block5;
                                }
                                case 6: {
                                    String string = TangoTreeNode.getDevname(this, 2);
                                    deviceProxy = new String[]{this.toString()};
                                    dbAttributeArray = this.db.get_device_attribute_property(string, (String[])deviceProxy);
                                    if (dbAttributeArray.length <= 0) break;
                                    stringArray = dbAttributeArray[0].get_property_list();
                                }
                            }
                        }
                        catch (DevFailed devFailed) {
                            TangoTreeNode.showTangoError(devFailed);
                        }
                        break;
                    }
                    case 4: {
                        try {
                            switch (this.level) {
                                case 1: {
                                    stringArray = this.db.get_object_list("*");
                                    break block5;
                                }
                                case 2: {
                                    stringArray = this.db.get_object_property_list(this.toString(), "*");
                                }
                            }
                        }
                        catch (DevFailed devFailed) {
                            TangoTreeNode.showTangoError(devFailed);
                        }
                        break;
                    }
                    case 5: {
                        switch (this.level) {
                            case 1: {
                                stringArray = new String[]{"Not implemented"};
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            this.numChildren = stringArray.length;
            int n = 0;
            while (n < this.numChildren) {
                this.add(new TangoTreeNode(this.level + 1, this.type, stringArray[n], this.db));
                ++n;
            }
        }
    }

    public static String formatPath(TreePath treePath) {
        String string = "";
        if (treePath == null) {
            return string;
        }
        int n = treePath.getPathCount();
        TangoTreeNode tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        int n2 = 1;
        while (n2 < n) {
            string = string + treePath.getPathComponent(n2);
            if (n2 < n - 1 || !tangoTreeNode.isLeaf()) {
                block0 : switch (tangoTreeNode.type) {
                    case 1: {
                        switch (n2 - 1) {
                            case 0: {
                                string = string + ":";
                                break block0;
                            }
                            case 1: {
                                string = string + " ";
                                break block0;
                            }
                            case 2: {
                                string = string + ":";
                                break block0;
                            }
                            case 3: {
                                string = string + "/";
                                break block0;
                            }
                        }
                        string = string + " ";
                        break;
                    }
                    case 2: {
                        switch (n2 - 1) {
                            case 0: {
                                string = string + ":";
                                break block0;
                            }
                            case 1: {
                                string = string + " CLASS:";
                                break block0;
                            }
                        }
                        string = string + " ";
                        break;
                    }
                    case 3: {
                        switch (n2 - 1) {
                            case 0: {
                                string = string + ":";
                                break block0;
                            }
                            case 1: {
                                string = string + "/";
                                break block0;
                            }
                            case 2: {
                                string = string + "/";
                                break block0;
                            }
                            case 3: {
                                string = string + " ";
                                break block0;
                            }
                            case 4: {
                                string = string + ":";
                                break block0;
                            }
                            case 5: {
                                string = string + "/";
                                break block0;
                            }
                        }
                        string = string + " ";
                        break;
                    }
                    case 4: 
                    case 5: {
                        switch (n2 - 1) {
                            case 0: {
                                string = string + ":";
                                break block0;
                            }
                        }
                        string = string + " ";
                    }
                }
            }
            ++n2;
        }
        return string;
    }

    public static String stringArrayToString(String[] stringArray) {
        String string = "";
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                string = string + stringArray[n];
                if (n + 1 < stringArray.length) {
                    string = string + "\n";
                }
                ++n;
            }
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public static String[] getValue(TreePath var0) {
        var1_1 = (TangoTreeNode)var0.getLastPathComponent();
        var2_2 = "";
        var3_3 = "...";
        var4_4 = new String[2];
        switch (var1_1.type) {
            case 1: {
                if (var1_1.level == 4 && var1_1.getParent().toString().equals("PROPERTY")) {
                    try {
                        var6_5 = var1_1.db.get_class_property(var1_1.getParent().getParent().toString(), var1_1.toString()).extractStringArray();
                        var2_2 = TangoTreeNode.stringArrayToString(var6_5);
                        var3_3 = "Property value";
                        if (var6_5.length >= 2) {
                            var3_3 = var3_3 + " [" + var6_5.length + " items]";
                        }
                    }
                    catch (Exception var6_6) {
                        System.out.println(var6_6);
                        var6_6.printStackTrace();
                    }
                }
                if (var1_1.level != 5 || !var1_1.getParent().getParent().toString().equals("ATTRIBUTE")) break;
                try {
                    var6_5 = new String[]{var1_1.getParent().toString()};
                    var7_17 = var1_1.db.get_class_attribute_property(var1_1.getParent().getParent().getParent().toString(), var6_5);
                    if (var7_17 != null && var7_17.length > 0) {
                        var2_2 = var2_2 + var7_17[0].get_value(var1_1.toString());
                    }
                    var3_3 = "Property value";
                }
                catch (Exception var6_7) {
                    System.out.println(var6_7);
                    var6_7.printStackTrace();
                }
                break;
            }
            case 2: 
            case 3: {
                if (var1_1.level == 4) {
                    try {
                        try {
                            var6_8 = var1_1.type == 2 ? var1_1.toString() : TangoTreeNode.getDevname(var1_1, 0);
                            var7_18 = new DbDevice(var6_8);
                            var8_19 = var7_18.import_device();
                            var2_2 = var8_19.toString();
                            var3_3 = "Device info";
                            ** GOTO lbl52
                        }
                        catch (DevFailed var6_9) {
                            var5_20 = 0;
                            ** while (var5_20 < var6_9.errors.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            var2_2 = var2_2 + "Desc -> " + var6_9.errors[var5_20].desc + "\n";
                            var2_2 = var2_2 + "Reason -> " + var6_9.errors[var5_20].reason + "\n";
                            var2_2 = var2_2 + "Origin -> " + var6_9.errors[var5_20].origin + "\n";
                            ++var5_20;
                            continue;
lbl48:
                            // 1 sources

                        }
                    }
                    catch (Exception var6_10) {
                        System.out.println(var6_10);
                        var6_10.printStackTrace();
                    }
                }
lbl52:
                // 5 sources

                if (var1_1.type == 2 && var1_1.level == 2) {
                    try {
                        try {
                            var6_8 = new DbServer(var1_1.toString());
                            var7_18 = var6_8.get_info();
                            var2_2 = var7_18.toString();
                            var3_3 = "Server info";
                            ** GOTO lbl72
                        }
                        catch (DevFailed var6_11) {
                            var5_20 = 0;
                            ** while (var5_20 < var6_11.errors.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            var2_2 = var2_2 + "Desc -> " + var6_11.errors[var5_20].desc + "\n";
                            var2_2 = var2_2 + "Reason -> " + var6_11.errors[var5_20].reason + "\n";
                            var2_2 = var2_2 + "Origin -> " + var6_11.errors[var5_20].origin + "\n";
                            ++var5_20;
                            continue;
lbl68:
                            // 1 sources

                        }
                    }
                    catch (Exception var6_12) {
                        System.out.println(var6_12);
                        var6_12.printStackTrace();
                    }
                }
lbl72:
                // 5 sources

                if (var1_1.type == 2) break;
                if (var1_1.level == 6 && var1_1.getParent().toString().equals("PROPERTY")) {
                    try {
                        var6_8 = TangoTreeNode.getDevname(var1_1, 2);
                        var7_18 = var1_1.db.get_device_property(var6_8, var1_1.toString()).extractStringArray();
                        var2_2 = TangoTreeNode.stringArrayToString(var7_18);
                        var3_3 = "Property value";
                        if (var7_18.length >= 2) {
                            var3_3 = var3_3 + " [" + var7_18.length + " items]";
                        }
                    }
                    catch (Exception var6_13) {
                        System.out.println(var6_13);
                        var6_13.printStackTrace();
                    }
                }
                if (var1_1.level != 7 || !var1_1.getParent().getParent().toString().equals("ATTRIBUTE")) break;
                try {
                    var6_8 = TangoTreeNode.getDevname(var1_1, 3);
                    var7_18 = new String[]{var1_1.getParent().toString()};
                    var8_19 = var1_1.db.get_device_attribute_property(var6_8, var7_18);
                    if (var8_19 != null && var8_19.length > 0) {
                        var2_2 = var2_2 + var8_19[0].get_value(var1_1.toString());
                    }
                    var3_3 = "Property value";
                }
                catch (Exception var6_14) {
                    System.out.println(var6_14);
                    var6_14.printStackTrace();
                }
                break;
            }
            case 4: {
                if (var1_1.level != 3) break;
                try {
                    var6_15 = var1_1.db.get_property(var1_1.getParent().toString(), var1_1.toString()).extractStringArray();
                    var2_2 = TangoTreeNode.stringArrayToString(var6_15);
                    var3_3 = "Property value";
                    if (var6_15.length < 2) break;
                    var3_3 = var3_3 + " [" + var6_15.length + " items]";
                }
                catch (Exception var6_16) {
                    System.out.println(var6_16);
                    var6_16.printStackTrace();
                }
                break;
            }
        }
        var4_4[0] = var2_2;
        var4_4[1] = var3_3;
        return var4_4;
    }

    public static DbDatum[] makeDbDatum(String string, String string2) {
        String[] stringArray = string2.split("\n");
        DbDatum[] dbDatumArray = new DbDatum[]{stringArray.length <= 1 ? new DbDatum(string, string2) : new DbDatum(string, stringArray)};
        return dbDatumArray;
    }

    public static void copyClassProperties(String string, TangoTreeNode tangoTreeNode) {
        String string2 = "%";
        try {
            String[] stringArray;
            String[] stringArray2 = tangoTreeNode.db.get_class_property_list(string, "*");
            int n = 0;
            while (n < stringArray2.length) {
                stringArray = tangoTreeNode.db.get_class_property(string, stringArray2[n]).extractStringArray();
                the_clipboard.add(stringArray2[n], TangoTreeNode.stringArrayToString(stringArray));
                ++n;
            }
            stringArray2 = tangoTreeNode.db.get_class_attribute_list(string, "*");
            n = 0;
            while (n < stringArray2.length) {
                stringArray = new String[]{stringArray2[n]};
                DbAttribute[] dbAttributeArray = tangoTreeNode.db.get_class_attribute_property(string, stringArray);
                if (dbAttributeArray.length > 0) {
                    String[] stringArray3 = dbAttributeArray[0].get_property_list();
                    int n2 = 0;
                    while (n2 < stringArray3.length) {
                        the_clipboard.add(stringArray3[n2], stringArray2[n], dbAttributeArray[0].get_value(n2));
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (DevFailed devFailed) {
            TangoTreeNode.showTangoError(devFailed);
        }
    }

    public static boolean removeClassProperties(String string, TangoTreeNode tangoTreeNode) {
        String string2 = "%";
        try {
            String[] stringArray = tangoTreeNode.db.get_class_property_list(string, "*");
            int n = 0;
            while (n < stringArray.length) {
                tangoTreeNode.db.delete_class_property(string, TangoTreeNode.makeDbDatum(stringArray[n], string2));
                ++n;
            }
            stringArray = tangoTreeNode.db.get_class_attribute_list(string, "*");
            n = 0;
            while (n < stringArray.length) {
                String[] stringArray2 = new String[]{stringArray[n]};
                DbAttribute[] dbAttributeArray = tangoTreeNode.db.get_class_attribute_property(string, stringArray2);
                if (dbAttributeArray.length > 0) {
                    String[] stringArray3 = dbAttributeArray[0].get_property_list();
                    int n2 = 0;
                    while (n2 < stringArray3.length) {
                        System.out.println("Removing: " + string + " ATT " + stringArray[n] + " PROP " + stringArray3[n2]);
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (DevFailed devFailed) {
            TangoTreeNode.showTangoError(devFailed);
            return false;
        }
        return true;
    }

    public static void copyDeviceProperties(String string, TangoTreeNode tangoTreeNode) {
        String string2 = "%";
        try {
            String[] stringArray;
            String[] stringArray2 = tangoTreeNode.db.get_device_property_list(string, "*");
            int n = 0;
            while (n < stringArray2.length) {
                stringArray = tangoTreeNode.db.get_device_property(string, stringArray2[n]).extractStringArray();
                the_clipboard.add(stringArray2[n], TangoTreeNode.stringArrayToString(stringArray));
                ++n;
            }
            stringArray = new DeviceProxy(string);
            stringArray2 = stringArray.get_attribute_list();
            n = 0;
            while (n < stringArray2.length) {
                String[] stringArray3 = new String[]{stringArray2[n]};
                DbAttribute[] dbAttributeArray = tangoTreeNode.db.get_device_attribute_property(string, stringArray3);
                if (dbAttributeArray != null && dbAttributeArray.length > 0) {
                    String[] stringArray4 = dbAttributeArray[0].get_property_list();
                    int n2 = 0;
                    while (n2 < stringArray4.length) {
                        the_clipboard.add(stringArray4[n2], stringArray2[n], dbAttributeArray[0].get_value(n2));
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (DevFailed devFailed) {
            TangoTreeNode.showTangoError(devFailed);
        }
    }

    public static boolean removeDeviceProperties(String string, TangoTreeNode tangoTreeNode) {
        String string2 = "%";
        try {
            String[] stringArray = tangoTreeNode.db.get_device_property_list(string, "*");
            int n = 0;
            while (n < stringArray.length) {
                tangoTreeNode.db.delete_device_property(string, TangoTreeNode.makeDbDatum(stringArray[n], string2));
                ++n;
            }
            DeviceProxy deviceProxy = new DeviceProxy(string);
            stringArray = deviceProxy.get_attribute_list();
            n = 0;
            while (n < stringArray.length) {
                String[] stringArray2 = new String[]{stringArray[n]};
                DbAttribute[] dbAttributeArray = tangoTreeNode.db.get_device_attribute_property(string, stringArray2);
                if (dbAttributeArray.length > 0) {
                    String[] stringArray3 = dbAttributeArray[0].get_property_list();
                    int n2 = 0;
                    while (n2 < stringArray3.length) {
                        DbAttribute dbAttribute = new DbAttribute(stringArray[n]);
                        dbAttribute.add(stringArray3[n2], string2);
                        tangoTreeNode.db.delete_device_attribute_property(string, dbAttribute);
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (DevFailed devFailed) {
            TangoTreeNode.showTangoError(devFailed);
            return false;
        }
        return true;
    }

    public static boolean setValue(TreePath treePath, String string) {
        TangoTreeNode tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        switch (tangoTreeNode.type) {
            case 1: {
                if (tangoTreeNode.level == 2 && string.equals("%")) {
                    String string2 = tangoTreeNode.toString();
                    int n = JOptionPane.showConfirmDialog(parent, "This will erase all class and attribute properties for " + string2 + "\n Do you want to continue ?", "Confirm delete class properties", 0);
                    if (n == 0) {
                        return TangoTreeNode.removeClassProperties(string2, tangoTreeNode);
                    }
                    return false;
                }
                if (tangoTreeNode.level == 4 && tangoTreeNode.getParent().toString().equals("PROPERTY")) {
                    try {
                        if (string.equals("%")) {
                            tangoTreeNode.db.delete_class_property(tangoTreeNode.getParent().getParent().toString(), TangoTreeNode.makeDbDatum(tangoTreeNode.toString(), string));
                        } else {
                            tangoTreeNode.db.put_class_property(tangoTreeNode.getParent().getParent().toString(), TangoTreeNode.makeDbDatum(tangoTreeNode.toString(), string));
                        }
                    }
                    catch (DevFailed devFailed) {
                        TangoTreeNode.showTangoError(devFailed);
                        return false;
                    }
                }
                if (tangoTreeNode.level != 5 || !tangoTreeNode.getParent().getParent().toString().equals("ATTRIBUTE")) break;
                try {
                    DbAttribute dbAttribute = new DbAttribute(tangoTreeNode.getParent().toString());
                    dbAttribute.add(tangoTreeNode.toString(), string);
                    if (string.equals("%")) break;
                    tangoTreeNode.db.put_class_attribute_property(tangoTreeNode.getParent().getParent().getParent().toString(), dbAttribute);
                    break;
                }
                catch (DevFailed devFailed) {
                    TangoTreeNode.showTangoError(devFailed);
                    return false;
                }
            }
            case 2: {
                if (tangoTreeNode.level == 2 && string.equals("%")) {
                    try {
                        tangoTreeNode.db.delete_server(tangoTreeNode.toString());
                    }
                    catch (DevFailed devFailed) {
                        TangoTreeNode.showTangoError(devFailed);
                        return false;
                    }
                }
                if (tangoTreeNode.level == 3) {
                    try {
                        if (string.equals("%")) {
                            int n = 0;
                            while (n < tangoTreeNode.getChildCount()) {
                                tangoTreeNode.db.delete_device(tangoTreeNode.getChildAt(n).toString());
                                ++n;
                            }
                        }
                    }
                    catch (DevFailed devFailed) {
                        TangoTreeNode.showTangoError(devFailed);
                        return false;
                    }
                }
                if (tangoTreeNode.level != 4) break;
                try {
                    if (string.equals("%")) {
                        tangoTreeNode.db.delete_device(tangoTreeNode.toString());
                        break;
                    }
                    tangoTreeNode.db.add_device(tangoTreeNode.toString(), tangoTreeNode.getParent().toString(), tangoTreeNode.getParent().getParent().toString());
                    break;
                }
                catch (DevFailed devFailed) {
                    TangoTreeNode.showTangoError(devFailed);
                    return false;
                }
            }
            case 3: {
                String string3;
                if (tangoTreeNode.level == 4 && string.equals("%")) {
                    String string4 = TangoTreeNode.getDevname(tangoTreeNode, 0);
                    int n = JOptionPane.showConfirmDialog(parent, "This will erase all device and attribute properties for " + string4 + "\n Do you want to continue ?", "Confirm delte device properties", 0);
                    if (n == 0) {
                        return TangoTreeNode.removeDeviceProperties(string4, tangoTreeNode);
                    }
                    return false;
                }
                if (tangoTreeNode.level == 6 && tangoTreeNode.getParent().toString().equals("PROPERTY")) {
                    try {
                        string3 = TangoTreeNode.getDevname(tangoTreeNode, 2);
                        if (string.equals("%")) {
                            tangoTreeNode.db.delete_device_property(string3, TangoTreeNode.makeDbDatum(tangoTreeNode.toString(), string));
                        } else {
                            tangoTreeNode.db.put_device_property(string3, TangoTreeNode.makeDbDatum(tangoTreeNode.toString(), string));
                        }
                    }
                    catch (DevFailed devFailed) {
                        TangoTreeNode.showTangoError(devFailed);
                        return false;
                    }
                }
                if (tangoTreeNode.level != 7 || !tangoTreeNode.getParent().getParent().toString().equals("ATTRIBUTE")) break;
                try {
                    string3 = TangoTreeNode.getDevname(tangoTreeNode, 3);
                    DbAttribute dbAttribute = new DbAttribute(tangoTreeNode.getParent().toString());
                    dbAttribute.add(tangoTreeNode.toString(), string);
                    if (string.equals("%")) {
                        tangoTreeNode.db.delete_device_attribute_property(string3, dbAttribute);
                        break;
                    }
                    tangoTreeNode.db.put_device_attribute_property(string3, dbAttribute);
                    break;
                }
                catch (DevFailed devFailed) {
                    TangoTreeNode.showTangoError(devFailed);
                    return false;
                }
            }
            case 4: {
                if (tangoTreeNode.level != 3) break;
                try {
                    if (string.equals("%")) {
                        tangoTreeNode.db.delete_property(tangoTreeNode.getParent().toString(), TangoTreeNode.makeDbDatum(tangoTreeNode.toString(), string));
                        break;
                    }
                    tangoTreeNode.db.put_property(tangoTreeNode.getParent().toString(), TangoTreeNode.makeDbDatum(tangoTreeNode.toString(), string));
                    break;
                }
                catch (DevFailed devFailed) {
                    TangoTreeNode.showTangoError(devFailed);
                    return false;
                }
            }
        }
        return true;
    }

    public static String getDevname(TangoTreeNode tangoTreeNode, int n) {
        TreeNode treeNode = tangoTreeNode;
        int n2 = 0;
        while (n2 < n) {
            treeNode = treeNode.getParent();
            ++n2;
        }
        return treeNode.getParent().getParent().toString() + "/" + treeNode.getParent().toString() + "/" + treeNode.toString();
    }

    public static void showTangoError(DevFailed devFailed) {
        String string = "";
        if (error_report && devFailed != null) {
            int n = 0;
            while (n < devFailed.errors.length) {
                string = string + "Desc -> " + devFailed.errors[n].desc + "\n";
                string = string + "Reason -> " + devFailed.errors[n].reason + "\n";
                string = string + "Origin -> " + devFailed.errors[n].origin + "\n";
                ++n;
            }
            if (string.length() > 0) {
                JOptionPane.showMessageDialog(parent, string, "Tango error", 0);
            }
        }
    }

    public static void showJiveError(String string) {
        if (error_report) {
            JOptionPane.showMessageDialog(parent, string, "Jive error", 0);
        }
    }

    public static FindInfo propertyExist(String string, DefaultTreeModel defaultTreeModel, TangoTreeNode tangoTreeNode) {
        int n = defaultTreeModel.getChildCount(tangoTreeNode);
        int n2 = 0;
        boolean bl = false;
        TangoTreeNode tangoTreeNode2 = null;
        while (n2 < n && !bl) {
            tangoTreeNode2 = (TangoTreeNode)defaultTreeModel.getChild(tangoTreeNode, n2);
            boolean bl2 = bl = tangoTreeNode2.toString().compareToIgnoreCase(string) == 0;
            if (bl) continue;
            ++n2;
        }
        return new FindInfo(n2, bl, tangoTreeNode2);
    }

    public static TreePath addProperty(String string, DefaultTreeModel defaultTreeModel, TreePath treePath, String string2, int n) {
        TangoTreeNode tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        FindInfo findInfo = TangoTreeNode.propertyExist(string, defaultTreeModel, tangoTreeNode);
        if (!findInfo.found) {
            TangoTreeNode tangoTreeNode2 = new TangoTreeNode(tangoTreeNode.level + 1, tangoTreeNode.type, string, tangoTreeNode.db);
            defaultTreeModel.insertNodeInto(tangoTreeNode2, tangoTreeNode, n);
            TreePath treePath2 = treePath.pathByAddingChild(tangoTreeNode2);
            TangoTreeNode.setValue(treePath2, string2);
            return treePath2;
        }
        if (string.substring(0, 12).toLowerCase().equals("new property")) {
            int n2 = 2;
            FindInfo findInfo2 = TangoTreeNode.propertyExist("New property#" + n2, defaultTreeModel, tangoTreeNode);
            while (findInfo2.found) {
                findInfo2 = TangoTreeNode.propertyExist("New property#" + ++n2, defaultTreeModel, tangoTreeNode);
            }
            return TangoTreeNode.addProperty("New property#" + n2, defaultTreeModel, treePath, string2, n);
        }
        return findInfo.nodeFound.getCompletePath();
    }

    public static void removeProperty(DefaultTreeModel defaultTreeModel, TreePath treePath) {
        TangoTreeNode tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        TangoTreeNode tangoTreeNode2 = (TangoTreeNode)treePath.getParentPath().getLastPathComponent();
        if (TangoTreeNode.setValue(treePath, "%")) {
            defaultTreeModel.removeNodeFromParent(tangoTreeNode);
        }
    }

    public static TreePath convertOldPath(DefaultTreeModel defaultTreeModel, TangoTreeNode tangoTreeNode, TreePath treePath) {
        TreePath treePath2 = new TreePath(tangoTreeNode);
        if (treePath != null) {
            int n = treePath.getPathCount();
            int n2 = 1;
            boolean bl = false;
            TangoTreeNode tangoTreeNode2 = tangoTreeNode;
            while (!bl && n2 < n) {
                TangoTreeNode tangoTreeNode3 = (TangoTreeNode)treePath.getPathComponent(n2);
                FindInfo findInfo = TangoTreeNode.propertyExist(tangoTreeNode3.toString(), defaultTreeModel, tangoTreeNode2);
                boolean bl2 = bl = !findInfo.found;
                if (bl) continue;
                tangoTreeNode2 = (TangoTreeNode)defaultTreeModel.getChild(tangoTreeNode2, findInfo.index);
                treePath2 = treePath2.pathByAddingChild(tangoTreeNode2);
                ++n2;
            }
        }
        return treePath2;
    }

    public static void showServerDlg(ServerDlg serverDlg, TreePath treePath, DefaultTreeModel defaultTreeModel, JTree jTree) {
        TangoTreeNode tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        if (tangoTreeNode.level == 3) {
            treePath = treePath.getParentPath();
            tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        }
        if (serverDlg.showDlg()) {
            TreePath treePath2;
            String[] stringArray = serverDlg.getDeviceNames();
            String string = serverDlg.getServerName();
            String string2 = serverDlg.getClassName();
            if (tangoTreeNode.level == 1) {
                treePath = TangoTreeNode.addProperty(string, defaultTreeModel, treePath, "", 0);
            }
            if ((treePath2 = TangoTreeNode.addProperty(string2, defaultTreeModel, treePath, "", 0)) != null) {
                jTree.setSelectionPath(treePath2);
            }
            try {
                int n = 0;
                while (n < stringArray.length) {
                    tangoTreeNode.db.add_device(new DbDevInfo(stringArray[n], string2, string));
                    ++n;
                }
            }
            catch (DevFailed devFailed) {
                TangoTreeNode.showTangoError(devFailed);
            }
        }
    }

    public static void execAction(int n, TreePath treePath, JTree jTree, DefaultTreeModel defaultTreeModel, Rectangle rectangle) {
        TangoTreeNode tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        switch (n) {
            case 0: 
            case 1: {
                the_clipboard.clear();
            }
            case 101: {
                String string;
                if (tangoTreeNode.isLeaf()) {
                    string = TangoTreeNode.getValue(treePath)[0];
                    if (tangoTreeNode.type == 3 && tangoTreeNode.level == 6 || tangoTreeNode.type == 1 && tangoTreeNode.level == 4) {
                        the_clipboard.add(tangoTreeNode.toString(), string);
                    } else {
                        the_clipboard.add(tangoTreeNode.toString(), tangoTreeNode.getParent().toString(), string);
                    }
                }
                if (tangoTreeNode.type == 3 && tangoTreeNode.level == 4) {
                    string = TangoTreeNode.getDevname(tangoTreeNode, 0);
                    TangoTreeNode.copyDeviceProperties(string, tangoTreeNode);
                }
                if (tangoTreeNode.type == 1 && tangoTreeNode.level == 2) {
                    TangoTreeNode.copyClassProperties(tangoTreeNode.toString(), tangoTreeNode);
                }
                if (n != 0) break;
                TangoTreeNode.removeProperty(defaultTreeModel, treePath);
                break;
            }
            case 2: {
                try {
                    DbAttribute dbAttribute;
                    int n2;
                    String string;
                    if (tangoTreeNode.type == 3 && tangoTreeNode.level == 5 && tangoTreeNode.toString().equals("PROPERTY")) {
                        string = TangoTreeNode.getDevname(tangoTreeNode, 1);
                        n2 = 0;
                        while (n2 < the_clipboard.getObjectPropertyLength()) {
                            tangoTreeNode.db.put_device_property(string, TangoTreeNode.makeDbDatum(the_clipboard.getObjectPropertyName(n2), the_clipboard.getObjectPropertyValue(n2)));
                            ++n2;
                        }
                    }
                    if (tangoTreeNode.type == 3 && tangoTreeNode.level == 5 && tangoTreeNode.toString().equals("ATTRIBUTE")) {
                        string = TangoTreeNode.getDevname(tangoTreeNode, 1);
                        n2 = 0;
                        while (n2 < the_clipboard.getAttPropertyLength()) {
                            dbAttribute = new DbAttribute(the_clipboard.getAttName(n2));
                            dbAttribute.add(the_clipboard.getAttPropertyName(n2), the_clipboard.getAttPropertyValue(n2));
                            tangoTreeNode.db.put_device_attribute_property(string, dbAttribute);
                            ++n2;
                        }
                    }
                    if (tangoTreeNode.type == 3 && tangoTreeNode.level == 6 && tangoTreeNode.getParent().toString().equals("ATTRIBUTE")) {
                        string = TangoTreeNode.getDevname(tangoTreeNode, 2);
                        n2 = 0;
                        while (n2 < the_clipboard.getAttPropertyLength()) {
                            dbAttribute = new DbAttribute(tangoTreeNode.toString());
                            dbAttribute.add(the_clipboard.getAttPropertyName(n2), the_clipboard.getAttPropertyValue(n2));
                            tangoTreeNode.db.put_device_attribute_property(string, dbAttribute);
                            ++n2;
                        }
                    }
                    if (tangoTreeNode.type == 1 && tangoTreeNode.level == 3 && tangoTreeNode.toString().equals("PROPERTY")) {
                        string = tangoTreeNode.getParent().toString();
                        n2 = 0;
                        while (n2 < the_clipboard.getObjectPropertyLength()) {
                            tangoTreeNode.db.put_class_property(string, TangoTreeNode.makeDbDatum(the_clipboard.getObjectPropertyName(n2), the_clipboard.getObjectPropertyValue(n2)));
                            ++n2;
                        }
                    }
                    if (tangoTreeNode.type == 1 && tangoTreeNode.level == 3 && tangoTreeNode.toString().equals("ATTRIBUTE")) {
                        string = tangoTreeNode.getParent().toString();
                        n2 = 0;
                        while (n2 < the_clipboard.getAttPropertyLength()) {
                            dbAttribute = new DbAttribute(the_clipboard.getAttName(n2));
                            dbAttribute.add(the_clipboard.getAttPropertyName(n2), the_clipboard.getAttPropertyValue(n2));
                            tangoTreeNode.db.put_class_attribute_property(string, dbAttribute);
                            ++n2;
                        }
                    }
                    if (tangoTreeNode.type != 3 || tangoTreeNode.level != 4) break;
                    string = TangoTreeNode.getDevname(tangoTreeNode, 0);
                    n2 = 0;
                    while (n2 < the_clipboard.getObjectPropertyLength()) {
                        tangoTreeNode.db.put_device_property(string, TangoTreeNode.makeDbDatum(the_clipboard.getObjectPropertyName(n2), the_clipboard.getObjectPropertyValue(n2)));
                        ++n2;
                    }
                    n2 = 0;
                    while (n2 < the_clipboard.getAttPropertyLength()) {
                        dbAttribute = new DbAttribute(the_clipboard.getAttName(n2));
                        dbAttribute.add(the_clipboard.getAttPropertyName(n2), the_clipboard.getAttPropertyValue(n2));
                        tangoTreeNode.db.put_device_attribute_property(string, dbAttribute);
                        ++n2;
                    }
                }
                catch (DevFailed devFailed) {
                    TangoTreeNode.showTangoError(devFailed);
                }
                break;
            }
            case 3: 
            case 103: {
                TangoTreeNode.removeProperty(defaultTreeModel, treePath);
                break;
            }
            case 4: {
                String string = JOptionPane.showInputDialog(parent, "Enter device name", "Add device", 3);
                TreePath treePath2 = TangoTreeNode.addProperty(string, defaultTreeModel, treePath, "", 0);
                if (treePath2 == null) break;
                jTree.setSelectionPath(treePath2);
                break;
            }
            case 5: {
                ServerDlg serverDlg = new ServerDlg(parent);
                serverDlg.setValidFields(true, true);
                serverDlg.setDefaults("", "");
                TangoTreeNode.showServerDlg(serverDlg, treePath, defaultTreeModel, jTree);
                break;
            }
            case 6: {
                TreePath treePath3;
                if (tangoTreeNode.level == 1) {
                    String string = JOptionPane.showInputDialog(parent, "Enter object name", "New property", 3);
                    treePath3 = TangoTreeNode.addProperty(string, defaultTreeModel, treePath, "", 0);
                    if (treePath3 != null) {
                        treePath3 = TangoTreeNode.addProperty("New property", defaultTreeModel, treePath3, "", 0);
                    }
                } else {
                    treePath3 = TangoTreeNode.addProperty("New property", defaultTreeModel, treePath, "", 0);
                }
                if (treePath3 == null) break;
                jTree.setSelectionPath(treePath3);
                break;
            }
            case 8: {
                ServerDlg serverDlg = new ServerDlg(parent);
                serverDlg.setValidFields(false, true);
                serverDlg.setDefaults(tangoTreeNode.toString(), "");
                TangoTreeNode.showServerDlg(serverDlg, treePath, defaultTreeModel, jTree);
                break;
            }
            case 9: {
                dlg = tangoTreeNode.level == 5 && tangoTreeNode.getParent().getParent().toString().equals("ATTRIBUTE") || tangoTreeNode.level == 7 && tangoTreeNode.getParent().getParent().toString().equals("ATTRIBUTE") ? new RenameDlg(parent, treePath.getLastPathComponent().toString(), att_prop_default, rectangle) : new RenameDlg(parent, treePath.getLastPathComponent().toString(), rectangle);
                if (dlg.showDlg()) {
                    String string = dlg.getNewName();
                    FindInfo findInfo = TangoTreeNode.propertyExist(string, defaultTreeModel, (TangoTreeNode)tangoTreeNode.getParent());
                    FindInfo findInfo2 = TangoTreeNode.propertyExist(tangoTreeNode.toString(), defaultTreeModel, (TangoTreeNode)tangoTreeNode.getParent());
                    if (findInfo.found && findInfo.index != findInfo2.index) {
                        TangoTreeNode.showJiveError("Name already exists.");
                    } else {
                        String string2 = TangoTreeNode.getValue(treePath)[0];
                        TangoTreeNode.removeProperty(defaultTreeModel, treePath);
                        TangoTreeNode.addProperty(dlg.getNewName(), defaultTreeModel, treePath.getParentPath(), string2, findInfo2.index);
                    }
                }
                dlg = null;
                break;
            }
            case 10: {
                String[] stringArray = new String[]{tangoTreeNode.isLeaf() ? tangoTreeNode.toString() : TangoTreeNode.getDevname(tangoTreeNode, 0)};
                System.out.println("Running AtkPanel " + stringArray[0]);
                atkdlg = new MainPanel(stringArray, false);
                break;
            }
            case 11: {
                String string = tangoTreeNode.isLeaf() ? tangoTreeNode.toString() : TangoTreeNode.getDevname(tangoTreeNode, 0);
                JiveMenu jiveMenu = new JiveMenu(parent);
                jiveMenu.showDlg(string);
                break;
            }
            case 12: {
                String string;
                if (tangoTreeNode.type == 3 && tangoTreeNode.level == 4) {
                    string = TangoTreeNode.getDevname(tangoTreeNode, 0);
                    tangoTreeNode.getChildCount();
                    tangoTreeNode = (TangoTreeNode)tangoTreeNode.getChildAt(0);
                    tangoTreeNode.editProperties("device:" + string);
                }
                if (tangoTreeNode.type == 3 && tangoTreeNode.level == 6 && tangoTreeNode.getParent().toString().equals("ATTRIBUTE")) {
                    string = tangoTreeNode.toString();
                    tangoTreeNode.editProperties("attribute:" + string);
                }
                if (tangoTreeNode.type == 1 && tangoTreeNode.level == 2) {
                    string = tangoTreeNode.toString();
                    tangoTreeNode.getChildCount();
                    tangoTreeNode = (TangoTreeNode)tangoTreeNode.getChildAt(0);
                    tangoTreeNode.editProperties("class:" + string);
                }
                if (tangoTreeNode.type == 1 && tangoTreeNode.level == 4 && tangoTreeNode.getParent().toString().equals("ATTRIBUTE")) {
                    string = tangoTreeNode.toString();
                    tangoTreeNode.editProperties("attribute:" + string);
                }
                if (tangoTreeNode.type != 2 || tangoTreeNode.level != 4) break;
                string = tangoTreeNode.toString();
                TangoTreeNode tangoTreeNode2 = (TangoTreeNode)treePath.getPathComponent(0);
                TangoTreeNode tangoTreeNode3 = (TangoTreeNode)tangoTreeNode2.getChildAt(2);
                TangoTreeNode tangoTreeNode4 = TangoTreeNode.findDeviceNode(tangoTreeNode3, string);
                if (tangoTreeNode4 == null) break;
                tangoTreeNode4.getChildCount();
                tangoTreeNode4 = (TangoTreeNode)tangoTreeNode4.getChildAt(0);
                tangoTreeNode4.editProperties("device:" + string);
                break;
            }
            case 13: {
                String string = "dserver/" + tangoTreeNode.toString();
                JiveMenu jiveMenu = new JiveMenu(parent);
                jiveMenu.showDlg(string);
                break;
            }
            case 14: {
                int n3 = JOptionPane.showConfirmDialog(parent, "This will unexport all devices of " + tangoTreeNode.toString() + "\n Do you want to continue ?", "Confirm unexport device", 0);
                if (n3 != 0) break;
                try {
                    System.out.println(" Unexport device of" + tangoTreeNode.toString());
                    tangoTreeNode.db.unexport_server(tangoTreeNode.toString());
                }
                catch (DevFailed devFailed) {
                    TangoTreeNode.showTangoError(devFailed);
                }
                break;
            }
            case 15: {
                File file;
                int n4 = 0;
                JFileChooser jFileChooser = new JFileChooser();
                int n5 = jFileChooser.showSaveDialog(parent);
                if (n5 != 0 || (file = jFileChooser.getSelectedFile()) == null) break;
                if (file.exists()) {
                    n4 = JOptionPane.showConfirmDialog(parent, "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
                }
                if (n4 != 0) break;
                tangoTreeNode.saveServerData(file.getAbsolutePath());
            }
        }
    }

    public static TangoTreeNode findDeviceNode(TangoTreeNode tangoTreeNode, String string) {
        TangoTreeNode tangoTreeNode2 = null;
        String[] stringArray = string.split("/");
        if (stringArray.length != 3) {
            TangoTreeNode.showJiveError("Invalid device name:" + string);
            return null;
        }
        int n = tangoTreeNode.getChildCount();
        int n2 = 0;
        boolean bl = false;
        while (!bl && n2 < n) {
            tangoTreeNode2 = (TangoTreeNode)tangoTreeNode.getChildAt(n2);
            boolean bl2 = bl = stringArray[0].compareToIgnoreCase(tangoTreeNode2.toString()) == 0;
            if (bl) continue;
            ++n2;
        }
        if (!bl) {
            TangoTreeNode.showJiveError("Device domain not found:" + stringArray[0]);
            return null;
        }
        tangoTreeNode = tangoTreeNode2;
        n = tangoTreeNode.getChildCount();
        n2 = 0;
        bl = false;
        while (!bl && n2 < n) {
            tangoTreeNode2 = (TangoTreeNode)tangoTreeNode.getChildAt(n2);
            boolean bl3 = bl = stringArray[1].compareToIgnoreCase(tangoTreeNode2.toString()) == 0;
            if (bl) continue;
            ++n2;
        }
        if (!bl) {
            TangoTreeNode.showJiveError("Device family not found:" + stringArray[1]);
            return null;
        }
        tangoTreeNode = tangoTreeNode2;
        n = tangoTreeNode.getChildCount();
        n2 = 0;
        bl = false;
        while (!bl && n2 < n) {
            tangoTreeNode2 = (TangoTreeNode)tangoTreeNode.getChildAt(n2);
            boolean bl4 = bl = stringArray[2].compareToIgnoreCase(tangoTreeNode2.toString()) == 0;
            if (bl) continue;
            ++n2;
        }
        if (!bl) {
            TangoTreeNode.showJiveError("Device member not found:" + stringArray[2]);
            return null;
        }
        return tangoTreeNode2;
    }

    public static void printFormatedRes(String string, String[] stringArray, FileWriter fileWriter) throws IOException {
        int n = string.length();
        fileWriter.write(string, 0, n);
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].length() == 0) {
                stringArray[n2] = " ";
            }
            if (stringArray[n2].indexOf(32) != -1 || stringArray[n2].indexOf(47) != -1) {
                stringArray[n2] = "\"" + stringArray[n2] + "\"";
            }
            if (n2 > 0) {
                int n3 = 0;
                while (n3 < n) {
                    fileWriter.write(32);
                    ++n3;
                }
            }
            String string2 = n2 < stringArray.length - 1 ? stringArray[n2] + ",\\ \n" : stringArray[n2] + "\n";
            fileWriter.write(string2, 0, string2.length());
            ++n2;
        }
    }

    public void saveServerData(String string) {
        try {
            String[] stringArray;
            FileWriter fileWriter = new FileWriter(string);
            DbServer dbServer = new DbServer(this.toString());
            String[] stringArray2 = dbServer.get_class_list();
            Date date = new Date(System.currentTimeMillis());
            String string2 = "#\n#Server " + this.toString() + " backup , created " + date + "\n";
            fileWriter.write(string2, 0, string2.length());
            string2 = "#\n\n";
            fileWriter.write(string2, 0, string2.length());
            string2 = "#Server defition\n\n";
            fileWriter.write(string2, 0, string2.length());
            int n = 0;
            while (n < stringArray2.length) {
                stringArray = dbServer.get_device_name(stringArray2[n]);
                string2 = this.toString() + "/DEVICE/" + stringArray2[n] + ": ";
                TangoTreeNode.printFormatedRes(string2, stringArray, fileWriter);
                ++n;
            }
            n = 0;
            while (n < stringArray2.length) {
                String[] stringArray3;
                String[] stringArray4;
                string2 = "\n#############################################\n";
                fileWriter.write(string2, 0, string2.length());
                string2 = "# CLASS " + stringArray2[n] + "\n\n";
                fileWriter.write(string2, 0, string2.length());
                stringArray = this.db.get_class_property_list(stringArray2[n], "*");
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray[n2].indexOf(32) != -1) {
                        stringArray[n2] = "\"" + stringArray[n2] + "\"";
                    }
                    string2 = "CLASS/" + stringArray2[n] + "->" + stringArray[n2] + ": ";
                    stringArray4 = this.db.get_class_property(stringArray2[n], stringArray[n2]).extractStringArray();
                    TangoTreeNode.printFormatedRes(string2, stringArray4, fileWriter);
                    ++n2;
                }
                string2 = "\n# CLASS " + stringArray2[n] + " attribute properties\n\n";
                fileWriter.write(string2, 0, string2.length());
                stringArray4 = this.db.get_class_attribute_list(stringArray2[n], "*");
                DbAttribute[] dbAttributeArray = this.db.get_class_attribute_property(stringArray2[n], stringArray4);
                int n3 = 0;
                while (n3 < dbAttributeArray.length) {
                    stringArray = dbAttributeArray[n3].get_property_list();
                    n2 = 0;
                    while (n2 < stringArray.length) {
                        if (stringArray[n2].indexOf(32) != -1) {
                            stringArray[n2] = "\"" + stringArray[n2] + "\"";
                        }
                        string2 = "CLASS/" + stringArray2[n] + "/" + stringArray4[n3] + "->" + stringArray[n2] + ": ";
                        stringArray3 = new String[]{dbAttributeArray[n3].get_value(n2)};
                        TangoTreeNode.printFormatedRes(string2, stringArray3, fileWriter);
                        ++n2;
                    }
                    ++n3;
                }
                stringArray3 = dbServer.get_device_name(stringArray2[n]);
                int n4 = 0;
                while (n4 < stringArray3.length) {
                    String[] stringArray5;
                    string2 = "\n# DEVICE " + stringArray3[n4] + " properties\n\n";
                    fileWriter.write(string2, 0, string2.length());
                    stringArray = this.db.get_device_property_list(stringArray3[n4], "*");
                    n2 = 0;
                    while (n2 < stringArray.length) {
                        if (stringArray[n2].indexOf(32) != -1) {
                            stringArray[n2] = "\"" + stringArray[n2] + "\"";
                        }
                        string2 = stringArray3[n4] + "->" + stringArray[n2] + ": ";
                        stringArray5 = this.db.get_device_property(stringArray3[n4], stringArray[n2]).extractStringArray();
                        TangoTreeNode.printFormatedRes(string2, stringArray5, fileWriter);
                        ++n2;
                    }
                    string2 = "\n# DEVICE " + stringArray3[n4] + " attribute properties\n\n";
                    fileWriter.write(string2, 0, string2.length());
                    try {
                        stringArray5 = new DeviceProxy(stringArray3[n4]);
                        stringArray4 = stringArray5.get_attribute_list();
                        dbAttributeArray = this.db.get_device_attribute_property(stringArray3[n4], stringArray4);
                        n3 = 0;
                        while (n3 < dbAttributeArray.length) {
                            stringArray = dbAttributeArray[n3].get_property_list();
                            n2 = 0;
                            while (n2 < stringArray.length) {
                                if (stringArray[n2].indexOf(32) != -1) {
                                    stringArray[n2] = "\"" + stringArray[n2] + "\"";
                                }
                                string2 = stringArray3[n4] + "/" + stringArray4[n3] + "->" + stringArray[n2] + ": ";
                                String[] stringArray6 = new String[]{dbAttributeArray[n3].get_value(n2)};
                                TangoTreeNode.printFormatedRes(string2, stringArray6, fileWriter);
                                ++n2;
                            }
                            ++n3;
                        }
                    }
                    catch (DevFailed devFailed) {
                        TangoTreeNode.showTangoError(devFailed);
                        TangoTreeNode.showJiveError("Attribute properties for " + stringArray3[n4] + " has not been saved !");
                    }
                    ++n4;
                }
                ++n;
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            TangoTreeNode.showJiveError("Cannot write to " + string + " !\n" + exception.getMessage());
        }
    }

    public void editProperties(String string) {
        int n = this.getChildCount();
        if (n > 0) {
            Serializable serializable;
            TreePath[] treePathArray = new TreePath[n];
            Object[][] objectArray = new Object[n][2];
            int n2 = 0;
            while (n2 < n) {
                serializable = (TangoTreeNode)this.getChildAt(n2);
                treePathArray[n2] = ((TangoTreeNode)serializable).getCompletePath();
                String[] stringArray = TangoTreeNode.getValue(treePathArray[n2]);
                objectArray[n2][0] = TangoTreeNode.formatPath(treePathArray[n2]);
                objectArray[n2][1] = stringArray[0];
                ++n2;
            }
            serializable = new DetailsDlg(parent, objectArray, treePathArray);
            ((Dialog)serializable).show();
        } else {
            TangoTreeNode.showJiveError("No properties defined for " + string);
        }
    }

    public static boolean[] getAction(TreePath treePath) {
        TangoTreeNode tangoTreeNode = (TangoTreeNode)treePath.getLastPathComponent();
        boolean[] blArray = new boolean[nbAction];
        int n = 0;
        while (n < nbAction) {
            blArray[n] = false;
            ++n;
        }
        switch (tangoTreeNode.type) {
            case 0: {
                blArray[7] = true;
                return blArray;
            }
            case 1: {
                if (tangoTreeNode.level == 2) {
                    blArray[0] = true;
                    blArray[1] = true;
                    blArray[3] = true;
                    blArray[12] = true;
                }
                if (tangoTreeNode.level == 2 || tangoTreeNode.level == 3) {
                    boolean bl = blArray[2] = !the_clipboard.empty();
                }
                if (tangoTreeNode.level == 3 && tangoTreeNode.toString().equals("PROPERTY")) {
                    blArray[6] = true;
                }
                if (tangoTreeNode.level == 4 && tangoTreeNode.getParent().toString().equals("PROPERTY")) {
                    blArray[0] = true;
                    blArray[1] = true;
                    blArray[3] = true;
                    blArray[9] = true;
                }
                if (tangoTreeNode.level == 4 && tangoTreeNode.getParent().toString().equals("ATTRIBUTE")) {
                    blArray[12] = true;
                    blArray[6] = true;
                }
                if (tangoTreeNode.level != 5 || !tangoTreeNode.getParent().getParent().toString().equals("ATTRIBUTE")) break;
                blArray[0] = true;
                blArray[1] = true;
                blArray[3] = true;
                blArray[9] = true;
                break;
            }
            case 2: {
                if (tangoTreeNode.level == 1) {
                    blArray[5] = true;
                }
                if (tangoTreeNode.level == 2) {
                    blArray[3] = true;
                    blArray[8] = true;
                    blArray[13] = true;
                    blArray[14] = true;
                    blArray[15] = true;
                }
                if (tangoTreeNode.level == 3) {
                    blArray[3] = true;
                    blArray[4] = true;
                }
                if (tangoTreeNode.level != 4) break;
                blArray[3] = true;
                blArray[10] = true;
                blArray[11] = true;
                blArray[12] = true;
                break;
            }
            case 3: {
                if (tangoTreeNode.level == 4 || tangoTreeNode.level == 5) {
                    boolean bl = blArray[2] = !the_clipboard.empty();
                }
                if (tangoTreeNode.level == 4) {
                    blArray[0] = true;
                    blArray[1] = true;
                    blArray[3] = true;
                    blArray[10] = true;
                    blArray[11] = true;
                    blArray[12] = true;
                }
                if (tangoTreeNode.level == 5 && tangoTreeNode.toString().equals("PROPERTY")) {
                    blArray[6] = true;
                    boolean bl = blArray[2] = !the_clipboard.empty();
                }
                if (tangoTreeNode.level == 6 && tangoTreeNode.getParent().toString().equals("PROPERTY")) {
                    blArray[0] = true;
                    blArray[1] = true;
                    blArray[3] = true;
                    blArray[9] = true;
                }
                if (tangoTreeNode.level == 6 && tangoTreeNode.getParent().toString().equals("ATTRIBUTE")) {
                    blArray[6] = true;
                    blArray[12] = true;
                    boolean bl = blArray[2] = !the_clipboard.empty();
                }
                if (tangoTreeNode.level != 7 || !tangoTreeNode.getParent().getParent().toString().equals("ATTRIBUTE")) break;
                blArray[0] = true;
                blArray[1] = true;
                blArray[3] = true;
                blArray[9] = true;
                break;
            }
            case 4: {
                if (tangoTreeNode.level == 1) {
                    blArray[6] = true;
                }
                if (tangoTreeNode.level == 2) {
                    blArray[6] = true;
                    boolean bl = blArray[2] = !the_clipboard.empty();
                }
                if (tangoTreeNode.level != 3) break;
                blArray[0] = true;
                blArray[1] = true;
                blArray[3] = true;
                blArray[9] = true;
                break;
            }
        }
        return blArray;
    }

    public static void InitiateSearch(TangoTreeNode tangoTreeNode, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        searchStack = new Stack();
        searchStack.push(tangoTreeNode);
        searchIngoreCase = bl;
        searchValues = bl2;
        searchAttributes = bl3;
        searchUseRegexp = bl4;
        searchOnlyLeaf = bl5;
    }

    public static TreePath findText(String string) {
        searchText = string;
        Thread thread = new Thread(){

            public void run() {
                searchResult = TangoTreeNode.findText_sub(searchText);
                searchDlg.hide();
            }
        };
        searchStopflag = false;
        searchResult = null;
        searchDlg = new ThreadDlg(parent, thread);
        searchDlg.show();
        return searchResult;
    }

    public static TreePath[] findMultipleText(String string) {
        searchText = string;
        Thread thread = new Thread(){

            public void run() {
                boolean bl = false;
                Vector<TreePath> vector = new Vector<TreePath>();
                while (!bl) {
                    searchResult = TangoTreeNode.findText_sub(searchText);
                    if (searchResult != null) {
                        vector.add(searchResult);
                        continue;
                    }
                    bl = true;
                }
                if (vector.size() > 0) {
                    searchResults = new TreePath[vector.size()];
                    int n = 0;
                    while (n < vector.size()) {
                        TangoTreeNode.searchResults[n] = (TreePath)vector.get(n);
                        ++n;
                    }
                } else {
                    searchResults = null;
                }
                searchDlg.hide();
            }
        };
        searchStopflag = false;
        searchResults = null;
        searchDlg = new ThreadDlg(parent, thread);
        searchDlg.show();
        return searchResults;
    }

    public static TreePath findText_sub(String string) {
        Pattern pattern = null;
        if (searchUseRegexp) {
            try {
                pattern = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                error_report = true;
                TangoTreeNode.showJiveError("Invalid regular expression\n" + patternSyntaxException.getDescription());
                return null;
            }
        }
        if (searchStack != null) {
            while (!searchStack.empty() && !searchStopflag) {
                TangoTreeNode tangoTreeNode = (TangoTreeNode)searchStack.pop();
                ++scan_progress;
                if (tangoTreeNode.isLeaf() || !searchOnlyLeaf) {
                    String string2;
                    String string3;
                    if (searchIngoreCase) {
                        string3 = tangoTreeNode.toStringEx().toLowerCase();
                        string2 = string.toLowerCase();
                    } else {
                        string3 = tangoTreeNode.toStringEx();
                        string2 = string;
                    }
                    if (searchUseRegexp ? pattern.matcher(string3).matches() : string3.indexOf(string2) != -1) {
                        return tangoTreeNode.getCompletePath();
                    }
                    if (searchValues) {
                        string3 = searchIngoreCase ? TangoTreeNode.getValue(new TreePath(tangoTreeNode))[0].toLowerCase() : TangoTreeNode.getValue(new TreePath(tangoTreeNode))[0];
                        if (searchUseRegexp ? pattern.matcher(string3).matches() : string3.indexOf(string2) != -1) {
                            return tangoTreeNode.getCompletePath();
                        }
                    }
                }
                if (tangoTreeNode.toString().equals("ATTRIBUTE") && !searchAttributes) continue;
                int n = tangoTreeNode.getChildCount();
                int n2 = n - 1;
                while (n2 >= 0) {
                    searchStack.push(tangoTreeNode.getChildAt(n2));
                    --n2;
                }
            }
        }
        return null;
    }

    public String toString() {
        return this.value;
    }

    public TreePath getCompletePath() {
        TangoTreeNode tangoTreeNode = this;
        Object[] objectArray = new TangoTreeNode[tangoTreeNode.level + 1];
        int n = objectArray.length - 1;
        while (n >= 0) {
            objectArray[n] = tangoTreeNode;
            tangoTreeNode = (TangoTreeNode)tangoTreeNode.getParent();
            --n;
        }
        return new TreePath(objectArray);
    }

    public String toStringEx() {
        String string = "";
        TangoTreeNode tangoTreeNode = this;
        TangoTreeNode[] tangoTreeNodeArray = new TangoTreeNode[tangoTreeNode.level + 1];
        int n = tangoTreeNodeArray.length - 1;
        while (n >= 0) {
            tangoTreeNodeArray[n] = tangoTreeNode;
            tangoTreeNode = (TangoTreeNode)tangoTreeNode.getParent();
            --n;
        }
        n = 0;
        while (n < tangoTreeNodeArray.length) {
            string = string + tangoTreeNodeArray[n].toString();
            string = string + "/";
            ++n;
        }
        return string;
    }

    static {
        searchStack = null;
    }
}

