/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive.DetailsDlg;
import jive.SearchDlg;
import jive.TangoTreeNode;

public class MainPanel
extends JFrame {
    private JTree mainTree;
    private DefaultTreeModel mainTreeModel;
    private DefaultMutableTreeNode rootNode;
    private MouseListener treeMousellistemner;
    private TreeSelectionListener treeSelectionlistemner;
    private JScrollPane treeView;
    private JTextArea resValue;
    private JScrollPane resView;
    private JButton applyPb;
    private JButton refreshPb;
    private JButton detailsPb;
    private Database db;
    private String tangoHost;
    private JLabel statusLine;
    private JMenuBar mainMenu;
    private JPopupMenu treeMenu;
    private JMenuItem[] treeMenuItem;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private boolean running_from_shell;

    public MainPanel() {
        this.running_from_shell = false;
        this.initComponents();
        this.setSize(650, 480);
        this.placeComponents();
        this.setTitle("Jive 2.0 [beta release]");
        this.setVisible(true);
        TangoTreeNode.parent = this;
    }

    public MainPanel(int n) {
        this.running_from_shell = true;
        this.initComponents();
        this.setSize(650, 480);
        this.placeComponents();
        this.setTitle("Jive 2.0 [beta release]");
        this.setVisible(true);
        TangoTreeNode.parent = this;
    }

    private void refreshValues(TreePath treePath) {
        String[] stringArray = TangoTreeNode.getValue(treePath);
        this.resValue.setText(stringArray[0]);
        this.resView.setBorder(BorderFactory.createTitledBorder(stringArray[1]));
        this.resValue.setEnabled(stringArray[1].startsWith("Property value"));
        this.applyPb.setEnabled(false);
        this.detailsPb.setEnabled(false);
    }

    private void refreshValuesMultiple(TreePath[] treePathArray) {
        String[] stringArray = TangoTreeNode.getValue(treePathArray[0]);
        boolean bl = stringArray[1].startsWith("Property value");
        boolean bl2 = true;
        String string = stringArray[0];
        int n = 1;
        while (n < treePathArray.length) {
            stringArray = TangoTreeNode.getValue(treePathArray[n]);
            bl2 &= stringArray[0].equals(string);
            bl &= stringArray[1].startsWith("Property value");
            ++n;
        }
        if (bl2) {
            this.resValue.setText(string);
        } else {
            this.resValue.setText("Values are not equals");
        }
        this.resView.setBorder(BorderFactory.createTitledBorder("Multiple selection"));
        this.resValue.setEnabled(bl);
        this.applyPb.setEnabled(false);
        this.detailsPb.setEnabled(!bl2);
    }

    private void gobalValueRefresh() {
        TreePath[] treePathArray = this.mainTree.getSelectionPaths();
        if (treePathArray != null) {
            if (treePathArray.length == 1) {
                String string = TangoTreeNode.formatPath(treePathArray[0]);
                this.statusLine.setText(string);
                this.refreshValues(treePathArray[0]);
                this.jMenuItem5.setEnabled(false);
                this.jMenuItem6.setEnabled(false);
            } else if (treePathArray.length > 1) {
                this.statusLine.setText("Multiple selection: " + treePathArray.length + " items selected");
                this.refreshValuesMultiple(treePathArray);
                this.jMenuItem5.setEnabled(true);
                this.jMenuItem6.setEnabled(true);
            }
        }
    }

    private void refreshTree() {
        TreePath treePath = this.mainTree.getSelectionPath();
        this.getContentPane().remove(this.treeView);
        this.createMainTree();
        this.getContentPane().add(this.treeView);
        TreePath treePath2 = TangoTreeNode.convertOldPath(this.mainTreeModel, (TangoTreeNode)this.rootNode, treePath);
        this.mainTree.setSelectionPath(treePath2);
        this.mainTree.expandPath(treePath2);
        this.mainTree.makeVisible(treePath2);
        this.placeComponents();
    }

    private void createMainTree() {
        this.rootNode = new TangoTreeNode(0, 0, this.tangoHost, this.db);
        this.mainTreeModel = new DefaultTreeModel(this.rootNode);
        this.mainTree = new JTree(this.mainTreeModel);
        this.mainTree.setEditable(false);
        this.mainTree.getSelectionModel().setSelectionMode(4);
        this.mainTree.setShowsRootHandles(true);
        this.mainTree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeView = new JScrollPane(this.mainTree);
        this.mainTree.addMouseListener(this.treeMousellistemner);
        this.mainTree.addTreeSelectionListener(this.treeSelectionlistemner);
    }

    public void showClipboard() {
        TangoTreeNode.the_clipboard.show(this);
    }

    public void showDetails() {
        TreePath[] treePathArray = this.mainTree.getSelectionPaths();
        if (treePathArray != null) {
            Object object;
            Object[][] objectArray = new Object[treePathArray.length][2];
            int n = 0;
            while (n < treePathArray.length) {
                object = TangoTreeNode.getValue(treePathArray[n]);
                objectArray[n][0] = TangoTreeNode.formatPath(treePathArray[n]);
                objectArray[n][1] = object[0];
                ++n;
            }
            object = new DetailsDlg((Frame)this, objectArray, treePathArray);
            ((Dialog)object).show();
        }
    }

    private void initComponents() {
        this.getContentPane().setLayout(null);
        this.tangoHost = System.getProperty("TANGO_HOST", "null");
        if (this.tangoHost.equals("null") || this.tangoHost.equals("")) {
            System.out.println("TANGO_HOST no defined, exiting...");
            this.exitForm();
        }
        try {
            this.db = new Database();
        }
        catch (DevFailed devFailed) {
            TangoTreeNode.showTangoError(devFailed);
            this.db = null;
        }
        this.resValue = new JTextArea();
        this.resValue.setBackground(Color.white);
        this.resValue.setForeground(Color.black);
        this.resValue.setOpaque(true);
        this.resValue.setText("");
        this.resValue.setEnabled(false);
        this.resValue.setBorder(BorderFactory.createLoweredBevelBorder());
        this.resView = new JScrollPane(this.resValue);
        this.resView.setBorder(BorderFactory.createTitledBorder("..."));
        this.getContentPane().add(this.resView);
        this.resValue.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                MainPanel.this.applyPb.setEnabled(true);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MainPanel.this.applyPb.setEnabled(true);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                MainPanel.this.applyPb.setEnabled(true);
            }

            public void updateLog(DocumentEvent documentEvent, String string) {
                MainPanel.this.applyPb.setEnabled(true);
            }
        });
        this.applyPb = new JButton();
        this.applyPb.setText("Apply change");
        this.applyPb.setEnabled(false);
        this.applyPb.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath[] treePathArray = MainPanel.this.mainTree.getSelectionPaths();
                String string = MainPanel.this.resValue.getText();
                if (treePathArray != null) {
                    int n = 0;
                    while (n < treePathArray.length) {
                        TangoTreeNode.setValue(treePathArray[n], string);
                        ++n;
                    }
                }
                MainPanel.this.gobalValueRefresh();
            }
        });
        this.getContentPane().add(this.applyPb);
        this.detailsPb = new JButton();
        this.detailsPb.setText("Show details");
        this.detailsPb.setEnabled(false);
        this.detailsPb.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MainPanel.this.showDetails();
            }
        });
        this.getContentPane().add(this.detailsPb);
        this.refreshPb = new JButton();
        this.refreshPb.setText("Refresh");
        this.getContentPane().add(this.refreshPb);
        this.refreshPb.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MainPanel.this.gobalValueRefresh();
            }
        });
        this.statusLine = new JLabel();
        this.statusLine.setBackground(Color.white);
        this.statusLine.setForeground(Color.black);
        this.statusLine.setOpaque(true);
        this.statusLine.setText("");
        this.statusLine.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add(this.statusLine);
        this.treeMousellistemner = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                TreePath treePath = MainPanel.this.mainTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                int n = MainPanel.this.mainTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 3 && treePath != null) {
                    MainPanel.this.mainTree.setSelectionPath(treePath);
                    boolean[] blArray = TangoTreeNode.getAction(treePath);
                    int n2 = 0;
                    while (n2 < blArray.length) {
                        MainPanel.this.treeMenuItem[n2].setEnabled(blArray[n2]);
                        if (n2 > 3) {
                            MainPanel.this.treeMenuItem[n2].setVisible(blArray[n2]);
                        }
                        ++n2;
                    }
                    MainPanel.this.treeMenu.show(MainPanel.this.mainTree, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.treeSelectionlistemner = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                MainPanel.this.gobalValueRefresh();
            }
        };
        this.createMainTree();
        this.getContentPane().add(this.treeView);
        this.mainMenu = new JMenuBar();
        JMenu jMenu = new JMenu();
        JMenu jMenu2 = new JMenu();
        JMenuItem jMenuItem = new JMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        JMenuItem jMenuItem3 = new JMenuItem();
        JMenuItem jMenuItem4 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem6 = new JMenuItem();
        JMenuItem jMenuItem5 = new JMenuItem();
        JMenuItem jMenuItem6 = new JMenuItem();
        JMenuItem jMenuItem7 = new JMenuItem();
        jMenu.setText("File");
        jMenu2.setText("Edit");
        jMenuItem.setText("Exit");
        jMenuItem2.setText("Refresh tree");
        jMenuItem3.setText("Show clipbaord");
        jMenuItem4.setText("Clear clipbaord");
        this.jMenuItem5.setText("Multiple delete");
        this.jMenuItem6.setText("Multiple copy");
        jMenuItem5.setText("Multiple selection");
        jMenuItem6.setText("Find property");
        jMenuItem7.setText("Find next");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.exitForm();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.refreshTree();
            }
        });
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.showClipboard();
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TangoTreeNode.the_clipboard.clear();
            }
        });
        this.jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.execMultipleAction(3);
            }
        });
        this.jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.execMultipleAction(1);
            }
        });
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.selectProperties();
            }
        });
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.findProperty(0);
            }
        });
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.findProperty(1);
            }
        });
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.jMenuItem5.setEnabled(false);
        this.jMenuItem6.setEnabled(false);
        jMenu.add(jMenuItem);
        jMenu2.add(jMenuItem2);
        jMenu2.add(jMenuItem3);
        jMenu2.add(jMenuItem4);
        jMenu2.add(jMenuItem5);
        jMenu2.add(new JSeparator());
        jMenu2.add(this.jMenuItem5);
        jMenu2.add(this.jMenuItem6);
        jMenu2.add(new JSeparator());
        jMenu2.add(jMenuItem6);
        jMenu2.add(jMenuItem7);
        this.mainMenu.add(jMenu);
        this.mainMenu.add(jMenu2);
        this.setJMenuBar(this.mainMenu);
        this.treeMenu = new JPopupMenu();
        this.treeMenuItem = new JMenuItem[TangoTreeNode.nbAction];
        int n = 0;
        while (n < TangoTreeNode.nbAction) {
            this.treeMenuItem[n] = new JMenuItem();
            this.treeMenuItem[n].setEnabled(false);
            this.treeMenuItem[n].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainPanel.this.execMenuAction(actionEvent);
                }
            });
            ++n;
        }
        this.treeMenuItem[0].setText("Cut");
        this.treeMenuItem[1].setText("Copy");
        this.treeMenuItem[2].setText("Paste");
        this.treeMenuItem[3].setText("Delete");
        this.treeMenuItem[4].setText("Add device");
        this.treeMenuItem[5].setText("Create server");
        this.treeMenuItem[6].setText("Create new property");
        this.treeMenuItem[7].setText("Change TANGO HOST");
        this.treeMenuItem[8].setText("Add class to server");
        this.treeMenuItem[9].setText("Rename");
        this.treeMenuItem[10].setText("Monitor device");
        this.treeMenuItem[11].setText("Test device");
        this.treeMenuItem[12].setText("Show properties");
        this.treeMenuItem[13].setText("Test admin server");
        this.treeMenuItem[14].setText("Unexport devices");
        this.treeMenuItem[15].setText("Save server data");
        int n2 = 0;
        while (n2 < TangoTreeNode.nbAction) {
            if (n2 == 4) {
                this.treeMenu.add(new JSeparator());
            }
            this.treeMenu.add(this.treeMenuItem[n2]);
            ++n2;
        }
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
                TreePath treePath;
                if (TangoTreeNode.dlg != null && (treePath = MainPanel.this.mainTree.getSelectionPath()) != null) {
                    MainPanel.this.mainTree.makeVisible(treePath);
                    Rectangle rectangle = MainPanel.this.mainTree.getPathBounds(treePath);
                    Point point = rectangle.getLocation();
                    SwingUtilities.convertPointToScreen(point, MainPanel.this.mainTree);
                    TangoTreeNode.dlg.moveToLocation(point.x, point.y);
                }
            }

            public void componentResized(ComponentEvent componentEvent) {
                MainPanel.this.placeComponents();
            }

            public void componentShown(ComponentEvent componentEvent) {
                MainPanel.this.placeComponents();
            }
        });
    }

    public void execMenuAction(ActionEvent actionEvent) {
        Object object;
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        int n = 0;
        boolean bl = false;
        while (n < TangoTreeNode.nbAction && !bl) {
            boolean bl2 = bl = jMenuItem == this.treeMenuItem[n];
            if (bl) continue;
            ++n;
        }
        if (n == 7) {
            object = JOptionPane.showInputDialog(this, "Enter tango host (ex gizmo:20000)", "Jive", 3);
            System.setProperty("TANGO_HOST", (String)object);
            this.tangoHost = object;
            try {
                this.db = new Database();
            }
            catch (DevFailed devFailed) {
                TangoTreeNode.showTangoError(devFailed);
                this.db = null;
            }
            this.refreshTree();
        }
        if ((object = this.mainTree.getSelectionPath()) != null) {
            this.mainTree.makeVisible((TreePath)object);
            Rectangle rectangle = this.mainTree.getPathBounds((TreePath)object);
            Point point = rectangle.getLocation();
            SwingUtilities.convertPointToScreen(point, this.mainTree);
            rectangle.setLocation(point);
            rectangle.width += 20;
            TangoTreeNode.execAction(n, (TreePath)object, this.mainTree, this.mainTreeModel, rectangle);
            switch (n) {
                case 2: 
                case 5: 
                case 8: {
                    this.refreshTree();
                }
            }
        }
    }

    public void execMultipleAction(int n) {
        Rectangle rectangle = new Rectangle();
        TreePath[] treePathArray = this.mainTree.getSelectionPaths();
        if (treePathArray != null) {
            int n2 = 0;
            while (n2 < treePathArray.length) {
                TangoTreeNode.execAction(n + 100, treePathArray[n2], this.mainTree, this.mainTreeModel, rectangle);
                ++n2;
            }
        }
    }

    public void placeComponents() {
        Dimension dimension = this.getContentPane().getSize();
        int n = dimension.width - 10;
        int n2 = dimension.height;
        this.statusLine.setBounds(5, 2, n, 20);
        this.treeView.setBounds(5, 25, dimension.width / 2 - 10, n2 - 30);
        this.resView.setBounds(dimension.width / 2 + 5, 25, dimension.width / 2 - 10, n2 - 60);
        this.applyPb.setBounds(dimension.width / 2 + 5, n2 - 30, 110, 25);
        this.refreshPb.setBounds(dimension.width / 2 + 120, n2 - 30, 80, 25);
        this.detailsPb.setBounds(dimension.width / 2 + 205, n2 - 30, 110, 25);
        this.treeView.revalidate();
        this.resView.revalidate();
    }

    public void findProperty(int n) {
        Serializable serializable;
        if (n == 0) {
            TangoTreeNode.scan_progress = 0;
            TreePath treePath = this.mainTree.getSelectionPath();
            serializable = treePath == null ? (TangoTreeNode)this.rootNode : (TangoTreeNode)treePath.getLastPathComponent();
            SearchDlg searchDlg = new SearchDlg((Frame)this, true, "Search Tango data base", "Text to find");
            if (!searchDlg.showDlg()) {
                return;
            }
            TangoTreeNode.InitiateSearch((TangoTreeNode)serializable, SearchDlg.dIgnoreCase, SearchDlg.dSearchValues, SearchDlg.dSearchAttributes, SearchDlg.dSearchUseRegexp, false);
        }
        TangoTreeNode.error_report = false;
        serializable = TangoTreeNode.findText(SearchDlg.textToFind);
        if (serializable != null) {
            this.mainTree.setSelectionPath((TreePath)serializable);
            this.mainTree.scrollPathToVisible((TreePath)serializable);
        }
        TangoTreeNode.error_report = true;
        if (serializable == null) {
            TangoTreeNode.showJiveError("No item found...");
        }
    }

    public void selectProperties() {
        TangoTreeNode.scan_progress = 0;
        TreePath treePath = this.mainTree.getSelectionPath();
        TangoTreeNode tangoTreeNode = treePath == null ? (TangoTreeNode)this.rootNode : (TangoTreeNode)treePath.getLastPathComponent();
        SearchDlg searchDlg = new SearchDlg((Frame)this, true, "Multiple selection", "Select");
        if (!searchDlg.showDlg()) {
            return;
        }
        TangoTreeNode.InitiateSearch(tangoTreeNode, SearchDlg.dIgnoreCase, SearchDlg.dSearchValues, SearchDlg.dSearchAttributes, SearchDlg.dSearchUseRegexp, true);
        TangoTreeNode.error_report = false;
        TreePath[] treePathArray = TangoTreeNode.findMultipleText(SearchDlg.textToFind);
        if (treePathArray != null && treePathArray.length > 0) {
            this.mainTree.setSelectionPaths(treePathArray);
            this.mainTree.scrollPathToVisible(treePathArray[0]);
        }
        TangoTreeNode.error_report = true;
        this.gobalValueRefresh();
    }

    private void exitForm() {
        if (this.running_from_shell) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] stringArray) {
        MainPanel mainPanel = new MainPanel(0);
    }
}

