/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.TangoConst;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public final class HtmlHelper
implements TangoConst {
    String id = "$Id: HtmlHelper.java,v 0.8 2001/11/12 13:59:10 perez Exp perez $";

    public static void error(PrintWriter printWriter, String string, Vector vector) {
        HtmlHelper.head(printWriter, string);
        printWriter.println("<P>");
        printWriter.println("<H1>");
        printWriter.println("<FONT COLOR=\"#FF0000\">Error</FONT>");
        printWriter.println("</H1>");
        int n = 0;
        while (n < vector.size()) {
            printWriter.println("<P>");
            printWriter.println((String)vector.elementAt(n));
            ++n;
        }
        printWriter.println("<P>");
        HtmlHelper.bottom(printWriter);
    }

    public static void head(PrintWriter printWriter, String string) {
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.println("<TITLE>");
        printWriter.println("TANGO Wizard");
        printWriter.println("</TITLE>");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY text=\"#000000\" bgcolor=\"#FFFFFF\" link=\"#0000EF\">");
        printWriter.println("<CENTER>");
        printWriter.println("<H1>");
        printWriter.println("<FONT COLOR=\"#3366FF\">");
        printWriter.println(string);
        printWriter.println("</H1>");
        printWriter.println("</FONT>");
    }

    public static void bottom(PrintWriter printWriter) {
        HtmlHelper.bottom(printWriter, "perez@esrf.fr");
    }

    public static void bottom(PrintWriter printWriter, String string) {
        printWriter.println("<hr noshade width=\"100%\">");
        printWriter.println("<table width=92% border=0>");
        printWriter.println("<tr> <td width=50% align=left>");
        printWriter.println("<A HREF=\"/Jive.html\"><font size=+3>JIVE home</font></a></td>");
        printWriter.println("<td width=50% align=right>");
        printWriter.println("<i><a href=\"mailto:" + string + "\">" + string + "</a>");
        printWriter.println("<br>dynamically generated</i> </td> </tr> </table>");
        printWriter.println("</CENTER>");
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
    }

    public static int string_to_devicedata(String string, DeviceData deviceData, int n, Vector vector) {
        if (n != 0) {
            if (n != 8 && string.equals("")) {
                vector.removeAllElements();
                vector.addElement("Empty argument, you must specify a value");
                return -1;
            }
            vector.addElement(string.trim());
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                deviceData.insert(Boolean.getBoolean(string));
                break;
            }
            case 6: {
                int n2 = HtmlHelper.check_ushort(string, vector);
                if (n2 == -1) {
                    return -1;
                }
                deviceData.insert_u((short)n2);
                break;
            }
            case 2: {
                deviceData.insert(HtmlHelper.parse_short(string));
                break;
            }
            case 7: {
                long l = HtmlHelper.check_ulong(string, vector);
                if (l == -1L) {
                    return -1;
                }
                deviceData.insert_u((int)l);
                break;
            }
            case 3: {
                deviceData.insert(HtmlHelper.parse_int(string));
                break;
            }
            case 4: {
                deviceData.insert(Float.valueOf(string).floatValue());
                break;
            }
            case 5: {
                deviceData.insert(Double.valueOf(string).doubleValue());
                break;
            }
            case 8: {
                deviceData.insert(string);
                break;
            }
            case 9: {
                vector.removeAllElements();
                byte[] byArray = string.getBytes();
                String string2 = new String();
                int n3 = 0;
                while (n3 < string.length()) {
                    string2 = byArray[n3] >= 32 ? new Character((char)byArray[n3]).toString() : " ";
                    string2 = string2 + " = 0x" + Integer.toString(byArray[n3], 16);
                    vector.addElement(string2);
                    ++n3;
                }
                deviceData.insert(byArray);
                break;
            }
            case 10: 
            case 14: {
                Vector vector2 = HtmlHelper.parse_string_1sep(string, ",");
                vector.removeAllElements();
                short[] sArray = new short[vector2.size()];
                int n4 = 0;
                while (n4 < vector2.size()) {
                    try {
                        short s;
                        if (n == 14) {
                            int n5 = HtmlHelper.check_ushort((String)vector2.elementAt(n4), vector);
                            if (n5 == -1) {
                                return -1;
                            }
                            s = (short)n5;
                            vector.addElement(HtmlHelper.short_to_ushort(s));
                        } else {
                            s = HtmlHelper.parse_short((String)vector2.elementAt(n4));
                            vector.addElement(Short.toString(s));
                        }
                        sArray[n4] = s;
                    }
                    catch (NumberFormatException numberFormatException) {
                        vector.removeAllElements();
                        vector.addElement("Following element not of type short: ");
                        vector.addElement((String)vector2.elementAt(n4));
                        return -1;
                    }
                    ++n4;
                }
                if (n == 14) {
                    deviceData.insert_u(sArray);
                    break;
                }
                deviceData.insert(sArray);
                break;
            }
            case 11: 
            case 15: {
                Vector vector3 = HtmlHelper.parse_string_1sep(string, ",");
                vector.removeAllElements();
                int[] nArray = new int[vector3.size()];
                int n6 = 0;
                while (n6 < vector3.size()) {
                    try {
                        int n7;
                        if (n == 15) {
                            long l = HtmlHelper.check_ulong((String)vector3.elementAt(n6), vector);
                            if (l == -1L) {
                                return -1;
                            }
                            n7 = (int)l;
                            vector.addElement(HtmlHelper.int_to_uint(n7));
                        } else {
                            n7 = HtmlHelper.parse_int((String)vector3.elementAt(n6));
                            vector.addElement(Integer.toString(n7));
                        }
                        nArray[n6] = n7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        vector.removeAllElements();
                        vector.addElement("Following element not of type Java integer: ");
                        vector.addElement((String)vector3.elementAt(n6));
                        return -1;
                    }
                    ++n6;
                }
                if (n == 15) {
                    deviceData.insert_u(nArray);
                    break;
                }
                deviceData.insert(nArray);
                break;
            }
            case 12: {
                Vector vector4 = HtmlHelper.parse_string_1sep(string, ",");
                vector.removeAllElements();
                float[] fArray = new float[vector4.size()];
                int n8 = 0;
                while (n8 < vector4.size()) {
                    try {
                        float f;
                        fArray[n8] = f = Float.valueOf((String)vector4.elementAt(n8)).floatValue();
                        vector.addElement(Float.toString(f));
                    }
                    catch (NumberFormatException numberFormatException) {
                        vector.removeAllElements();
                        vector.addElement("Following element not of type float: ");
                        vector.addElement((String)vector4.elementAt(n8));
                        return -1;
                    }
                    ++n8;
                }
                deviceData.insert(fArray);
                break;
            }
            case 13: {
                Vector vector5 = HtmlHelper.parse_string_1sep(string, ",");
                vector.removeAllElements();
                double[] dArray = new double[vector5.size()];
                int n9 = 0;
                while (n9 < vector5.size()) {
                    try {
                        double d;
                        dArray[n9] = d = Double.valueOf((String)vector5.elementAt(n9)).doubleValue();
                        vector.addElement(Double.toString(d));
                    }
                    catch (NumberFormatException numberFormatException) {
                        vector.removeAllElements();
                        vector.addElement("Following element not of type double: ");
                        vector.addElement((String)vector5.elementAt(n9));
                        return -1;
                    }
                    ++n9;
                }
                deviceData.insert(dArray);
                break;
            }
            case 16: {
                Vector vector6 = HtmlHelper.parse_string_quot1sep(string, ",");
                String[] stringArray = new String[vector6.size()];
                vector.removeAllElements();
                int n10 = 0;
                while (n10 < vector6.size()) {
                    stringArray[n10] = (String)vector6.elementAt(n10);
                    vector.addElement(vector6.elementAt(n10));
                    ++n10;
                }
                deviceData.insert(stringArray);
                break;
            }
            case 17: {
                Vector vector7 = HtmlHelper.parse_string(string, "[", "]");
                if (vector7.size() != 2) {
                    vector.removeAllElements();
                    vector.addElement("Parsing error, syntax: [1,2] [\"qwe\",\"ty\"]");
                    return -1;
                }
                vector.removeAllElements();
                Vector vector8 = HtmlHelper.parse_string_1sep((String)vector7.elementAt(0), ",");
                int[] nArray = new int[vector8.size()];
                vector.addElement("long array length: " + nArray.length);
                vector.addElement("lvalue:");
                int n11 = 0;
                while (n11 < vector8.size()) {
                    try {
                        int n12 = HtmlHelper.parse_int((String)vector8.elementAt(n11));
                        vector.addElement("[" + n11 + "]\t " + Integer.toString(n12));
                        nArray[n11] = n12;
                    }
                    catch (NumberFormatException numberFormatException) {
                        vector.removeAllElements();
                        vector.addElement("Following element not of type Java integer: ");
                        vector.addElement((String)vector8.elementAt(n11));
                        return -1;
                    }
                    ++n11;
                }
                Vector vector9 = HtmlHelper.parse_string_quot1sep((String)vector7.elementAt(1), ",");
                String[] stringArray = new String[vector9.size()];
                vector.addElement("string array length: " + stringArray.length);
                vector.addElement("svalue:");
                int n13 = 0;
                while (n13 < vector9.size()) {
                    stringArray[n13] = (String)vector9.elementAt(n13);
                    vector.addElement("[" + n13 + "]\t " + vector9.elementAt(n13));
                    ++n13;
                }
                DevVarLongStringArray devVarLongStringArray = new DevVarLongStringArray(nArray, stringArray);
                deviceData.insert(devVarLongStringArray);
                break;
            }
            case 18: {
                Vector vector10 = HtmlHelper.parse_string(string, "[", "]");
                if (vector10.size() != 2) {
                    vector.removeAllElements();
                    vector.addElement("Parsing error, syntax: [1,2] [\"qwe\",\"ty\"]");
                    return -1;
                }
                vector.removeAllElements();
                Vector vector11 = HtmlHelper.parse_string_1sep((String)vector10.elementAt(0), ",");
                double[] dArray = new double[vector11.size()];
                vector.addElement("double array length: " + dArray.length);
                vector.addElement("dvalue:");
                int n14 = 0;
                while (n14 < vector11.size()) {
                    try {
                        double d = Double.valueOf((String)vector11.elementAt(n14));
                        vector.addElement("[" + n14 + "]\t " + Double.toString(d));
                        dArray[n14] = d;
                    }
                    catch (NumberFormatException numberFormatException) {
                        vector.removeAllElements();
                        vector.addElement("Following element not of type double: ");
                        vector.addElement((String)vector11.elementAt(n14));
                        return -1;
                    }
                    ++n14;
                }
                Vector vector12 = HtmlHelper.parse_string_quot1sep((String)vector10.elementAt(1), ",");
                String[] stringArray = new String[vector12.size()];
                vector.addElement("string array length: " + stringArray.length);
                vector.addElement("svalue:");
                int n15 = 0;
                while (n15 < vector12.size()) {
                    stringArray[n15] = (String)vector12.elementAt(n15);
                    vector.addElement("[" + n15 + "]\t " + vector12.elementAt(n15));
                    ++n15;
                }
                DevVarDoubleStringArray devVarDoubleStringArray = new DevVarDoubleStringArray(dArray, stringArray);
                deviceData.insert(devVarDoubleStringArray);
                break;
            }
            case 19: {
                deviceData.insert(DevState.from_int((int)Integer.parseInt(string)));
                break;
            }
        }
        return 0;
    }

    private static String int_to_uint(int n) {
        long l = n;
        if (l < 0L) {
            l += 0x100000000L;
        }
        String string = Long.toString(l);
        return string;
    }

    private static String short_to_ushort(short n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 65536;
        }
        String string = Integer.toString(n2);
        return string;
    }

    private static short parse_short(String string) {
        int n;
        String string2 = string.trim();
        if (string2.startsWith("0x") || string2.startsWith("0X")) {
            n = 16;
            string2 = string2.substring(2);
        } else {
            n = 10;
        }
        short s = Short.parseShort(string2, n);
        return s;
    }

    private static int parse_int(String string) {
        int n;
        String string2 = string.trim();
        if (string2.startsWith("0x") || string2.startsWith("0X")) {
            n = 16;
            string2 = string2.substring(2);
        } else {
            n = 10;
        }
        int n2 = Integer.parseInt(string2, n);
        return n2;
    }

    private static long parse_long(String string) {
        int n;
        String string2 = string.trim();
        if (string2.startsWith("0x") || string2.startsWith("0X")) {
            n = 16;
            string2 = string2.substring(2);
        } else {
            n = 10;
        }
        long l = Long.parseLong(string2, n);
        return l;
    }

    private static int check_ushort(String string, Vector vector) {
        int n = HtmlHelper.parse_int(string);
        if (n > 65535 || n < 0) {
            vector.removeAllElements();
            vector.addElement("Value " + string + " out of range [0," + 65535 + "]\n");
            return -1;
        }
        return n;
    }

    private static long check_ulong(String string, Vector vector) {
        long l = HtmlHelper.parse_long(string);
        if (l > 0xFFFFFFFFL || l < 0L) {
            vector.removeAllElements();
            vector.addElement("Value " + string + " out of range [0," + 0xFFFFFFFFL + "]\n");
            return -1L;
        }
        return l;
    }

    public static int string_to_deviceattribute(String string, DeviceAttribute deviceAttribute, AttrDataFormat attrDataFormat, int n, Vector vector) {
        int n2 = 0;
        if (string.equals("")) {
            vector.removeAllElements();
            vector.addElement("Empty argument, you must specify a value");
            return -1;
        }
        vector.removeAllElements();
        vector.addElement("Not supported type of argin");
        block0 : switch (n) {
            case 2: {
                switch (attrDataFormat.value()) {
                    case 0: {
                        deviceAttribute.insert(HtmlHelper.parse_short(string));
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        vector.removeAllElements();
                        vector.addElement("SPECTRUM and IMAGE attributes are not writable");
                        break block0;
                    }
                }
                n2 = -1;
                break;
            }
            case 3: {
                switch (attrDataFormat.value()) {
                    case 0: {
                        deviceAttribute.insert(HtmlHelper.parse_int(string));
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        vector.removeAllElements();
                        vector.addElement("SPECTRUM and IMAGE attributes are not writable");
                        break block0;
                    }
                }
                n2 = -1;
                break;
            }
            case 5: {
                switch (attrDataFormat.value()) {
                    case 0: {
                        deviceAttribute.insert(Double.valueOf(string).doubleValue());
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        vector.removeAllElements();
                        vector.addElement("SPECTRUM and IMAGE attributes are not writable");
                        break block0;
                    }
                }
                n2 = -1;
                break;
            }
            case 8: {
                switch (attrDataFormat.value()) {
                    case 0: {
                        deviceAttribute.insert(string);
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        vector.removeAllElements();
                        vector.addElement("SPECTRUM and IMAGE attributes are not writable");
                        break block0;
                    }
                }
                n2 = -1;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    public static String devicedata_to_string(DeviceData deviceData, int n) {
        return HtmlHelper.devicedata_to_string(deviceData, n, -1);
    }

    public static String devicedata_to_string(DeviceData deviceData, int n, int n2) {
        String string = new String("");
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                Boolean bl = new Boolean(deviceData.extractBoolean());
                string = bl.toString();
                break;
            }
            case 6: {
                string = HtmlHelper.short_to_ushort(deviceData.extractUShort());
                break;
            }
            case 2: {
                string = HtmlHelper.short_to_ushort(deviceData.extractShort());
                break;
            }
            case 7: {
                string = HtmlHelper.int_to_uint(deviceData.extractULong());
                break;
            }
            case 3: {
                string = Integer.toString(deviceData.extractLong());
                break;
            }
            case 4: {
                string = Float.toString(deviceData.extractFloat());
                break;
            }
            case 5: {
                string = Double.toString(deviceData.extractDouble());
                break;
            }
            case 8: {
                string = deviceData.extractString();
                break;
            }
            case 9: {
                byte[] byArray = deviceData.extractByteArray();
                int n3 = byArray.length;
                if (n2 >= 0 && n2 < n3) {
                    n3 = n2;
                    string = string + "limiting print to " + n2 + "elements\n";
                }
                int n4 = 0;
                while (n4 < n3) {
                    string = byArray[n4] >= 32 ? string + new Character((char)byArray[n4]).toString() : string + " ";
                    string = string + " = 0x" + Integer.toString(byArray[n4], 16) + "\n";
                    ++n4;
                }
                break;
            }
            case 14: {
                short[] sArray = deviceData.extractUShortArray();
                string = string + "array length: " + sArray.length + "\n";
                int n5 = sArray.length;
                if (n2 >= 0 && n2 < n5) {
                    n5 = n2;
                    string = string + "limiting print to " + n2 + "elements\n";
                }
                int n6 = 0;
                while (n6 < n5) {
                    string = string + "[" + n6 + "]\t " + HtmlHelper.short_to_ushort(sArray[n6]) + "\n";
                    ++n6;
                }
                break;
            }
            case 10: {
                short[] sArray = deviceData.extractShortArray();
                string = string + "array length: " + sArray.length + "\n";
                int n7 = sArray.length;
                if (n2 >= 0 && n2 < n7) {
                    n7 = n2;
                    string = string + "limiting print to " + n2 + "elements\n";
                }
                int n8 = 0;
                while (n8 < n7) {
                    string = string + "[" + n8 + "]\t " + Short.toString(sArray[n8]) + "\n";
                    ++n8;
                }
                break;
            }
            case 15: {
                int[] nArray = deviceData.extractULongArray();
                string = string + "array length: " + nArray.length + "\n";
                int n9 = nArray.length;
                if (n2 >= 0 && n2 < n9) {
                    n9 = n2;
                    string = string + "limiting print to " + n2 + "elements\n";
                }
                int n10 = 0;
                while (n10 < n9) {
                    string = string + "[" + n10 + "]\t " + HtmlHelper.int_to_uint(nArray[n10]) + "\n";
                    ++n10;
                }
                break;
            }
            case 11: {
                int[] nArray = deviceData.extractLongArray();
                string = string + "array length: " + nArray.length + "\n";
                int n11 = nArray.length;
                if (n2 >= 0 && n2 < n11) {
                    n11 = n2;
                    string = string + "limiting print to " + n2 + "elements\n";
                }
                int n12 = 0;
                while (n12 < n11) {
                    string = string + "[" + n12 + "]\t " + Integer.toString(nArray[n12]) + "\n";
                    ++n12;
                }
                break;
            }
            case 12: {
                float[] fArray = deviceData.extractFloatArray();
                string = string + "array length: " + fArray.length + "\n";
                int n13 = fArray.length;
                if (n2 >= 0 && n2 < n13) {
                    n13 = n2;
                    string = string + "limiting print to " + n2 + "elements\n";
                }
                int n14 = 0;
                while (n14 < n13) {
                    string = string + "[" + n14 + "]\t " + Float.toString(fArray[n14]) + "\n";
                    ++n14;
                }
                break;
            }
            case 13: {
                double[] dArray = deviceData.extractDoubleArray();
                string = string + "array length: " + dArray.length + "\n";
                int n15 = dArray.length;
                if (n2 >= 0 && n2 < n15) {
                    n15 = n2;
                    string = string + "limiting print to " + n2 + "elements\n";
                }
                int n16 = 0;
                while (n16 < n15) {
                    string = string + "[" + n16 + "]\t" + Double.toString(dArray[n16]) + "\n";
                    ++n16;
                }
                break;
            }
            case 16: {
                String[] stringArray = deviceData.extractStringArray();
                string = string + "array length: " + stringArray.length + "\n";
                int n17 = stringArray.length;
                if (n2 >= 0 && n2 < n17) {
                    n17 = n2;
                    string = string + "limiting print to " + n2 + "elements\n";
                }
                int n18 = 0;
                while (n18 < n17) {
                    string = string + "[" + n18 + "]\t " + stringArray[n18] + "\n";
                    ++n18;
                }
                break;
            }
            case 17: {
                DevVarLongStringArray devVarLongStringArray = deviceData.extractLongStringArray();
                string = string + "long array length: " + devVarLongStringArray.lvalue.length + "\n";
                string = string + "lvalue:\n";
                int n19 = devVarLongStringArray.lvalue.length;
                if (n2 >= 0 && n2 < n19) {
                    n19 = n2;
                    string = string + "limiting print to " + n2 + "elements\n";
                }
                int n20 = 0;
                while (n20 < n19) {
                    string = string + "[" + n20 + "]\t " + Integer.toString(devVarLongStringArray.lvalue[n20]) + "\n";
                    ++n20;
                }
                string = string + "string array length: " + devVarLongStringArray.svalue.length + "\n";
                string = string + "svalue:\n";
                n19 = devVarLongStringArray.svalue.length;
                if (n2 >= 0 && n2 < n19) {
                    n19 = n2;
                    string = string + "limiting print to " + n2 + "elements\n";
                }
                int n21 = 0;
                while (n21 < n19) {
                    string = string + "[" + n21 + "]\t " + devVarLongStringArray.svalue[n21] + "\n";
                    ++n21;
                }
                break;
            }
            case 18: {
                DevVarDoubleStringArray devVarDoubleStringArray = deviceData.extractDoubleStringArray();
                string = string + "double array length: " + devVarDoubleStringArray.dvalue.length + "\n";
                string = string + "dvalue:\n";
                int n22 = devVarDoubleStringArray.dvalue.length;
                if (n2 >= 0 && n2 < n22) {
                    n22 = n2;
                    string = string + "limiting print to " + n2 + "elements\n";
                }
                int n23 = 0;
                while (n23 < n22) {
                    string = string + "[" + n23 + "]\t " + Double.toString(devVarDoubleStringArray.dvalue[n23]) + "\n";
                    ++n23;
                }
                string = string + "string array length: " + devVarDoubleStringArray.svalue.length + "\n";
                string = string + "svalue:\n";
                n22 = devVarDoubleStringArray.svalue.length;
                if (n2 >= 0 && n2 < n22) {
                    n22 = n2;
                    string = string + "limiting print to " + n2 + "elements\n";
                }
                int n24 = 0;
                while (n24 < n22) {
                    string = string + "[" + n24 + "]\t " + devVarDoubleStringArray.svalue[n24] + "\n";
                    ++n24;
                }
                break;
            }
            case 19: {
                string = TangoConst.Tango_DevStateName[deviceData.extractDevState().value()];
                break;
            }
        }
        return string;
    }

    public static String deviceattribute_to_string(DeviceAttribute deviceAttribute, AttrWriteType attrWriteType, AttrDataFormat attrDataFormat, int n) {
        String string = new String("");
        TimeVal timeVal = deviceAttribute.getTimeVal();
        string = string + "measure date: " + timeVal.tv_sec + "sec   " + timeVal.tv_usec + "usec\n";
        Date date = new Date((long)((double)timeVal.tv_sec * 1000.0 + (double)timeVal.tv_usec / 1000.0));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        string = string + "measure date: " + simpleDateFormat.format(date) + "\n";
        AttrQuality attrQuality = deviceAttribute.getQuality();
        string = string + "quality: ";
        switch (attrQuality.value()) {
            case 0: {
                string = string + "VALID";
                break;
            }
            case 1: {
                string = string + "INVALID";
                break;
            }
            case 2: {
                string = string + "ALARM";
                break;
            }
            default: {
                string = string + "UNKNOWN";
            }
        }
        string = string + "\n";
        switch (attrDataFormat.value()) {
            case 0: {
                break;
            }
            case 1: {
                string = string + "dim x: " + deviceAttribute.getDimX() + "\n";
                break;
            }
            case 2: {
                string = string + "dim x: " + deviceAttribute.getDimX() + "\n";
                string = string + "dim y: " + deviceAttribute.getDimY() + "\n";
                break;
            }
        }
        switch (n) {
            case 2: {
                short[] sArray = deviceAttribute.extractShortArray();
                if (attrDataFormat.value() == 0) {
                    if (sArray.length > 0) {
                        string = attrWriteType == AttrWriteType.WRITE ? string + "last written value: " + HtmlHelper.short_to_ushort(sArray[0]) + "\n" : string + "read point: " + HtmlHelper.short_to_ushort(sArray[0]) + "\n";
                    }
                    if (sArray.length <= 1) break;
                    string = string + "set  point: " + HtmlHelper.short_to_ushort(sArray[1]) + "\n";
                    break;
                }
                string = string + "array length: " + sArray.length + "\n";
                int n2 = 0;
                while (n2 < sArray.length) {
                    string = string + "[" + n2 + "]\t" + HtmlHelper.short_to_ushort(sArray[n2]) + "\n";
                    ++n2;
                }
                break;
            }
            case 3: {
                int[] nArray = deviceAttribute.extractLongArray();
                if (attrDataFormat.value() == 0) {
                    if (nArray.length > 0) {
                        string = string + "read point: " + Integer.toString(nArray[0]) + "\n";
                    }
                    if (nArray.length <= 1) break;
                    string = string + "set  point: " + Integer.toString(nArray[1]) + "\n";
                    break;
                }
                string = string + "array length: " + nArray.length + "\n";
                int n3 = 0;
                while (n3 < nArray.length) {
                    string = string + "[" + n3 + "]\t" + Integer.toString(nArray[n3]) + "\n";
                    ++n3;
                }
                break;
            }
            case 5: {
                double[] dArray = deviceAttribute.extractDoubleArray();
                if (attrDataFormat.value() == 0) {
                    if (dArray.length > 0) {
                        string = string + "read point: " + Double.toString(dArray[0]) + "\n";
                    }
                    if (dArray.length <= 1) break;
                    string = string + "set  point: " + Double.toString(dArray[1]) + "\n";
                    break;
                }
                string = string + "array length: " + dArray.length + "\n";
                int n4 = 0;
                while (n4 < dArray.length) {
                    string = string + "[" + n4 + "]\t" + Double.toString(dArray[n4]) + "\n";
                    ++n4;
                }
                break;
            }
            case 8: {
                if (attrDataFormat.value() == 0) {
                    string = deviceAttribute.extractString();
                    break;
                }
                String[] stringArray = deviceAttribute.extractStringArray();
                string = string + "array length: " + stringArray.length + "\n";
                int n5 = 0;
                while (n5 < stringArray.length) {
                    string = string + "[" + n5 + "]\t" + stringArray[n5] + "\n";
                    ++n5;
                }
                break;
            }
            default: {
                string = new String("Unsupported attribute type");
            }
        }
        return string;
    }

    private static Vector parse_string(String string, String string2, String string3) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = 0;
        string = string.trim();
        while (n != -1 && n2 != -1) {
            n = string.indexOf(string2, n);
            n2 = string.indexOf(string3, n + 1);
            if (n == -1 || n2 == -1) continue;
            vector.addElement(string.substring(n + 1, n2));
            n = n2 + 1;
        }
        return vector;
    }

    private static Vector parse_string_1sep(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        String string3 = null;
        int n = 0;
        int n2 = 0;
        string = string.trim();
        while (n != -1 && n2 != -1) {
            n2 = string.indexOf(string2, n);
            if (n2 != -1) {
                string3 = string.substring(n, n2).trim();
                if (string3.length() != 0) {
                    vector.addElement(string3);
                }
                n = n2 + 1;
                continue;
            }
            string3 = string.substring(n).trim();
            if (string3.length() == 0) continue;
            vector.addElement(string3);
        }
        return vector;
    }

    private static Vector parse_string_quot1sep(String string, String string2) throws NumberFormatException {
        string = string.trim();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        boolean bl = false;
        int n2 = string.length();
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            if (cArray[n3] == '\"') {
                bl = !bl;
            } else if (bl) {
                cArray2[n++] = cArray[n3];
            } else if (cArray[n3] == ',') {
                vector.addElement(new String(cArray2, 0, n));
                n = 0;
            } else if (cArray[n3] != ' ' && cArray[n3] != '\t') {
                cArray2[n++] = cArray[n3];
            }
            ++n3;
        }
        if (n != 0) {
            vector.addElement(new String(cArray2, 0, n));
        }
        if (bl) {
            throw new NumberFormatException("too many quotes");
        }
        return vector;
    }

    public static String argin_example(int n) {
        String string = new String("Ex: ");
        switch (n) {
            case 0: {
                string = new String("");
                break;
            }
            case 1: {
                string = string + "true";
                break;
            }
            case 6: {
                string = string + "10 or 0xa (unsigned 16bits)";
                break;
            }
            case 2: {
                string = string + "10 or 0xa (signed 16bits)";
                break;
            }
            case 7: {
                string = string + "10 or 0xa (unsigned 32bits)";
                break;
            }
            case 3: {
                string = string + "10 or 0xa (signed 32bits)";
                break;
            }
            case 4: {
                string = string + "2.3 (32bits float)";
                break;
            }
            case 5: {
                string = string + "2.3 (64bits float)";
                break;
            }
            case 8: {
                string = "no quotes needed";
                break;
            }
            case 9: {
                string = string + "abc (no quotes needed)";
                break;
            }
            case 14: {
                string = string + "2,0xa,4 (unsigned 16bits)";
                break;
            }
            case 10: {
                string = string + "2,0xa,4 (signed 16bits)";
                break;
            }
            case 15: {
                string = string + "2,0xa,4 (unsigned 32bits)";
                break;
            }
            case 11: {
                string = string + "2,0xa,4 (signed 32bits)";
                break;
            }
            case 12: {
                string = string + "2.3,4 (32bits floats)";
                break;
            }
            case 13: {
                string = string + "2.3,4 (64bits floats)";
                break;
            }
            case 16: {
                string = string + "\"Dance\",\"TANGO\"";
                break;
            }
            case 17: {
                string = string + "[1,2][\"A\",\"B\"]";
                break;
            }
            case 18: {
                string = "not supported";
                break;
            }
            case 19: {
                string = string + "0 (16bits value)";
                break;
            }
            default: {
                string = new String("");
            }
        }
        return string;
    }
}

