/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.CommandInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jive.AttrInfo;
import jive.CmdInfo;
import jive.DevHelper;
import jive.DevHelperDevFailed;
import jive.HtmlHelper;

public class ExecDev
extends JPanel
implements ActionListener,
ListSelectionListener,
MouseListener {
    Thread thread;
    String client_host = null;
    DevHelper device;
    String device_name = null;
    String session_id = null;
    int nb_commands;
    CmdInfo[] commands;
    String[] attrs;
    AttrInfo[] attr_configs;
    final String EXEC_SERVLET_NAME = "/jive/servlet/CmdExec";
    final String SEP_COMMAND_NAME = "_____________";
    int getto_index;
    int setto_index;
    int setlim_index;
    int answer_limit = -1;
    JList list_commands;
    JList list_attrs;
    JList list_attr_props;
    JScrollPane list_commands_view;
    JScrollPane list_attrs_view;
    JScrollPane list_attr_props_view;
    JTextField in_type_field;
    JTextField out_type_field;
    JTextArea in_type_desc;
    JTextArea out_type_desc;
    JScrollPane in_type_desc_view;
    JScrollPane out_type_desc_view;
    JTextField in_value;
    JTextArea history;
    JScrollPane history_view;
    JButton exec_button;
    JButton clear_button;
    JButton rdattr_button;
    JButton wrattr_button;
    JButton close_button;
    JLabel title_label;
    JLabel in_example;
    JLabel in_value_lb;
    JLabel command_list_lb;
    JLabel argin_type_lb;
    JLabel argout_type_lb;
    JLabel argin_desc_lb;
    JLabel argout_desc_lb;
    JLabel att_list_lb;
    JLabel att_prop_lb;
    boolean isAnApplet = false;
    static final int DBG_NONE = 0;
    static final int DBG_ERRORS = 1;
    static final int DBG_TRACE = 2;
    static final int DBG_INFOS = 3;
    static final int DBG_MAX = 4;
    final String[] Tango_CmdArgTypeName = new String[]{new String("DevVoid"), new String("DevBoolean"), new String("DevShort"), new String("DevLong"), new String("DevFloat"), new String("DevDouble"), new String("DevUShort"), new String("DevULong"), new String("DevString"), new String("DevVarCharArray"), new String("DevVarShortArray"), new String("DevVarLongArray"), new String("DevVarFloatArray"), new String("DevVarDoubleArray"), new String("DevVarUShortArray"), new String("DevVarULongArray"), new String("DevVarStringArray"), new String("DevVarLongStringArray"), new String("DevVarDoubleStringArray"), new String("DevState")};

    public ExecDev() {
        this.setLayout(null);
        this.title_label = new JLabel();
        this.title_label.setHorizontalAlignment(0);
        this.title_label.setFont(new Font("Lucida Bright", 1, 16));
        this.add(this.title_label);
        this.in_value_lb = new JLabel("Argin Value");
        this.add(this.in_value_lb);
        this.in_example = new JLabel("");
        this.add(this.in_example);
        this.in_value = new JTextField();
        this.in_value.setBackground(Color.white);
        this.in_value.setEditable(true);
        this.add(this.in_value);
        this.command_list_lb = new JLabel("Command List");
        this.add(this.command_list_lb);
        this.argin_type_lb = new JLabel("Argin Type");
        this.add(this.argin_type_lb);
        this.argout_type_lb = new JLabel("Argout Type");
        this.add(this.argout_type_lb);
        this.list_commands = new JList();
        this.list_commands.addListSelectionListener(this);
        this.list_commands.addMouseListener(this);
        this.list_commands_view = new JScrollPane(this.list_commands);
        this.add(this.list_commands_view);
        this.in_type_field = new JTextField();
        this.in_type_field.setEditable(false);
        this.add(this.in_type_field);
        this.out_type_field = new JTextField(10);
        this.out_type_field.setEditable(false);
        this.add(this.out_type_field);
        this.argin_desc_lb = new JLabel("Argin Description");
        this.add(this.argin_desc_lb);
        this.argout_desc_lb = new JLabel("Argout Description");
        this.add(this.argout_desc_lb);
        this.in_type_desc = new JTextArea();
        this.in_type_desc.setEditable(false);
        this.in_type_desc.setBackground(this.in_type_field.getBackground());
        this.in_type_desc_view = new JScrollPane(this.in_type_desc);
        this.in_type_desc_view.setHorizontalScrollBarPolicy(32);
        this.add(this.in_type_desc_view);
        this.out_type_desc = new JTextArea();
        this.out_type_desc.setEditable(false);
        this.out_type_desc.setBackground(this.out_type_field.getBackground());
        this.out_type_desc_view = new JScrollPane(this.out_type_desc);
        this.out_type_desc_view.setHorizontalScrollBarPolicy(32);
        this.add(this.out_type_desc_view);
        this.exec_button = new JButton("Execute Command");
        this.exec_button.addActionListener(this);
        this.add(this.exec_button);
        this.clear_button = new JButton("Clear History");
        this.clear_button.addActionListener(this);
        this.add(this.clear_button);
        this.att_list_lb = new JLabel("Attribute List");
        this.add(this.att_list_lb);
        this.att_prop_lb = new JLabel("Attribute properties");
        this.add(this.att_prop_lb);
        this.list_attrs = new JList();
        this.list_attrs.addListSelectionListener(this);
        this.list_attrs.addMouseListener(this);
        this.list_attrs_view = new JScrollPane(this.list_attrs);
        this.add(this.list_attrs_view);
        this.list_attr_props = new JList();
        this.list_attr_props.addListSelectionListener(this);
        this.list_attr_props.addMouseListener(this);
        this.list_attr_props_view = new JScrollPane(this.list_attr_props);
        this.add(this.list_attr_props_view);
        this.rdattr_button = new JButton("Read Attribute");
        this.rdattr_button.addActionListener(this);
        this.add(this.rdattr_button);
        this.wrattr_button = new JButton("Write Attribute");
        this.wrattr_button.addActionListener(this);
        this.add(this.wrattr_button);
        this.close_button = new JButton("Dismiss");
        this.close_button.addActionListener(this);
        this.add(this.close_button);
        this.history = new JTextArea("");
        this.history.setEditable(false);
        this.history_view = new JScrollPane(this.history);
        this.add(this.history_view);
    }

    public Rectangle getPRect(double d, double d2, double d3, double d4) {
        Dimension dimension = this.getSize();
        double d5 = (double)dimension.width / 100.0;
        double d6 = (double)dimension.height / 100.0;
        Rectangle rectangle = new Rectangle((int)(d * d5), (int)(d2 * d6), (int)((d3 - d) * d5), (int)((d4 - d2) * d6));
        return rectangle;
    }

    public void placeComponents(Dimension dimension) {
        this.setSize(dimension);
        this.title_label.setBounds(this.getPRect(2.0, 1.0, 98.0, 4.0));
        this.in_value_lb.setBounds(this.getPRect(2.0, 4.0, 20.0, 6.4));
        this.in_example.setBounds(this.getPRect(36.4, 10.3, 98.0, 12.5));
        this.in_value.setBounds(this.getPRect(2.0, 6.8, 98.0, 10.2));
        this.command_list_lb.setBounds(this.getPRect(2.0, 10.5, 22.6, 12.5));
        this.list_commands_view.setBounds(this.getPRect(2.0, 13.0, 31.6, 33.0));
        this.argin_type_lb.setBounds(this.getPRect(33.4, 15.4, 62.2, 18.2));
        this.in_type_field.setBounds(this.getPRect(33.4, 18.6, 62.6, 22.8));
        this.argout_type_lb.setBounds(this.getPRect(66.4, 15.4, 98.0, 18.2));
        this.out_type_field.setBounds(this.getPRect(66.4, 18.6, 98.0, 22.8));
        this.argin_desc_lb.setBounds(this.getPRect(33.4, 23.6, 62.2, 26.2));
        this.in_type_desc_view.setBounds(this.getPRect(33.4, 26.6, 63.0, 33.0));
        this.argout_desc_lb.setBounds(this.getPRect(66.4, 23.6, 98.0, 26.2));
        this.out_type_desc_view.setBounds(this.getPRect(66.4, 26.6, 98.0, 33.0));
        this.exec_button.setBounds(this.getPRect(20.0, 34.0, 49.0, 38.0));
        this.clear_button.setBounds(this.getPRect(51.0, 34.0, 80.0, 38.0));
        this.list_attrs_view.setBounds(this.getPRect(2.0, 42.0, 30.5, 55.4));
        this.att_list_lb.setBounds(this.getPRect(2.0, 38.5, 29.6, 41.5));
        this.list_attr_props_view.setBounds(this.getPRect(31.4, 42.0, 98.0, 55.4));
        this.att_prop_lb.setBounds(this.getPRect(31.6, 38.5, 98.0, 41.5));
        this.rdattr_button.setBounds(this.getPRect(20.0, 56.8, 49.0, 60.8));
        this.wrattr_button.setBounds(this.getPRect(51.0, 56.8, 80.0, 60.8));
        this.history_view.setBounds(this.getPRect(2.0, 61.6, 98.0, 94.0));
        this.close_button.setBounds(this.getPRect(40.0, 95.0, 60.0, 99.0));
        this.list_commands_view.revalidate();
        this.history_view.revalidate();
        this.list_attrs_view.revalidate();
        this.list_attr_props_view.revalidate();
        this.out_type_desc_view.revalidate();
        this.in_type_desc_view.revalidate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.clear_button) {
            this.history.replaceRange("", 0, this.history.getText().length());
        }
        if (object == this.exec_button) {
            this.execCurCommand();
        }
        if (object == this.rdattr_button) {
            this.readCurAttr();
        }
        if (object == this.wrattr_button) {
            this.writeCurAttr();
        }
        if (object == this.close_button) {
            this.getParent().getParent().getParent().getParent().setVisible(false);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        if (jList == this.list_commands) {
            this.debug(3, "Command selected: " + jList.getSelectedValue());
            this.update_command_infos(jList.getSelectedIndex());
        } else if (jList == this.list_attrs) {
            this.debug(3, "Attribute selected: " + jList.getSelectedValue());
            this.update_attr_infos(jList.getSelectedIndex());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (mouseEvent.getClickCount() >= 2) {
            if (object == this.list_attrs) {
                this.readCurAttr();
            }
            if (object == this.list_commands) {
                this.execCurCommand();
            }
        }
    }

    public void display_error(String string) {
        JOptionPane.showMessageDialog(null, string, "Device Panel Error", 0);
    }

    public boolean set_device_name(String string) {
        this.device_name = string;
        this.debug(2, "Entering set_device_name()");
        this.title_label.setText(this.device_name);
        if (!this.isAnApplet) {
            try {
                this.device = new DevHelper(this.device_name);
            }
            catch (DevHelperDevFailed devHelperDevFailed) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("failed to import device: " + this.device_name + "\n");
                stringBuffer.append("reason:\t" + devHelperDevFailed.reason + "\n");
                stringBuffer.append("origin:\t" + devHelperDevFailed.origin + "\n");
                stringBuffer.append("desc:\t" + devHelperDevFailed.desc + "\n");
                this.debug(1, stringBuffer.toString());
                this.display_error(stringBuffer.toString());
                return true;
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("ORB failed connecting to database");
                this.debug(1, stringBuffer.toString());
                this.display_error(stringBuffer.toString());
                return true;
            }
        }
        this.get_commands();
        this.get_attrs();
        this.update_ui_list();
        this.history.replaceRange("", 0, this.history.getText().length());
        return false;
    }

    void update_ui_list() {
        this.list_commands.removeAll();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        int n = 0;
        while (n < this.nb_commands) {
            defaultListModel.add(n, this.commands[n].cmd_name);
            ++n;
        }
        this.list_commands.setModel(defaultListModel);
        this.list_commands.setSelectedIndex(0);
        this.update_command_infos(0);
        this.list_attrs.removeAll();
        this.list_attr_props.removeAll();
        if (this.attrs.length > 0) {
            defaultListModel = new DefaultListModel();
            int n2 = 0;
            while (n2 < this.attrs.length) {
                defaultListModel.add(n2, this.attrs[n2]);
                ++n2;
            }
            this.list_attrs.setModel(defaultListModel);
            this.list_attrs.setSelectedIndex(0);
            this.update_attr_infos(0);
            this.rdattr_button.setEnabled(true);
            this.wrattr_button.setEnabled(true);
        } else {
            this.rdattr_button.setEnabled(false);
            this.wrattr_button.setEnabled(false);
        }
    }

    void get_commands() {
        int n;
        this.debug(2, "Entering get_commands()");
        CmdInfo[] cmdInfoArray = null;
        int n2 = 0;
        if (!this.isAnApplet) {
            CommandInfo[] commandInfoArray = this.device.command_list_query();
            n2 = commandInfoArray.length;
            cmdInfoArray = new CmdInfo[n2];
            n = 0;
            while (n < n2) {
                cmdInfoArray[n] = new CmdInfo();
                cmdInfoArray[n].cmd_name = commandInfoArray[n].cmd_name;
                cmdInfoArray[n].in_type = commandInfoArray[n].in_type;
                cmdInfoArray[n].in_type_desc = commandInfoArray[n].in_type_desc;
                cmdInfoArray[n].out_type = commandInfoArray[n].out_type;
                cmdInfoArray[n].out_type_desc = commandInfoArray[n].out_type_desc;
                ++n;
            }
        }
        int n3 = 4;
        this.nb_commands = n2 + n3;
        this.commands = new CmdInfo[this.nb_commands];
        n = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (n4 == 3) {
                n += n3;
            }
            this.commands[n] = new CmdInfo();
            this.commands[n].cmd_name = cmdInfoArray[n4].cmd_name;
            this.commands[n].in_type = cmdInfoArray[n4].in_type;
            this.commands[n].in_type_desc = cmdInfoArray[n4].in_type_desc;
            this.commands[n].out_type = cmdInfoArray[n4].out_type;
            this.commands[n].out_type_desc = cmdInfoArray[n4].out_type_desc;
            ++n4;
            ++n;
        }
        n = 3;
        this.commands[n] = new CmdInfo();
        this.commands[n].cmd_name = "SetTimeout";
        this.commands[n].in_type = 2;
        this.commands[n].in_type_desc = "Timeout in mS";
        this.commands[n].out_type = 0;
        this.commands[n].out_type_desc = "";
        this.setto_index = n++;
        this.commands[n] = new CmdInfo();
        this.commands[n].cmd_name = "GetTimeout";
        this.commands[n].in_type = 0;
        this.commands[n].in_type_desc = "";
        this.commands[n].out_type = 2;
        this.commands[n].out_type_desc = "Timeout in mS";
        this.getto_index = n++;
        this.commands[n] = new CmdInfo();
        this.commands[n].cmd_name = "SetAnswerLimit";
        this.commands[n].in_type = 2;
        this.commands[n].in_type_desc = "Argout print limit (-1 for no limit)";
        this.commands[n].out_type = 0;
        this.commands[n].out_type_desc = "";
        this.setlim_index = n++;
        this.commands[n] = new CmdInfo();
        this.commands[n].cmd_name = "_____________";
        this.commands[n].in_type = 0;
        this.commands[n].in_type_desc = "";
        this.commands[n].out_type = 0;
        this.commands[n].out_type_desc = "";
        ++n;
        this.debug(2, "Leaving get_commands()");
    }

    void get_attrs() {
        this.debug(2, "Entering get_attrs()");
        if (!this.isAnApplet) {
            this.attrs = this.device.get_attribute_list();
            AttributeInfo[] attributeInfoArray = this.device.get_attribute_config();
            int n = attributeInfoArray.length;
            this.attr_configs = new AttrInfo[n];
            int n2 = 0;
            while (n2 < n) {
                this.attr_configs[n2] = new AttrInfo(attributeInfoArray[n2].name, this.AttrWriteType_to_string(attributeInfoArray[n2].writable), this.AttrDataFormat_to_string(attributeInfoArray[n2].data_format), this.Tango_CmdArgTypeName[attributeInfoArray[n2].data_type], attributeInfoArray[n2].data_type, Integer.toString(attributeInfoArray[n2].max_dim_x), Integer.toString(attributeInfoArray[n2].max_dim_y), attributeInfoArray[n2].description, attributeInfoArray[n2].label, attributeInfoArray[n2].unit, attributeInfoArray[n2].standard_unit, attributeInfoArray[n2].display_unit, attributeInfoArray[n2].format, attributeInfoArray[n2].min_value, attributeInfoArray[n2].max_value, attributeInfoArray[n2].min_alarm, attributeInfoArray[n2].max_alarm);
                ++n2;
            }
        }
        this.debug(2, "Leaving get_attrs()");
    }

    String AttrWriteType_to_string(AttrWriteType attrWriteType) {
        String string = attrWriteType == AttrWriteType.READ ? "READ" : (attrWriteType == AttrWriteType.READ_WITH_WRITE ? "READ_WITH_WRITE" : (attrWriteType == AttrWriteType.WRITE ? "WRITE" : (attrWriteType == AttrWriteType.READ_WRITE ? "READ_WRITE" : "UNKNOWN")));
        return string;
    }

    String AttrDataFormat_to_string(AttrDataFormat attrDataFormat) {
        String string = attrDataFormat == AttrDataFormat.SCALAR ? "SCALAR" : (attrDataFormat == AttrDataFormat.SPECTRUM ? "SPECTRUM" : (attrDataFormat == AttrDataFormat.IMAGE ? "IMAGE" : "UNKNOWN"));
        return string;
    }

    String get_timeout() {
        int n = -1;
        this.debug(2, "Entering get_timeout()");
        if (!this.isAnApplet) {
            try {
                n = this.device.get_timeout();
            }
            catch (DevHelperDevFailed devHelperDevFailed) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("failed getting timeout\n");
                stringBuffer.append("reason:\t" + devHelperDevFailed.reason + "\n");
                stringBuffer.append("origin:\t" + devHelperDevFailed.origin + "\n");
                stringBuffer.append("desc:\t" + devHelperDevFailed.desc + "\n");
                this.debug(1, stringBuffer.toString());
                this.display_error(stringBuffer.toString());
                return null;
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Exception: " + exception.getClass().getName() + "\n");
                stringBuffer.append("message:\t" + exception.getMessage() + "\n");
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return null;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n###################################\n");
        stringBuffer.append("Current timeout to communicate with device\n");
        stringBuffer.append(Integer.toString(n) + " mS\n");
        this.debug(2, "Leaving get_timeout()");
        return stringBuffer.toString();
    }

    String set_timeout(String string) {
        this.debug(2, "Entering set_timeout()");
        String string2 = null;
        try {
            int n = Integer.valueOf(string);
            if (n < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.append_error("New timeout value not a positive integer value");
            return null;
        }
        if (!this.isAnApplet) {
            try {
                string2 = this.device.set_timeout(string);
            }
            catch (DevHelperDevFailed devHelperDevFailed) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("failed setting timeout to: " + string + "\n");
                stringBuffer.append("reason:\t" + devHelperDevFailed.reason + "\n");
                stringBuffer.append("origin:\t" + devHelperDevFailed.origin + "\n");
                stringBuffer.append("desc:\t" + devHelperDevFailed.desc + "\n");
                this.debug(1, stringBuffer.toString());
                this.display_error(stringBuffer.toString());
                return null;
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Exception: " + exception.getClass().getName() + "\n");
                stringBuffer.append("message:\t" + exception.getMessage() + "\n");
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return null;
            }
        }
        this.debug(2, "Leaving set_timeout()");
        return string2;
    }

    void execCurCommand() {
        this.debug(2, "Entering execCurCommand()");
        int n = this.list_commands.getSelectedIndex();
        String string = this.commands[n].cmd_name;
        this.debug(3, "Command to be executed: " + string);
        String string2 = this.in_value.getText();
        int n2 = this.commands[n].in_type;
        int n3 = this.commands[n].out_type;
        String string3 = null;
        if (string.equals("_____________")) {
            return;
        }
        if (n == this.getto_index) {
            string3 = this.get_timeout();
        } else if (n == this.setto_index) {
            string3 = this.set_timeout(string2);
        } else if (n == this.setlim_index) {
            try {
                this.answer_limit = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("wrong argin\n");
                stringBuffer.append("expecting an integer value\n");
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n###################################\n");
            if (this.answer_limit > 0) {
                stringBuffer.append("Argout arrays print out limited to ");
                stringBuffer.append(Integer.toString(this.answer_limit) + " elements\n");
            } else {
                stringBuffer.append("Argout arrays print out not limited\n");
            }
            string3 = stringBuffer.toString();
        } else if (!this.isAnApplet) {
            try {
                string3 = this.device.exec_command(string, string2, this.answer_limit);
            }
            catch (DevHelperDevFailed devHelperDevFailed) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("failed execution command: " + string + "\n");
                stringBuffer.append("reason:\t" + devHelperDevFailed.reason + "\n");
                stringBuffer.append("origin:\t" + devHelperDevFailed.origin + "\n");
                stringBuffer.append("desc:\t" + devHelperDevFailed.desc + "\n");
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return;
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Exception: " + exception.getClass().getName() + "\n");
                stringBuffer.append("message:\t" + exception.getMessage() + "\n");
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return;
            }
        }
        if (string3 != null) {
            this.append_history(string3);
            if (string3.indexOf("WARNING: device re-imported") != -1) {
                this.get_commands();
                this.get_attrs();
                this.update_ui_list();
            }
        }
        this.debug(2, "Leaving execCurCommand()");
    }

    void readCurAttr() {
        this.debug(2, "Entering readCurAttr()");
        int n = this.list_attrs.getSelectedIndex();
        String string = this.attrs[n];
        this.debug(3, "Attribute to be read: " + string);
        String string2 = null;
        if (!this.isAnApplet) {
            try {
                string2 = this.device.read_attr(string);
            }
            catch (DevHelperDevFailed devHelperDevFailed) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("failed reading attribute: " + string + "\n");
                stringBuffer.append("reason:\t" + devHelperDevFailed.reason + "\n");
                stringBuffer.append("origin:\t" + devHelperDevFailed.origin + "\n");
                stringBuffer.append("desc:\t" + devHelperDevFailed.desc + "\n");
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return;
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Exception: " + exception.getClass().getName() + "\n");
                stringBuffer.append("message:\t" + exception.getMessage() + "\n");
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return;
            }
        }
        if (string2 != null) {
            this.append_history(string2);
            if (string2.indexOf("WARNING: device re-imported") != -1) {
                this.get_commands();
                this.get_attrs();
                this.update_ui_list();
            }
        }
        this.debug(2, "Leaving readCurAttr()");
    }

    void writeCurAttr() {
        this.debug(2, "Entering writeCurAttr()");
        int n = this.list_attrs.getSelectedIndex();
        String string = this.attrs[n];
        this.debug(3, "Attribute to write: " + string);
        String string2 = this.in_value.getText();
        String string3 = null;
        if (!this.isAnApplet) {
            try {
                string3 = this.device.write_attr(string, string2);
            }
            catch (DevHelperDevFailed devHelperDevFailed) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("failed writting attribute: " + string + "\n");
                stringBuffer.append("reason:\t" + devHelperDevFailed.reason + "\n");
                stringBuffer.append("origin:\t" + devHelperDevFailed.origin + "\n");
                stringBuffer.append("desc:\t" + devHelperDevFailed.desc + "\n");
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return;
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Exception: " + exception.getClass().getName() + "\n");
                stringBuffer.append("message:\t" + exception.getMessage() + "\n");
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return;
            }
        }
        if (string3 != null) {
            this.append_history(string3);
            if (string3.indexOf("WARNING: device re-imported") != -1) {
                this.get_commands();
                this.get_attrs();
                this.update_ui_list();
            }
        }
        this.debug(2, "Leaving writeCurAttr()");
    }

    private void update_command_infos(int n) {
        this.in_type_field.setText(this.Tango_CmdArgTypeName[this.commands[n].in_type]);
        if (this.commands[n].in_type != 0) {
            this.in_type_desc.setText(this.commands[n].in_type_desc);
            this.in_value.setEditable(true);
            this.in_example.setText(HtmlHelper.argin_example(this.commands[n].in_type));
        } else {
            this.in_type_desc.setText("");
            this.in_value.setText("");
            this.in_value.setEditable(false);
            this.in_example.setText("");
        }
        this.in_type_desc.setCaretPosition(0);
        this.out_type_field.setText(this.Tango_CmdArgTypeName[this.commands[n].out_type]);
        if (this.commands[n].out_type != 0) {
            this.out_type_desc.setText(this.commands[n].out_type_desc);
        } else {
            this.out_type_desc.setText("");
        }
        this.out_type_desc.setCaretPosition(0);
    }

    private void update_attr_infos(int n) {
        this.list_attr_props.removeAll();
        if (this.attr_configs.length == 0) {
            return;
        }
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.add(0, "Name:          " + this.attr_configs[n].name);
        defaultListModel.add(1, "Writable:      " + this.attr_configs[n].writable);
        defaultListModel.add(2, "Data Format:   " + this.attr_configs[n].data_format);
        defaultListModel.add(3, "Data Type:     " + this.attr_configs[n].data_type);
        defaultListModel.add(4, "Max Dim X:     " + this.attr_configs[n].max_dim_x);
        defaultListModel.add(5, "Max Dim Y:     " + this.attr_configs[n].max_dim_y);
        defaultListModel.add(6, "Description:   " + this.attr_configs[n].description);
        defaultListModel.add(7, "Label:         " + this.attr_configs[n].label);
        defaultListModel.add(8, "Unit:          " + this.attr_configs[n].unit);
        defaultListModel.add(9, "Standard Unit: " + this.attr_configs[n].standard_unit);
        defaultListModel.add(10, "Display Unit:  " + this.attr_configs[n].display_unit);
        defaultListModel.add(11, "Format:        " + this.attr_configs[n].format);
        defaultListModel.add(12, "Min Value:     " + this.attr_configs[n].min_value);
        defaultListModel.add(13, "Max Value:     " + this.attr_configs[n].max_value);
        defaultListModel.add(14, "Min Alarm:     " + this.attr_configs[n].min_alarm);
        defaultListModel.add(15, "Max Alarm:     " + this.attr_configs[n].max_alarm);
        this.list_attr_props.setModel(defaultListModel);
        this.list_attr_props.setSelectedIndex(0);
        if (this.attr_configs[n].writable.indexOf("WRITE") != -1) {
            this.in_value.setEditable(true);
            this.in_example.setText(HtmlHelper.argin_example(this.attr_configs[n].data_type_num));
        } else {
            this.in_value.setEditable(false);
            this.in_example.setText("");
        }
    }

    private void append_error(String string) {
        this.debug(1, string);
        this.append_history("\n###################################\nERROR !!\n" + string);
    }

    private void append_history(String string) {
        this.history.append(string);
        int n = this.history.getText().length();
        this.history.select(n, n);
    }

    private void debug(int n, String string) {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: ExecDev devicename");
        } else {
            final ExecDev execDev = new ExecDev();
            if (!execDev.set_device_name(stringArray[0])) {
                final JFrame jFrame = new JFrame();
                jFrame.setTitle("Device Panel");
                jFrame.getContentPane().setLayout(null);
                jFrame.getContentPane().add(execDev);
                jFrame.addComponentListener(new ComponentListener(){

                    public void componentHidden(ComponentEvent componentEvent) {
                        System.exit(0);
                    }

                    public void componentMoved(ComponentEvent componentEvent) {
                    }

                    public void componentResized(ComponentEvent componentEvent) {
                        execDev.placeComponents(jFrame.getContentPane().getSize());
                    }

                    public void componentShown(ComponentEvent componentEvent) {
                        execDev.placeComponents(jFrame.getContentPane().getSize());
                    }
                });
                jFrame.setBounds(50, 50, 450, 650);
                jFrame.setVisible(true);
            } else {
                System.exit(0);
            }
        }
    }
}

