/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import jive.DevHelperDevFailed;
import jive.HtmlHelper;

public class DevHelper
implements TangoConst {
    String id = "$Id: DevHelper.java,v 0.81 2001/11/13 11:17:15 perez Exp perez $";
    DeviceProxy device;
    String device_name;
    CommandInfo[] commands;
    String[] attrs;
    AttributeInfo[] attr_configs = new AttributeInfo[0];
    String client_host;
    public static final String CMD_RESULT_FINISHED = "finished";
    public static final String CMD_INTERNAL = "MP_Jive_Internal";
    public static final String GET_TIMEOUT_CMD = "MP_Jive_Internal_Get_Timeout";
    public static final String SET_TIMEOUT_CMD = "MP_Jive_Internal_Set_Timeout";

    public DevHelper(String string) throws DevHelperDevFailed {
        this.device_name = string;
        try {
            this.client_host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.import_device();
    }

    private void import_device() throws DevHelperDevFailed {
        try {
            this.device = new DeviceProxy(this.device_name);
        }
        catch (DevFailed devFailed) {
            throw new DevHelperDevFailed(devFailed.errors[0].reason, devFailed.errors[0].origin, devFailed.errors[0].desc);
        }
        CommandInfo[] commandInfoArray = null;
        try {
            commandInfoArray = this.device.command_list_query();
        }
        catch (DevFailed devFailed) {
            throw new DevHelperDevFailed(devFailed.errors[0].reason, devFailed.errors[0].origin, devFailed.errors[0].desc);
        }
        int n = commandInfoArray.length;
        this.commands = new CommandInfo[n + 3];
        DevCmdInfo devCmdInfo = new DevCmdInfo();
        int n2 = 0;
        devCmdInfo.cmd_name = "BlackBox";
        devCmdInfo.in_type = 3;
        devCmdInfo.in_type_desc = "Nb commands";
        devCmdInfo.out_type = 16;
        devCmdInfo.out_type_desc = "Last commands";
        this.commands[n2++] = new CommandInfo(devCmdInfo);
        devCmdInfo.cmd_name = "Info";
        devCmdInfo.in_type = 0;
        devCmdInfo.in_type_desc = "";
        devCmdInfo.out_type = 8;
        devCmdInfo.out_type_desc = "Device infos";
        this.commands[n2++] = new CommandInfo(devCmdInfo);
        devCmdInfo.cmd_name = "Ping";
        devCmdInfo.in_type = 0;
        devCmdInfo.in_type_desc = "";
        devCmdInfo.out_type = 8;
        devCmdInfo.out_type_desc = "Device alive";
        this.commands[n2++] = new CommandInfo(devCmdInfo);
        int n3 = 0;
        while (n3 < n) {
            this.commands[n3 + n2] = commandInfoArray[n3];
            ++n3;
        }
        try {
            this.attrs = new String[1];
            this.attrs[0] = "All attributes";
            this.attr_configs = this.device.get_attribute_config(this.attrs);
            int n4 = this.attr_configs.length;
            this.attrs = new String[n4];
            n2 = 0;
            while (n2 < n4) {
                this.attrs[n2] = this.attr_configs[n2].name;
                ++n2;
            }
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("API_AttrNotFound")) {
                this.attrs = new String[0];
            }
            throw new DevHelperDevFailed(devFailed.errors[0].reason, devFailed.errors[0].origin, devFailed.errors[0].desc);
        }
    }

    public CommandInfo[] command_list_query() {
        return this.commands;
    }

    public String[] get_attribute_list() {
        return this.attrs;
    }

    public AttributeInfo[] get_attribute_config() {
        return this.attr_configs;
    }

    public String get_device_name() {
        return this.device_name;
    }

    public String exec_command(String string, String string2) throws DevHelperDevFailed, NumberFormatException {
        return this.exec_command(string, string2, -1);
    }

    public String exec_command(String string, String string2, int n) throws DevHelperDevFailed, NumberFormatException {
        Object object;
        boolean bl;
        DeviceData deviceData;
        long l = 0L;
        long l2 = 0L;
        String string3 = new String("");
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        while (n3 < this.commands.length && !string.equals(this.commands[n3].cmd_name)) {
            ++n3;
        }
        if (n3 >= this.commands.length) {
            this.import_device();
            bl2 = true;
            n3 = 0;
            while (n3 < this.commands.length && !string.equals(this.commands[n3].cmd_name)) {
                ++n3;
            }
            if (n3 >= this.commands.length) {
                throw new DevHelperDevFailed(new String("unknown command for that device"), new String("DevHelper"), new String("unknown command even after a re-import of the device"));
            }
        }
        try {
            deviceData = new DeviceData();
        }
        catch (DevFailed devFailed) {
            throw new DevHelperDevFailed(devFailed.errors[0].reason, devFailed.errors[0].origin, devFailed.errors[0].desc);
        }
        Vector vector = new Vector();
        if (HtmlHelper.string_to_devicedata(string2, deviceData, this.commands[n3].in_type, vector) == -1) {
            String string4 = new String("");
            int n4 = 0;
            while (n4 < vector.size()) {
                string4 = string4 + (String)vector.elementAt(n4);
                ++n4;
            }
            throw new NumberFormatException(string4);
        }
        n2 = 0;
        do {
            block32: {
                bl = false;
                if (string.equals("BlackBox")) {
                    try {
                        object = null;
                        l = System.currentTimeMillis();
                        object = this.device.black_box(Integer.parseInt(string2));
                        l2 = System.currentTimeMillis();
                        int n5 = 0;
                        while (n5 < ((DevInfo)object).length) {
                            string3 = string3 + (String)object[n5] + "\n";
                            ++n5;
                        }
                    }
                    catch (DevFailed devFailed) {
                        if (!(devFailed.errors[0].reason.toUpperCase().indexOf("COMM_FAILURE") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("OBJECT_NOT_EXIST") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("TRANSIENT") == -1 || bl3)) {
                            bl = true;
                        }
                        throw new DevHelperDevFailed(devFailed.errors[0].reason, devFailed.errors[0].origin, devFailed.errors[0].desc);
                    }
                } else if (string.equals("Info")) {
                    try {
                        object = null;
                        l = System.currentTimeMillis();
                        object = this.device.info();
                        l2 = System.currentTimeMillis();
                        string3 = string3 + "device class:   " + object.dev_class + "\n";
                        string3 = string3 + "server id:      " + object.server_id + "\n";
                        string3 = string3 + "server host:    " + object.server_host + "\n";
                        string3 = string3 + "server version: " + object.server_version + "\n";
                        string3 = string3 + "doc URL:        " + object.doc_url + "\n";
                    }
                    catch (DevFailed devFailed) {
                        if (!(devFailed.errors[0].reason.toUpperCase().indexOf("COMM_FAILURE") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("OBJECT_NOT_EXIST") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("TRANSIENT") == -1 || bl3)) {
                            bl = true;
                        }
                        throw new DevHelperDevFailed(devFailed.errors[0].reason, devFailed.errors[0].origin, devFailed.errors[0].desc);
                    }
                } else if (string.equals("Ping")) {
                    try {
                        l = System.currentTimeMillis();
                        this.device.ping();
                        l2 = System.currentTimeMillis();
                        string3 = "Device ALIVE";
                    }
                    catch (DevFailed devFailed) {
                        if (!(devFailed.errors[0].reason.toUpperCase().indexOf("COMM_FAILURE") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("OBJECT_NOT_EXIST") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("TRANSIENT") == -1 || bl3)) {
                            bl = true;
                            break block32;
                        }
                        string3 = "Device NOT ALIVE";
                        l = 0L;
                        l2 = 0L;
                    }
                } else {
                    try {
                        l = System.currentTimeMillis();
                        DeviceData deviceData2 = this.device.command_inout(string, deviceData);
                        l2 = System.currentTimeMillis();
                        string3 = HtmlHelper.devicedata_to_string(deviceData2, this.commands[n3].out_type, n);
                    }
                    catch (DevFailed devFailed) {
                        if (!(devFailed.errors[0].reason.toUpperCase().indexOf("COMM_FAILURE") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("OBJECT_NOT_EXIST") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("TRANSIENT") == -1 || bl3)) {
                            bl = true;
                        }
                        throw new DevHelperDevFailed(devFailed.errors[0].reason, devFailed.errors[0].origin, devFailed.errors[0].desc);
                    }
                }
            }
            if (n2 != 0 || !bl) continue;
            this.import_device();
            bl3 = true;
        } while (++n2 < 2 && bl);
        object = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        String string5 = "";
        if (bl2 || bl3) {
            string5 = "   WARNING: device re-imported";
        }
        String string6 = "\n###################################\n" + simpleDateFormat.format((Date)object) + string5 + "\n" + "From host   : " + this.client_host + "\n" + this.device_name + ": " + string + "\n" + "Duration    : " + Long.toString(l2 - l) + " (ms)\n";
        if (this.commands[n3].in_type != 0) {
            String string7 = new String();
            int n6 = 0;
            while (n6 < vector.size()) {
                string7 = string7 + (String)vector.elementAt(n6) + "\n";
                ++n6;
            }
            string6 = string6 + "In  Argument(s):\n" + string7;
        }
        if (this.commands[n3].out_type != 0) {
            string6 = string6 + "Out Argument(s):\n" + string3;
        }
        return string6;
    }

    public String read_attr(String string) throws DevHelperDevFailed {
        boolean bl;
        String string2 = new String("");
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < this.attr_configs.length && !string.equals(this.attr_configs[n2].name)) {
            ++n2;
        }
        if (n2 >= this.attr_configs.length) {
            // empty if block
        }
        n = 0;
        do {
            bl = false;
            try {
                l = System.currentTimeMillis();
                DeviceAttribute deviceAttribute = this.device.read_attribute(string);
                l2 = System.currentTimeMillis();
                string2 = HtmlHelper.deviceattribute_to_string(deviceAttribute, this.attr_configs[n2].writable, this.attr_configs[n2].data_format, this.attr_configs[n2].data_type);
            }
            catch (DevFailed devFailed) {
                if (!(devFailed.errors[0].reason.toUpperCase().indexOf("COMM_FAILURE") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("OBJECT_NOT_EXIST") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("TRANSIENT") == -1 || bl2)) {
                    bl = true;
                }
                throw new DevHelperDevFailed(devFailed.errors[0].reason, devFailed.errors[0].origin, devFailed.errors[0].desc);
            }
            if (n != 0 || !bl) continue;
            this.import_device();
            bl2 = true;
        } while (++n < 2 && bl);
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        String string3 = "";
        if (bl2) {
            string3 = "   WARNING: device re-imported";
        }
        String string4 = "\n###################################\n" + simpleDateFormat.format(date) + string3 + "\n" + "From host   : " + this.client_host + "\n" + this.device_name + ": " + string + "\n" + "Duration    : " + Long.toString(l2 - l) + " (ms)\n";
        string4 = string4 + "Out Argument(s):\n" + string2;
        return string4;
    }

    public String write_attr(String string, String string2) throws DevHelperDevFailed {
        boolean bl;
        Vector vector;
        String string3 = new String("");
        long l = 0L;
        long l2 = 0L;
        DeviceAttribute deviceAttribute = null;
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        while (n2 < this.attr_configs.length && !string.equals(this.attr_configs[n2].name)) {
            ++n2;
        }
        if (n2 >= this.attr_configs.length) {
            this.import_device();
            bl2 = true;
            n2 = 0;
            while (n2 < this.attr_configs.length && !string.equals(this.attr_configs[n2].name)) {
                ++n2;
            }
            if (n2 >= this.attr_configs.length) {
                throw new DevHelperDevFailed(new String("unknown attribute for that device"), new String("DevHelper"), new String("unknown attribute even after a re-import of the device"));
            }
        }
        if (HtmlHelper.string_to_deviceattribute(string2, deviceAttribute = new DeviceAttribute(string, 0), this.attr_configs[n2].data_format, this.attr_configs[n2].data_type, vector = new Vector()) == -1) {
            String string4 = new String("");
            int n3 = 0;
            while (n3 < vector.size()) {
                string4 = string4 + (String)vector.elementAt(n3);
                ++n3;
            }
            throw new NumberFormatException(string4);
        }
        n = 0;
        do {
            bl = false;
            try {
                l = System.currentTimeMillis();
                this.device.write_attribute(deviceAttribute);
                l2 = System.currentTimeMillis();
            }
            catch (DevFailed devFailed) {
                if (!(devFailed.errors[0].reason.toUpperCase().indexOf("COMM_FAILURE") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("OBJECT_NOT_EXIST") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("TRANSIENT") == -1 || bl3)) {
                    bl = true;
                }
                throw new DevHelperDevFailed(devFailed.errors[0].reason, devFailed.errors[0].origin, devFailed.errors[0].desc);
            }
            if (n != 0 || !bl) continue;
            this.import_device();
            bl3 = true;
        } while (++n < 2 && bl);
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        String string5 = "";
        if (bl3) {
            string5 = "   WARNING: device re-imported";
        }
        String string6 = "\n###################################\n" + simpleDateFormat.format(date) + string5 + "\n" + "From host   : " + this.client_host + "\n" + this.device_name + ": " + string + "\n" + "Duration    : " + Long.toString(l2 - l) + " (ms)\n";
        return string6;
    }

    public int get_timeout() throws DevHelperDevFailed {
        boolean bl;
        int n = 0;
        boolean bl2 = false;
        int n2 = -1;
        n = 0;
        do {
            bl = false;
            try {
                n2 = this.device.get_timeout_millis();
            }
            catch (DevFailed devFailed) {
                if (!(devFailed.errors[0].reason.toUpperCase().indexOf("COMM_FAILURE") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("OBJECT_NOT_EXIST") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("TRANSIENT") == -1 || bl2)) {
                    bl = true;
                }
                throw new DevHelperDevFailed(devFailed.errors[0].reason, devFailed.errors[0].origin, devFailed.errors[0].desc);
            }
            if (n != 0 || !bl) continue;
            this.import_device();
            bl2 = true;
        } while (++n < 2 && bl);
        return n2;
    }

    public String set_timeout(String string) throws DevHelperDevFailed, NumberFormatException {
        boolean bl;
        int n = 0;
        boolean bl2 = false;
        long l = 0L;
        long l2 = 0L;
        int n2 = Integer.parseInt(string);
        n = 0;
        do {
            bl = false;
            try {
                l = System.currentTimeMillis();
                this.device.set_timeout_millis(n2);
                l2 = System.currentTimeMillis();
            }
            catch (DevFailed devFailed) {
                if (!(devFailed.errors[0].reason.toUpperCase().indexOf("COMM_FAILURE") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("OBJECT_NOT_EXIST") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("TRANSIENT") == -1 || bl2)) {
                    bl = true;
                }
                throw new DevHelperDevFailed(devFailed.errors[0].reason, devFailed.errors[0].origin, devFailed.errors[0].desc);
            }
            if (n != 0 || !bl) continue;
            this.import_device();
            bl2 = true;
        } while (++n < 2 && bl);
        String string2 = "";
        if (bl2) {
            string2 = "   WARNING: device re-imported";
        }
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        String string3 = "\n###################################\n" + simpleDateFormat.format(date) + string2 + "\n" + "From host   : " + this.client_host + "\n" + this.device_name + ": setting communication timeout" + "\n" + "Duration    : " + Long.toString(l2 - l) + " (ms)\n";
        string3 = string3 + "In  Argument(s):\n" + n2 + "\n";
        return string3;
    }
}

