/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jacorb.util.Debug;

public class Environment {
    private static String propertiesFile1 = ".jacorb_properties";
    private static String propertiesFile2 = "jacorb.properties";
    private static Vector propertiesFiles = new Vector();
    private static String jacorbPrefix = "jacorb.";
    private static String poaPrefix = jacorbPrefix + "poa.";
    private static Properties _props;
    private static int _retries;
    private static long _retry_interval;
    private static int _outbuf_size;
    private static int maxManagedBufSize;
    private static String _default_context;
    private static int _verbosity;
    private static boolean _locate_on_bind;
    private static boolean _use_imr;
    private static boolean _use_imr_endpoint;
    private static boolean _cache_references;
    private static PrintWriter _log_file_out;
    private static boolean _use_domain;
    private static boolean _mount_orb_domain;
    private static String _orb_domain_filename;
    private static long _cache_entry_lifetime;
    private static String _default_domains;
    private static boolean _monitoring_on;
    private static int _thread_pool_max;
    private static int _thread_pool_min;
    private static int _queue_max;
    private static String _proxy_server;
    private static boolean _use_appligator_for_applets;
    private static boolean _use_appligator_for_applications;
    private static Hashtable _use_httptunneling_for;
    public static URL URL;
    private static byte[] _impl_name;
    private static byte[] _server_id;
    private static Hashtable untrimmedPrefixProps;
    private static Hashtable trimmedPrefixProps;

    private static final void _init() {
        try {
            _props = new Properties();
            String string = System.getProperty("custom.props");
            String string2 = System.getProperty("user.home");
            String string3 = System.getProperty("file.separator");
            String string4 = System.getProperty("java.home");
            propertiesFiles.addElement(string2 + string3 + propertiesFile1);
            propertiesFiles.addElement(string2 + string3 + propertiesFile2);
            propertiesFiles.addElement(propertiesFile1);
            propertiesFiles.addElement(propertiesFile2);
            propertiesFiles.addElement(string4 + string3 + "lib" + string3 + propertiesFile1);
            propertiesFiles.addElement(string4 + string3 + "lib" + string3 + propertiesFile2);
            boolean bl = false;
            String string5 = null;
            try {
                URL uRL = null;
                uRL = ClassLoader.getSystemResource(propertiesFile1);
                if (uRL == null) {
                    uRL = ClassLoader.getSystemResource(propertiesFile2);
                }
                if (uRL != null) {
                    _props.load(uRL.openStream());
                    string5 = uRL.toString();
                    bl = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!bl) {
                int n = 0;
                while (n < propertiesFiles.size()) {
                    try {
                        _props.load(new BufferedInputStream(new FileInputStream((String)propertiesFiles.elementAt(n))));
                        bl = true;
                        string5 = (String)propertiesFiles.elementAt(n);
                        break;
                    }
                    catch (Exception exception) {
                        ++n;
                    }
                }
            }
            if (string != null) {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        _props.load(new BufferedInputStream(new FileInputStream(stringTokenizer.nextToken())));
                    }
                    bl = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ((Hashtable)_props).putAll(System.getProperties());
            Environment.readValues();
            if (_verbosity > 0 && !bl && !_props.getProperty("jacorb.suppress_no_props_warning", "off").equals("on")) {
                System.err.println("#####################################################################");
                System.err.println("WARNING: no properties file found! This warning can be ignored \nfor applets. A file file called \"jacorb.properties\" or \n\".jacorb_properties\" should be present in the classpath, \nthe home directory (" + string2 + "), the current directory (.) or \nin Javas lib directory (" + string4 + ")");
                System.err.println("#####################################################################\n");
            }
            if (_verbosity > 2 && string5 != null) {
                System.err.println("Setup Info: properties was file loaded from: " + string5);
            }
        }
        catch (SecurityException securityException) {
            System.out.println("Could not read local jacorb properties.");
        }
    }

    public static void addProperties(Properties properties) {
        if (_props == null) {
            _props = new Properties();
        }
        if (properties != null) {
            try {
                ((Hashtable)_props).putAll(System.getProperties());
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            ((Hashtable)_props).putAll(properties);
            Environment.readValues();
        }
    }

    private static final String readValue(String string, String string2) {
        if (_props.getProperty(string) != null) {
            return _props.getProperty(string);
        }
        if (string2 != null && _props.getProperty(string2) != null) {
            return _props.getProperty(string2);
        }
        return null;
    }

    private static final void readValue(String string, String string2, String string3) {
        String string4 = Environment.readValue(string2, string3);
        if (string4 == null) {
            return;
        }
        if (string.equals("_retries")) {
            _retries = Integer.parseInt(string4);
        } else if (string.equals("_retry_interval")) {
            _retry_interval = Integer.parseInt(string4);
        } else if (string.equals("_cache_entry_lifetime")) {
            _cache_entry_lifetime = Long.parseLong(string4);
        } else if (string.equals("_outbuf_size")) {
            _outbuf_size = Integer.parseInt(string4);
        } else if (string.equals("_max_managed_bufsize")) {
            maxManagedBufSize = Integer.parseInt(string4);
        } else if (string.equals("_default_context")) {
            _default_context = string4;
        } else if (string.equals("_orb_domain_filename")) {
            _orb_domain_filename = string4;
        } else if (string.equals("_default_domains")) {
            _default_domains = string4;
        } else if (string.equals("_verbosity")) {
            _verbosity = Integer.parseInt(string4);
        } else if (string.equals("_locate_on_bind")) {
            _locate_on_bind = string4.equalsIgnoreCase("on");
        } else if (string.equals("_cache_references")) {
            _cache_references = string4.equalsIgnoreCase("on");
        } else if (string.equals("_monitoring_on")) {
            _monitoring_on = string4.equalsIgnoreCase("on");
        } else if (string.equals("_use_imr")) {
            _use_imr = string4.equalsIgnoreCase("on");
        } else if (string.equals("_use_imr_endpoint")) {
            _use_imr_endpoint = string4.equalsIgnoreCase("on");
        } else if (string.equals("_use_domain")) {
            _use_domain = string4.equalsIgnoreCase("on");
        } else if (string.equals("_mount_orb_domain")) {
            _mount_orb_domain = !string4.equalsIgnoreCase("off");
        } else if (string.equals("_thread_pool_max")) {
            _thread_pool_max = Integer.parseInt(string4);
        } else if (string.equals("_thread_pool_min")) {
            _thread_pool_min = Integer.parseInt(string4);
        } else if (string.equals("_queue_max")) {
            _queue_max = Integer.parseInt(string4);
        } else if (string.equals("_proxy_server")) {
            _proxy_server = string4;
        } else if (string.equals("_use_appligator_for_applets")) {
            _use_appligator_for_applets = !string4.equalsIgnoreCase("off");
        } else if (string.equals("_use_appligator_for_applications")) {
            _use_appligator_for_applications = !string4.equalsIgnoreCase("off");
        } else if (string.equals("_use_httptunneling_for")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                System.out.println("HTTP Tunneling set for:" + string5);
                _use_httptunneling_for.put(string5, new Object());
            }
        } else if (string.equals("_impl_name")) {
            _impl_name = string4.getBytes();
        }
    }

    private static final void readValues() {
        String string = null;
        if (_props.getProperty("logfile") != null) {
            string = _props.getProperty("logfile");
        } else if (_props.getProperty(jacorbPrefix + "logfile") != null) {
            string = _props.getProperty(jacorbPrefix + "logfile");
        }
        Environment.readValue("_verbosity", "verbosity", jacorbPrefix + "verbosity");
        if (string != null && !string.equals("")) {
            if (string.endsWith("$implname")) {
                string = string.substring(0, string.length() - 9);
                string = _props.getProperty("implname") != null ? string + _props.getProperty("implname") : (_props.getProperty(jacorbPrefix + "implname") != null ? string + _props.getProperty(jacorbPrefix + "implname") : string + "log");
            }
            try {
                _log_file_out = new PrintWriter(new FileOutputStream(string));
                if (_verbosity > 0) {
                    System.out.println("Write output to log file \"" + string + "\"");
                }
            }
            catch (IOException iOException) {
                System.out.println("Cannot access log file \"" + string + "\"");
            }
        }
        Environment.readValue("_retries", "retries", jacorbPrefix + "retries");
        Environment.readValue("_retry_interval", "retry_interval", jacorbPrefix + "retry_interval");
        Environment.readValue("_cache_entry_lifetime", "_cache_entry_lifetime", jacorbPrefix + "domain.cache_entry.lifetime");
        Environment.readValue("_outbuf_size", "outbuf_size", jacorbPrefix + "outbuf_size");
        Environment.readValue("_max_managedbufsize", "maxManagedBufSize", jacorbPrefix + "maxManagedBufSize");
        Environment.readValue("_orb_domain_filename", "ds", jacorbPrefix + "orb_domain.filename");
        Environment.readValue("_default_domains", "ds", jacorbPrefix + "poa.default_domains");
        Environment.readValue("_locate_on_bind", "locate_on_bind", jacorbPrefix + "locate_on_bind");
        Environment.readValue("_cache_references", "reference_caching", jacorbPrefix + "reference_caching");
        Environment.readValue("_monitoring_on", "monitoring", poaPrefix + "monitoring");
        Environment.readValue("_use_imr", "use_imr", jacorbPrefix + "use_imr");
        Environment.readValue("_use_imr_endpoint", "use_imr_endpoint", jacorbPrefix + "use_imr_endpoint");
        Environment.readValue("_use_domain", "use_domain", jacorbPrefix + "use_domain");
        Environment.readValue("_mount_orb_domain", "_mount_orb_domain", jacorbPrefix + "orb_domain.mount");
        Environment.readValue("_thread_pool_max", "thread_pool_max", poaPrefix + "thread_pool_max");
        Environment.readValue("_thread_pool_min", "thread_pool_min", poaPrefix + "thread_pool_min");
        Environment.readValue("_queue_max", "queue_max", poaPrefix + "queue_max");
        Environment.readValue("_proxy_server", "proxy", jacorbPrefix + "ProxyServerURL");
        Environment.readValue("_use_appligator_for_applets", jacorbPrefix + "use_appligator_for_applets", null);
        Environment.readValue("_use_appligator_for_applications", jacorbPrefix + "use_appligator_for_applications", null);
        Environment.readValue("_use_httptunneling_for", jacorbPrefix + "use_httptunneling_for", null);
        Environment.readValue("_impl_name", "implname", jacorbPrefix + "implname");
    }

    public static final boolean isMonitoringOn() {
        return _monitoring_on;
    }

    public static final Properties jacorbProperties() {
        return _props;
    }

    public static final PrintWriter logFileOut() {
        return _log_file_out;
    }

    public static final int noOfRetries() {
        return _retries;
    }

    public static final int outBufSize() {
        return _outbuf_size;
    }

    public static final boolean locateOnBind() {
        return _locate_on_bind;
    }

    public static final boolean cacheReferences() {
        return _cache_references;
    }

    public static final int queueMax() {
        return _queue_max;
    }

    public static final long retryInterval() {
        return _retry_interval;
    }

    public static final String ORBDomainFilename() {
        return _orb_domain_filename;
    }

    public static final String DefaultDomains() {
        return _default_domains;
    }

    public static final long LifetimeOfCacheEntry() {
        return _cache_entry_lifetime;
    }

    public static final boolean useImR() {
        return _use_imr;
    }

    public static final boolean useImREndpoint() {
        return _use_imr_endpoint;
    }

    public static final boolean useDomain() {
        return _use_domain;
    }

    public static final boolean mountORBDomain() {
        return _mount_orb_domain;
    }

    public static final int threadPoolMax() {
        return _thread_pool_max;
    }

    public static final int threadPoolMin() {
        return _thread_pool_min;
    }

    public static final int verbosityLevel() {
        return _verbosity;
    }

    public static final String proxyURL() {
        return _proxy_server;
    }

    public static final byte[] implName() {
        return _impl_name;
    }

    public static final boolean useAppligator(boolean bl) {
        if (bl) {
            return _use_appligator_for_applets;
        }
        return _use_appligator_for_applications;
    }

    public static final boolean useHTTPTunneling(String string) {
        Object v = _use_httptunneling_for.get(string);
        return v != null;
    }

    public static void setProxyURL(String string) {
        _proxy_server = string;
    }

    public static int getMaxManagedBufSize() {
        return maxManagedBufSize;
    }

    public static String getProperty(String string) {
        return _props.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        return _props.getProperty(string, string2);
    }

    public static boolean isPropertyOn(String string) {
        String string2 = _props.getProperty(string, "off");
        return "on".equals(string2);
    }

    public static int getIntProperty(String string, int n) {
        String string2 = _props.getProperty(string);
        try {
            return Integer.parseInt(string2, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Error("Unable to create int from string >>" + string2 + "<<. " + "Please check property \"" + string + "\"");
        }
    }

    public static boolean hasProperty(String string) {
        return ((Hashtable)_props).containsKey(string);
    }

    public static void setProperty(String string, String string2) {
        ((Hashtable)_props).put(string, string2);
    }

    public static String[] getPropertyValueList(String string) {
        String string2 = _props.getProperty(string);
        if (string2 == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public static Properties getProperties() {
        return (Properties)((Hashtable)_props).clone();
    }

    public static final String time() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(11) + ":" + (calendar.get(12) < 10 ? "0" + calendar.get(12) : "" + calendar.get(12)) + ":" + (calendar.get(13) < 10 ? "0" + calendar.get(13) : "" + calendar.get(13));
    }

    public static final void readFromURL(URL uRL) {
        URL = uRL;
        System.out.println("Reading properties from url:" + URL.toString());
        try {
            _props = new Properties();
            _props.load(new BufferedInputStream(URL.openStream()));
        }
        catch (Exception exception) {
            System.out.println("Could not read properties from URL, reason: " + exception.toString());
        }
        Environment.readValues();
    }

    public static final byte[] serverId() {
        if (_server_id == null) {
            _server_id = String.valueOf((long)(Math.random() * 9.999999999E9)).getBytes();
        }
        return _server_id;
    }

    public static Vector getORBInitializers() {
        Enumeration<?> enumeration = _props.propertyNames();
        Vector vector = new Vector();
        String string = "org.omg.PortableInterceptor.ORBInitializerClass.";
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            String string3 = _props.getProperty(string2);
            if ((string3 == null || string3.length() == 0) && string2.length() > string.length()) {
                string3 = string2.substring(string.length());
            }
            if (string3 == null) continue;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                vector.addElement(classLoader.loadClass(string3).newInstance());
                Debug.output(16387, "Build: " + string3);
            }
            catch (Exception exception) {
                Debug.output(1, exception);
                Debug.output(1, "Unable to build ORBInitializer from >>" + string3 + "<<");
            }
        }
        return vector;
    }

    public static Hashtable getProperties(String string) {
        return Environment.getProperties(string, false);
    }

    public static Hashtable getProperties(String string, boolean bl) {
        if (bl && trimmedPrefixProps.containsKey(string)) {
            return (Hashtable)trimmedPrefixProps.get(string);
        }
        if (!bl && untrimmedPrefixProps.containsKey(string)) {
            return (Hashtable)untrimmedPrefixProps.get(string);
        }
        Enumeration<?> enumeration = _props.propertyNames();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            if (bl) {
                hashtable.put(string2.substring(string.length() + 1), _props.getProperty(string2));
                continue;
            }
            hashtable.put(string2, _props.getProperty(string2));
        }
        if (bl) {
            trimmedPrefixProps.put(string, hashtable);
        } else {
            untrimmedPrefixProps.put(string, hashtable);
        }
        return hashtable;
    }

    public static boolean doMapObjectKeys() {
        Hashtable hashtable = Environment.getProperties("jacorb.orb.objectKeyMap", true);
        return !hashtable.isEmpty();
    }

    static {
        _retries = 10;
        _retry_interval = 700L;
        _outbuf_size = 4096;
        maxManagedBufSize = 18;
        _default_context = "<undefined>";
        _verbosity = 2;
        _locate_on_bind = false;
        _use_imr = false;
        _use_imr_endpoint = true;
        _cache_references = false;
        _log_file_out = null;
        _use_domain = false;
        _mount_orb_domain = true;
        _orb_domain_filename = null;
        _cache_entry_lifetime = 300000L;
        _default_domains = null;
        _monitoring_on = false;
        _thread_pool_max = 20;
        _thread_pool_min = 10;
        _queue_max = 100;
        _proxy_server = null;
        _use_appligator_for_applets = true;
        _use_appligator_for_applications = false;
        _use_httptunneling_for = new Hashtable();
        URL = null;
        _impl_name = null;
        _server_id = null;
        untrimmedPrefixProps = new Hashtable();
        trimmedPrefixProps = new Hashtable();
        Environment._init();
    }
}

