/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;

public class UShortValue
implements Value {
    private Integer m_value;

    public void setValue(Object object) {
        this.m_value = (Integer)object;
    }

    public int getTypeId() {
        return 2;
    }

    public Object getValue() {
        return this.m_value;
    }

    public boolean equals(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 2) {
            throw new IllegalArgumentException();
        }
        bl = this.m_value.equals(value.getValue());
        return bl;
    }

    public boolean lessThan(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 2) {
            throw new IllegalArgumentException();
        }
        Integer n = (Integer)value.getValue();
        bl = this.m_value < n;
        return bl;
    }

    public boolean lessThanEqual(Value value) {
        return this.lessThan(value) || this.equals(value);
    }

    public boolean greaterThan(Value value) {
        return !this.lessThan(value) && !this.equals(value);
    }

    public boolean greaterThanEqual(Value value) {
        return !this.lessThan(value);
    }

    public Value plus(Value value) {
        UShortValue uShortValue = null;
        if (value.getTypeId() != 2) {
            throw new IllegalArgumentException();
        }
        Integer n = (Integer)value.getValue();
        uShortValue = new UShortValue(this.m_value + n);
        return uShortValue;
    }

    public Value minus(Value value) {
        Value value2 = null;
        if (value.getTypeId() == 2) {
            Integer n = (Integer)value.getValue();
            int n2 = this.m_value - n;
            value2 = n2 < 0 ? ValueFactory.createLong(n2) : new UShortValue(n2);
        } else {
            throw new IllegalArgumentException();
        }
        return value2;
    }

    public Value multiply(Value value) {
        Value value2 = null;
        if (value.getTypeId() != 2) {
            throw new IllegalArgumentException();
        }
        Integer n = (Integer)value.getValue();
        value2 = ValueFactory.createULong(this.m_value * n);
        return value2;
    }

    public Value divide(Value value) {
        UShortValue uShortValue = null;
        if (value.getTypeId() != 2) {
            throw new IllegalArgumentException();
        }
        Integer n = (Integer)value.getValue();
        uShortValue = new UShortValue(this.m_value / n);
        return uShortValue;
    }

    public Value negate() {
        return ValueFactory.createLong(-1 * this.m_value);
    }

    public Value convert(int n) {
        Value value = null;
        switch (n) {
            case 2: {
                value = new UShortValue(this.m_value);
                break;
            }
            case 3: {
                value = ValueFactory.createLong(this.m_value);
                break;
            }
            case 4: {
                value = ValueFactory.createULong(this.m_value.longValue());
                break;
            }
            case 5: {
                value = ValueFactory.createFloat(this.m_value.floatValue());
                break;
            }
            case 6: {
                value = ValueFactory.createDouble(this.m_value.doubleValue());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return value;
    }

    public String toString() {
        return this.m_value.toString();
    }

    public UShortValue() {
        this(0);
    }

    public UShortValue(int n) {
        this.m_value = new Integer(n);
    }

    public UShortValue(Object object) {
        this.m_value = (Integer)object;
    }
}

