/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import java.io.PrintStream;
import org.jacorb.trading.constraint.ExprNode;
import org.jacorb.trading.constraint.MissingPropertyException;
import org.jacorb.trading.constraint.PropertySource;
import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;
import org.jacorb.trading.constraint.ValueType;

public class LiteralNode
extends ExprNode {
    public static final int BOOLEAN = 0;
    public static final int NUMBER = 1;
    public static final int STRING = 2;
    private Value m_value;

    public void print(PrintStream printStream) {
        printStream.println("LiteralNode: type = " + this.getType() + " value = " + this.m_value);
    }

    public Value evaluate(PropertySource propertySource) throws MissingPropertyException {
        return this.m_value;
    }

    protected void determineType(int n, String string) {
        if (n == 0) {
            this.setType(new ValueType(0));
        } else if (n == 2) {
            this.setType(new ValueType(8));
        } else if (string.indexOf(46) >= 0 || string.indexOf(69) >= 0 || string.indexOf(101) >= 0) {
            this.setType(new ValueType(6));
        } else {
            this.setType(new ValueType(3));
        }
    }

    private LiteralNode() {
    }

    public LiteralNode(int n, String string) {
        this.determineType(n, string);
        switch (this.getType().getId()) {
            case 0: {
                this.m_value = ValueFactory.createBoolean(string.equals("TRUE"));
                break;
            }
            case 6: {
                try {
                    Double d = Double.valueOf(string);
                    this.m_value = ValueFactory.createDouble(d);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 3: {
                try {
                    Integer n2 = Integer.valueOf(string);
                    this.m_value = ValueFactory.createLong(n2);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 8: {
                this.m_value = ValueFactory.createString(string);
                break;
            }
        }
    }
}

