/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.util;

import java.io.PrintWriter;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;

public class AnyUtil {
    public static void print(ORB oRB, PrintWriter printWriter, Any any) {
        ORB oRB2 = oRB;
        try {
            TypeCode typeCode = any.type();
            while (typeCode.kind() == TCKind.tk_alias) {
                typeCode = typeCode.content_type();
            }
            TCKind tCKind = typeCode.kind();
            if (tCKind == TCKind.tk_sequence) {
                AnyUtil.printSequence(oRB, printWriter, any);
            }
            switch (tCKind.value()) {
                case 2: {
                    short s = any.extract_short();
                    printWriter.print(s);
                    break;
                }
                case 3: {
                    int n = any.extract_long();
                    printWriter.print(n);
                    break;
                }
                case 4: {
                    short s = any.extract_ushort();
                    printWriter.print(s);
                    break;
                }
                case 5: {
                    long l = any.extract_ulong();
                    printWriter.print(l);
                    break;
                }
                case 6: {
                    float f = any.extract_float();
                    printWriter.print(f);
                    break;
                }
                case 7: {
                    double d = any.extract_double();
                    printWriter.print(d);
                    break;
                }
                case 8: {
                    boolean bl = any.extract_boolean();
                    printWriter.print(bl);
                    break;
                }
                case 9: {
                    char c = any.extract_char();
                    printWriter.print(c);
                    break;
                }
                case 18: {
                    String string = any.extract_string();
                    printWriter.print("'" + string + "'");
                    break;
                }
                case 10: {
                    byte by = any.extract_octet();
                    printWriter.print(by);
                    break;
                }
                case 14: {
                    Object object = any.extract_Object();
                    if (object == null) {
                        printWriter.print("nil");
                        break;
                    }
                    oRB.object_to_string(object);
                    break;
                }
            }
        }
        catch (BadKind badKind) {
            badKind.printStackTrace();
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            bAD_OPERATION.printStackTrace();
        }
    }

    public static void print(PrintWriter printWriter, TypeCode typeCode) {
        try {
            TCKind tCKind = typeCode.kind();
            switch (tCKind.value()) {
                case 14: {
                    printWriter.print("interface " + typeCode.name());
                    break;
                }
                case 21: {
                    printWriter.print("typedef ");
                    TypeCode typeCode2 = typeCode.content_type();
                    AnyUtil.printName(printWriter, typeCode2);
                    printWriter.print(" " + typeCode.name());
                    break;
                }
                case 18: {
                    printWriter.print("string");
                    int n = typeCode.length();
                    if (n != 0) {
                        printWriter.print("<" + n + ">");
                    }
                    break;
                }
                case 19: {
                    printWriter.print("sequence<");
                    TypeCode typeCode3 = typeCode.content_type();
                    AnyUtil.printName(printWriter, typeCode3);
                    int n = typeCode.length();
                    if (n != 0) {
                        printWriter.print(", " + n);
                    }
                    printWriter.print(">");
                    break;
                }
                case 20: {
                    TypeCode typeCode4 = typeCode.content_type();
                    AnyUtil.printName(printWriter, typeCode4);
                    int n = typeCode.length();
                    printWriter.print("[" + n + "]");
                    break;
                }
                default: {
                    AnyUtil.printKind(printWriter, tCKind);
                }
            }
        }
        catch (BadKind badKind) {
            badKind.printStackTrace();
        }
    }

    protected static void printSequence(ORB oRB, PrintWriter printWriter, Any any) {
        try {
            TypeCode typeCode = any.type();
            while (typeCode.kind() == TCKind.tk_alias) {
                typeCode = typeCode.content_type();
            }
            TypeCode typeCode2 = typeCode.content_type();
            TCKind tCKind = typeCode2.kind();
            DynAnyFactory dynAnyFactory = DynAnyFactoryHelper.narrow(oRB.resolve_initial_references("DynAnyFactory"));
            DynAny dynAny = dynAnyFactory.create_dyn_any(any);
            DynSequence dynSequence = DynSequenceHelper.narrow(dynAny);
            int n = dynSequence.get_length();
            switch (tCKind.value()) {
                case 2: {
                    int n2 = 0;
                    while (n2 < n) {
                        printWriter.print(dynSequence.current_component().get_short());
                        if (n2 < n - 1) {
                            printWriter.print(", ");
                        }
                        ++n2;
                        dynSequence.next();
                    }
                    break;
                }
                case 3: {
                    int n3 = 0;
                    while (n3 < n) {
                        printWriter.print(dynSequence.current_component().get_long());
                        if (n3 < n - 1) {
                            printWriter.print(", ");
                        }
                        ++n3;
                        dynSequence.next();
                    }
                    break;
                }
                case 4: {
                    int n4 = 0;
                    while (n4 < n) {
                        printWriter.print(dynSequence.current_component().get_ushort());
                        if (n4 < n - 1) {
                            printWriter.print(", ");
                        }
                        ++n4;
                        dynSequence.next();
                    }
                    break;
                }
                case 5: {
                    int n5 = 0;
                    while (n5 < n) {
                        printWriter.print(dynSequence.current_component().get_ulong());
                        if (n5 < n - 1) {
                            printWriter.print(", ");
                        }
                        ++n5;
                        dynSequence.next();
                    }
                    break;
                }
                case 6: {
                    int n6 = 0;
                    while (n6 < n) {
                        printWriter.print(dynSequence.current_component().get_float());
                        if (n6 < n - 1) {
                            printWriter.print(", ");
                        }
                        ++n6;
                        dynSequence.next();
                    }
                    break;
                }
                case 7: {
                    int n7 = 0;
                    while (n7 < n) {
                        printWriter.print(dynSequence.current_component().get_double());
                        if (n7 < n - 1) {
                            printWriter.print(", ");
                        }
                        ++n7;
                        dynSequence.next();
                    }
                    break;
                }
                case 8: {
                    int n8 = 0;
                    while (n8 < n) {
                        printWriter.print(dynSequence.current_component().get_boolean());
                        if (n8 < n - 1) {
                            printWriter.print(", ");
                        }
                        ++n8;
                        dynSequence.next();
                    }
                    break;
                }
                case 9: {
                    int n9 = 0;
                    while (n9 < n) {
                        printWriter.print(dynSequence.current_component().get_char());
                        if (n9 < n - 1) {
                            printWriter.print(", ");
                        }
                        ++n9;
                        dynSequence.next();
                    }
                    break;
                }
                case 18: {
                    int n10 = 0;
                    while (n10 < n) {
                        printWriter.print("'" + dynSequence.current_component().get_string() + "'");
                        if (n10 < n - 1) {
                            printWriter.print(", ");
                        }
                        ++n10;
                        dynSequence.next();
                    }
                    break;
                }
                case 10: {
                    int n11 = 0;
                    while (n11 < n) {
                        printWriter.print(dynSequence.current_component().get_octet());
                        if (n11 < n - 1) {
                            printWriter.print(", ");
                        }
                        ++n11;
                        dynSequence.next();
                    }
                    break;
                }
                case 14: {
                    int n12 = 0;
                    while (n12 < n) {
                        Object object = dynSequence.current_component().get_reference();
                        if (object == null) {
                            printWriter.println("nil");
                        } else {
                            oRB.object_to_string(object);
                        }
                        if (n12 < n - 1) {
                            printWriter.println();
                        }
                        ++n12;
                        dynSequence.next();
                    }
                    break;
                }
            }
            dynAny.destroy();
        }
        catch (BadKind badKind) {
            badKind.printStackTrace();
        }
        catch (InvalidName invalidName) {
            invalidName.printStackTrace();
        }
        catch (TypeMismatch typeMismatch) {
            typeMismatch.printStackTrace();
        }
        catch (InvalidValue invalidValue) {
            invalidValue.printStackTrace();
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            inconsistentTypeCode.printStackTrace();
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            bAD_OPERATION.printStackTrace();
        }
    }

    protected static void printName(PrintWriter printWriter, TypeCode typeCode) {
        try {
            TCKind tCKind = typeCode.kind();
            switch (tCKind.value()) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 21: 
                case 22: {
                    printWriter.print(typeCode.name());
                    break;
                }
                case 18: {
                    printWriter.print("string");
                    int n = typeCode.length();
                    if (n != 0) {
                        printWriter.print("<" + n + ">");
                    }
                    break;
                }
                case 19: {
                    printWriter.print("sequence<");
                    TypeCode typeCode2 = typeCode.content_type();
                    AnyUtil.printName(printWriter, typeCode2);
                    int n = typeCode.length();
                    if (n != 0) {
                        printWriter.print(", " + n);
                    }
                    printWriter.print(">");
                    break;
                }
                case 20: {
                    TypeCode typeCode3 = typeCode.content_type();
                    AnyUtil.printName(printWriter, typeCode3);
                    int n = typeCode.length();
                    printWriter.print("[" + n + "]");
                }
                default: {
                    AnyUtil.printKind(printWriter, tCKind);
                }
            }
        }
        catch (BadKind badKind) {
            badKind.printStackTrace();
        }
    }

    protected static void printKind(PrintWriter printWriter, TCKind tCKind) {
        switch (tCKind.value()) {
            case 0: {
                printWriter.print("null");
                break;
            }
            case 1: {
                printWriter.print("void");
                break;
            }
            case 2: {
                printWriter.print("short");
                break;
            }
            case 3: {
                printWriter.print("long");
                break;
            }
            case 4: {
                printWriter.print("unsigned short");
                break;
            }
            case 5: {
                printWriter.print("unsigned long");
                break;
            }
            case 6: {
                printWriter.print("float");
                break;
            }
            case 7: {
                printWriter.print("double");
                break;
            }
            case 8: {
                printWriter.print("boolean");
                break;
            }
            case 9: {
                printWriter.print("char");
                break;
            }
            case 10: {
                printWriter.print("octet");
                break;
            }
            case 11: {
                printWriter.print("any");
                break;
            }
            case 12: {
                printWriter.print("TypeCode");
                break;
            }
            case 13: {
                printWriter.print("Principal");
                break;
            }
            case 14: {
                printWriter.print("Object");
                break;
            }
            case 15: {
                printWriter.print("struct");
                break;
            }
            case 16: {
                printWriter.print("union");
                break;
            }
            case 17: {
                printWriter.print("enum");
                break;
            }
            case 18: {
                printWriter.print("string");
                break;
            }
            case 19: {
                printWriter.print("sequence");
                break;
            }
            case 20: {
                printWriter.print("array");
                break;
            }
            case 21: {
                printWriter.print("alias");
                break;
            }
            case 22: {
                printWriter.print("exception");
                break;
            }
            default: {
                printWriter.print("(unknown)");
                break;
            }
        }
    }

    private AnyUtil() {
    }
}

