/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.util;

import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.SubjectAltName;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.security.util.UserSponsor;

public class KeyStoreUtil {
    public static KeyStore getKeyStore(String string, char[] cArray) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore;
        Object object;
        File file = new File(string);
        if (!file.exists()) {
            object = System.getProperty("user.home") + System.getProperty("file.separator") + string;
            file = new File((String)object);
        }
        object = new FileInputStream(file);
        try {
            keyStore = KeyStore.getInstance("IAIKKeyStore", "IAIK");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            System.err.println(noSuchProviderException.toString());
            keyStore = KeyStore.getInstance("jks");
        }
        keyStore.load((InputStream)object, cArray);
        ((FileInputStream)object).close();
        return keyStore;
    }

    public static KeyPair getKeyPair(String string, String string2, char[] cArray, char[] cArray2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        KeyStore keyStore = KeyStoreUtil.getKeyStore(string, cArray);
        if (!keyStore.isKeyEntry(string2)) {
            return null;
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(string2, cArray2);
        java.security.cert.X509Certificate x509Certificate = (java.security.cert.X509Certificate)keyStore.getCertificate(string2);
        PublicKey publicKey = x509Certificate.getPublicKey();
        return new KeyPair(publicKey, privateKey);
    }

    public static KeyPair getKeyPair(KeyStore keyStore, String string, char[] cArray) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        if (!keyStore.isKeyEntry(string)) {
            return null;
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(string, cArray);
        java.security.cert.X509Certificate x509Certificate = (java.security.cert.X509Certificate)keyStore.getCertificate(string);
        PublicKey publicKey = x509Certificate.getPublicKey();
        return new KeyPair(publicKey, privateKey);
    }

    public static KeyPair getKeyPair(KeyStore keyStore) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        String[] stringArray = new String[]{"Entry Alias"};
        UserSponsor userSponsor = new UserSponsor("", "Please authenticate to retrieve key pair", stringArray, new String[]{"Entry Password"});
        char[][] cArray = new char[1][];
        if (!userSponsor.getInput(stringArray, cArray)) {
            System.err.println("Input cancelled");
            System.exit(1);
        }
        String string = stringArray[0];
        char[] cArray2 = cArray[0];
        if (string == null || cArray2 == null) {
            return null;
        }
        return KeyStoreUtil.getKeyPair(keyStore, string, cArray2);
    }

    public static KeyPair getKeyPair() throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        String[] stringArray = new String[]{"Keystore file", "Entry Alias"};
        UserSponsor userSponsor = new UserSponsor("", "Please authenticate to retrieve key pair", stringArray, new String[]{"Keystore Password", "Entry Password"});
        char[][] cArray = new char[2][];
        if (!userSponsor.getInput(stringArray, cArray)) {
            System.err.println("Input cancelled");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        char[] cArray2 = cArray[0];
        char[] cArray3 = cArray[1];
        if (string == null || string2 == null || cArray2 == null || cArray3 == null) {
            System.err.println("no input");
            System.exit(1);
        }
        return KeyStoreUtil.getKeyPair(string, string2, cArray2, cArray3);
    }

    public static java.security.cert.X509Certificate[] getCerts(String string, String string2, char[] cArray) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        if (string2 == null || string2.length() == 0 || cArray == null) {
            return KeyStoreUtil.getCerts(string);
        }
        KeyStore keyStore = KeyStoreUtil.getKeyStore(string, cArray);
        if (!keyStore.isKeyEntry(string2)) {
            return null;
        }
        return (java.security.cert.X509Certificate[])keyStore.getCertificateChain(string2);
    }

    public static java.security.cert.X509Certificate[] getCerts(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        KeyStore keyStore;
        String[] stringArray = new String[]{"User name"};
        UserSponsor userSponsor = new UserSponsor("Authentication", "Please authenticate to retrieve certificates", stringArray, new String[]{"Password"});
        char[][] cArray = new char[1][];
        if (!userSponsor.getInput(stringArray, cArray)) {
            System.err.println("Input cancelled");
            System.exit(1);
        }
        String string2 = stringArray[0];
        char[] cArray2 = cArray[0];
        if (string2 == null || cArray2 == null) {
            System.err.println("no input");
            System.exit(1);
        }
        if (!(keyStore = KeyStoreUtil.getKeyStore(string, cArray2)).isKeyEntry(string2)) {
            return null;
        }
        return (java.security.cert.X509Certificate[])keyStore.getCertificateChain(string2);
    }

    public static java.security.cert.X509Certificate[] getRoleCerts(KeyStore keyStore, String string, PublicKey[] publicKeyArray) throws KeyStoreException, CertificateEncodingException {
        if (!keyStore.isKeyEntry(string)) {
            return null;
        }
        Vector<X509Certificate> vector = new Vector<X509Certificate>();
        Certificate[] certificateArray = keyStore.getCertificateChain(string);
        int n = 0;
        while (n < certificateArray.length) {
            block11: {
                try {
                    X509Certificate x509Certificate = (X509Certificate)certificateArray[n];
                    if (!x509Certificate.hasExtensions()) break block11;
                    Enumeration enumeration = x509Certificate.listExtensions();
                    while (enumeration.hasMoreElements()) {
                        V3Extension v3Extension = (V3Extension)enumeration.nextElement();
                        if (!(v3Extension instanceof SubjectAltName)) continue;
                        SubjectAltName subjectAltName = (SubjectAltName)v3Extension;
                        GeneralNames generalNames = subjectAltName.getGeneralNames();
                        Enumeration enumeration2 = generalNames.getNames();
                        while (enumeration2.hasMoreElements()) {
                            String string2;
                            GeneralName generalName = (GeneralName)enumeration2.nextElement();
                            if (generalName.getType() != GeneralName.rfc822Name || !(string2 = (String)generalName.getName()).startsWith("role:")) continue;
                            x509Certificate.checkValidity();
                            Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
                            int n2 = 0;
                            while (n2 < publicKeyArray.length) {
                                try {
                                    signature.initVerify(publicKeyArray[n2]);
                                    signature.verify(x509Certificate.getSignature());
                                    vector.addElement(x509Certificate);
                                }
                                catch (SignatureException signatureException) {
                                }
                                catch (InvalidKeyException invalidKeyException) {
                                    // empty catch block
                                }
                                ++n2;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n;
        }
        java.security.cert.X509Certificate[] x509CertificateArray = new java.security.cert.X509Certificate[vector.size()];
        int n3 = 0;
        while (n3 < x509CertificateArray.length) {
            x509CertificateArray[n3] = (java.security.cert.X509Certificate)vector.elementAt(n3);
            ++n3;
        }
        return x509CertificateArray;
    }
}

