/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.util;

import iaik.asn1.ObjectID;
import iaik.asn1.structures.Name;
import iaik.security.provider.IAIK;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.tree.TreeNode;
import org.jacorb.security.util.CertNode;
import org.jacorb.security.util.CertUtils;
import org.jacorb.security.util.KSEntryTree;
import org.jacorb.security.util.KSNode;
import org.jacorb.security.util.KeyNode;
import org.jacorb.security.util.KeyStoreUtil;
import org.jacorb.security.util.NoKeyStoreException;
import org.jacorb.security.util.TrustNode;
import org.jacorb.security.util.UserSponsor;

public class KeyStoreManager
extends JFrame {
    private char[] ksPassword;
    private KeyStore ks;
    private String ksFileName;
    private boolean done = false;
    private boolean dirty = false;
    private KSEntryTree tree;
    private EventHandler actionHandler = new EventHandler();
    JMenuItem openMenuItem;
    JMenuItem newMenuItem;
    JMenuItem saveMenuItem;
    JMenuItem saveAsMenuItem;
    JMenuItem closeMenuItem;
    JMenuItem exitMenuItem;
    JMenuItem generateKeyMenuItem;
    JMenuItem deleteKeyMenuItem;
    JMenuItem verifyChainMenuItem;
    JMenuItem addTrusteeMenuItem;
    JMenuItem deleteTrusteeMenuItem;
    JMenuItem createCertMenuItem;
    JMenuItem signMenuItem;
    JMenuItem exportCertMenuItem;
    JMenuItem importCertMenuItem;
    JMenuItem deleteCertMenuItem;
    JFileChooser chooser = new JFileChooser();
    JPanel topPanel;

    public boolean close() {
        if (this.ks == null) {
            return true;
        }
        if (this.dirty) {
            int n = JOptionPane.showConfirmDialog(null, "KeyStore modified, save changes?", "Close", 1, 1);
            if (n == 2) {
                return false;
            }
            if (n == 0) {
                this.save();
            }
        }
        this.ks = null;
        this.ksPassword = null;
        this.tree.clean();
        this.repaint();
        return true;
    }

    private final void _exit() {
        if (this.close()) {
            System.exit(0);
        }
    }

    private final void load() {
        if (this.ks != null && !this.close()) {
            return;
        }
        int n = this.chooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        this.ksFileName = this.chooser.getSelectedFile().getAbsolutePath();
        this.ksPassword = UserSponsor.getPasswd("Password for KeyStore " + this.ksFileName);
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.ks = KeyStoreUtil.getKeyStore(this.ksFileName, this.ksPassword);
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getClass().getName() + ":" + exception.getMessage(), "Exception", 0);
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.tree.load(this.ks);
        this.repaint();
        this.setCursor(Cursor.getDefaultCursor());
        this.dirty = false;
    }

    private final void save() {
        if (this.ks == null || !this.dirty) {
            return;
        }
        if (this.ksFileName == null) {
            this.saveAs();
        } else {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                FileOutputStream fileOutputStream = new FileOutputStream(this.ksFileName);
                Enumeration enumeration = this.tree.getNodes();
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode = (TreeNode)enumeration.nextElement();
                    if (treeNode instanceof KeyNode) {
                        ((KeyNode)treeNode).store();
                        continue;
                    }
                    if (!(treeNode instanceof TrustNode)) continue;
                    ((TrustNode)treeNode).store();
                }
                this.ks.store(fileOutputStream, this.ksPassword);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.dirty = false;
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private final void saveAs() {
        Object object;
        if (this.ks == null || !this.dirty) {
            return;
        }
        int n = this.chooser.showSaveDialog(this);
        if (n != 0) {
            return;
        }
        this.ksFileName = this.chooser.getSelectedFile().getAbsolutePath();
        if (this.ksPassword == null) {
            object = JOptionPane.showInputDialog("Please enter Password to save KeyStore");
            if (object != null) {
                this.ksPassword = ((String)object).toCharArray();
            } else {
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            object = new FileOutputStream(this.ksFileName);
            Enumeration enumeration = this.tree.getNodes();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = (TreeNode)enumeration.nextElement();
                if (treeNode instanceof KeyNode) {
                    ((KeyNode)treeNode).store();
                    continue;
                }
                if (!(treeNode instanceof TrustNode)) continue;
                ((TrustNode)treeNode).store();
            }
            this.ks.store((OutputStream)object, this.ksPassword);
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.dirty = false;
    }

    private final void newFile() {
        if (this.ks != null && !this.close()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            try {
                this.ks = KeyStore.getInstance("IAIKKeyStore", "IAIK");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                System.err.println(noSuchProviderException.toString());
                this.ks = KeyStore.getInstance("jks");
            }
            this.ks.load(null, new char[0]);
        }
        catch (Exception exception) {
            this.showException(exception);
            return;
        }
        this.tree.load(this.ks);
        this.repaint();
        this.setCursor(Cursor.getDefaultCursor());
        this.dirty = false;
    }

    private final void exportCert(Certificate certificate) {
        if (certificate == null) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Export Certificate to File");
        jFileChooser.setApproveButtonText("Export");
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                if (fileOutputStream == null) {
                    throw new IOException("File " + string + " not found.");
                }
                fileOutputStream.write(certificate.getEncoded());
                fileOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private final void exportCert() {
        Object var1_1 = null;
        try {
            KSNode kSNode = this.tree.getSelectedNode();
            if (kSNode != null) {
                this.exportCert((Certificate)kSNode.getCert());
            }
        }
        catch (Exception exception) {
            this.showException(exception);
            return;
        }
    }

    private final void createCert() {
        block17: {
            if (this.ks == null) {
                return;
            }
            try {
                char[][] cArray;
                String[] stringArray;
                String[] stringArray2;
                String string = this.tree.getSelectedAlias();
                Vector<String> vector = new Vector<String>();
                String[] stringArray3 = this.tree.getNodes();
                while (stringArray3.hasMoreElements()) {
                    TreeNode treeNode = (TreeNode)stringArray3.nextElement();
                    if (!(treeNode instanceof KeyNode)) continue;
                    vector.add(((KeyNode)treeNode).getAlias());
                }
                stringArray3 = new String[vector.size()];
                int n = 0;
                while (n < stringArray3.length) {
                    stringArray3[n] = (String)vector.elementAt(n);
                    ++n;
                }
                String[] stringArray4 = string != null ? new String[]{string} : stringArray3;
                UserSponsor userSponsor = new UserSponsor("Create Certificate", "Please select Certificate parameters", new String[]{"Role Name\n(only needed for role certs)"}, new String[]{"Subject Key Alias", "Signer Key Alias", "Certificate Type"}, new String[][]{stringArray4, stringArray3, {"Public Key Cert", "Role Cert"}}, new String[]{"Password of signer\nprivate key"});
                if (!userSponsor.getInput(stringArray2 = new String[1], stringArray = new String[3], cArray = new char[1][])) break block17;
                this.setCursor(Cursor.getPredefinedCursor(3));
                String string2 = null;
                String string3 = null;
                String string4 = null;
                char[] cArray2 = new char[]{};
                if (stringArray2[0] != null) {
                    string2 = stringArray2[0];
                }
                if (string == null && stringArray[0] != null) {
                    string = stringArray[0];
                }
                if (stringArray[1] != null) {
                    string3 = stringArray[1];
                }
                if (stringArray[2] != null) {
                    string4 = stringArray[2];
                }
                if (string3 == null || string3.length() == 0) {
                    throw new IllegalArgumentException("No alias for key entry!");
                }
                if (cArray[0] != null) {
                    cArray2 = cArray[0];
                }
                KeyNode keyNode = (KeyNode)this.tree.getNode(string3);
                KSNode kSNode = this.tree.getNode(string);
                System.out.println("signerAlias is " + string3);
                PrivateKey privateKey = keyNode.getKey(cArray2);
                if (string4.equals("Role Cert")) {
                    Object object;
                    System.out.println("creating role cert");
                    if (privateKey == null) {
                        System.out.println("signPrivKey is null");
                        object = KeyStoreUtil.getKeyPair(this.ks, string3, cArray2);
                        privateKey = ((KeyPair)object).getPrivate();
                        keyNode.setKey(privateKey, cArray2);
                    }
                    object = kSNode.getCert();
                    PublicKey publicKey = object.getPublicKey();
                    X509Certificate x509Certificate = CertUtils.certifyRoleMembership(string2, CertUtils.createName(string), CertUtils.createName(string3), publicKey, privateKey);
                    System.out.println("bnv: will build a new certificate chain for targetAlias");
                    X509Certificate[] x509CertificateArray = keyNode.getCertificateChain();
                    X509Certificate[] x509CertificateArray2 = new X509Certificate[1 + x509CertificateArray.length];
                    x509CertificateArray2[0] = x509Certificate;
                    int n2 = 1;
                    while (n2 <= x509CertificateArray.length) {
                        x509CertificateArray2[n2] = x509CertificateArray[n2 - 1];
                        ++n2;
                    }
                    System.out.println("bnv: old certificate chain for targetAlias is removed and new one inserted");
                    this.tree.removeCerts(string);
                    this.tree.addCerts(string, (Certificate[])x509CertificateArray2);
                    this.repaint();
                    break block17;
                }
                if (string4.equals("Public Key Cert")) {
                    System.out.println("creating public key cert");
                    X509Certificate x509Certificate = CertUtils.createPublicKeyCert(CertUtils.createName(string), CertUtils.createName(string3), kSNode.getCert().getPublicKey(), privateKey);
                    X509Certificate[] x509CertificateArray = new X509Certificate[]{x509Certificate, keyNode.getCert()};
                    if (kSNode instanceof TrustNode) {
                        this.exportCert((Certificate)x509Certificate);
                    } else {
                        this.tree.addCert(string, -1, (Certificate)x509CertificateArray[0]);
                        this.tree.addCert(string, -1, (Certificate)x509CertificateArray[1]);
                    }
                    this.repaint();
                    break block17;
                }
                throw new IllegalArgumentException("Unknown Certificate Type: " + string4);
            }
            catch (Exception exception) {
                this.showException(exception);
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void importCert() {
        if (this.ks == null) {
            return;
        }
        String string = null;
        String string2 = null;
        KSNode kSNode = this.tree.getSelectedNode();
        if (kSNode == null) {
            return;
        }
        if (kSNode instanceof CertNode) {
            return;
        }
        if (kSNode instanceof KeyNode) {
            string2 = ((KeyNode)kSNode).getAlias();
            ((KeyNode)kSNode).checkAccess();
        }
        if (string2 == null) {
            return;
        }
        int n = this.chooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        string = this.chooser.getSelectedFile().getAbsolutePath();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            FileInputStream fileInputStream = new FileInputStream(string);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "IAIK");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
            X509Certificate[] x509CertificateArray = ((KeyNode)kSNode).getCertificateChain();
            int n2 = 0;
            X509Certificate[] x509CertificateArray2 = ((KeyNode)kSNode).children();
            while (x509CertificateArray2.hasMoreElements()) {
                CertNode certNode = (CertNode)x509CertificateArray2.nextElement();
                x509CertificateArray[n2] = certNode.getCert();
                ++n2;
            }
            x509CertificateArray2 = new X509Certificate[x509CertificateArray != null ? x509CertificateArray.length + 1 : 1];
            int n3 = 0;
            while (n3 < x509CertificateArray.length) {
                x509CertificateArray2[n3] = x509CertificateArray[n3];
                ++n3;
            }
            x509CertificateArray2[x509CertificateArray2.length - 1] = x509Certificate;
            PrivateKey privateKey = this.tree.getKeyNode(string2).getKey();
            this.tree.addCert(string2, x509CertificateArray2.length - 1, (Certificate)x509Certificate);
            this.dirty = true;
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception exception) {
            this.showException(exception);
        }
        this.repaint();
    }

    public X509Certificate importCertificate() {
        String string = null;
        int n = this.chooser.showOpenDialog(this);
        if (n != 0) {
            return null;
        }
        string = this.chooser.getSelectedFile().getAbsolutePath();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "IAIK");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
            x509Certificate.verify(x509Certificate.getPublicKey());
            return x509Certificate;
        }
        catch (Exception exception) {
            this.showException(exception);
            return null;
        }
    }

    private final void addTrustee() {
        X509Certificate x509Certificate = this.importCertificate();
        if (x509Certificate == null) {
            System.out.println("cert is null");
            return;
        }
        Name name = (Name)x509Certificate.getSubjectDN();
        String string = name.getRDN(ObjectID.commonName);
        Name name2 = (Name)x509Certificate.getIssuerDN();
        String string2 = name2.getRDN(ObjectID.commonName);
        try {
            if (!string.equals(string2)) {
                throw new RuntimeException("subject != issuer: " + string + string2);
            }
            this.tree.addTrustedCert(string, (Certificate)x509Certificate);
            this.repaint();
            this.dirty = true;
        }
        catch (Exception exception) {
            this.showException(exception);
        }
    }

    private final void deleteNode() {
        KSNode kSNode = this.tree.getSelectedNode();
        if (kSNode == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, "This will delete the selected entry! Continue?", "Delete", 2, 1);
        if (n == 0) {
            try {
                kSNode.removeFromParent();
                this.tree.removeSelectedNode();
                this.tree.reload();
                this.dirty = true;
            }
            catch (Exception exception) {
                this.showException(exception);
            }
        }
    }

    private final void generateKeys() throws NoKeyStoreException, NoSuchAlgorithmException, KeyStoreException {
        if (this.ks == null) {
            throw new NoKeyStoreException();
        }
        String[] stringArray = new String[]{"Algorithm", "KeyLength"};
        String[][] stringArray2 = new String[][]{{"RSA", "DSA"}, {"1024", "2048"}};
        UserSponsor userSponsor = new UserSponsor("Generate Keys", "Please select Key Generation parameters", new String[]{"New Key Alias"}, stringArray, stringArray2, new String[]{"Password"});
        String[] stringArray3 = new String[1];
        char[][] cArray = new char[1][];
        if (userSponsor.getInput(stringArray3, stringArray, cArray)) {
            String string = "DSA";
            int n = 1024;
            String string2 = "<unknown>";
            char[] cArray2 = new char[]{};
            if (stringArray[0] != null) {
                string = stringArray[0];
            }
            if (stringArray[1] != null) {
                n = Integer.parseInt(stringArray[1]);
            }
            if ((string2 = stringArray3[0]) == null || string2.length() == 0) {
                throw new IllegalArgumentException("No alias for key entry!");
            }
            if (cArray[0] != null) {
                cArray2 = cArray[0];
            }
            KeyPairGenerator keyPairGenerator = null;
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                keyPairGenerator = KeyPairGenerator.getInstance(string, "IAIK");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new NoSuchAlgorithmException("Provider IAIK not found!");
            }
            keyPairGenerator.initialize(n);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            Object var12_13 = null;
            X509Certificate x509Certificate = null;
            try {
                Name name = CertUtils.createName(string2);
                x509Certificate = CertUtils.createPublicKeyCert(name, name, keyPair.getPublic(), keyPair.getPrivate());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new Error("Internal Error: invalid keys generated!");
            }
            catch (CertificateException certificateException) {
                certificateException.printStackTrace();
            }
            catch (X509ExtensionException x509ExtensionException) {
                x509ExtensionException.printStackTrace();
            }
            this.dirty = true;
            this.tree.addKey(string2, keyPair.getPrivate(), cArray2);
            this.repaint();
            this.tree.addCert(string2, 0, (Certificate)x509Certificate);
            this.setCursor(Cursor.getDefaultCursor());
            this.repaint();
        }
    }

    private final void verifyChain() {
        if (this.ks == null) {
            return;
        }
        Object var1_1 = null;
        String string = null;
        KSNode kSNode = this.tree.getSelectedNode();
        if (kSNode == null) {
            return;
        }
        if (kSNode instanceof KeyNode) {
            string = ((KeyNode)kSNode).getAlias();
            X509Certificate[] x509CertificateArray = ((KeyNode)kSNode).getCertificateChain();
            int n = x509CertificateArray.length;
            try {
                x509CertificateArray[n - 1].verify(x509CertificateArray[n - 1].getPublicKey());
                int n2 = n - 1;
                while (n2 > 0) {
                    x509CertificateArray[n2 - 1].verify(x509CertificateArray[n2].getPublicKey());
                    --n2;
                }
                if (this.tree.isTrusted(x509CertificateArray[n - 1])) {
                    JOptionPane.showMessageDialog(null, "Verification successful", "Certificate Chain Verification", 1);
                } else {
                    JOptionPane.showMessageDialog(null, "Verification failed, last chain element not trusted", "Certificate Chain Verification", 0);
                }
            }
            catch (Exception exception) {
                this.showException(exception);
            }
        }
    }

    public void showException(Exception exception) {
        exception.printStackTrace();
        JOptionPane.showMessageDialog(null, exception.getClass().getName() + ":" + exception.getMessage(), "Exception", 0);
    }

    public static void main(String[] stringArray) {
        IAIK.addAsProvider();
        new KeyStoreManager();
    }

    public KeyStoreManager() {
        super("KeyStoreManager");
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        this.openMenuItem = new JMenuItem("Open...");
        this.openMenuItem.addActionListener(this.actionHandler);
        jMenu.add(this.openMenuItem);
        this.newMenuItem = new JMenuItem("New");
        this.newMenuItem.addActionListener(this.actionHandler);
        jMenu.add(this.newMenuItem);
        this.saveMenuItem = new JMenuItem("Save");
        this.saveMenuItem.addActionListener(this.actionHandler);
        jMenu.add(this.saveMenuItem);
        this.saveAsMenuItem = new JMenuItem("SaveAs...");
        this.saveAsMenuItem.addActionListener(this.actionHandler);
        jMenu.add(this.saveAsMenuItem);
        this.closeMenuItem = new JMenuItem("Close");
        this.closeMenuItem.addActionListener(this.actionHandler);
        jMenu.add(this.closeMenuItem);
        this.exitMenuItem = new JMenuItem("Exit");
        this.exitMenuItem.addActionListener(this.actionHandler);
        jMenu.add(this.exitMenuItem);
        JMenu jMenu2 = new JMenu("Keys");
        jMenuBar.add(jMenu2);
        this.generateKeyMenuItem = new JMenuItem("New...");
        this.generateKeyMenuItem.addActionListener(this.actionHandler);
        jMenu2.add(this.generateKeyMenuItem);
        this.deleteKeyMenuItem = new JMenuItem("Delete");
        this.deleteKeyMenuItem.addActionListener(this.actionHandler);
        jMenu2.add(this.deleteKeyMenuItem);
        this.verifyChainMenuItem = new JMenuItem("Verify Chain");
        this.verifyChainMenuItem.addActionListener(this.actionHandler);
        jMenu2.add(this.verifyChainMenuItem);
        JMenu jMenu3 = new JMenu("Trustees");
        jMenuBar.add(jMenu3);
        this.addTrusteeMenuItem = new JMenuItem("add...");
        this.addTrusteeMenuItem.addActionListener(this.actionHandler);
        jMenu3.add(this.addTrusteeMenuItem);
        this.deleteTrusteeMenuItem = new JMenuItem("Delete");
        this.deleteTrusteeMenuItem.addActionListener(this.actionHandler);
        jMenu3.add(this.deleteTrusteeMenuItem);
        JMenu jMenu4 = new JMenu("Certificates");
        jMenuBar.add(jMenu4);
        this.createCertMenuItem = new JMenuItem("Create");
        this.createCertMenuItem.addActionListener(this.actionHandler);
        jMenu4.add(this.createCertMenuItem);
        this.exportCertMenuItem = new JMenuItem("Export");
        this.exportCertMenuItem.addActionListener(this.actionHandler);
        jMenu4.add(this.exportCertMenuItem);
        this.importCertMenuItem = new JMenuItem("Import");
        this.importCertMenuItem.addActionListener(this.actionHandler);
        jMenu4.add(this.importCertMenuItem);
        this.deleteCertMenuItem = new JMenuItem("Delete");
        this.deleteCertMenuItem.addActionListener(this.actionHandler);
        jMenu4.add(this.deleteCertMenuItem);
        this.tree = new KSEntryTree();
        JScrollPane jScrollPane = this.tree.getPane();
        this.getContentPane().setBackground(Color.white);
        this.getContentPane().add(jScrollPane);
        this.pack();
        ((Component)this).setVisible(true);
    }

    private class EventHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                try {
                    if ((JMenuItem)object == KeyStoreManager.this.exitMenuItem) {
                        KeyStoreManager.this._exit();
                    }
                    if ((JMenuItem)object == KeyStoreManager.this.openMenuItem) {
                        KeyStoreManager.this.load();
                    }
                    if ((JMenuItem)object == KeyStoreManager.this.closeMenuItem) {
                        KeyStoreManager.this.close();
                    }
                    if ((JMenuItem)object == KeyStoreManager.this.newMenuItem) {
                        KeyStoreManager.this.newFile();
                    }
                    if ((JMenuItem)object == KeyStoreManager.this.saveMenuItem) {
                        KeyStoreManager.this.save();
                    }
                    if ((JMenuItem)object == KeyStoreManager.this.saveAsMenuItem) {
                        KeyStoreManager.this.saveAs();
                    }
                    if ((JMenuItem)object == KeyStoreManager.this.generateKeyMenuItem) {
                        KeyStoreManager.this.generateKeys();
                    }
                    if ((JMenuItem)object == KeyStoreManager.this.deleteKeyMenuItem) {
                        KeyStoreManager.this.deleteNode();
                    }
                    if ((JMenuItem)object == KeyStoreManager.this.verifyChainMenuItem) {
                        KeyStoreManager.this.verifyChain();
                    }
                    if ((JMenuItem)object == KeyStoreManager.this.addTrusteeMenuItem) {
                        KeyStoreManager.this.addTrustee();
                    }
                    if ((JMenuItem)object == KeyStoreManager.this.deleteTrusteeMenuItem) {
                        KeyStoreManager.this.deleteNode();
                    }
                    if ((JMenuItem)object == KeyStoreManager.this.exportCertMenuItem) {
                        KeyStoreManager.this.exportCert();
                    }
                    if ((JMenuItem)object == KeyStoreManager.this.createCertMenuItem) {
                        KeyStoreManager.this.createCert();
                    }
                    if ((JMenuItem)object == KeyStoreManager.this.importCertMenuItem) {
                        KeyStoreManager.this.importCert();
                    }
                    if ((JMenuItem)object == KeyStoreManager.this.deleteCertMenuItem) {
                        KeyStoreManager.this.deleteNode();
                    }
                }
                catch (NoKeyStoreException noKeyStoreException) {
                    JOptionPane.showMessageDialog(null, "Please select a valid key store", "No Key Store selected", 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(null, exception.getClass().getName() + ":" + exception.getMessage(), "Exception", 0);
                }
            }
        }

        EventHandler() {
        }
    }
}

