/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.util;

import iaik.security.dsa.DSAPublicKey;
import iaik.security.rsa.RSAPublicKey;
import iaik.x509.X509Certificate;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jacorb.security.util.CertNode;
import org.jacorb.security.util.KSNode;
import org.jacorb.security.util.UserSponsor;

public class KeyNode
implements KSNode {
    private String alias;
    private PrivateKey key;
    private char[] password;
    Vector children;
    private String label;
    private String keytype = "<unknown key type>";
    private TreeNode root = null;
    private KeyStore ks;
    private boolean dirty = false;

    public X509Certificate getCert() {
        return ((CertNode)this.children.elementAt(0)).getCert();
    }

    public X509Certificate[] getCertificateChain() {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.getChildCount()];
        int n = 0;
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            CertNode certNode = (CertNode)enumeration.nextElement();
            x509CertificateArray[n] = certNode.getCert();
            ++n;
        }
        return x509CertificateArray;
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        if (!this.checkAccess()) {
            return;
        }
        this.children.insertElementAt(mutableTreeNode, n);
        mutableTreeNode.setParent(this);
        this.dirty = true;
    }

    public void remove(int n) {
        if (!this.checkAccess()) {
            return;
        }
        this.children.removeElementAt(n);
        this.dirty = true;
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        if (!this.checkAccess()) {
            return;
        }
        this.children.remove(mutableTreeNode);
        this.dirty = true;
    }

    public void setParent(MutableTreeNode mutableTreeNode) {
        this.root = mutableTreeNode;
    }

    public void setUserObject(Object object) {
    }

    public Enumeration children() {
        return this.children.elements();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        return (TreeNode)this.children.elementAt(n);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode) {
        return this.children.indexOf(treeNode);
    }

    public TreeNode getParent() {
        return this.root;
    }

    public String getAlias() {
        return this.alias;
    }

    private final boolean charsEqual(char[] cArray, char[] cArray2) {
        if (cArray.length != cArray2.length) {
            return false;
        }
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] != cArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setKey(PrivateKey privateKey, char[] cArray) {
        if (this.password == null) {
            this.key = privateKey;
        } else if (this.charsEqual(this.password, cArray)) {
            this.key = privateKey;
            this.password = cArray;
        } else {
            return;
        }
        if (privateKey != null) {
            this.keytype = privateKey instanceof RSAPrivateKey || privateKey instanceof iaik.security.rsa.RSAPrivateKey ? "RSA" : (privateKey instanceof DSAPrivateKey || privateKey instanceof iaik.security.dsa.DSAPrivateKey ? "DSA" : privateKey.getClass().getName());
            this.label = this.alias + " (" + this.keytype + " key)";
        }
    }

    public PrivateKey getKey(char[] cArray) {
        if (this.password == null || !this.charsEqual(this.password, cArray)) {
            System.out.println("coucou getKey wrong password >" + this.password + "<>" + cArray + "<");
            return null;
        }
        return this.key;
    }

    PrivateKey getKey() throws IllegalAccessException {
        if (!this.checkAccess()) {
            throw new IllegalAccessException("Wrong password.");
        }
        return this.key;
    }

    public boolean isLeaf() {
        return false;
    }

    public void removeFromParent() {
        if (!this.checkAccess()) {
            return;
        }
        try {
            this.ks.deleteEntry(this.alias);
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
    }

    public void store() {
        if (!this.dirty || !this.checkAccess()) {
            return;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[this.children.size()];
        int n = 0;
        while (n < x509CertificateArray.length) {
            x509CertificateArray[n] = ((CertNode)this.children.elementAt(n)).getCert();
            ++n;
        }
        try {
            this.ks.setKeyEntry(this.alias, this.key, this.password, (Certificate[])x509CertificateArray);
            this.dirty = false;
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
    }

    public boolean checkAccess() {
        if (this.key != null && this.password != null) {
            return true;
        }
        try {
            this.password = UserSponsor.getPasswd("Please enter password for key alias " + this.alias);
            if (this.password != null) {
                this.key = (PrivateKey)this.ks.getKey(this.alias, this.password);
                return true;
            }
            return false;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            unrecoverableKeyException.printStackTrace();
            return false;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return false;
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
            return false;
        }
    }

    public String toString() {
        if (this.label.indexOf("(") > 0) {
            if (this.key != null) {
                this.keytype = this.key instanceof RSAPrivateKey || this.key instanceof iaik.security.rsa.RSAPrivateKey ? "RSA" : (this.key instanceof DSAPrivateKey || this.key instanceof iaik.security.dsa.DSAPrivateKey ? "DSA" : this.key.getClass().getName());
            }
            this.label = this.alias + " (" + this.keytype + " key)";
        }
        return this.label;
    }

    public KeyNode(String string, PrivateKey privateKey, char[] cArray, KeyStore keyStore) {
        this.alias = string;
        this.key = privateKey;
        this.password = cArray;
        this.ks = keyStore;
        this.children = new Vector();
        if (privateKey != null) {
            this.keytype = privateKey instanceof RSAPrivateKey || privateKey instanceof iaik.security.rsa.RSAPrivateKey ? "RSA" : (privateKey instanceof DSAPrivateKey || privateKey instanceof iaik.security.dsa.DSAPrivateKey ? "DSA" : privateKey.getClass().getName());
        } else {
            try {
                Certificate certificate = keyStore.getCertificate(string);
                PublicKey publicKey = certificate.getPublicKey();
                this.keytype = publicKey instanceof java.security.interfaces.RSAPublicKey || publicKey instanceof RSAPublicKey ? "RSA" : (publicKey instanceof java.security.interfaces.DSAPublicKey || publicKey instanceof DSAPublicKey ? "DSA" : publicKey.getClass().getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.label = string + " (" + this.keytype + " key)";
    }
}

