/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.util;

import iaik.x509.X509Certificate;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jacorb.security.util.CertNode;
import org.jacorb.security.util.KSNode;
import org.jacorb.security.util.KeyNode;
import org.jacorb.security.util.TrustNode;

public class KSEntryTree {
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("<empty>");
    private JTree tree;
    JScrollPane pane;
    private DefaultTreeModel model = new DefaultTreeModel(this.root);
    private KeyStore ks;

    public JScrollPane getPane() {
        return this.pane;
    }

    public String listNodes() {
        String string = "";
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            KSNode kSNode = (KSNode)enumeration.nextElement();
            string = kSNode instanceof KeyNode ? string + "KeyNode " + ((KeyNode)kSNode).getAlias() + "\n" : (kSNode instanceof TrustNode ? string + "TrustNode " + ((TrustNode)kSNode).getAlias() + "\n" : string + "unknown node type\n");
        }
        return string;
    }

    public KSNode getNode(String string) {
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            KSNode kSNode = (KSNode)enumeration.nextElement();
            if (kSNode instanceof KeyNode && ((KeyNode)kSNode).getAlias().equals(string)) {
                return kSNode;
            }
            if (!(kSNode instanceof TrustNode) || !((TrustNode)kSNode).getAlias().equals(string)) continue;
            return kSNode;
        }
        return null;
    }

    public KeyNode getKeyNode(String string) {
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            KSNode kSNode = (KSNode)enumeration.nextElement();
            if (!(kSNode instanceof KeyNode) || !((KeyNode)kSNode).getAlias().equals(string)) continue;
            return (KeyNode)kSNode;
        }
        return null;
    }

    public void load(KeyStore keyStore) {
        this.ks = keyStore;
        try {
            this.root.setUserObject("KeyStore");
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                Certificate[] certificateArray;
                String string = enumeration.nextElement();
                if (keyStore.isKeyEntry(string)) {
                    System.out.println("bnv: iserted key entry for " + string);
                    certificateArray = keyStore.getCertificateChain(string);
                    KeyNode keyNode = new KeyNode(string, null, null, keyStore);
                    this.model.insertNodeInto(keyNode, this.root, this.root.getChildCount());
                    int n = 0;
                    while (n < certificateArray.length) {
                        CertNode certNode = new CertNode((X509Certificate)certificateArray[n], n);
                        this.model.insertNodeInto(certNode, keyNode, keyNode.getChildCount());
                        ++n;
                    }
                    this.tree.scrollPathToVisible(new TreePath(new TreeNode[]{this.root, keyNode}));
                    continue;
                }
                if (!keyStore.isCertificateEntry(string)) continue;
                certificateArray = (Certificate[])keyStore.getCertificate(string);
                this.model.insertNodeInto(new TrustNode(string, (X509Certificate)certificateArray, keyStore), this.root, this.root.getChildCount());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addKey(String string, PrivateKey privateKey, char[] cArray) {
        if (this.containsAlias(string)) {
            return;
        }
        KeyNode keyNode = new KeyNode(new String(string), privateKey, cArray, this.ks);
        this.model.insertNodeInto(keyNode, this.root, this.root.getChildCount());
        this.tree.scrollPathToVisible(new TreePath(new TreeNode[]{this.root, keyNode}));
    }

    public void addTrustedCert(String string, Certificate certificate) {
        if (this.containsAlias(string)) {
            return;
        }
        TrustNode trustNode = new TrustNode(new String(string), (X509Certificate)certificate, this.ks);
        this.model.insertNodeInto(trustNode, this.root, this.root.getChildCount());
        this.tree.scrollPathToVisible(new TreePath(new TreeNode[]{this.root, trustNode}));
    }

    public void addCert(String string, int n, Certificate certificate) {
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            MutableTreeNode mutableTreeNode = (MutableTreeNode)enumeration.nextElement();
            if (!(mutableTreeNode instanceof KeyNode) || !((KeyNode)mutableTreeNode).getAlias().equals(string)) continue;
            if (n == -1) {
                n = mutableTreeNode.getChildCount();
            }
            CertNode certNode = new CertNode((X509Certificate)certificate, n);
            this.model.insertNodeInto(certNode, mutableTreeNode, n);
            this.tree.scrollPathToVisible(new TreePath(certNode.getPath()));
            return;
        }
        throw new RuntimeException("Alias " + string + " not found!");
    }

    public void addCerts(String string, Certificate[] certificateArray) {
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            MutableTreeNode mutableTreeNode = (MutableTreeNode)enumeration.nextElement();
            if (!(mutableTreeNode instanceof KeyNode) || !((KeyNode)mutableTreeNode).getAlias().equals(string)) continue;
            int n = 0;
            while (n < certificateArray.length) {
                CertNode certNode = new CertNode((X509Certificate)certificateArray[n], n);
                this.model.insertNodeInto(certNode, mutableTreeNode, n);
                if (n == certificateArray.length - 1) {
                    this.tree.scrollPathToVisible(new TreePath(certNode.getPath()));
                }
                ++n;
            }
            return;
        }
        throw new RuntimeException("Alias " + string + " not found!");
    }

    public void clean() {
        this.root.removeAllChildren();
        this.root.setUserObject("<empty>");
        this.model.reload();
    }

    public String getSelectedAlias() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            if (treePath.getLastPathComponent() instanceof KeyNode) {
                return ((KeyNode)treePath.getLastPathComponent()).getAlias();
            }
            if (treePath.getLastPathComponent() instanceof TrustNode) {
                return ((TrustNode)treePath.getLastPathComponent()).getAlias();
            }
        }
        return null;
    }

    public KSNode getSelectedNode() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            return (KSNode)treePath.getLastPathComponent();
        }
        return null;
    }

    public String removeSelectedNode() {
        MutableTreeNode mutableTreeNode;
        MutableTreeNode mutableTreeNode2;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null && (mutableTreeNode2 = (MutableTreeNode)(mutableTreeNode = (MutableTreeNode)treePath.getLastPathComponent()).getParent()) != null) {
            String string = mutableTreeNode.toString();
            this.model.removeNodeFromParent(mutableTreeNode);
            return string;
        }
        return null;
    }

    public void removeCerts(String string) {
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            MutableTreeNode mutableTreeNode = (MutableTreeNode)enumeration.nextElement();
            if (!(mutableTreeNode instanceof KeyNode) || !((KeyNode)mutableTreeNode).getAlias().equals(string)) continue;
            KeyNode keyNode = (KeyNode)mutableTreeNode;
            int n = keyNode.getChildCount();
            while (n > 0) {
                CertNode certNode = (CertNode)keyNode.getChildAt(n - 1);
                this.model.removeNodeFromParent(certNode);
                --n;
            }
            return;
        }
        throw new RuntimeException("Alias " + string + " not found!");
    }

    public void reload() {
        this.model.reload(this.root);
    }

    public Enumeration getNodes() {
        return this.root.children();
    }

    public boolean isTrusted(X509Certificate x509Certificate) {
        Enumeration enumeration = this.getNodes();
        while (enumeration.hasMoreElements()) {
            KSNode kSNode = (KSNode)enumeration.nextElement();
            if (!(kSNode instanceof TrustNode) || !kSNode.getCert().equals(x509Certificate)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAlias(String string) {
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            MutableTreeNode mutableTreeNode = (MutableTreeNode)enumeration.nextElement();
            if ((!(mutableTreeNode instanceof KeyNode) || !((KeyNode)mutableTreeNode).getAlias().equals(string)) && (!(mutableTreeNode instanceof TrustNode) || !((TrustNode)mutableTreeNode).getAlias().equals(string))) continue;
            return true;
        }
        return false;
    }

    public KSEntryTree() {
        this.tree = new JTree(this.model);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.tree.setVisible(true);
        this.pane = new JScrollPane(this.tree);
    }
}

