/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.util;

import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.provider.IAIK;
import iaik.utils.KeyAndCertificate;
import iaik.x509.X509Certificate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class CertificatesManager {
    public static int saveFormat = 2;
    private static final String pass_phrase = "bnv_8.12.99_passpass_find_out_ORB_JacORB1_0/beta14_SSL";
    private static Hashtable signers = new Hashtable();

    public static Principal addTrustedSigner(java.security.cert.X509Certificate x509Certificate) {
        Vector<java.security.cert.X509Certificate> vector;
        Principal principal;
        if (x509Certificate == null) {
            System.out.println("certificate is empty.");
            System.exit(0);
        }
        if ((principal = x509Certificate.getSubjectDN()) == null) {
            System.out.println("Unable to get dn from certificate.");
            System.exit(0);
        }
        if ((vector = (Vector<java.security.cert.X509Certificate>)signers.get(principal)) == null) {
            vector = new Vector<java.security.cert.X509Certificate>(4);
            signers.put(principal, vector);
        }
        vector.addElement(x509Certificate);
        if (principal == null) {
            System.out.println("Unable to add dn.");
            System.exit(0);
        }
        return principal;
    }

    public static void setTrustedSigners(X509Certificate[] x509CertificateArray) {
        signers = new Hashtable();
        int n = 0;
        while (n < x509CertificateArray.length) {
            CertificatesManager.addTrustedSigner((java.security.cert.X509Certificate)x509CertificateArray[n]);
            ++n;
        }
    }

    public static boolean hasTrustedRoot(java.security.cert.X509Certificate[] x509CertificateArray) {
        try {
            int n = 0;
            while (n < x509CertificateArray.length) {
                Vector vector;
                if (n > 0) {
                    x509CertificateArray[n - 1].verify(x509CertificateArray[n].getPublicKey());
                }
                if ((vector = (Vector)signers.get(x509CertificateArray[n].getSubjectDN())) != null) {
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        X509Certificate x509Certificate = (X509Certificate)vector.elementAt(n2);
                        if (x509Certificate.equals(x509CertificateArray[n])) {
                            return true;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public static void saveKeyAndCert(KeyPair keyPair, X509Certificate[] x509CertificateArray, String string) throws IOException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo((PrivateKey)((PrivateKeyInfo)keyPair.getPrivate()));
        try {
            encryptedPrivateKeyInfo.encrypt(pass_phrase, AlgorithmID.pbeWithMD5AndDES_CBC, null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("No implementation for pbeWithMD5AndDES_CBC!");
        }
        string = string + (saveFormat == 1 ? ".der" : ".pem");
        System.out.println("save private key and certificate chain to file " + string + "...");
        new KeyAndCertificate((PrivateKey)encryptedPrivateKeyInfo, x509CertificateArray).saveTo(string, saveFormat);
    }

    public static KeyPair generateKeyPair(String string, int n) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string, "IAIK");
            keyPairGenerator.initialize(n);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            return keyPair;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            System.out.println("Provider IAIK not found!");
            return null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("Algorithm " + string + " not found!");
            return null;
        }
    }

    public static boolean verifyCertificateChain(java.security.cert.X509Certificate[] x509CertificateArray) {
        int n = x509CertificateArray.length;
        try {
            x509CertificateArray[n - 1].verify(x509CertificateArray[n - 1].getPublicKey());
            int n2 = n - 1;
            while (n2 > 0) {
                x509CertificateArray[n2 - 1].verify(x509CertificateArray[n2].getPublicKey());
                --n2;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return CertificatesManager.hasTrustedRoot(x509CertificateArray);
    }

    public static X509Certificate createCertificate(Name name, PublicKey publicKey, Name name2, PrivateKey privateKey, AlgorithmID algorithmID) {
        X509Certificate x509Certificate = new X509Certificate();
        try {
            x509Certificate.setSerialNumber(new BigInteger(20, new Random()));
            x509Certificate.setSubjectDN((Principal)name);
            x509Certificate.setPublicKey(publicKey);
            x509Certificate.setIssuerDN((Principal)name2);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.add(5, -1);
            x509Certificate.setValidNotBefore(gregorianCalendar.getTime());
            gregorianCalendar.add(2, 6);
            x509Certificate.setValidNotAfter(gregorianCalendar.getTime());
            x509Certificate.sign(algorithmID, privateKey);
        }
        catch (CertificateException certificateException) {
            System.out.println("CertificateException: " + certificateException.getMessage());
            return null;
        }
        catch (InvalidKeyException invalidKeyException) {
            System.out.println("InvalidKeyException: " + invalidKeyException.getMessage());
            return null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("NoSuchAlgorithmException: " + noSuchAlgorithmException.getMessage());
            return null;
        }
        return x509Certificate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        PrivateKey privateKey = null;
        X509Certificate x509Certificate = null;
        if (stringArray.length == 3) {
            bl = true;
            if (stringArray[0].equals("-ca")) {
                string2 = stringArray[1];
                string = stringArray[2];
            } else {
                if (!stringArray[1].equals("-ca")) {
                    System.out.println("caNotFound");
                    System.out.println("Usage: CerttificatesManager [-ca caName] userName");
                    return;
                }
                System.out.println("caFound at 1");
                string2 = stringArray[2];
                string = stringArray[0];
            }
        } else {
            if (stringArray.length != 1) {
                System.out.println("bad # params");
                System.out.println("Usage: CertificatesManager [-ca caName] userName");
                return;
            }
            string = stringArray[0];
            bl2 = true;
        }
        try {
            IAIK.addAsProvider();
            File file = new File("certs");
            String string3 = null;
            if (file.exists()) {
                if (bl) {
                    string3 = "certs/" + string2 + "KeyAndCert" + ".pem";
                    KeyAndCertificate keyAndCertificate = new KeyAndCertificate(string3);
                    EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (EncryptedPrivateKeyInfo)keyAndCertificate.getPrivateKey();
                    encryptedPrivateKeyInfo.decrypt(pass_phrase);
                    privateKey = encryptedPrivateKeyInfo.getPrivateKeyInfo();
                    x509Certificate = keyAndCertificate.getCertificateChain()[0];
                }
            } else {
                if (string2 != null) {
                    System.out.println("No certificate file " + string3);
                    return;
                }
                file.mkdir();
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string4 = InetAddress.getLocalHost().getHostName();
            System.out.print("Give server host name [" + string4 + "]:");
            String string5 = bufferedReader.readLine();
            if (string5.length() != 0) {
                string4 = string5;
            }
            if (!bl2 && bl) {
                System.out.println("Creating server certificates for " + string + " at " + string4 + "\n");
                KeyPair keyPair = CertificatesManager.generateKeyPair("RSA", 1024);
                KeyPair keyPair2 = CertificatesManager.generateKeyPair("RSA", 1024);
                Name name = new Name();
                name.addRDN(ObjectID.country, (Object)"CH");
                name.addRDN(ObjectID.organization, (Object)"EPFL");
                name.addRDN(ObjectID.organizationalUnit, (Object)"SSLCertificateManager");
                name.addRDN(ObjectID.commonName, (Object)string2);
                Name name2 = new Name();
                name2.addRDN(ObjectID.country, (Object)"CH");
                name2.addRDN(ObjectID.organization, (Object)"EPFL");
                name2.addRDN(ObjectID.commonName, (Object)(string + string4));
                X509Certificate[] x509CertificateArray = new X509Certificate[2];
                name2.addRDN(ObjectID.organizationalUnit, (Object)"RSA Server Certificate");
                x509CertificateArray[0] = CertificatesManager.createCertificate(name2, keyPair2.getPublic(), name, privateKey, AlgorithmID.md5WithRSAEncryption);
                x509CertificateArray[1] = x509Certificate;
                CertificatesManager.verifyCertificateChain((java.security.cert.X509Certificate[])x509CertificateArray);
                CertificatesManager.saveKeyAndCert(keyPair2, x509CertificateArray, "certs/server" + string + "KeyAndCert");
                System.out.println("Creating client test certificates for " + string + " at " + string4 + "\n");
                Name name3 = new Name();
                name3.addRDN(ObjectID.country, (Object)"CH");
                name3.addRDN(ObjectID.organization, (Object)"EPFL");
                name3.addRDN(ObjectID.commonName, (Object)("Client" + string + string4));
                x509CertificateArray = new X509Certificate[2];
                name3.addRDN(ObjectID.organizationalUnit, (Object)"RSA Client Certificate");
                x509CertificateArray[0] = CertificatesManager.createCertificate(name3, keyPair.getPublic(), name, privateKey, AlgorithmID.md5WithRSAEncryption);
                x509CertificateArray[1] = x509Certificate;
                CertificatesManager.verifyCertificateChain((java.security.cert.X509Certificate[])x509CertificateArray);
                CertificatesManager.saveKeyAndCert(keyPair, x509CertificateArray, "certs/client" + string + "KeyAndCert");
            } else {
                X509Certificate x509Certificate2 = null;
                X509Certificate[] x509CertificateArray = new X509Certificate[1];
                System.out.println("create self signed RSA CA certificate... for " + string);
                Name name = new Name();
                name.addRDN(ObjectID.country, (Object)"CH");
                name.addRDN(ObjectID.organization, (Object)"EPFL");
                name.addRDN(ObjectID.organizationalUnit, (Object)"SSLCertificateManager");
                name.addRDN(ObjectID.commonName, (Object)string);
                KeyPair keyPair = CertificatesManager.generateKeyPair("RSA", 1024);
                x509CertificateArray[0] = x509Certificate2 = CertificatesManager.createCertificate(name, keyPair.getPublic(), name, keyPair.getPrivate(), AlgorithmID.md5WithRSAEncryption);
                FileOutputStream fileOutputStream = new FileOutputStream("certs/" + string + "Cert.pem");
                x509Certificate2.writeTo((OutputStream)fileOutputStream);
                ((OutputStream)fileOutputStream).close();
                CertificatesManager.saveKeyAndCert(keyPair, x509CertificateArray, "certs/" + string + "KeyAndCert");
            }
            System.out.println("\nServer and Client certificates created.");
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("NoSuchAlgorithmException: " + noSuchAlgorithmException.toString());
            return;
        }
        catch (UnknownHostException unknownHostException) {
            System.out.print("UnknownHostException: " + unknownHostException.getMessage());
            return;
        }
        catch (CertificateException certificateException) {
            System.out.print("CertificateException: " + certificateException.getMessage());
            return;
        }
        catch (Exception exception) {
            System.out.println("Other Exception: " + exception);
        }
    }
}

