/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.util;

import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.extensions.SubjectAltName;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import org.jacorb.util.Debug;

public class CertUtils {
    public static X509Certificate createPublicKeyCert(Name name, Name name2, PublicKey publicKey, PrivateKey privateKey) throws X509ExtensionException, CertificateException, NoSuchAlgorithmException, InvalidKeyException {
        X509Certificate x509Certificate = new X509Certificate();
        if (name == null) {
            name = CertUtils.emptyName();
        }
        if (name2 == null) {
            name2 = CertUtils.emptyName();
        }
        x509Certificate.setIssuerDN((Principal)name2);
        x509Certificate.setSubjectDN((Principal)name);
        x509Certificate.setPublicKey(publicKey);
        Date date = new Date();
        x509Certificate.setSerialNumber(new BigInteger(Long.toString(date.getTime())));
        x509Certificate.setValidNotBefore(date);
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 12);
        x509Certificate.setValidNotAfter(calendar.getTime());
        if (privateKey instanceof DSAPrivateKey) {
            x509Certificate.sign(AlgorithmID.dsaWithSHA1, privateKey);
        } else if (privateKey instanceof RSAPrivateKey) {
            x509Certificate.sign(AlgorithmID.md5WithRSAEncryption, privateKey);
        } else {
            throw new InvalidKeyException("Unknown private key: " + privateKey.getClass().getName());
        }
        return x509Certificate;
    }

    public static X509Certificate certifyRoleMembership(String string, Name name, Name name2, PublicKey publicKey, PrivateKey privateKey) throws X509ExtensionException, CertificateException, NoSuchAlgorithmException, InvalidKeyException {
        X509Certificate x509Certificate = new X509Certificate();
        if (name == null) {
            name = CertUtils.emptyName();
        }
        if (name2 == null) {
            name2 = CertUtils.emptyName();
        }
        x509Certificate.setIssuerDN((Principal)name2);
        x509Certificate.setSubjectDN((Principal)name);
        x509Certificate.setPublicKey(publicKey);
        Date date = new Date();
        x509Certificate.setSerialNumber(new BigInteger(Long.toString(date.getTime())));
        x509Certificate.setValidNotBefore(date);
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 12);
        x509Certificate.setValidNotAfter(calendar.getTime());
        GeneralName generalName = new GeneralName(GeneralName.rfc822Name, (Object)("role:" + string));
        GeneralNames generalNames = new GeneralNames(generalName);
        SubjectAltName subjectAltName = new SubjectAltName(generalNames);
        x509Certificate.addExtension((V3Extension)subjectAltName);
        if (privateKey instanceof DSAPrivateKey) {
            x509Certificate.sign(AlgorithmID.dsaWithSHA1, privateKey);
        } else if (privateKey instanceof RSAPrivateKey) {
            x509Certificate.sign(AlgorithmID.md5WithRSAEncryption, privateKey);
        }
        System.out.println("Cert signed");
        return x509Certificate;
    }

    public static Name emptyName() {
        Name name = new Name();
        name.addRDN(ObjectID.commonName, (Object)"");
        name.addRDN(ObjectID.organizationalUnit, (Object)"");
        name.addRDN(ObjectID.organization, (Object)"");
        name.addRDN(ObjectID.locality, (Object)"");
        name.addRDN(ObjectID.country, (Object)"");
        return name;
    }

    public static Name createName(String string) {
        Name name = new Name();
        name.addRDN(ObjectID.commonName, (Object)string);
        name.addRDN(ObjectID.organizationalUnit, (Object)"AGSS");
        name.addRDN(ObjectID.organization, (Object)"FU Berlin");
        name.addRDN(ObjectID.locality, (Object)"Berlin");
        name.addRDN(ObjectID.country, (Object)"DE");
        return name;
    }

    public static String getCertLabel(java.security.cert.X509Certificate x509Certificate) {
        String string = CertUtils.getRoleName(x509Certificate);
        if (string == null) {
            string = x509Certificate.getSubjectDN() + ", signer: " + x509Certificate.getIssuerDN();
        }
        return string;
    }

    public static String getRoleName(java.security.cert.X509Certificate x509Certificate) {
        try {
            X509Certificate x509Certificate2;
            try {
                x509Certificate2 = (X509Certificate)x509Certificate;
            }
            catch (ClassCastException classCastException) {
                x509Certificate2 = new X509Certificate(x509Certificate.getEncoded());
            }
            if (!x509Certificate2.hasExtensions()) {
                return null;
            }
            x509Certificate2.checkValidity();
            Enumeration enumeration = x509Certificate2.listExtensions();
            while (enumeration.hasMoreElements()) {
                V3Extension v3Extension = (V3Extension)enumeration.nextElement();
                if (!(v3Extension instanceof SubjectAltName)) continue;
                SubjectAltName subjectAltName = (SubjectAltName)v3Extension;
                GeneralNames generalNames = subjectAltName.getGeneralNames();
                Enumeration enumeration2 = generalNames.getNames();
                while (enumeration2.hasMoreElements()) {
                    String string;
                    GeneralName generalName = (GeneralName)enumeration2.nextElement();
                    if (generalName.getType() != GeneralName.rfc822Name || !(string = (String)generalName.getName()).startsWith("role:")) continue;
                    return string.substring(5);
                }
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean isRoleCert(java.security.cert.X509Certificate x509Certificate) {
        try {
            X509Certificate x509Certificate2;
            try {
                x509Certificate2 = (X509Certificate)x509Certificate;
            }
            catch (ClassCastException classCastException) {
                x509Certificate2 = new X509Certificate(x509Certificate.getEncoded());
            }
            if (!x509Certificate2.hasExtensions()) {
                return false;
            }
            Enumeration enumeration = x509Certificate2.listExtensions();
            while (enumeration.hasMoreElements()) {
                V3Extension v3Extension = (V3Extension)enumeration.nextElement();
                if (!(v3Extension instanceof SubjectAltName)) continue;
                SubjectAltName subjectAltName = (SubjectAltName)v3Extension;
                GeneralNames generalNames = subjectAltName.getGeneralNames();
                Enumeration enumeration2 = generalNames.getNames();
                while (enumeration2.hasMoreElements()) {
                    String string;
                    GeneralName generalName = (GeneralName)enumeration2.nextElement();
                    if (generalName.getType() != GeneralName.rfc822Name || !(string = (String)generalName.getName()).startsWith("role:")) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean verifyCertificateChain(java.security.cert.X509Certificate[] x509CertificateArray, KeyStore keyStore) {
        int n = x509CertificateArray.length;
        try {
            x509CertificateArray[n - 1].verify(x509CertificateArray[n - 1].getPublicKey());
            int n2 = n - 1;
            while (n2 > 0) {
                Debug.output(3, "verifying chain[ " + (n2 - 1) + " ]");
                x509CertificateArray[n2 - 1].verify(x509CertificateArray[n2].getPublicKey());
                --n2;
            }
            String string = x509CertificateArray[n - 1].getIssuerDN().getName();
            int n3 = string.indexOf("CN=") + 3;
            int n4 = string.length();
            Debug.output(4, "index = " + n3 + " l = " + n4);
            string = string.substring(n3, n4);
            Debug.output(4, "check if " + string + " is a trusted certificate entry in key store");
            return keyStore.isCertificateEntry(string);
        }
        catch (Exception exception) {
            Debug.output(3, "exection: " + exception.toString());
            return false;
        }
    }

    public static java.security.cert.X509Certificate readCertificate(String string) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "IAIK");
            return (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new FileInputStream(string));
        }
        catch (Exception exception) {
            Debug.output(1, exception);
            return null;
        }
    }
}

