/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.iaik;

import iaik.security.ssl.ChainVerifier;
import iaik.security.ssl.CipherSuite;
import iaik.security.ssl.SSLClientContext;
import iaik.security.ssl.SSLContext;
import iaik.security.ssl.SSLServerContext;
import iaik.security.ssl.SSLSocket;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.security.level2.CurrentImpl;
import org.jacorb.security.level2.KeyAndCert;
import org.jacorb.security.ssl.iaik.SSLSetup;
import org.jacorb.security.ssl.iaik.ServerChainVerifier;
import org.jacorb.security.util.CertUtils;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.ORBPackage.InvalidName;

public class SSLSocketFactory
implements SocketFactory {
    private String[] default_cs = null;
    private boolean isRoleChange;
    private CurrentImpl securityCurrent = null;
    private ORB orb = null;
    private SSLContext default_context = null;

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        SSLSocket sSLSocket = new SSLSocket(string, n, this.getDefaultContext());
        if (this.isRoleChange) {
            Debug.output(1, "SSLSocket switch to server mode...");
            sSLSocket.setUseClientMode(false);
        }
        return sSLSocket;
    }

    private final KeyAndCert[] getSSLCredentials() {
        CurrentImpl currentImpl = null;
        try {
            currentImpl = (CurrentImpl)this.orb.resolve_initial_references("SecurityCurrent");
        }
        catch (InvalidName invalidName) {
            Debug.output(1, "Unable to obtain Security Current. Giving up");
            System.exit(-1);
        }
        return currentImpl.getSSLCredentials();
    }

    private final SSLContext getDefaultContext() {
        if (this.default_context != null) {
            return this.default_context;
        }
        if (this.isRoleChange) {
            SSLServerContext sSLServerContext = new SSLServerContext();
            KeyAndCert[] keyAndCertArray = this.getSSLCredentials();
            int n = 0;
            while (n < keyAndCertArray.length) {
                sSLServerContext.addServerCredentials((X509Certificate[])keyAndCertArray[n].chain, keyAndCertArray[n].key);
                ++n;
            }
            if ((Environment.getIntProperty("jacorb.security.ssl.client.required_options", 16) & 0x20) != 0) {
                sSLServerContext.setRequestClientCertificate(true);
                sSLServerContext.setChainVerifier((ChainVerifier)new ServerChainVerifier(true));
                String[] stringArray = Environment.getPropertyValueList("jacorb.security.trustees");
                if (stringArray.length == 0) {
                    Debug.output(1, "WARNING: No trusted certificates specified. This will accept all peer certificate chains!");
                }
                int n2 = 0;
                while (n2 < stringArray.length) {
                    sSLServerContext.addTrustedCertificate(CertUtils.readCertificate(stringArray[n2]));
                    ++n2;
                }
            }
            this.default_context = sSLServerContext;
        } else {
            int n;
            Object[] objectArray;
            SSLClientContext sSLClientContext = new SSLClientContext();
            if ((Environment.getIntProperty("jacorb.security.ssl.client.supported_options", 16) & 0x40) != 0) {
                objectArray = this.getSSLCredentials();
                n = 0;
                while (n < objectArray.length) {
                    sSLClientContext.addClientCredentials((X509Certificate[])((KeyAndCert)objectArray[n]).chain, ((KeyAndCert)objectArray[n]).key);
                    ++n;
                }
            }
            if ((objectArray = Environment.getPropertyValueList("jacorb.security.trustees")).length == 0) {
                Debug.output(1, "WARNING: No trusted certificates specified. This will accept all peer certificate chains!");
            }
            n = 0;
            while (n < objectArray.length) {
                sSLClientContext.addTrustedCertificate(CertUtils.readCertificate((String)objectArray[n]));
                ++n;
            }
            this.default_context = sSLClientContext;
        }
        if (Environment.isPropertyOn("jacorb.security.iaik_debug")) {
            this.default_context.setDebugStream((OutputStream)System.out);
        }
        return this.default_context;
    }

    public String[] getDefaultCipherSuites() {
        return this.default_cs;
    }

    public String[] getSupportedCipherSuites() {
        CipherSuite[] cipherSuiteArray = CipherSuite.getDefault();
        String[] stringArray = new String[cipherSuiteArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = cipherSuiteArray[n].toString();
            ++n;
        }
        return stringArray;
    }

    public boolean isSSL(Socket socket) {
        return socket instanceof SSLSocket;
    }

    public SSLSocketFactory(ORB oRB) {
        this.orb = oRB;
        this.isRoleChange = Environment.isPropertyOn("jacorb.security.change_ssl_roles");
        CipherSuite[] cipherSuiteArray = SSLSetup.getCipherSuites();
        this.default_cs = new String[cipherSuiteArray.length];
        int n = 0;
        while (n < cipherSuiteArray.length) {
            this.default_cs[n] = cipherSuiteArray[n].toString();
            ++n;
        }
    }
}

