/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.iaik;

import iaik.security.ssl.ChainVerifier;
import iaik.security.ssl.CipherSuite;
import iaik.security.ssl.DefaultSessionManager;
import iaik.security.ssl.SSLServerContext;
import iaik.security.ssl.SSLServerSocket;
import iaik.security.ssl.SSLSocket;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.cert.X509Certificate;
import org.jacorb.orb.ORB;
import org.jacorb.security.level2.CurrentImpl;
import org.jacorb.security.level2.KeyAndCert;
import org.jacorb.security.ssl.iaik.SSLSetup;
import org.jacorb.security.ssl.iaik.ServerChainVerifier;
import org.jacorb.security.util.CertUtils;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.ORBPackage.InvalidName;

public class SSLServerSocketFactory
implements org.jacorb.orb.factory.SSLServerSocketFactory {
    private SSLServerContext defaultContext;
    private CipherSuite[] cs = SSLSetup.getCipherSuites();

    private final KeyAndCert[] getSSLCredentials(ORB oRB) {
        CurrentImpl currentImpl = null;
        try {
            currentImpl = (CurrentImpl)oRB.resolve_initial_references("SecurityCurrent");
        }
        catch (InvalidName invalidName) {
            Debug.output(1, "Unable to obtain Security Current. Giving up");
            System.exit(-1);
        }
        return currentImpl.getSSLCredentials();
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        if (this.defaultContext == null) {
            throw new IOException("Cannot support SSL, no default SSL context found!");
        }
        return new SSLServerSocket(n, this.defaultContext);
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        if (this.defaultContext == null) {
            throw new IOException("Cannot support SSL, no default SSL context found!");
        }
        return new SSLServerSocket(n, n2, this.defaultContext);
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        if (this.defaultContext == null) {
            throw new IOException("Cannot support SSL, no default SSL context found!");
        }
        return new SSLServerSocket(n, n2, inetAddress, this.defaultContext);
    }

    public String[] getDefaultCipherSuites() {
        String[] stringArray = new String[this.cs.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.cs[n].toString();
            ++n;
        }
        return stringArray;
    }

    public String[] getSupportedCipherSuites() {
        CipherSuite[] cipherSuiteArray = CipherSuite.getDefault();
        String[] stringArray = new String[cipherSuiteArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = cipherSuiteArray[n].toString();
            ++n;
        }
        return stringArray;
    }

    public boolean isSSL(ServerSocket serverSocket) {
        return serverSocket instanceof SSLServerSocket;
    }

    public void switchToClientMode(Socket socket) {
        if (Environment.isPropertyOn("jacorb.security.change_ssl_roles")) {
            try {
                Debug.output(2, "SSLServerSocket, switching to client mode...");
                ((SSLSocket)socket).setUseClientMode(true);
            }
            catch (IOException iOException) {
                Debug.output(0x10000001, iOException);
            }
        }
    }

    public SSLServerSocketFactory(ORB oRB) {
        this.defaultContext = new SSLServerContext();
        if (Environment.isPropertyOn("jacorb.security.change_ssl_roles")) {
            if ((Environment.getIntProperty("jacorb.security.ssl.server.supported_options", 16) & 0x20) != 0) {
                KeyAndCert[] keyAndCertArray = this.getSSLCredentials(oRB);
                int n = 0;
                while (n < keyAndCertArray.length) {
                    this.defaultContext.addClientCredentials((X509Certificate[])keyAndCertArray[n].chain, keyAndCertArray[n].key);
                    ++n;
                }
                ((DefaultSessionManager)this.defaultContext.getSessionManager()).setResumePeriod(0L);
            }
        } else {
            KeyAndCert[] keyAndCertArray = this.getSSLCredentials(oRB);
            int n = 0;
            while (n < keyAndCertArray.length) {
                this.defaultContext.addServerCredentials((X509Certificate[])keyAndCertArray[n].chain, keyAndCertArray[n].key);
                ++n;
            }
            if ((Environment.getIntProperty("jacorb.security.ssl.server.required_options", 16) & 0x40) != 0) {
                this.defaultContext.setRequestClientCertificate(true);
                this.defaultContext.setChainVerifier((ChainVerifier)new ServerChainVerifier(true));
                String[] stringArray = Environment.getPropertyValueList("jacorb.security.trustees");
                if (stringArray.length == 0) {
                    Debug.output(1, "WARNING: No trusted certificates specified. This will accept all peer certificate chains!");
                }
                int n2 = 0;
                while (n2 < stringArray.length) {
                    this.defaultContext.addTrustedCertificate(CertUtils.readCertificate(stringArray[n2]));
                    ++n2;
                }
            }
        }
        if (Environment.isPropertyOn("jacorb.security.iaik_debug")) {
            this.defaultContext.setDebugStream((OutputStream)System.out);
        }
    }
}

