/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.level2;

import iaik.security.provider.IAIK;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.jacorb.security.level2.CredentialsImpl;
import org.jacorb.security.level2.KeyAndCert;
import org.jacorb.security.level2.SecAttributeManager;
import org.jacorb.security.util.KeyStoreUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.Security.AttributeType;
import org.omg.Security.AuthenticationStatus;
import org.omg.Security.ExtensibleFamily;
import org.omg.Security.InvocationCredentialsType;
import org.omg.Security.OpaqueHolder;
import org.omg.Security.SecAttribute;
import org.omg.SecurityLevel2.Credentials;
import org.omg.SecurityLevel2.CredentialsHolder;
import org.omg.SecurityLevel2.PrincipalAuthenticator;

public class PrincipalAuthenticatorImpl
extends LocalObject
implements PrincipalAuthenticator {
    public int[] get_supported_authen_methods(String string) {
        return new int[]{0};
    }

    public AuthenticationStatus authenticate(int n, String string, String string2, byte[] byArray, SecAttribute[] secAttributeArray, CredentialsHolder credentialsHolder, OpaqueHolder opaqueHolder, OpaqueHolder opaqueHolder2) {
        Debug.output(3, "JPA: starting authentication");
        try {
            String string3;
            String string4;
            this.registerProvider();
            String string5 = Environment.getProperty("jacorb.security.keystore");
            if (string5 == null) {
                System.out.print("Please enter key store file name: ");
                string5 = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            if ((string4 = Environment.getProperty("jacorb.security.keystore_password")) == null) {
                System.out.print("Please enter store pass phrase: ");
                string4 = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            if ((string3 = string2) == null) {
                System.out.print("Please enter alias  name: ");
                string3 = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            String string6 = null;
            if (byArray == null) {
                System.out.print("Please enter password: ");
                string6 = new BufferedReader(new InputStreamReader(System.in)).readLine();
            } else {
                string6 = new String(byArray);
            }
            if (string5 == null || string4 == null || string3 == null || string6 == null) {
                return AuthenticationStatus.SecAuthFailure;
            }
            KeyStore keyStore = KeyStoreUtil.getKeyStore(string5, string4.toCharArray());
            Certificate[] certificateArray = (X509Certificate[])keyStore.getCertificateChain(string3);
            if (certificateArray == null) {
                Debug.output(0, "No keys found in keystore for alias \"" + string3 + "\"!");
                if (Environment.getProperty("jacorb.security.default_user") != null) {
                    Debug.output(0, "Please check property \"jacorb.security.default_user\"");
                }
                return AuthenticationStatus.SecAuthFailure;
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(string3, string6.toCharArray());
            KeyAndCert keyAndCert = new KeyAndCert(privateKey, certificateArray);
            AttributeType attributeType = new AttributeType(new ExtensibleFamily(0, 1), 2);
            SecAttributeManager secAttributeManager = SecAttributeManager.getInstance();
            SecAttribute secAttribute = secAttributeManager.createAttribute(keyAndCert, attributeType);
            CredentialsImpl credentialsImpl = new CredentialsImpl(new SecAttribute[]{secAttribute}, AuthenticationStatus.SecAuthSuccess, InvocationCredentialsType.SecOwnCredentials);
            credentialsHolder.value = credentialsImpl;
            Debug.output(3, "JPA: authentication succeeded");
            return AuthenticationStatus.SecAuthSuccess;
        }
        catch (Exception exception) {
            Debug.output(2, exception);
            return AuthenticationStatus.SecAuthFailure;
        }
    }

    public AuthenticationStatus continue_authentication(byte[] byArray, Credentials credentials, OpaqueHolder opaqueHolder, OpaqueHolder opaqueHolder2) {
        throw new NO_IMPLEMENT();
    }

    private final void registerProvider() {
        IAIK.addAsProvider();
        Debug.output(3, "added Provider IAIK");
    }
}

