/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.proxy;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.proxy.Proxy;
import org.jacorb.proxy.ProxyHelper;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;

public class ProxyClientForwardInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private long localNetwork = 0L;
    private long localNetmask = 0L;
    private ORB orb = null;
    private Vector proxies = new Vector();
    private Codec codec = null;

    public void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        Object object = clientRequestInfo.target();
        if (this.isProxy(object)) {
            Debug.output(1, "ProxyClientForwardInterceptor calling to proxy");
            Any any = this.orb.create_any();
            any.insert_string(this.orb.object_to_string(clientRequestInfo.effective_target()));
            try {
                ServiceContext serviceContext = new ServiceContext(1245790978, this.codec.encode(any));
                clientRequestInfo.add_request_service_context(serviceContext, false);
            }
            catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                invalidTypeForEncoding.printStackTrace();
            }
        } else {
            Proxy proxy = this.redirectProxy(object);
            if (proxy != null) {
                throw new ForwardRequest("ProxyForward", proxy);
            }
        }
    }

    public String name() {
        return "JacORB.ProxyClientForwardInterceptor";
    }

    public void send_poll(ClientRequestInfo clientRequestInfo) {
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo) {
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
    }

    public void destroy() {
        this.orb = null;
        this.proxies = null;
        this.codec = null;
    }

    private final boolean isProxy(Object object) {
        boolean bl = false;
        Enumeration enumeration = this.proxies.elements();
        while (enumeration.hasMoreElements()) {
            ProxyInfo proxyInfo = (ProxyInfo)enumeration.nextElement();
            if (!proxyInfo.proxy._is_equivalent(object)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private final Proxy redirectProxy(Object object) {
        Proxy proxy = null;
        boolean bl = false;
        ParsedIOR parsedIOR = new ParsedIOR(object.toString());
        String string = parsedIOR.getHost();
        long l = ProxyClientForwardInterceptor.ipToInt(string);
        bl = this.orb.isApplet() ? !this.orb.getApplet().getCodeBase().getHost().equals(string) : (this.localNetwork != 0L ? (l & this.localNetmask) != this.localNetwork : true);
        if (bl) {
            Debug.output(1, "ProxyClientForwardInterceptor forwarding to " + string);
            Enumeration enumeration = this.proxies.elements();
            while (enumeration.hasMoreElements()) {
                ProxyInfo proxyInfo = (ProxyInfo)enumeration.nextElement();
                if (proxyInfo.network == 0L) {
                    proxy = proxyInfo.proxy;
                    break;
                }
                if ((l & proxyInfo.netmask) != proxyInfo.network) continue;
                proxy = proxyInfo.proxy;
                break;
            }
        }
        return proxy;
    }

    private final void getProxies() {
        ProxyInfo proxyInfo;
        String string;
        Hashtable hashtable = Environment.getProperties("jacorb.ProxyServer.URL-");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = (String)hashtable.get(string2);
            try {
                proxyInfo = this.getProxyInfo(string2, string);
                this.proxies.add(proxyInfo);
            }
            catch (BAD_PARAM bAD_PARAM) {
                // empty catch block
            }
        }
        string = Environment.getProperty("jacorb.ProxyServer.URL", "");
        if (string.length() > 0) {
            proxyInfo = new ProxyInfo();
            try {
                proxyInfo.proxy = this.getProxy(string);
                this.proxies.add(proxyInfo);
            }
            catch (BAD_PARAM bAD_PARAM) {
                // empty catch block
            }
        }
    }

    private final ProxyInfo getProxyInfo(String string, String string2) throws BAD_PARAM {
        ProxyInfo proxyInfo = new ProxyInfo();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        if (stringTokenizer.countTokens() == 3) {
            stringTokenizer.nextToken();
            proxyInfo.network = ProxyClientForwardInterceptor.ipToInt(stringTokenizer.nextToken());
            proxyInfo.netmask = ProxyClientForwardInterceptor.ipToInt(stringTokenizer.nextToken());
            proxyInfo.network &= proxyInfo.netmask;
        } else {
            Debug.output(1, "ProxyClientForwardInterceptor Invalid proxy: " + string);
            throw new BAD_PARAM();
        }
        proxyInfo.proxy = this.getProxy(string2);
        return proxyInfo;
    }

    private final Proxy getProxy(String string) throws BAD_PARAM {
        try {
            return ProxyHelper.narrow(this.orb.string_to_object(string));
        }
        catch (Exception exception) {
            Debug.output(1, "ProxyClientForwardInterceptor failed to resolve Proxy URL: " + string);
            throw new BAD_PARAM();
        }
    }

    private final void getSubnet() throws BAD_PARAM {
        this.localNetmask = ProxyClientForwardInterceptor.ipToInt(Environment.getProperty("jacorb.ProxyServer.Netmask", ""));
        this.localNetwork = ProxyClientForwardInterceptor.ipToInt(Environment.getProperty("jacorb.ProxyServer.Network", ""));
        this.localNetwork &= this.localNetmask;
    }

    private static final long ipToInt(String string) throws BAD_PARAM {
        long l = 0L;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (string.length() > 0) {
            if (stringTokenizer.countTokens() == 4) {
                try {
                    while (stringTokenizer.hasMoreTokens()) {
                        l += (long)Integer.parseInt(stringTokenizer.nextToken());
                        l <<= 8;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.output(1, "ProxyClientForwardInterceptor Invalid address: " + string);
                    throw new BAD_PARAM();
                }
            } else {
                Debug.output(1, "ProxyClientForwardInterceptor Invalid address: " + string);
                throw new BAD_PARAM();
            }
        }
        return l;
    }

    public ProxyClientForwardInterceptor(ORBInitInfo oRBInitInfo, Codec codec) {
        this.orb = ((ORBInitInfoImpl)oRBInitInfo).getORB();
        this.codec = codec;
        this.getProxies();
        this.getSubnet();
    }

    private class ProxyInfo {
        long network = 0L;
        long netmask = 0L;
        Proxy proxy = null;

        ProxyInfo() {
        }
    }
}

