/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa.util;

import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.util.LogTrace;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.PortableServer.POAManagerPackage.State;

public class LogWriter
implements LogTrace {
    private LogTrace delegate;
    private String prefix;
    private boolean isSystemId;
    private boolean isLogFileOut;

    public boolean test(int n) {
        return Environment.verbosityLevel() >= n;
    }

    public void printLog(byte[] byArray, String string) {
        this.printLog_("oid: " + POAUtil.convert(byArray, this.isSystemId) + " - " + string);
    }

    public void printLog(ServerRequest serverRequest, String string) {
        this.printLog_("rid: " + serverRequest.requestId() + " oid: " + POAUtil.convert(serverRequest.objectId(), this.isSystemId) + " opname: " + serverRequest.operation() + " - " + string);
    }

    public void printLog(ServerRequest serverRequest, State state, String string) {
        this.printLog_("rid: " + serverRequest.requestId() + " oid: " + POAUtil.convert(serverRequest.objectId(), this.isSystemId) + " opname: " + serverRequest.operation() + " - " + string + " (in state " + POAUtil.convert(state) + ")");
    }

    public void printLog(String string) {
        this.printLog_(string);
    }

    public void printLog(Throwable throwable) {
        this.printLog_(throwable);
    }

    private final void printLog_(String string) {
        if (this.isLogFileOut || this.delegate == null) {
            Debug.output(0, this.prefix + string);
        }
        if (this.delegate != null) {
            this.delegate.printLog(string);
        }
    }

    private final void printLog_(Throwable throwable) {
        if (this.isLogFileOut || this.delegate == null) {
            Debug.output(0, throwable);
        }
        if (this.delegate != null) {
            this.delegate.printLog(throwable);
        }
    }

    public void setLogTrace(LogTrace logTrace) {
        this.delegate = logTrace;
    }

    private LogWriter() {
    }

    public LogWriter(String string, boolean bl) {
        this.prefix = string + " - ";
        this.isSystemId = bl;
        if (Environment.logFileOut() != null) {
            this.isLogFileOut = true;
        }
    }
}

