/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Vector;
import org.jacorb.poa.Current;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.RPPoolManagerListener;
import org.jacorb.poa.RequestProcessor;
import org.jacorb.poa.except.POAInternalError;

public class RPPoolManager {
    private RPPoolManagerListener pmListener;
    private Current current;
    private Vector pool;
    private int pool_size;
    private int max_pool_size;
    private int min_pool_size;
    private boolean inUse = false;

    private final void addProcessor() throws IllegalAccessException, InstantiationException {
        RequestProcessor requestProcessor = new RequestProcessor(this);
        this.current._addContext(requestProcessor, requestProcessor);
        requestProcessor.setDaemon(true);
        this.pool.addElement(requestProcessor);
        ++this.pool_size;
        requestProcessor.start();
    }

    protected synchronized void addRPPoolManagerListener(RPPoolManagerListener rPPoolManagerListener) {
        this.pmListener = EventMulticaster.add(this.pmListener, rPPoolManagerListener);
    }

    protected synchronized void destroy() {
        if (this.pool == null || !this.inUse) {
            return;
        }
        Object[] objectArray = new RequestProcessor[this.pool.size()];
        this.pool.copyInto(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            if (((RequestProcessor)objectArray[n]).isActive()) {
                throw new POAInternalError("error: request processor is active (RequestProcessorPM.destroy)");
            }
            this.pool.removeElement(objectArray[n]);
            --this.pool_size;
            this.current._removeContext((Thread)objectArray[n]);
            ((Thread)objectArray[n]).stop();
            ++n;
        }
        this.inUse = false;
    }

    protected int getPoolCount() {
        return this.pool == null ? 0 : this.pool.size();
    }

    protected int getPoolSize() {
        return this.pool_size;
    }

    protected synchronized RequestProcessor getProcessor() {
        if (!this.inUse) {
            this.init();
            this.inUse = true;
        }
        if (this.pool.size() == 0 && this.pool_size < this.max_pool_size) {
            try {
                this.addProcessor();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        while (this.pool.size() == 0) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        RequestProcessor requestProcessor = (RequestProcessor)this.pool.lastElement();
        this.pool.removeElement(requestProcessor);
        if (this.pmListener != null) {
            this.pmListener.processorRemovedFromPool(requestProcessor, this.pool.size(), this.pool_size);
        }
        return requestProcessor;
    }

    private final void init() {
        this.pool = new Vector(this.max_pool_size);
        int n = 0;
        while (n < this.min_pool_size) {
            try {
                this.addProcessor();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
    }

    protected synchronized void releaseProcessor(RequestProcessor requestProcessor) {
        if (this.pool.size() < this.min_pool_size) {
            this.pool.addElement(requestProcessor);
            this.notifyAll();
        } else {
            --this.pool_size;
            this.current._removeContext(requestProcessor);
            requestProcessor.end();
        }
        if (this.pmListener != null) {
            this.pmListener.processorAddedToPool(requestProcessor, this.pool.size(), this.pool_size);
        }
    }

    protected synchronized void removeRPPoolManagerListener(RPPoolManagerListener rPPoolManagerListener) {
        this.pmListener = EventMulticaster.remove(this.pmListener, rPPoolManagerListener);
    }

    protected synchronized void setPoolSize(int n, int n2) {
        this.min_pool_size = n;
        this.max_pool_size = n2;
        while (this.pool_size < this.min_pool_size) {
            try {
                this.addProcessor();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private RPPoolManager() {
    }

    protected RPPoolManager(Current current, int n, int n2) {
        this.current = current;
        this.max_pool_size = n2;
        this.min_pool_size = n;
    }
}

