/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.poa.AOMListener;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.POA;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.util.ByteArrayKey;
import org.jacorb.poa.util.LogTrace;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.poa.util.StringPair;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;

public class AOM {
    private AOMListener aomListener;
    private boolean unique;
    private boolean singleThreaded;
    private LogTrace logTrace;
    private Hashtable objectMap = new Hashtable();
    private Hashtable servantMap;
    private Vector etherealisationList = new Vector();
    private Vector incarnationList = new Vector();
    private Vector deactivationList = new Vector();
    private Object deactivationListLock = new Object();

    protected synchronized void add(byte[] byArray, Servant servant) throws ObjectAlreadyActive, ServantAlreadyActive {
        ByteArrayKey byteArrayKey = POAUtil.oid_to_bak(byArray);
        while (this.incarnationList.contains(byteArrayKey) || this.etherealisationList.contains(byteArrayKey)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.objectMap.containsKey(byteArrayKey)) {
            throw new ObjectAlreadyActive();
        }
        if (this.unique && this.servantMap.containsKey(servant)) {
            throw new ServantAlreadyActive();
        }
        this.objectMap.put(byteArrayKey, servant);
        if (this.unique) {
            this.servantMap.put(servant, byteArrayKey);
        }
        if (this.logTrace.test(2)) {
            this.logTrace.printLog(byArray, "object is activated");
        }
        if (this.aomListener != null) {
            this.aomListener.objectActivated(byArray, servant, this.objectMap.size());
        }
    }

    protected synchronized void addAOMListener(AOMListener aOMListener) {
        this.aomListener = EventMulticaster.add(this.aomListener, aOMListener);
    }

    protected boolean contains(Servant servant) {
        if (this.unique) {
            return this.servantMap.containsKey(servant);
        }
        return this.objectMap.contains(servant);
    }

    protected synchronized StringPair[] deliverContent() {
        StringPair[] stringPairArray = new StringPair[this.objectMap.size()];
        Enumeration enumeration = this.objectMap.keys();
        int n = 0;
        while (n < stringPairArray.length) {
            ByteArrayKey byteArrayKey = (ByteArrayKey)enumeration.nextElement();
            stringPairArray[n] = new StringPair(POAUtil.oid_to_string(byteArrayKey.getBytes()), this.objectMap.get(byteArrayKey).getClass().getName());
            ++n;
        }
        return stringPairArray;
    }

    protected byte[] getObjectId(Servant servant) {
        if (!this.unique) {
            throw new POAInternalError("error: not UNIQUE_ID policy (getObjectId)");
        }
        ByteArrayKey byteArrayKey = (ByteArrayKey)this.servantMap.get(servant);
        if (byteArrayKey != null) {
            return POAUtil.bak_to_oid(byteArrayKey);
        }
        return null;
    }

    protected Servant getServant(byte[] byArray) {
        return (Servant)this.objectMap.get(POAUtil.oid_to_bak(byArray));
    }

    protected synchronized Servant incarnate(byte[] byArray, ServantActivator servantActivator, org.omg.PortableServer.POA pOA) throws ForwardRequest {
        ByteArrayKey byteArrayKey = POAUtil.oid_to_bak(byArray);
        Servant servant = null;
        if (this.logTrace.test(0)) {
            this.logTrace.printLog(byArray, " incarnate");
        }
        while (!this.incarnationList.isEmpty() || !this.etherealisationList.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.objectMap.containsKey(byteArrayKey)) {
            return (Servant)this.objectMap.get(byteArrayKey);
        }
        this.incarnationList.addElement(byteArrayKey);
        try {
            servant = servantActivator.incarnate(byArray, pOA);
        }
        finally {
            Object var7_8 = null;
            this.incarnationList.removeElement(byteArrayKey);
            this.notifyAll();
        }
        if (servant == null) {
            if (this.logTrace.test(0)) {
                this.logTrace.printLog(byArray, "servant is not incarnated (incarnate returns null)");
            }
            return null;
        }
        if (this.unique && this.servantMap.containsKey(servant)) {
            if (this.logTrace.test(0)) {
                this.logTrace.printLog(byArray, "servant is not incarnated (unique_id policy is violated)");
            }
            return null;
        }
        if (this.logTrace.test(2)) {
            this.logTrace.printLog(byArray, "servant is incarnated");
        }
        if (this.aomListener != null) {
            this.aomListener.servantIncarnated(byArray, servant);
        }
        try {
            this.add(byArray, servant);
        }
        catch (ObjectAlreadyActive objectAlreadyActive) {
            throw new POAInternalError("error: object already active (AOM.incarnate)");
        }
        catch (ServantAlreadyActive servantAlreadyActive) {
            throw new POAInternalError("error: servant already active (AOM.incarnate)");
        }
        return servant;
    }

    protected void remove(byte[] byArray, RequestController requestController, ServantActivator servantActivator, POA pOA, boolean bl) throws ObjectNotActive {
        ByteArrayKey byteArrayKey = POAUtil.oid_to_bak(byArray);
        Object object = this.deactivationListLock;
        synchronized (object) {
            if (!this.objectMap.containsKey(byteArrayKey) || this.deactivationList.contains(byteArrayKey)) {
                throw new ObjectNotActive();
            }
            this.deactivationList.addElement(byteArrayKey);
        }
        byte[] byArray2 = byArray;
        RequestController requestController2 = requestController;
        ServantActivator servantActivator2 = servantActivator;
        POA pOA2 = pOA;
        boolean bl2 = bl;
        Thread thread = new Thread(this, byArray2, requestController2, servantActivator2, pOA2, bl2, "AOM_RemovalThread"){
            private final /* synthetic */ AOM this$0;
            private final /* synthetic */ byte[] val$oid_;
            private final /* synthetic */ RequestController val$requestController_;
            private final /* synthetic */ ServantActivator val$servantActivator_;
            private final /* synthetic */ POA val$poa_;
            private final /* synthetic */ boolean val$cleanupInProgress_;

            public final void run() {
                AOM.access$0(this.this$0, this.val$oid_, this.val$requestController_, this.val$servantActivator_, this.val$poa_, this.val$cleanupInProgress_);
            }
            {
                this.val$oid_ = byArray;
                this.val$requestController_ = requestController;
                this.val$servantActivator_ = servantActivator;
                this.val$poa_ = pOA;
                this.val$cleanupInProgress_ = bl;
                this.this$0 = aOM;
                this.constructor$0(aOM, string);
            }

            private final void constructor$0(AOM aOM, String string) {
            }
        };
        thread.start();
    }

    /*
     * Unable to fully structure code
     */
    private final synchronized void _remove(byte[] var1_1, RequestController var2_2, ServantActivator var3_3, POA var4_4, boolean var5_5) {
        block17: {
            var6_6 = POAUtil.oid_to_bak(var1_1);
            var7_7 = null;
            if (!this.objectMap.containsKey(var6_6)) {
                this.deactivationList.removeElement(var6_6);
                return;
            }
            if (var2_2 != null) {
                var2_2.waitForObjectCompletion(var1_1);
            }
            this.deactivationList.removeElement(var6_6);
            var7_7 = (Servant)this.objectMap.get(var6_6);
            if (var7_7 == null) {
                return;
            }
            this.objectMap.remove(var6_6);
            if (this.unique) {
                this.servantMap.remove(var7_7);
            }
            if (this.logTrace.test(2)) {
                this.logTrace.printLog(var1_1, "object is deactivated");
            }
            if (this.aomListener != null) {
                this.aomListener.objectDeactivated(var1_1, var7_7, this.objectMap.size());
            }
            if (var3_3 != null) ** GOTO lbl31
            var2_2.freeObject(var1_1);
            return;
lbl-1000:
            // 1 sources

            {
                try {
                    this.wait();
                    continue;
                }
                catch (InterruptedException var8_8) {
                    // empty catch block
                }
lbl31:
                // 3 sources

                ** while (!this.incarnationList.isEmpty() || !this.etherealisationList.isEmpty())
            }
lbl32:
            // 1 sources

            this.etherealisationList.addElement(var6_6);
            try {
                block16: {
                    var3_3.etherealize(var1_1, var4_4, var7_7, var5_5, this.contains(var7_7));
                    if (this.logTrace.test(2)) {
                        this.logTrace.printLog(var1_1, "servant is etherealized");
                    }
                    if (this.aomListener == null) break block16;
                    this.aomListener.servantEtherialized(var1_1, var7_7);
                }
                var9_10 = null;
                this.etherealisationList.removeElement(var6_6);
            }
            catch (Throwable var8_9) {
                var9_12 = null;
                this.etherealisationList.removeElement(var6_6);
                this.notifyAll();
                throw var8_9;
            }
            this.notifyAll();
            {
                break block17;
                catch (SystemException var10_13) {
                    if (this.logTrace.test(1)) {
                        this.logTrace.printLog(var1_1, "exception occurred during servant etherialisation: " + var10_13);
                    }
                    var9_11 = null;
                    this.etherealisationList.removeElement(var6_6);
                    this.notifyAll();
                }
            }
        }
        if (var2_2 != null) {
            var2_2.freeObject(var1_1);
        }
    }

    protected void removeAll(ServantActivator servantActivator, POA pOA, boolean bl) {
        Enumeration enumeration = this.objectMap.keys();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = POAUtil.bak_to_oid((ByteArrayKey)enumeration.nextElement());
            this._remove(byArray, null, servantActivator, pOA, bl);
        }
    }

    protected synchronized void removeAOMListener(AOMListener aOMListener) {
        this.aomListener = EventMulticaster.remove(this.aomListener, aOMListener);
    }

    protected int size() {
        return this.objectMap.size();
    }

    public void printSizes() {
        System.out.println("AOM: objectMap " + this.size() + " servantMap " + this.servantMap.size());
    }

    static /* synthetic */ void access$0(AOM aOM, byte[] byArray, RequestController requestController, ServantActivator servantActivator, POA pOA, boolean bl) {
        aOM._remove(byArray, requestController, servantActivator, pOA, bl);
    }

    private AOM() {
    }

    protected AOM(boolean bl, boolean bl2, LogTrace logTrace) {
        this.unique = bl;
        this.singleThreaded = bl2;
        this.logTrace = logTrace;
        if (this.unique) {
            this.servantMap = new Hashtable();
        }
    }
}

