/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.lang.reflect.Constructor;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.DefaultServerSocketFactory;
import org.jacorb.orb.factory.DefaultSocketFactory;
import org.jacorb.orb.factory.PortRangeSocketFactory;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;

public class SocketFactoryManager {
    private static final String FACTORY_PROP = "jacorb.net.socket_factory";
    private static final String SERVER_FACTORY_PROP = "jacorb.net.server_socket_factory";
    private static SocketFactory socketFactory = null;
    private static ServerSocketFactory serverFactory = null;
    private static /* synthetic */ Class class$Lorg$jacorb$orb$ORB;

    public static synchronized SocketFactory getSocketFactory(ORB oRB) {
        String string;
        if (socketFactory != null) {
            return socketFactory;
        }
        String string2 = Environment.getProperty(FACTORY_PROP);
        socketFactory = string2 == null || string2.length() == 0 ? ((string = Environment.getProperty("jacorb.net.socket_factory.port.min")) != null && string.length() > 0 ? new PortRangeSocketFactory() : new DefaultSocketFactory()) : SocketFactoryManager.getFactory(oRB, string2);
        return socketFactory;
    }

    public static synchronized ServerSocketFactory getServerSocketFactory(ORB oRB) {
        if (serverFactory != null) {
            return serverFactory;
        }
        String string = Environment.getProperty(SERVER_FACTORY_PROP);
        serverFactory = string == null || string.length() == 0 ? new DefaultServerSocketFactory() : SocketFactoryManager.getServerFactory(oRB, string);
        return serverFactory;
    }

    private static final SocketFactory getFactory(ORB oRB, String string) {
        Object object = SocketFactoryManager.getFactoryObject(oRB, string);
        if (object instanceof SocketFactory) {
            return (SocketFactory)object;
        }
        throw new RuntimeException("Custom factory " + string + " does not implement SocketFactory");
    }

    private static final ServerSocketFactory getServerFactory(ORB oRB, String string) {
        Object object = SocketFactoryManager.getFactoryObject(oRB, string);
        if (object instanceof ServerSocketFactory) {
            return (ServerSocketFactory)object;
        }
        throw new RuntimeException("Custom factory " + string + " does not implement ServerSocketFactory");
    }

    private static final Object getFactoryObject(ORB oRB, String string) {
        Object object;
        Constructor<?> constructor = null;
        try {
            Class<?> clazz = Class.forName(string);
            if (oRB != null) {
                try {
                    constructor = clazz.getConstructor(class$Lorg$jacorb$orb$ORB != null ? class$Lorg$jacorb$orb$ORB : (class$Lorg$jacorb$orb$ORB = SocketFactoryManager.class$("org.jacorb.orb.ORB")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = constructor != null ? constructor.newInstance(oRB) : clazz.newInstance();
        }
        catch (Exception exception) {
            Debug.output(257, exception);
            throw new RuntimeException("Failed to create custom socket factory: " + string);
        }
        Debug.output(2, "SocketFactoryManager: created " + object.getClass().getName());
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

