/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.dsi;

import java.util.Enumeration;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.NVList;
import org.jacorb.orb.NamedValue;
import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.connection.GIOPConnection;
import org.jacorb.orb.connection.Messages;
import org.jacorb.orb.connection.ReplyOutputStream;
import org.jacorb.orb.connection.RequestInputStream;
import org.jacorb.orb.portableInterceptor.ServerInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Debug;
import org.omg.CORBA.Any;
import org.omg.CORBA.Context;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.Dynamic.Parameter;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;

public class ServerRequest
extends org.omg.CORBA.ServerRequest
implements ResponseHandler {
    private RequestInputStream in;
    private ReplyOutputStream out;
    private GIOPConnection connection;
    private int status = 0;
    private byte[] oid;
    private byte[] object_key;
    private Object reference = null;
    private String[] rest_of_name = null;
    private boolean stream_based;
    private SystemException sys_ex;
    private org.omg.PortableServer.ForwardRequest location_forward;
    private Any ex;
    private Any result;
    private NVList args;
    private ORB orb;
    private boolean usePreconstructedReply = false;
    private ServerRequestInfoImpl info = null;

    public void setRemainingPOAName(String[] stringArray) {
        this.rest_of_name = stringArray;
    }

    public String[] remainingPOAName() {
        return this.rest_of_name;
    }

    public String operation() {
        return this.in.req_hdr.operation;
    }

    public Any result() {
        if (this.stream_based) {
            Any any = this.orb.create_any();
            CDROutputStream cDROutputStream = (CDROutputStream)any.create_output_stream();
            byte[] byArray = this.out.getBody();
            cDROutputStream.setBuffer(byArray);
            cDROutputStream.skip(byArray.length);
            return any;
        }
        return this.result;
    }

    public org.omg.CORBA.NVList arguments() {
        if (this.stream_based) {
            throw new RuntimeException("This ServerRequest is stream-based!");
        }
        return this.args;
    }

    public Any except() {
        if (this.stream_based) {
            throw new RuntimeException("This ServerRequest is stream-based!");
        }
        return this.ex;
    }

    public ReplyStatusType_1_2 status() {
        return ReplyStatusType_1_2.from_int(this.status);
    }

    public Context ctx() {
        return null;
    }

    public void arguments(org.omg.CORBA.NVList nVList) {
        this.args = (NVList)nVList;
        if (this.args != null) {
            this.in.mark(0);
            Parameter[] parameterArray = this.args.enumerate();
            while (parameterArray.hasMoreElements()) {
                org.omg.CORBA.NamedValue namedValue = (org.omg.CORBA.NamedValue)parameterArray.nextElement();
                if (namedValue.flags() == 2) continue;
                try {
                    namedValue.value().read_value(this.in, namedValue.value().type());
                }
                catch (Exception exception) {
                    throw new MARSHAL("Couldn't unmarshal object of type " + namedValue.value().type() + " in ServerRequest.");
                }
            }
            try {
                this.in.reset();
            }
            catch (Exception exception) {
                throw new UNKNOWN("Could not reset input stream");
            }
            if (this.info != null) {
                IDLEntity iDLEntity;
                parameterArray = new Parameter[this.args.count()];
                int n = 0;
                while (n < parameterArray.length) {
                    try {
                        org.omg.CORBA.NamedValue namedValue = this.args.item(n);
                        iDLEntity = null;
                        if (namedValue.flags() == 1) {
                            iDLEntity = ParameterMode.PARAM_IN;
                        } else if (namedValue.flags() == 2) {
                            iDLEntity = ParameterMode.PARAM_OUT;
                        } else if (namedValue.flags() == 3) {
                            iDLEntity = ParameterMode.PARAM_INOUT;
                        }
                        parameterArray[n] = new Parameter(namedValue.value(), (ParameterMode)iDLEntity);
                    }
                    catch (Exception exception) {
                        Debug.output(2, exception);
                    }
                    ++n;
                }
                this.info.arguments = parameterArray;
                ServerInterceptorIterator serverInterceptorIterator = this.orb.getInterceptorManager().getServerIterator();
                try {
                    serverInterceptorIterator.iterate(this.info, (short)1);
                }
                catch (UserException userException) {
                    if (userException instanceof ForwardRequest) {
                        iDLEntity = (ForwardRequest)userException;
                        this.setLocationForward(new org.omg.PortableServer.ForwardRequest(((ForwardRequest)iDLEntity).forward));
                    }
                }
                catch (SystemException systemException) {
                    this.setSystemException(systemException);
                }
                this.info = null;
            }
        }
    }

    public void set_result(Any any) {
        if (this.stream_based) {
            throw new RuntimeException("This ServerRequest is stream-based!");
        }
        this.result = any;
    }

    public void set_exception(Any any) {
        if (this.stream_based) {
            throw new RuntimeException("This ServerRequest is stream-based!");
        }
        this.ex = any;
        this.status = 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reply() {
        if (!this.responseExpected()) return;
        if (this.usePreconstructedReply) {
            try {
                try {
                    this.connection.sendMessage(this.out);
                    return;
                }
                catch (Exception exception) {
                    Debug.output(2, exception);
                    System.err.println("ServerRequest: Error replying to request!");
                    return;
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
        Debug.output(6, "ServerRequest: reply to " + this.operation());
        try {
            if (this.out == null) {
                this.out = new ReplyOutputStream(this.requestId(), ReplyStatusType_1_2.from_int(this.status), this.in.getGIOPMinor(), this.in.isLocateRequest());
            }
            if (!this.stream_based) {
                if (this.status == 1) {
                    this.out.write_string(this.ex.type().id());
                    this.ex.write_value(this.out);
                } else if (this.status == 0) {
                    if (this.result != null) {
                        this.result.write_value(this.out);
                    }
                    if (this.args != null) {
                        Enumeration enumeration = this.args.enumerate();
                        while (enumeration.hasMoreElements()) {
                            NamedValue namedValue = (NamedValue)enumeration.nextElement();
                            if (namedValue.flags() == 1) continue;
                            try {
                                namedValue.send(this.out);
                            }
                            catch (Exception exception) {
                                throw new MARSHAL("Couldn't return (in)out arg of type " + namedValue.value().type() + " in ServerRequest.");
                            }
                        }
                    }
                }
            }
            if (this.status == 3) {
                this.out.write_Object(this.location_forward.forward_reference);
            } else if (this.status == 2) {
                SystemExceptionHelper.write(this.out, this.sys_ex);
            }
            this.connection.sendMessage(this.out);
            return;
        }
        catch (Exception exception) {
            Debug.output(2, exception);
            System.err.println("ServerRequest: Error replying to request!");
        }
    }

    public OutputStream createReply() {
        this.stream_based = true;
        if (this.out != null) {
            throw new Error("Internal: reply already created!");
        }
        if (!this.stream_based) {
            throw new Error("Internal: ServerRequest not stream-based!");
        }
        this.out = new ReplyOutputStream(this.requestId(), ReplyStatusType_1_2.NO_EXCEPTION, this.in.getGIOPMinor(), this.in.isLocateRequest());
        return this.out;
    }

    public OutputStream createExceptionReply() {
        this.stream_based = true;
        this.status = 1;
        this.out = new ReplyOutputStream(this.requestId(), ReplyStatusType_1_2.USER_EXCEPTION, this.in.getGIOPMinor(), this.in.isLocateRequest());
        return this.out;
    }

    public void setSystemException(SystemException systemException) {
        Debug.output(2, systemException);
        this.status = 2;
        this.out = new ReplyOutputStream(this.requestId(), ReplyStatusType_1_2.SYSTEM_EXCEPTION, this.in.getGIOPMinor(), this.in.isLocateRequest());
        this.sys_ex = systemException;
    }

    public void setLocationForward(org.omg.PortableServer.ForwardRequest forwardRequest) {
        Debug.output(2, "Location Forward");
        this.status = 3;
        this.out = new ReplyOutputStream(this.requestId(), ReplyStatusType_1_2.LOCATION_FORWARD, this.in.getGIOPMinor(), this.in.isLocateRequest());
        this.location_forward = forwardRequest;
    }

    public CDRInputStream getInputStream() {
        this.stream_based = true;
        return this.in;
    }

    public ReplyOutputStream getReplyOutputStream() {
        if (this.out == null) {
            this.createReply();
        }
        this.stream_based = true;
        return this.out;
    }

    public boolean responseExpected() {
        return Messages.responseExpected(this.in.req_hdr.response_flags);
    }

    public SystemException getSystemException() {
        return this.sys_ex;
    }

    public int requestId() {
        return this.in.req_hdr.request_id;
    }

    public byte[] objectKey() {
        return this.object_key;
    }

    public ServiceContext[] getServiceContext() {
        return this.in.req_hdr.service_context;
    }

    public byte[] objectId() {
        return this.oid;
    }

    public boolean streamBased() {
        return this.stream_based;
    }

    public void setReference(Object object) {
        this.reference = object;
    }

    public Object getReference() {
        return this.reference;
    }

    public RequestInputStream get_in() {
        return this.in;
    }

    public ReplyOutputStream get_out() {
        if (this.out == null) {
            this.out = new ReplyOutputStream(this.requestId(), ReplyStatusType_1_2.NO_EXCEPTION, this.in.getGIOPMinor(), this.in.isLocateRequest());
        }
        return this.out;
    }

    public void setServerRequestInfo(ServerRequestInfoImpl serverRequestInfoImpl) {
        this.info = serverRequestInfoImpl;
    }

    public Object getForwardReference() {
        if (this.location_forward != null) {
            return this.location_forward.forward_reference;
        }
        return null;
    }

    public GIOPConnection getConnection() {
        return this.connection;
    }

    public void setUsePreconstructedReply(boolean bl) {
        this.usePreconstructedReply = bl;
    }

    public ServerRequest(ORB oRB, RequestInputStream requestInputStream, GIOPConnection gIOPConnection) {
        this.orb = oRB;
        this.in = requestInputStream;
        this.connection = gIOPConnection;
        this.object_key = oRB.mapObjectKey(requestInputStream.req_hdr.target.object_key());
        this.oid = POAUtil.extractOID(this.object_key);
    }
}

