/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import java.io.IOException;
import java.util.Vector;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.connection.GIOPConnection;
import org.jacorb.orb.connection.MessageOutputStream;
import org.jacorb.orb.connection.Messages;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextHelper;

public class ServiceContextTransportingOutputStream
extends MessageOutputStream {
    protected static ServiceContext[] service_context = new ServiceContext[0];
    private static ServiceContext padding_ctx = new ServiceContext(1245790977, new byte[0]);
    private int header_end = -1;
    private int header_padding = 0;
    private Vector contexts = null;

    protected void markHeaderEnd() {
        this.header_end = this.size();
        this.header_padding = 8 - this.size() % 8;
        this.header_padding = this.header_padding == 8 ? 0 : this.header_padding;
        this.skip(this.header_padding);
    }

    private final int getHeaderEnd() {
        return this.header_end;
    }

    private final int getBodyBegin() {
        return this.header_end + this.header_padding;
    }

    private final int getHeaderPadding() {
        return this.header_padding;
    }

    private final boolean hasBody() {
        return this.size() > this.getBodyBegin();
    }

    public void insertMsgSize() {
        if (this.header_padding == 0) {
            this.insertMsgSize(this.size() - Messages.MSG_HEADER_SIZE);
        } else if (this.size() > this.header_end + this.header_padding) {
            this.insertMsgSize(this.size() - Messages.MSG_HEADER_SIZE);
        } else {
            this.insertMsgSize(this.size() - this.header_padding - Messages.MSG_HEADER_SIZE);
            this.reduceSize(this.header_padding);
        }
    }

    public void write_to(GIOPConnection gIOPConnection) throws IOException {
        if (this.contexts == null || this.contexts.size() == 0) {
            this.insertMsgSize();
            this.write(gIOPConnection, 0, this.size());
        } else {
            switch (this.giop_minor) {
                case 0: 
                case 1: {
                    this.contexts.addElement(padding_ctx);
                    CDROutputStream cDROutputStream = this.createContextStream();
                    int n = 8 - cDROutputStream.size() % 8;
                    int n2 = n = n == 8 ? 0 : n;
                    if (n > 0) {
                        cDROutputStream.reduceSize(4);
                        cDROutputStream.write_ulong(n);
                        cDROutputStream.increaseSize(n);
                    }
                    this.insertMsgSize(this.size() - Messages.MSG_HEADER_SIZE - 4 + cDROutputStream.size());
                    this.write(gIOPConnection, 0, Messages.MSG_HEADER_SIZE);
                    cDROutputStream.write(gIOPConnection, 0, cDROutputStream.size());
                    this.write(gIOPConnection, Messages.MSG_HEADER_SIZE + 4, this.size() - (Messages.MSG_HEADER_SIZE + 4));
                    break;
                }
                case 2: {
                    CDROutputStream cDROutputStream = this.createContextStream();
                    int n = this.getHeaderEnd() - 4 + cDROutputStream.size();
                    int n3 = 8 - n % 8;
                    int n4 = n3 = n3 == 8 ? 0 : n3;
                    if (n3 > 0 && this.hasBody()) {
                        cDROutputStream.increaseSize(n3);
                    }
                    this.insertMsgSize(this.size() - Messages.MSG_HEADER_SIZE - 4 - this.getHeaderPadding() + cDROutputStream.size());
                    this.write(gIOPConnection, 0, this.getHeaderEnd() - 4);
                    cDROutputStream.write(gIOPConnection, 0, cDROutputStream.size());
                    this.write(gIOPConnection, this.getBodyBegin(), this.size() - this.getBodyBegin());
                    break;
                }
                default: {
                    throw new Error("Unknown GIOP minor: " + this.giop_minor);
                }
            }
        }
    }

    public void addServiceContext(ServiceContext serviceContext) {
        if (this.contexts == null) {
            this.contexts = new Vector();
        }
        this.contexts.add(serviceContext);
    }

    public byte[] getBody() {
        byte[] byArray = BufferManager.getInstance().getBuffer(this.size() - this.getBodyBegin());
        System.arraycopy(this.getBufferCopy(), this.getBodyBegin(), byArray, 0, byArray.length);
        return byArray;
    }

    private final CDROutputStream createContextStream() {
        CDROutputStream cDROutputStream = new CDROutputStream(null);
        cDROutputStream.write_ulong(this.contexts.size());
        int n = 0;
        while (n < this.contexts.size()) {
            ServiceContextHelper.write(cDROutputStream, (ServiceContext)this.contexts.elementAt(n));
            ++n;
        }
        return cDROutputStream;
    }
}

