/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import org.jacorb.orb.connection.CloseConnectionException;
import org.jacorb.orb.connection.TCP_IP_Transport;
import org.jacorb.util.Debug;

public class Server_TCP_IP_Transport
extends TCP_IP_Transport {
    private boolean is_ssl;

    public Socket getSocket() {
        return this.socket;
    }

    protected void close(int n) throws IOException {
        Debug.output(2, "Closing TCP connection, reason " + n);
        if (this.socket != null) {
            try {
                Method method = this.socket.getClass().getMethod("shutdownOutput", new Class[0]);
                method.invoke((Object)this.socket, new Object[0]);
                method = this.socket.getClass().getMethod("shutdownInput", new Class[0]);
                method.invoke((Object)this.socket, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.socket.close();
            if (this.in_stream != null) {
                this.in_stream.close();
            }
            if (this.out_stream != null) {
                this.out_stream.close();
            }
        }
        Debug.output(2, "Closed connection (server-side) " + this.connection_info);
        throw new CloseConnectionException();
    }

    protected void waitUntilConnected() throws IOException {
    }

    protected void connect() {
    }

    public boolean isSSL() {
        return this.is_ssl;
    }

    public Server_TCP_IP_Transport(Socket socket, boolean bl) throws IOException {
        this.socket = socket;
        this.is_ssl = bl;
        this.in_stream = socket.getInputStream();
        this.out_stream = new BufferedOutputStream(socket.getOutputStream());
        this.connection_info = socket.getInetAddress().getHostName() + ":" + socket.getPort();
        Debug.output(2, "Opened new server-side TCP/IP transport to " + this.connection_info);
    }
}

