/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import java.io.IOException;
import java.util.StringTokenizer;
import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.connection.CodeSet;
import org.jacorb.orb.connection.GIOPConnection;
import org.jacorb.orb.connection.LocateReplyOutputStream;
import org.jacorb.orb.connection.ReplyOutputStream;
import org.jacorb.orb.connection.RequestInputStream;
import org.jacorb.orb.connection.RequestListener;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.WrongAdapter;

public class ServerRequestListener
implements RequestListener {
    private ORB orb = null;
    private org.jacorb.poa.POA rootPOA = null;
    private boolean require_ssl = false;

    public void requestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        Object object;
        RequestInputStream requestInputStream = new RequestInputStream(this.orb, byArray);
        if (this.require_ssl && !gIOPConnection.isSSL()) {
            ReplyOutputStream replyOutputStream = new ReplyOutputStream(requestInputStream.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, requestInputStream.getGIOPMinor(), false);
            Debug.output(2, "About to reject request because connection is not SSL.");
            SystemExceptionHelper.write(replyOutputStream, new NO_PERMISSION(3, CompletionStatus.COMPLETED_NO));
            try {
                gIOPConnection.sendMessage(replyOutputStream);
            }
            catch (IOException iOException) {
                Debug.output(1, iOException);
            }
            return;
        }
        if (!gIOPConnection.isTCSNegotiated()) {
            if (requestInputStream.getGIOPMinor() == 0) {
                gIOPConnection.markTCSNegotiated();
            } else {
                object = CodeSet.getCodeSetContext(requestInputStream.req_hdr.service_context);
                if (object != null) {
                    gIOPConnection.setCodeSets(((CodeSetContext)object).char_data, ((CodeSetContext)object).wchar_data);
                    Debug.output(3, "Received CodeSetContext. Using " + CodeSet.csName(((CodeSetContext)object).char_data) + " as TCS and " + CodeSet.csName(((CodeSetContext)object).wchar_data) + " as TCSW");
                }
            }
        }
        requestInputStream.setCodeSet(gIOPConnection.getTCS(), gIOPConnection.getTCSW());
        object = null;
        try {
            object = new ServerRequest(this.orb, requestInputStream, gIOPConnection);
        }
        catch (POAInternalError pOAInternalError) {
            Debug.output(1, "WARNING: Received a request with a non-jacorb object key");
            if (requestInputStream.isLocateRequest()) {
                LocateReplyOutputStream locateReplyOutputStream = new LocateReplyOutputStream(requestInputStream.req_hdr.request_id, 0, requestInputStream.getGIOPMinor());
                try {
                    gIOPConnection.sendMessage(locateReplyOutputStream);
                }
                catch (IOException iOException) {
                    Debug.output(1, iOException);
                }
            } else {
                ReplyOutputStream replyOutputStream = new ReplyOutputStream(requestInputStream.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, requestInputStream.getGIOPMinor(), false);
                SystemExceptionHelper.write(replyOutputStream, new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO));
                try {
                    gIOPConnection.sendMessage(replyOutputStream);
                }
                catch (IOException iOException) {
                    Debug.output(1, iOException);
                }
            }
            return;
        }
        this.orb.getBasicAdapter().replyPending();
        this.deliverRequest((ServerRequest)object);
    }

    public void locateRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        this.requestReceived(byArray, gIOPConnection);
    }

    public void cancelRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
    }

    /*
     * Unable to fully structure code
     */
    private final void deliverRequest(ServerRequest var1_1) {
        var2_2 = this.rootPOA;
        try {
            var3_3 = POAUtil.extractPOAName(var1_1.objectKey());
            var4_7 = new StringTokenizer(var3_3, "/");
            var5_8 = new String[var4_7.countTokens()];
            var6_9 = 0;
            while (var4_7.hasMoreTokens()) {
                var5_8[var6_9] = var4_7.nextToken();
                ++var6_9;
            }
            var6_9 = 0;
            while (var6_9 < var5_8.length) {
                block10: {
                    if (var5_8[var6_9].equals("")) break;
                    try {
                        var2_2 = var2_2._getChildPOA(var5_8[var6_9]);
                        break block10;
                    }
                    catch (ParentIsHolding var7_10) {
                        var8_11 = new String[var5_8.length - var6_9];
                        var9_12 = 0;
                        ** while (var9_12 < var6_9)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var8_11[var9_12] = var5_8[var9_12 + var6_9];
                        ++var9_12;
                        continue;
                    }
lbl24:
                    // 1 sources

                    var1_1.setRemainingPOAName(var8_11);
                    break;
                }
                ++var6_9;
            }
            if (var2_2 == null) {
                throw new Error("request POA null!");
            }
            var2_2._invoke(var1_1);
        }
        catch (WrongAdapter var3_4) {
            var1_1.setSystemException(new OBJECT_NOT_EXIST("unknown oid"));
            var1_1.reply();
        }
        catch (SystemException var3_5) {
            var1_1.setSystemException(var3_5);
            var1_1.reply();
        }
        catch (Throwable var3_6) {
            var1_1.setSystemException(new UNKNOWN(var3_6.toString()));
            var1_1.reply();
            var3_6.printStackTrace();
        }
    }

    public ServerRequestListener(org.omg.CORBA.ORB oRB, POA pOA) {
        this.orb = (ORB)oRB;
        this.rootPOA = (org.jacorb.poa.POA)pOA;
        if (Environment.isPropertyOn("jacorb.security.support_ssl")) {
            int n = Environment.getIntProperty("jacorb.security.ssl.server.required_options", 16);
            this.require_ssl = Environment.isPropertyOn("jacorb.security.support_ssl") && (n & 0x60) != 0;
        }
    }
}

