/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.orb.ORB;
import org.jacorb.orb.connection.ClientConnection;
import org.jacorb.orb.connection.Client_TCP_IP_Transport;
import org.jacorb.orb.connection.GIOPConnection;
import org.jacorb.orb.connection.MessageReceptorPool;
import org.jacorb.orb.connection.NoBiDirClientRequestListener;
import org.jacorb.orb.connection.RequestListener;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.TRANSIENT;

public class ConnectionManager {
    public static final String FACTORY_PROP = "jacorb.net.socket_factory";
    private ORB orb = null;
    private Hashtable connections = new Hashtable();
    private SocketFactory socket_factory = null;
    private SocketFactory ssl_socket_factory = null;
    private RequestListener request_listener = null;
    private MessageReceptorPool receptor_pool = null;
    private static /* synthetic */ Class class$Lorg$jacorb$orb$ORB;

    public static String unifyTargetAddress(String string) {
        int n = string.indexOf(":");
        if (n < 0) {
            throw new BAD_PARAM("Missing port in host_and_port string: >" + string + "<");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            string = inetAddress.getHostAddress() + ":" + string3;
        }
        catch (UnknownHostException unknownHostException) {
            throw new TRANSIENT("Unknown host " + string2);
        }
        return string;
    }

    public void setRequestListener(RequestListener requestListener) {
        this.request_listener = requestListener;
    }

    public synchronized ClientConnection getConnection(String string, boolean bl) {
        string = ConnectionManager.unifyTargetAddress(string);
        int n = string.indexOf(":");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        ClientConnection clientConnection = (ClientConnection)this.connections.get(string);
        if (clientConnection == null) {
            int n2 = -1;
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Debug.output(1, "Unable to create port int from string >" + string3 + "<");
                throw new BAD_PARAM();
            }
            if (n2 < 0) {
                n2 += 65536;
            }
            SocketFactory socketFactory = null;
            socketFactory = bl ? this.ssl_socket_factory : this.socket_factory;
            Client_TCP_IP_Transport client_TCP_IP_Transport = new Client_TCP_IP_Transport(string2, n2, socketFactory);
            GIOPConnection gIOPConnection = new GIOPConnection(client_TCP_IP_Transport, this.request_listener, null);
            clientConnection = new ClientConnection(gIOPConnection, this.orb, this, string, true);
            Debug.output(2, "ConnectionManager: created new conn to target " + clientConnection.getInfo());
            this.connections.put(clientConnection.getInfo(), clientConnection);
            this.receptor_pool.connectionCreated(gIOPConnection);
        } else {
            Debug.output(2, "ConnectionManager: found conn to target " + clientConnection.getInfo());
        }
        clientConnection.incClients();
        return clientConnection;
    }

    public synchronized void releaseConnection(ClientConnection clientConnection) {
        clientConnection.decClients();
        if (clientConnection.hasNoMoreClients()) {
            clientConnection.close();
            this.connections.remove(clientConnection.getInfo());
        }
    }

    public synchronized void removeConnection(ClientConnection clientConnection) {
        this.connections.remove(clientConnection.getInfo());
    }

    public synchronized void addConnection(GIOPConnection gIOPConnection, String string) {
        if (!this.connections.containsKey(string)) {
            string = ConnectionManager.unifyTargetAddress(string);
            ClientConnection clientConnection = new ClientConnection(gIOPConnection, this.orb, this, string, false);
            clientConnection.incClients();
            this.connections.put(string, clientConnection);
        }
    }

    public void shutdown() {
        Enumeration enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            ((ClientConnection)enumeration.nextElement()).close();
        }
        Debug.output(3, "ConnectionManager shut down (all connections released)");
        this.connections.clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ConnectionManager(ORB oRB) {
        this.orb = oRB;
        this.socket_factory = SocketFactoryManager.getSocketFactory(oRB);
        if (Environment.isPropertyOn("jacorb.security.support_ssl")) {
            String string = Environment.getProperty("jacorb.ssl.socket_factory");
            if (string == null || string.length() == 0) {
                throw new RuntimeException("SSL support is on, but the property \"jacorb.ssl.socket_factory\" is not set!");
            }
            try {
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(class$Lorg$jacorb$orb$ORB != null ? class$Lorg$jacorb$orb$ORB : (class$Lorg$jacorb$orb$ORB = ConnectionManager.class$("org.jacorb.orb.ORB")));
                this.ssl_socket_factory = (SocketFactory)constructor.newInstance(oRB);
            }
            catch (Exception exception) {
                Debug.output(257, exception);
                throw new RuntimeException("SSL support is on, but the ssl socket factory can't be instanciated (see trace)!");
            }
        }
        this.request_listener = new NoBiDirClientRequestListener();
        this.receptor_pool = MessageReceptorPool.getInstance();
    }
}

