/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.IOP.ServiceContext;

public class CodeSet {
    public static final int ISO8859_1 = 65537;
    public static final int UTF16 = 65801;
    public static final int UTF8 = 0x5010001;

    public static String csName(int n) {
        switch (n) {
            case 65537: {
                return "ISO 8859-1";
            }
            case 65801: {
                return "UTF-16";
            }
            case 0x5010001: {
                return "UTF-8";
            }
        }
        return "Unknown TCS: " + Integer.toHexString(n);
    }

    public static int getTCSDefault() {
        return 65537;
    }

    public static int getTCSWDefault() {
        return 65801;
    }

    public static int getConversionDefault() {
        return 0x5010001;
    }

    public static int selectTCS(CodeSetComponentInfo codeSetComponentInfo) {
        int n = CodeSet.selectCodeSet(codeSetComponentInfo.ForCharData, CodeSet.getTCSDefault());
        if (n == -1) {
            return CodeSet.selectCodeSet(codeSetComponentInfo.ForCharData, CodeSet.getConversionDefault());
        }
        return n;
    }

    public static int selectTCSW(CodeSetComponentInfo codeSetComponentInfo) {
        int n = CodeSet.selectCodeSet(codeSetComponentInfo.ForWcharData, CodeSet.getTCSWDefault());
        if (n == -1) {
            return CodeSet.selectCodeSet(codeSetComponentInfo.ForWcharData, CodeSet.getConversionDefault());
        }
        return n;
    }

    private static final int selectCodeSet(CodeSetComponent codeSetComponent, int n) {
        if (codeSetComponent.native_code_set == n) {
            return n;
        }
        int n2 = 0;
        while (n2 < codeSetComponent.conversion_code_sets.length) {
            if (codeSetComponent.conversion_code_sets[n2] == n) {
                return n;
            }
            ++n2;
        }
        return -1;
    }

    public static ServiceContext createCodesetContext(int n, int n2) {
        CDROutputStream cDROutputStream = new CDROutputStream();
        cDROutputStream.beginEncapsulatedArray();
        CodeSetContextHelper.write(cDROutputStream, new CodeSetContext(n, n2));
        return new ServiceContext(1, cDROutputStream.getBufferCopy());
    }

    public static CodeSetContext getCodeSetContext(ServiceContext[] serviceContextArray) {
        int n = 0;
        while (n < serviceContextArray.length) {
            if (serviceContextArray[n].context_id == 1) {
                CDRInputStream cDRInputStream = new CDRInputStream(null, serviceContextArray[n].context_data);
                cDRInputStream.openEncapsulatedArray();
                return CodeSetContextHelper.read(cDRInputStream);
            }
            ++n;
        }
        return null;
    }
}

