/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.connection.CodeSet;
import org.jacorb.orb.connection.ConnectionListener;
import org.jacorb.orb.connection.ConnectionManager;
import org.jacorb.orb.connection.GIOPConnection;
import org.jacorb.orb.connection.LocateReplyInputStream;
import org.jacorb.orb.connection.MessageOutputStream;
import org.jacorb.orb.connection.Messages;
import org.jacorb.orb.connection.ReplyInputStream;
import org.jacorb.orb.connection.ReplyListener;
import org.jacorb.orb.connection.ReplyPlaceholder;
import org.jacorb.util.Debug;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORB;
import org.omg.IOP.ServiceContext;

public class ClientConnection
implements ReplyListener,
ConnectionListener {
    private GIOPConnection connection = null;
    private ORB orb = null;
    private Hashtable replies = null;
    private int client_count = 0;
    private int id_count = 0;
    private ConnectionManager conn_mg = null;
    private boolean client_initiated = true;
    private String info = null;

    public ServiceContext setCodeSet(ParsedIOR parsedIOR) {
        if (this.isTCSNegotiated()) {
            return null;
        }
        if (parsedIOR.getProfileBody().iiop_version.minor == 0) {
            this.connection.markTCSNegotiated();
            return null;
        }
        CodeSetComponentInfo codeSetComponentInfo = parsedIOR.getCodeSetComponentInfo();
        if (codeSetComponentInfo == null) {
            Debug.output(2, "No CodeSetComponentInfo present in IOR. Will use default CodeSets");
            this.connection.markTCSNegotiated();
            return null;
        }
        int n = CodeSet.selectTCS(codeSetComponentInfo);
        int n2 = CodeSet.selectTCSW(codeSetComponentInfo);
        if (n == -1 || n2 == -1) {
            throw new CODESET_INCOMPATIBLE("WARNING: CodeSet negotiation failed! No matching " + (n == -1 ? "normal" : "wide") + " CodeSet found");
        }
        this.connection.setCodeSets(n, n2);
        Debug.output(3, "Successfully negotiated Codesets. Using " + CodeSet.csName(n) + " as TCS and " + CodeSet.csName(n2) + " as TCSW");
        CDROutputStream cDROutputStream = new CDROutputStream(this.orb);
        cDROutputStream.beginEncapsulatedArray();
        CodeSetContextHelper.write(cDROutputStream, new CodeSetContext(n, n2));
        return new ServiceContext(1, cDROutputStream.getBufferCopy());
    }

    public boolean isTCSNegotiated() {
        return this.connection.isTCSNegotiated();
    }

    public int getTCS() {
        return this.connection.getTCS();
    }

    public int getTCSW() {
        return this.connection.getTCSW();
    }

    public String getInfo() {
        return this.info;
    }

    public synchronized int getId() {
        int n = this.id_count;
        this.id_count += 2;
        return n;
    }

    public void incClients() {
        ++this.client_count;
    }

    public void decClients() {
        --this.client_count;
    }

    public boolean hasNoMoreClients() {
        return this.client_count == 0;
    }

    public boolean isClientInitiated() {
        return this.client_initiated;
    }

    public void sendRequest(MessageOutputStream messageOutputStream, ReplyPlaceholder replyPlaceholder, int n) {
        Integer n2 = new Integer(n);
        Hashtable hashtable = this.replies;
        synchronized (hashtable) {
            this.replies.put(n2, replyPlaceholder);
        }
        this.sendRequest(messageOutputStream);
    }

    public void sendRequest(MessageOutputStream messageOutputStream) {
        try {
            this.connection.sendMessage(messageOutputStream);
        }
        catch (IOException iOException) {
            Debug.output(2, iOException);
            throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void close() {
        this.connection.close();
    }

    public void replyReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        Integer n = new Integer(Messages.getRequestId(byArray));
        ReplyPlaceholder replyPlaceholder = null;
        Hashtable hashtable = this.replies;
        synchronized (hashtable) {
            replyPlaceholder = (ReplyPlaceholder)this.replies.remove(n);
        }
        if (replyPlaceholder != null) {
            replyPlaceholder.replyReceived(new ReplyInputStream(this.orb, byArray));
        } else {
            Debug.output(1, "WARNING: Received an unknown reply");
        }
    }

    public void locateReplyReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        Integer n = new Integer(Messages.getRequestId(byArray));
        ReplyPlaceholder replyPlaceholder = null;
        Hashtable hashtable = this.replies;
        synchronized (hashtable) {
            replyPlaceholder = (ReplyPlaceholder)this.replies.remove(n);
        }
        if (replyPlaceholder != null) {
            replyPlaceholder.replyReceived(new LocateReplyInputStream(this.orb, byArray));
        } else {
            Debug.output(1, "WARNING: Received an unknown reply");
        }
    }

    public void closeConnectionReceived(byte[] byArray, GIOPConnection gIOPConnection) {
    }

    public void connectionClosed() {
        this.streamClosed();
        if (!this.client_initiated) {
            this.conn_mg.removeConnection(this);
        }
    }

    public void connectionTimedOut() {
        Hashtable hashtable = this.replies;
        synchronized (hashtable) {
            if (this.replies.size() > 0) {
                Debug.output(1, "ERROR: Read timed out. Lost " + this.replies.size() + " outstanding replie(s)!");
            }
            Enumeration enumeration = this.replies.keys();
            while (enumeration.hasMoreElements()) {
                ReplyPlaceholder replyPlaceholder = (ReplyPlaceholder)this.replies.remove(enumeration.nextElement());
                replyPlaceholder.timeout();
            }
        }
    }

    public void streamClosed() {
        Hashtable hashtable = this.replies;
        synchronized (hashtable) {
            if (this.replies.size() > 0) {
                Debug.output(1, "ERROR: Abnormal connection termination. Lost " + this.replies.size() + " outstanding replie(s)!");
            }
            Enumeration enumeration = this.replies.keys();
            while (enumeration.hasMoreElements()) {
                ReplyPlaceholder replyPlaceholder = (ReplyPlaceholder)this.replies.remove(enumeration.nextElement());
                replyPlaceholder.cancel();
            }
        }
    }

    public ClientConnection(GIOPConnection gIOPConnection, ORB oRB, ConnectionManager connectionManager, String string, boolean bl) {
        this.connection = gIOPConnection;
        this.orb = oRB;
        this.conn_mg = connectionManager;
        this.info = string;
        this.client_initiated = bl;
        if (!bl) {
            this.id_count = 1;
        }
        gIOPConnection.setReplyListener(this);
        gIOPConnection.setConnectionListener(this);
        this.replies = new Hashtable();
    }
}

