/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.applet.Applet;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ImRAccess;
import org.jacorb.orb.NVList;
import org.jacorb.orb.NamedValue;
import org.jacorb.orb.ORBSingleton;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.ServantDelegate;
import org.jacorb.orb.connection.ConnectionManager;
import org.jacorb.orb.dii.ExceptionList;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.dynany.DynAnyFactoryImpl;
import org.jacorb.orb.portableInterceptor.CodecFactoryImpl;
import org.jacorb.orb.portableInterceptor.IORInfoImpl;
import org.jacorb.orb.portableInterceptor.InterceptorManager;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.poa.POA;
import org.jacorb.poa.POAListener;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDef;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.ServiceInformationHolder;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.MultipleComponentProfileHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedProfile;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableServer.Servant;
import org.omg.SecurityLevel2.Current;

public final class ORB
extends ORBSingleton
implements POAListener {
    private static final String versionString = "1.4.1";
    private static final String dateString = "July 2002";
    private static final String nullIORString = "IOR:00000000000000010000000000000000";
    private Hashtable initial_references = new Hashtable();
    private POA rootpoa;
    private org.jacorb.poa.Current poaCurrent;
    private BasicAdapter basicAdapter;
    private Current securityCurrent = null;
    private InterceptorManager interceptor_manager = null;
    private boolean hasClientInterceptors = false;
    private boolean hasServerInterceptors = false;
    private org.omg.PortableInterceptor.Current piCurrent = new PICurrent();
    private Hashtable knownReferences = null;
    private ConnectionManager connectionManager;
    private BufferManager bufferManager = BufferManager.getInstance();
    protected Map valueFactories = new HashMap();
    private Map objectKeyMap = new HashMap();
    private Properties _props;
    public String[] _args;
    public Applet applet;
    private java.lang.Object orb_synch = new java.lang.Object();
    private boolean run = true;
    private boolean wait = true;
    private boolean shutdown_in_progress = false;
    private boolean destroyed = false;
    private java.lang.Object shutdown_synch = new java.lang.Object();
    private boolean always_add_1_0_Profile = false;
    private ImRAccess imr = null;
    private int persistentPOACount;
    public static final String orb_id = "jacorb:1.4.1";
    private Set requests = Collections.synchronizedSet(new HashSet());
    private Request request = null;
    private Hashtable policy_factories = null;
    private static TCKind kind;
    private static final String[] services;
    private boolean bidir_giop = false;
    static /* synthetic */ Class class$org$omg$CORBA$ORB;
    static /* synthetic */ Class class$org$omg$CORBA$portable$ValueFactory;

    public void putObjectKeyMap(String string, String string2) {
        this.objectKeyMap.put(string, string2);
    }

    public String id() {
        return orb_id;
    }

    public boolean useBiDirGIOP() {
        return this.bidir_giop;
    }

    public void turnOnBiDirGIOP() {
        if (!this.bidir_giop) {
            this.bidir_giop = true;
            this.connectionManager.setRequestListener(this.basicAdapter.getRequestListener());
        }
    }

    synchronized Object _getObject(ParsedIOR parsedIOR) {
        Delegate delegate;
        String string = parsedIOR.getIORString();
        ObjectImpl objectImpl = (ObjectImpl)this.knownReferences.get(string);
        if (objectImpl != null) {
            delegate = (Delegate)objectImpl._get_delegate();
            if (delegate != null) {
                ParsedIOR parsedIOR2 = delegate.getParsedIOR();
                if (parsedIOR2 == null) {
                    this.knownReferences.remove(string);
                    Debug.output(4, "Removing an invalid reference from cache.");
                } else if (parsedIOR.getAddress().equals(parsedIOR2.getAddress())) {
                    return objectImpl._duplicate();
                }
            } else {
                Debug.output(3, "remove stale reference  from cache ");
                this.knownReferences.remove(string);
            }
        }
        delegate = new Delegate(this, parsedIOR);
        objectImpl = delegate.getReference(null);
        if (Environment.cacheReferences()) {
            this.knownReferences.put(string, objectImpl);
        }
        return objectImpl;
    }

    POA findPOA(Delegate delegate, Object object) {
        if (this.rootpoa == null || this.basicAdapter == null) {
            return null;
        }
        String string = null;
        String string2 = Environment.getProperty("jacorb.implname", "");
        try {
            string = POAUtil.extractImplName(delegate.getObjectKey());
        }
        catch (POAInternalError pOAInternalError) {
            Debug.output(3, "ORB.findPOA: reference generated by foreign POA");
            return null;
        }
        if (string == null) {
            if (string2.length() > 0) {
                Debug.output(3, "ORB.findPOA: impl_name mismatch");
                return null;
            }
        } else if (!string2.equals(string)) {
            Debug.output(3, "ORB.findPOA: impl_name mismatch");
            return null;
        }
        try {
            POA pOA = this.rootpoa;
            String string3 = POAUtil.extractPOAName(delegate.getObjectKey());
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals("")) break;
                try {
                    pOA = pOA._getChildPOA(stringArray[n2]);
                }
                catch (ParentIsHolding parentIsHolding) {
                    Debug.output(3, "ORB.findPOA: holding adapter");
                    return null;
                }
                ++n2;
            }
            byte[] byArray = POAUtil.extractOID(object);
            if (pOA.isSystemId() && !pOA.previouslyGeneratedObjectId(byArray)) {
                Debug.output(3, "ORB.findPOA: not a previously generated object key.");
                return null;
            }
            return pOA;
        }
        catch (Exception exception) {
            Debug.output(2, exception);
            Debug.output(3, "ORB.findPOA: nothing found");
            return null;
        }
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    synchronized void _release(Delegate delegate) {
        this.knownReferences.remove(delegate.getParsedIOR().getIORString());
    }

    public Policy create_policy(int n, Any any) throws PolicyError {
        Integer n2 = new Integer(n);
        if (this.policy_factories == null || !this.policy_factories.containsKey(n2)) {
            throw new PolicyError();
        }
        PolicyFactory policyFactory = (PolicyFactory)this.policy_factories.get(n2);
        return policyFactory.create_policy(n, any);
    }

    public boolean hasPolicyFactoryForType(int n) {
        return this.policy_factories != null && this.policy_factories.containsKey(new Integer(n));
    }

    public ContextList create_context_list() {
        throw new NO_IMPLEMENT();
    }

    public org.omg.CORBA.Environment create_environment() {
        throw new NO_IMPLEMENT();
    }

    public OutputStream create_output_stream() {
        return new CDROutputStream(this);
    }

    IOR createIOR(String string, byte[] byArray, boolean bl, POA pOA, Hashtable hashtable) {
        java.lang.Object object;
        IDLEntity iDLEntity;
        String string2 = string.equals("IDL:org/jacorb/imr/ImplementationRepository:1.0") ? this.basicAdapter.getAddress() : this.getServerAddress();
        int n = string.equals("IDL:org/jacorb/imr/ImplementationRepository:1.0") ? this.basicAdapter.getPort() : this.getServerPort();
        if (!bl && Environment.useImR() && Environment.useImREndpoint()) {
            try {
                if (this.imr == null) {
                    try {
                        this.imr = (ImRAccess)Class.forName("org.jacorb.imr.ImRAccessImpl").newInstance();
                        this.imr.connect(this);
                    }
                    catch (Exception exception) {
                        if (exception instanceof INTERNAL) {
                            throw (INTERNAL)exception;
                        }
                        Debug.output(1, exception);
                        throw new INTERNAL(exception.toString());
                    }
                }
                string2 = this.imr.getImRHost();
                n = this.imr.getImRPort();
                Debug.output(2, "New persistent IOR created with ImR at " + string2 + ":" + n);
            }
            catch (Exception exception) {
                Debug.output(6, exception);
            }
        }
        int n2 = 2;
        String string3 = Environment.getProperty("jacorb.giop_minor_version", "2");
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Error("Unable to create int from string >>" + string3 + "<<. " + "(check property \"jacorb.giop_minor_version\")");
        }
        Vector<TaggedComponent> vector = new Vector<TaggedComponent>();
        Vector<TaggedComponent> vector2 = new Vector<TaggedComponent>();
        CDROutputStream cDROutputStream = new CDROutputStream(this);
        cDROutputStream.beginEncapsulatedArray();
        cDROutputStream.write_long(1245790976);
        TaggedComponent taggedComponent = new TaggedComponent(0, cDROutputStream.getBufferCopy());
        if (n2 > 0) {
            vector.addElement(taggedComponent);
        } else {
            vector2.addElement(taggedComponent);
        }
        if (this.interceptor_manager != null && this.interceptor_manager.hasIORInterceptors()) {
            iDLEntity = new IORInfoImpl(this, pOA, vector, vector2, hashtable);
            try {
                this.interceptor_manager.getIORIterator().iterate((IORInfoImpl)iDLEntity);
            }
            catch (Exception exception) {
                Debug.output(2, exception);
            }
        }
        iDLEntity = null;
        Vector<IORInfoImpl> vector3 = new Vector<IORInfoImpl>();
        java.lang.Object[] objectArray = null;
        CDROutputStream cDROutputStream2 = null;
        switch (n2) {
            case 1: 
            case 2: {
                objectArray = new TaggedComponent[vector.size()];
                vector.copyInto(objectArray);
                object = new ProfileBody_1_1(new Version(1, (byte)n2), string2, (short)n, byArray, (TaggedComponent[])objectArray);
                cDROutputStream2 = new CDROutputStream(this);
                cDROutputStream2.beginEncapsulatedArray();
                ProfileBody_1_1Helper.write(cDROutputStream2, (ProfileBody_1_1)object);
                iDLEntity = new TaggedProfile(0, cDROutputStream2.getBufferCopy());
                vector3.addElement((IORInfoImpl)iDLEntity);
                if (!this.always_add_1_0_Profile) break;
            }
            case 0: {
                object = new ProfileBody_1_0(new Version(1, 0), string2, (short)n, byArray);
                cDROutputStream2 = new CDROutputStream(this);
                cDROutputStream2.beginEncapsulatedArray();
                ProfileBody_1_0Helper.write(cDROutputStream2, (ProfileBody_1_0)object);
                iDLEntity = new TaggedProfile(0, cDROutputStream2.getBufferCopy());
                vector3.addElement((IORInfoImpl)iDLEntity);
            }
        }
        if (vector2.size() > 0) {
            objectArray = new TaggedComponent[vector2.size()];
            vector2.copyInto(objectArray);
            cDROutputStream2 = new CDROutputStream(this);
            cDROutputStream2.beginEncapsulatedArray();
            MultipleComponentProfileHelper.write(cDROutputStream2, (TaggedComponent[])objectArray);
            iDLEntity = new TaggedProfile(1, cDROutputStream2.getBufferCopy());
            vector3.addElement((IORInfoImpl)iDLEntity);
        }
        object = new TaggedProfile[vector3.size()];
        vector3.copyInto((java.lang.Object[])object);
        return new IOR(string, (TaggedProfile[])object);
    }

    public Context get_default_context() {
        throw new NO_IMPLEMENT();
    }

    public BasicAdapter getBasicAdapter() {
        if (this.basicAdapter == null) {
            throw new RuntimeException("Adapters not initialized, call POA.init() first");
        }
        return this.basicAdapter;
    }

    public org.jacorb.poa.Current getPOACurrent() {
        if (this.poaCurrent == null) {
            this.poaCurrent = org.jacorb.poa.Current._Current_init();
        }
        return this.poaCurrent;
    }

    public Object getReference(POA pOA, byte[] byArray, String string, boolean bl) {
        try {
            if (string == null) {
                string = "IDL:org.omg/CORBA/Object:1.0";
            }
            IOR iOR = this.createIOR(string, byArray, bl, pOA, null);
            Delegate delegate = new Delegate(this, iOR);
            return delegate.getReference(pOA);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public POA getRootPOA() {
        if (this.rootpoa == null) {
            this.rootpoa = POA._POA_init(this);
            this.rootpoa._addPOAEventListener(this);
            try {
                this.basicAdapter = new BasicAdapter(this, this.rootpoa);
            }
            catch (IOException iOException) {
                System.err.println("ORB: could not initialize Root POA!");
            }
        }
        return this.rootpoa;
    }

    public boolean isApplet() {
        return this.applet != null;
    }

    public Applet getApplet() {
        return this.applet;
    }

    public String[] list_initial_services() {
        Vector vector = new Vector();
        Enumeration enumeration = this.initial_references.keys();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        java.lang.Object[] objectArray = new String[services.length + vector.size()];
        vector.copyInto(objectArray);
        System.arraycopy(services, 0, objectArray, vector.size(), services.length);
        return objectArray;
    }

    public void poaCreated(POA pOA) {
        pOA._addPOAEventListener(this);
        if (pOA.isPersistent()) {
            ++this.persistentPOACount;
            if (this.imr == null && Environment.useImR()) {
                try {
                    this.imr = (ImRAccess)Class.forName("org.jacorb.imr.ImRAccessImpl").newInstance();
                    this.imr.connect(this);
                }
                catch (Exception exception) {
                    if (exception instanceof INTERNAL) {
                        throw (INTERNAL)exception;
                    }
                    Debug.output(1, exception);
                    throw new INTERNAL(exception.toString());
                }
            }
            if (this.imr != null) {
                String string = new String(Environment.implName());
                this.imr.registerPOA(string + "/" + pOA._getQualifiedName(), string, this.getServerAddress(), this.getServerPort());
            }
        }
    }

    private String getServerAddress() {
        String string = Environment.getProperty("jacorb.ior_proxy_host");
        if (string == null) {
            string = this.basicAdapter.getAddress();
        } else {
            Debug.output(514, "Using proxy host " + string + " in IOR");
        }
        return string;
    }

    private int getServerPort() {
        String string = Environment.getProperty("jacorb.ior_proxy_port");
        int n = -1;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Error("Unable to create integer from string >>" + string + "<<. " + "(check property \"jacorb.ior_proxy_port\")");
            }
            if (n < 0) {
                throw new Error("Negative port numbers are not allowed! (check property \"jacorb.ior_proxy_port\")");
            }
            Debug.output(514, "Using proxy port " + n + " in IOR");
        } else {
            n = this.basicAdapter.getPort();
        }
        return n;
    }

    public void poaStateChanged(POA pOA, int n) {
        if ((n == 4 || n == 3) && pOA.isPersistent() && this.imr != null && --this.persistentPOACount == 0) {
            this.imr.setServerDown(new String(Environment.implName()));
        }
    }

    public void referenceCreated(Object object) {
    }

    public boolean get_service_information(short s, ServiceInformationHolder serviceInformationHolder) {
        throw new NO_IMPLEMENT();
    }

    public Object resolve_initial_references(String string) throws InvalidName {
        if (this.initial_references.containsKey(string)) {
            return (Object)this.initial_references.get(string);
        }
        Object object = null;
        String string2 = Environment.getProperty("ORBInitRef." + string);
        if (string2 != null) {
            try {
                object = this.string_to_object(string2);
            }
            catch (Exception exception) {
                Debug.output(1, "ERROR: Could not create initial reference for \"" + string + '\"');
                Debug.output(1, "Please check property \"ORBInitRef." + string + '\"');
                Debug.output(3, exception);
                throw new InvalidName();
            }
        }
        if (string.equals("NameService") && this.isApplet()) {
            String string3 = ObjectUtil.readURL("http://" + this.applet.getCodeBase().getHost() + "/" + "NameService.ior");
            object = this.string_to_object(string3);
            if (object != null && !object._is_a(NamingContextHelper.id())) {
                object = null;
            }
        } else {
            if (string.equals("RootPOA")) {
                return this.getRootPOA();
            }
            if (string.equals("POACurrent")) {
                return this.getPOACurrent();
            }
            if (string.equals("SecurityCurrent")) {
                if (this.securityCurrent == null) {
                    try {
                        Class<?> clazz = Class.forName("org.jacorb.security.level2.CurrentImpl");
                        Constructor<?> constructor = clazz.getConstructor(class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = ORB.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB);
                        this.securityCurrent = (Current)constructor.newInstance(this);
                        Method method = clazz.getDeclaredMethod("init", new Class[0]);
                        method.invoke((java.lang.Object)this.securityCurrent, new java.lang.Object[0]);
                    }
                    catch (Exception exception) {
                        Debug.output(513, exception);
                    }
                }
                object = this.securityCurrent;
            } else if (string.equals("DynAnyFactory")) {
                object = new DynAnyFactoryImpl(this);
            } else {
                if (string.equals("PICurrent")) {
                    return this.piCurrent;
                }
                if (string.equals("CodecFactory")) {
                    object = new CodecFactoryImpl(this);
                } else {
                    throw new InvalidName();
                }
            }
        }
        if (object != null) {
            this.initial_references.put(string, object);
        }
        return object;
    }

    public void register_initial_reference(String string, Object object) throws InvalidName {
        if (string == null || string.length() == 0 || this.initial_references.containsKey(string)) {
            throw new InvalidName();
        }
        Debug.output(4, "Registering initial ref " + string);
        this.initial_references.put(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Debug.output(4, "ORB run");
        try {
            java.lang.Object object = this.orb_synch;
            synchronized (object) {
                while (this.run) {
                    this.orb_synch.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        Debug.output(4, "ORB run, exit");
    }

    public void send_multiple_requests_oneway(org.omg.CORBA.Request[] requestArray) {
        int n = 0;
        while (n < requestArray.length) {
            requestArray[n].send_oneway();
            ++n;
        }
    }

    public void send_multiple_requests_deferred(org.omg.CORBA.Request[] requestArray) {
        int n = 0;
        while (n < requestArray.length) {
            requestArray[n].send_deferred();
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean poll_next_response() {
        if (this.requests.size() == 0) {
            throw new BAD_INV_ORDER(11, CompletionStatus.COMPLETED_NO);
        }
        Set set = this.requests;
        synchronized (set) {
            Iterator iterator = this.requests.iterator();
            while (iterator.hasNext()) {
                Request request = (Request)iterator.next();
                if (!request.poll_response()) continue;
                this.request = request;
                return true;
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public org.omg.CORBA.Request get_next_response() {
        if (this.requests.size() == 0) {
            throw new BAD_INV_ORDER(11, CompletionStatus.COMPLETED_NO);
        }
        Set set = this.requests;
        synchronized (set) {
            Request request = null;
            if (this.request != null) {
                this.request.get_response();
                request = this.request;
                this.request = null;
                return request;
            }
            block2: while (true) {
                Iterator iterator = this.requests.iterator();
                do {
                    if (!iterator.hasNext()) continue block2;
                } while (!(request = (Request)iterator.next()).poll_response());
                break;
            }
            request.get_response();
            return request;
        }
    }

    public void addRequest(org.omg.CORBA.Request request) {
        this.requests.add(request);
    }

    public void removeRequest(org.omg.CORBA.Request request) {
        this.requests.remove(request);
    }

    protected void set_parameters(String[] stringArray, Properties properties) {
        String string;
        if (properties != null) {
            this._props = properties;
            Environment.addProperties(properties);
        }
        if (stringArray != null) {
            this._args = stringArray;
            int n = 0;
            while (n < stringArray.length) {
                int n2;
                String string2;
                string = stringArray[n].trim();
                if (string.startsWith("-ORBInitRef.")) {
                    string2 = string.substring(1);
                    n2 = string2.indexOf(61);
                    Environment.setProperty(string2.substring(0, n2), string2.substring(n2 + 1));
                } else if (string.equals("-ORBInitRef")) {
                    if (stringArray.length - 1 < n + 1) {
                        Debug.output(1, "WARNING: -ORBInitRef argument without value");
                    } else {
                        string2 = stringArray[++n].trim();
                        n2 = string2.indexOf(61);
                        Environment.setProperty("ORBInitRef." + string2.substring(0, n2), string2.substring(n2 + 1));
                    }
                }
                ++n;
            }
        }
        this.connectionManager = new ConnectionManager(this);
        String string3 = Environment.getProperty("jacorb.hashtable_class");
        if (string3 == null || string3.length() == 0) {
            Debug.output(514, "Property \"jacorb.hashtable_class\" not present. Will use default hashtable implementation");
            this.knownReferences = new Hashtable();
        } else {
            try {
                this.knownReferences = (Hashtable)Class.forName(string3).newInstance();
            }
            catch (Exception exception) {
                Debug.output(514, exception);
                this.knownReferences = new Hashtable();
            }
        }
        this.objectKeyMap = Environment.getProperties("jacorb.orb.objectKeyMap", true);
        string = Environment.getProperty("jacorb.orb.print_version");
        if (string != null && string.equals("on")) {
            System.out.println("\tJacORB V 1.4.1, www.jacorb.org");
            System.out.println("\t(C) Gerald Brose, FU Berlin/XTRADYNE Technologies, July 2002");
        }
        this.always_add_1_0_Profile = Environment.isPropertyOn("jacorb.giop.add_1_0_profiles");
        this.interceptorInit();
    }

    protected void set_parameters(Applet applet, Properties properties) {
        this.applet = applet;
        this._props = properties;
        Environment.addProperties(properties);
        this.connectionManager = new ConnectionManager(this);
        String string = Environment.getProperty("jacorb.hashtable_class");
        if (string == null || string.length() == 0) {
            Debug.output(514, "Property \"jacorb.hashtable_class\" not present. Will use default hashtable implementation");
            this.knownReferences = new Hashtable();
        } else {
            try {
                this.knownReferences = (Hashtable)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                Debug.output(514, exception);
                this.knownReferences = new Hashtable();
            }
        }
        this.interceptorInit();
    }

    private void interceptorInit() {
        Vector vector = Environment.getORBInitializers();
        if (vector.size() > 0) {
            ORBInitializer oRBInitializer;
            ORBInitInfoImpl oRBInitInfoImpl = new ORBInitInfoImpl(this);
            int n = 0;
            while (n < vector.size()) {
                try {
                    oRBInitializer = (ORBInitializer)vector.elementAt(n);
                    oRBInitializer.pre_init(oRBInitInfoImpl);
                }
                catch (Exception exception) {
                    Debug.output(0, exception);
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                try {
                    oRBInitializer = (ORBInitializer)vector.elementAt(n2);
                    oRBInitializer.post_init(oRBInitInfoImpl);
                }
                catch (Exception exception) {
                    Debug.output(0, exception);
                }
                ++n2;
            }
            oRBInitInfoImpl.setInvalid();
            Vector vector2 = oRBInitInfoImpl.getClientInterceptors();
            Vector vector3 = oRBInitInfoImpl.getServerInterceptors();
            Vector vector4 = oRBInitInfoImpl.getIORInterceptors();
            this.hasClientInterceptors = vector2.size() > 0;
            boolean bl = this.hasServerInterceptors = vector3.size() > 0;
            if (this.hasClientInterceptors || this.hasServerInterceptors || vector4.size() > 0) {
                this.interceptor_manager = new InterceptorManager(vector2, vector3, vector4, oRBInitInfoImpl.getSlotCount(), this);
            }
            this.policy_factories = oRBInitInfoImpl.getPolicyFactories();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean bl) {
        Debug.output(2, "prepare ORB for going down...");
        if (!this.run) {
            return;
        }
        java.lang.Object object = this.shutdown_synch;
        synchronized (object) {
            Debug.output(2, "ORB going down...");
            if (this.shutdown_in_progress && bl) {
                java.lang.Object object2 = this.shutdown_synch;
                synchronized (object2) {
                    try {
                        this.shutdown_synch.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Debug.output(2, "ORB shutdown complete (1)");
                    return;
                }
            }
            if (this.shutdown_in_progress && !bl) {
                Debug.output(2, "ORB shutdown complete (2)");
                return;
            }
            this.shutdown_in_progress = true;
        }
        if (this.rootpoa != null) {
            this.rootpoa.destroy(true, bl);
        }
        if (this.basicAdapter != null) {
            this.basicAdapter.stopListeners();
        }
        Debug.output(3, "ORB shutdown (cleaning up ORB...)");
        this.connectionManager.shutdown();
        this.knownReferences.clear();
        BufferManager.getInstance().release();
        Debug.output(3, "ORB shutdown (all tables cleared)");
        java.lang.Object object3 = this.shutdown_synch;
        synchronized (object3) {
            this.shutdown_synch.notifyAll();
        }
        Debug.output(3, "ORB shutdown (threads notified)");
        java.lang.Object object4 = this.orb_synch;
        synchronized (object4) {
            this.run = false;
            this.orb_synch.notifyAll();
        }
        Debug.output(2, "ORB shutdown complete");
    }

    public void destroy() {
        if (this.destroyed) {
            throw new OBJECT_NOT_EXIST();
        }
        if (this.run) {
            this.shutdown(true);
        }
        if (this.interceptor_manager != null) {
            this.interceptor_manager.destroy();
        }
        this.destroyed = true;
    }

    public Object string_to_object(String string) {
        if (string == null) {
            return null;
        }
        try {
            ParsedIOR parsedIOR = new ParsedIOR(string, this);
            if (parsedIOR.isNull()) {
                return null;
            }
            return this._getObject(parsedIOR);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Debug.output(5, illegalArgumentException);
            return null;
        }
    }

    public Object get_value_def(String string) throws BAD_PARAM {
        throw new NO_IMPLEMENT();
    }

    public void set_delegate(java.lang.Object object) {
        if (!(object instanceof Servant)) {
            throw new BAD_PARAM("Argument must be of type org.omg.PortableServer.Servant");
        }
        try {
            ((Servant)object)._get_delegate();
        }
        catch (BAD_INV_ORDER bAD_INV_ORDER) {
            ServantDelegate servantDelegate = new ServantDelegate(this);
            ((Servant)object)._set_delegate(servantDelegate);
        }
    }

    public void useProxy() {
        this.applet = new Applet();
    }

    public String object_to_string(Object object) {
        if (object == null) {
            return nullIORString;
        }
        if (object instanceof LocalObject) {
            throw new MARSHAL("Attempt to stringify a local object");
        }
        org.omg.CORBA.portable.Delegate delegate = ((ObjectImpl)object)._get_delegate();
        if (delegate instanceof Delegate) {
            return delegate.toString();
        }
        throw new Error("Argument has a delegate whose class is " + delegate.getClass().getName() + ", a org.jacorb.orb.Delegate was expected");
    }

    public void perform_work() {
        if (!this.run) {
            throw new BAD_INV_ORDER(4, CompletionStatus.COMPLETED_NO);
        }
    }

    public boolean work_pending() {
        if (!this.run) {
            throw new BAD_INV_ORDER(4, CompletionStatus.COMPLETED_NO);
        }
        return false;
    }

    public ValueFactory register_value_factory(String string, ValueFactory valueFactory) {
        return this.valueFactories.put(string, valueFactory);
    }

    public void unregister_value_factory(String string) {
        this.valueFactories.remove(string);
    }

    public ValueFactory lookup_value_factory(String string) {
        ValueFactory valueFactory = (ValueFactory)this.valueFactories.get(string);
        if (valueFactory == null && string.startsWith("IDL")) {
            String string2 = RepositoryID.className(string);
            valueFactory = this.findValueFactory(string2);
            this.valueFactories.put(string, valueFactory);
        }
        return valueFactory;
    }

    private ValueFactory findValueFactory(String string) {
        Class clazz = null;
        clazz = this.findClass(string + "DefaultFactory", true);
        if (clazz != null) {
            return (ValueFactory)this.instantiate(clazz);
        }
        Class clazz2 = this.findClass(string, false);
        clazz = this.findClass(string + "Impl", false);
        if (clazz != null && clazz2.isAssignableFrom(clazz)) {
            if ((class$org$omg$CORBA$portable$ValueFactory == null ? (class$org$omg$CORBA$portable$ValueFactory = ORB.class$("org.omg.CORBA.portable.ValueFactory")) : class$org$omg$CORBA$portable$ValueFactory).isAssignableFrom(clazz)) {
                return (ValueFactory)this.instantiate(clazz);
            }
            return new JacORBValueFactory(clazz);
        }
        return null;
    }

    private Class findClass(String string, boolean bl) {
        Class<?> clazz;
        block4: {
            clazz = null;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!bl || !string.startsWith("org.omg")) break block4;
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass("omg.org" + string.substring(7));
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
        }
        return clazz;
    }

    private java.lang.Object instantiate(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("cannot instantiate class " + clazz.getName() + " (IllegalAccessException)");
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("cannot instantiate class " + clazz.getName() + " (InstantiationException)");
        }
    }

    public boolean hasClientRequestInterceptors() {
        return this.hasClientInterceptors;
    }

    public boolean hasServerRequestInterceptors() {
        return this.hasServerInterceptors;
    }

    public boolean hasRequestInterceptors() {
        return this.hasServerInterceptors || this.hasClientInterceptors;
    }

    public InterceptorManager getInterceptorManager() {
        return this.interceptor_manager;
    }

    public org.omg.CORBA.ExceptionList create_exception_list() {
        return new ExceptionList();
    }

    public org.omg.CORBA.NVList create_list(int n) {
        return new NVList(this, n);
    }

    public org.omg.CORBA.NamedValue create_named_value(String string, Any any, int n) {
        return new NamedValue(string, any, n);
    }

    public org.omg.CORBA.NVList create_operation_list(Object object) {
        if (!(object instanceof OperationDef)) {
            throw new BAD_PARAM("Argument must be of type org.omg.CORBA.OperationDef");
        }
        OperationDef operationDef = (OperationDef)object;
        return this.create_operation_list(operationDef);
    }

    public org.omg.CORBA.NVList create_operation_list(OperationDef operationDef) {
        int n = 0;
        ParameterDescription[] parameterDescriptionArray = null;
        parameterDescriptionArray = operationDef.params();
        if (parameterDescriptionArray != null) {
            n = parameterDescriptionArray.length;
        }
        NVList nVList = new NVList(this, n);
        int n2 = 0;
        while (n2 < n) {
            ParameterDescription parameterDescription = parameterDescriptionArray[n2];
            Any any = this.create_any();
            any.type(parameterDescription.type);
            ((org.omg.CORBA.NVList)nVList).add_value(parameterDescription.name, any, parameterDescription.mode.value());
            ++n2;
        }
        return nVList;
    }

    public byte[] mapObjectKey(byte[] byArray) {
        String string;
        java.lang.Object v;
        if (Environment.doMapObjectKeys() && (v = this.objectKeyMap.get(string = new String(byArray))) != null) {
            return CorbaLoc.parseKey((String)v);
        }
        return byArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        services = new String[]{"RootPOA", "POACurrent", "DynAnyFactory", "PICurrent", "CodecFactory"};
    }

    private class PICurrent
    extends LocalObject
    implements org.omg.PortableInterceptor.Current {
        private PICurrent() {
        }

        private org.omg.PortableInterceptor.Current getTarget() {
            if (ORB.this.interceptor_manager == null) {
                return InterceptorManager.EMPTY_CURRENT;
            }
            return ORB.this.interceptor_manager.getCurrent();
        }

        public Any get_slot(int n) throws InvalidSlot {
            return this.getTarget().get_slot(n);
        }

        public void set_slot(int n, Any any) throws InvalidSlot {
            this.getTarget().set_slot(n, any);
        }
    }

    private class JacORBValueFactory
    implements ValueFactory {
        private Class implementationClass;

        public JacORBValueFactory(Class clazz) {
            this.implementationClass = clazz;
        }

        public Serializable read_value(InputStream inputStream) {
            StreamableValue streamableValue = (StreamableValue)ORB.this.instantiate(this.implementationClass);
            ((CDRInputStream)inputStream).register_value(streamableValue);
            streamableValue._read(inputStream);
            return streamableValue;
        }
    }
}

