/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming.namemanager;

import java.awt.Dimension;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jacorb.naming.Name;
import org.jacorb.naming.namemanager.ContextNode;
import org.jacorb.naming.namemanager.NSTable;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class NSTree
extends JTree {
    public static final int MAX_BIND = 40;
    public static NSTable nsTable;
    private NamingContextExt rootContext;
    private ContextNode rootNode;
    private Dimension size;
    private boolean created;

    public void bind(String string) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        TreePath treePath = null;
        int n = 0;
        try {
            treePath = this.getSelectionPath();
            n = treePath.getPathCount();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Nothing selected", "Selection error", 0);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        NamingContextExt namingContextExt = this.rootContext;
        if (n > 1) {
            int n2 = 1;
            while (n2 < n) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(n2);
                ContextNode contextNode = (ContextNode)defaultMutableTreeNode.getUserObject();
                if ((namingContextExt = NamingContextExtHelper.narrow(namingContextExt.resolve(contextNode.getName()))) == null) {
                    System.err.println("Naming context narrow failed!");
                    System.exit(1);
                }
                ++n2;
            }
        }
        if (defaultMutableTreeNode.getAllowsChildren()) {
            Name name = new Name(string);
            if (namingContextExt == null) {
                System.err.println("context null ");
            }
            if (name.components() == null) {
                System.err.println("name is null ");
            }
            namingContextExt.bind_new_context(name.components());
            this.update();
        } else {
            JOptionPane.showMessageDialog(this, "Please select a naming context", "Selection error", 0);
        }
    }

    public Dimension getPreferredSize() {
        if (!this.created) {
            this.created = true;
            return this.size;
        }
        return super.getPreferredSize();
    }

    public void unbind() {
        NamingContextExt namingContextExt = this.rootContext;
        TreePath treePath = null;
        int n = 0;
        try {
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode;
            treePath = this.getSelectionPath();
            n = treePath.getPathCount();
            if (n > 1) {
                int n2 = 1;
                while (n2 < n - 1) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(n2);
                    object = (ContextNode)defaultMutableTreeNode.getUserObject();
                    namingContextExt = NamingContextExtHelper.narrow(namingContextExt.resolve(((ContextNode)object).getName()));
                    ++n2;
                }
            }
            if (n > 0) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(n - 1);
                ContextNode contextNode = (ContextNode)defaultMutableTreeNode.getUserObject();
                namingContextExt.unbind(contextNode.getName());
                object = (DefaultTreeModel)this.getModel();
                ((DefaultTreeModel)object).removeNodeFromParent(defaultMutableTreeNode);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Nothing selected or invalid selection", "Selection error", 0);
        }
    }

    public void update() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        ((ContextNode)((DefaultMutableTreeNode)defaultTreeModel.getRoot()).getUserObject()).update();
        nsTable.update();
    }

    public NSTree(int n, int n2, NSTable nSTable, NamingContextExt namingContextExt) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("RootContext");
        defaultMutableTreeNode.setAllowsChildren(true);
        this.setModel(new DefaultTreeModel(defaultMutableTreeNode, true));
        this.created = false;
        this.size = new Dimension(n, n2);
        nsTable = nSTable;
        this.rootContext = namingContextExt;
        ContextNode contextNode = new ContextNode(this.rootContext, (DefaultTreeModel)this.getModel());
        contextNode.setNode(defaultMutableTreeNode);
        defaultMutableTreeNode.setUserObject(contextNode);
    }
}

