/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.jacorb.imr.AdminPackage.DuplicateServerName;
import org.jacorb.imr.AdminPackage.FileOpFailed;
import org.jacorb.imr.AdminPackage.IllegalServerName;
import org.jacorb.imr.AdminPackage.UnknownHostName;
import org.jacorb.imr.HostInfo;
import org.jacorb.imr.ImRHostInfo;
import org.jacorb.imr.ImRInfo;
import org.jacorb.imr.ImRPOAInfo;
import org.jacorb.imr.ImRServerInfo;
import org.jacorb.imr.ImplementationRepositoryPOA;
import org.jacorb.imr.RegistrationPackage.DuplicatePOAName;
import org.jacorb.imr.RegistrationPackage.IllegalHostName;
import org.jacorb.imr.RegistrationPackage.IllegalPOAName;
import org.jacorb.imr.RegistrationPackage.InvalidSSDRef;
import org.jacorb.imr.ServerInfo;
import org.jacorb.imr.ServerStartupFailed;
import org.jacorb.imr.ServerTable;
import org.jacorb.imr.UnknownServerName;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.connection.ClientConnection;
import org.jacorb.orb.connection.ConnectionManager;
import org.jacorb.orb.connection.GIOPConnection;
import org.jacorb.orb.connection.LocateReplyInputStream;
import org.jacorb.orb.connection.LocateRequestInputStream;
import org.jacorb.orb.connection.LocateRequestOutputStream;
import org.jacorb.orb.connection.MessageReceptorPool;
import org.jacorb.orb.connection.NoBiDirServerReplyListener;
import org.jacorb.orb.connection.ReplyListener;
import org.jacorb.orb.connection.ReplyOutputStream;
import org.jacorb.orb.connection.ReplyPlaceholder;
import org.jacorb.orb.connection.RequestInputStream;
import org.jacorb.orb.connection.RequestListener;
import org.jacorb.orb.connection.Server_TCP_IP_Transport;
import org.jacorb.poa.POAConstants;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.IOP.IOR;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class ImplementationRepositoryImpl
extends ImplementationRepositoryPOA {
    private static int default_port;
    private static ORB orb;
    private File table_file;
    private ServerTable server_table;
    private File table_file_backup;
    private SocketListener listener;
    private int object_activation_retries = 5;
    private int object_activation_sleep = 50;
    private boolean allow_auto_register = false;
    private boolean check_object_liveness = false;
    private WriteThread wt;
    private boolean updatePending;
    private Shutdown shutdownThread;
    private static /* synthetic */ Class class$Ljava$lang$Thread;
    private static /* synthetic */ Class class$Ljava$lang$Runtime;

    public void set_server_down(String string) throws UnknownServerName {
        Debug.output(2050, "ImR: server " + string + " is going down... ");
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        imRServerInfo.setDown();
    }

    public void register_poa(String string, String string2, String string3, int n) throws IllegalPOAName, DuplicatePOAName, UnknownServerName {
        java.lang.Object object;
        ImRServerInfo imRServerInfo = null;
        ImRPOAInfo imRPOAInfo = null;
        boolean bl = false;
        this.updatePending = true;
        Debug.output(2050, "ImR: registering poa " + string + " for server: " + string2 + " on " + string3);
        if (this.allow_auto_register && !this.server_table.hasServer(string2)) {
            try {
                this.register_server(string2, "", "");
            }
            catch (IllegalServerName illegalServerName) {
            }
            catch (DuplicateServerName duplicateServerName) {
                // empty catch block
            }
        }
        imRServerInfo = this.server_table.getServer(string2);
        imRPOAInfo = this.server_table.getPOA(string);
        if (imRPOAInfo == null) {
            imRPOAInfo = new ImRPOAInfo(string, string3, n, imRServerInfo);
            imRServerInfo.addPOA(imRPOAInfo);
            this.server_table.putPOA(string, imRPOAInfo);
            Debug.output(2050, "ImR: new poa registered");
        } else {
            if (imRPOAInfo.active || !string2.equals(imRPOAInfo.server.name)) {
                object = imRPOAInfo.name.getBytes();
                byte[] byArray = new byte[((byte[])object).length + 1];
                System.arraycopy(object, 0, byArray, 0, ((byte[])object).length);
                byArray[((byte[])object).length] = POAConstants.OBJECT_KEY_SEP_BYTE;
                if (imRPOAInfo.host.equals(string3) && imRPOAInfo.port == n) {
                    bl = true;
                } else {
                    boolean bl2 = bl = !ImplementationRepositoryImpl.checkServerActive(imRPOAInfo.host, imRPOAInfo.port, byArray);
                }
                if (!bl) {
                    throw new DuplicatePOAName("POA " + string + " has already been registered " + "for server " + imRPOAInfo.server.name);
                }
                Debug.output(2050, "ImR: Remapping server/port");
            }
            imRPOAInfo.reactivate(string3, n);
            Debug.output(2050, "ImR: register_poa, reactivated");
        }
        try {
            WriteThread writeThread = this.wt;
            object = writeThread;
            synchronized (writeThread) {
                this.wt.notify();
                // ** MonitorExit[var8_10 /* !! */ ] (shouldn't be in output)
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            Debug.output(2050, illegalMonitorStateException);
        }
        {
            return;
        }
    }

    public void register_host(HostInfo hostInfo) throws IllegalHostName, InvalidSSDRef {
        if (hostInfo.name == null || hostInfo.name.length() == 0) {
            throw new IllegalHostName(hostInfo.name);
        }
        try {
            hostInfo.ssd_ref.get_system_load();
        }
        catch (Exception exception) {
            Debug.output(2050, exception);
            throw new InvalidSSDRef();
        }
        this.updatePending = true;
        this.server_table.putHost(hostInfo.name, new ImRHostInfo(hostInfo));
        try {
            WriteThread writeThread = this.wt;
            synchronized (writeThread) {
                this.wt.notify();
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            Debug.output(2050, illegalMonitorStateException);
        }
    }

    public ImRInfo get_imr_info() {
        return new ImRInfo(this.listener.getAddress(), this.listener.getPort());
    }

    public HostInfo[] list_hosts() {
        return this.server_table.getHosts();
    }

    public ServerInfo[] list_servers() {
        return this.server_table.getServers();
    }

    public ServerInfo get_server_info(String string) throws UnknownServerName {
        return this.server_table.getServer(string).toServerInfo();
    }

    public void register_server(String string, String string2, String string3) throws IllegalServerName, DuplicateServerName {
        this.updatePending = true;
        ImRServerInfo imRServerInfo = new ImRServerInfo(string, string3, string2);
        this.server_table.putServer(string, imRServerInfo);
        Debug.output(2050, "ImR: server " + string + " on " + string3 + " registered");
        try {
            WriteThread writeThread = this.wt;
            synchronized (writeThread) {
                this.wt.notify();
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            Debug.output(2050, illegalMonitorStateException);
        }
    }

    public void unregister_server(String string) throws UnknownServerName {
        this.updatePending = true;
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        String[] stringArray = imRServerInfo.getPOANames();
        int n = 0;
        while (n < stringArray.length) {
            this.server_table.removePOA(stringArray[n]);
            ++n;
        }
        this.server_table.removeServer(string);
        Debug.output(2050, "ImR: server " + string + " unregistered");
        try {
            WriteThread writeThread = this.wt;
            synchronized (writeThread) {
                this.wt.notify();
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            Debug.output(2050, illegalMonitorStateException);
        }
    }

    public void edit_server(String string, String string2, String string3) throws UnknownServerName {
        this.updatePending = true;
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        imRServerInfo.command = string2;
        imRServerInfo.host = string3;
        Debug.output(2050, "ImR: server " + string + " edited");
        try {
            WriteThread writeThread = this.wt;
            synchronized (writeThread) {
                this.wt.notify();
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            Debug.output(2050, illegalMonitorStateException);
        }
    }

    public void hold_server(String string) throws UnknownServerName {
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        imRServerInfo.holding = true;
    }

    public void release_server(String string) throws UnknownServerName {
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        imRServerInfo.release();
    }

    public void start_server(String string) throws UnknownServerName, ServerStartupFailed {
        this.restartServer(this.server_table.getServer(string));
    }

    public void save_server_table() throws FileOpFailed {
        this.save_server_table(this.table_file_backup);
    }

    public void shutdown(boolean bl) {
        WriteThread writeThread = this.wt;
        synchronized (writeThread) {
            this.wt.shutdown();
            this.wt.notify();
        }
        if (this.listener != null) {
            this.listener.stopListening(bl);
            try {
                SocketListener socketListener = this.listener;
                synchronized (socketListener) {
                    this.listener.join(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                Debug.output(2050, interruptedException);
            }
        }
        Debug.output(2050, "ImR: Finished shutting down");
    }

    public void unregister_host(String string) throws UnknownHostName {
        if (this.server_table.removeHost(string) == null) {
            throw new UnknownHostName(string);
        }
    }

    private final void save_server_table(File file) throws FileOpFailed {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            this.server_table.table_lock.gainExclusiveLock();
            objectOutputStream.writeObject(this.server_table);
            this.server_table.table_lock.releaseExclusiveLock();
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            Debug.output(2050, exception);
            throw new FileOpFailed();
        }
        this.updatePending = false;
    }

    public static void usage() {
        System.out.println("Usage: ImplementationRepositoryImpl [Parameter]");
        System.out.println("Parameter:");
        System.out.println("\t -p <port> Port to listen on for requests");
        System.out.println("\t -f <file> Read in server table from this file");
        System.out.println("\t -n Start with empty server table");
        System.out.println("\t -i <iorfile> Place IOR in this file");
        System.out.println("\t -b <backupfile> Put server table in this file");
        System.out.println("\t -a Allow auto-registering of servers");
        System.out.println("\t -h Print this help");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        java.lang.Object object;
        java.lang.Object object2;
        if (stringArray.length > 8) {
            ImplementationRepositoryImpl.usage();
        }
        String string = null;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        System.setProperty("jacorb.implname", "the_ImR");
        System.setProperty("jacorb.use_imr", "off");
        try {
            int n = 0;
            while (n < stringArray.length) {
                switch (stringArray[n].charAt(1)) {
                    case 'h': {
                        ImplementationRepositoryImpl.usage();
                    }
                    case 'p': {
                        default_port = Integer.parseInt(stringArray[++n]);
                        break;
                    }
                    case 'f': {
                        if (bl) {
                            ImplementationRepositoryImpl.usage();
                        }
                        string = stringArray[++n];
                        break;
                    }
                    case 'n': {
                        if (string != null) {
                            ImplementationRepositoryImpl.usage();
                        }
                        bl = true;
                        break;
                    }
                    case 'i': {
                        string2 = stringArray[++n];
                        break;
                    }
                    case 'b': {
                        string3 = stringArray[++n];
                        break;
                    }
                    case 'a': {
                        Environment.setProperty("jacorb.imr.allow_auto_register", "on");
                        break;
                    }
                    default: {
                        ImplementationRepositoryImpl.usage();
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ImplementationRepositoryImpl.usage();
        }
        if (default_port == 0 && (string4 = Environment.getProperty("jacorb.imr.port_number")) != null && string4.length() > 0) {
            default_port = Integer.parseInt(string4);
            Debug.output(2050, "ImR: Using port number " + default_port);
        }
        if (string == null && (string = Environment.getProperty("jacorb.imr.table_file")) == null) {
            System.out.println("WARNING: No file for the server table specified!");
            System.out.println("Property jacorb.imr.table_file or use the -f switch");
            System.out.println("Will create \"table.dat\" in current directory, if necessary");
            string = "table.dat";
        }
        File file = new File(string);
        if (!bl) {
            if (!file.exists()) {
                System.out.println("ERROR: The table file does not exist!");
                System.out.println("Please check " + file.getAbsolutePath());
                System.out.println("Property jacorb.imr.table_file or use the -n or -f switch");
                System.exit(-1);
            }
            if (file.isDirectory()) {
                System.out.println("ERROR: The table file is a directory!");
                System.out.println("Please check " + file.getAbsolutePath());
                System.out.println("Property jacorb.imr.table_file or use the -n or -f switch");
                System.exit(-1);
            }
            if (!file.canRead()) {
                System.out.println("ERROR: The table file is not readable!");
                System.out.println("Please check " + file.getAbsolutePath());
                System.exit(-1);
            }
            if (!file.canWrite()) {
                System.out.println("WARNING: The table file is not writable!");
                System.out.println("Please check " + file.getAbsolutePath());
            }
        } else {
            try {
                object2 = new FileOutputStream(file);
                ((FileOutputStream)object2).close();
                file.delete();
            }
            catch (Exception exception) {
                System.out.println("WARNING: Unable to create table file!");
                System.out.println("Please check " + file.getAbsolutePath());
            }
        }
        if (string2 == null && (string2 = Environment.getProperty("jacorb.imr.ior_file")) == null) {
            System.out.println("ERROR: Please specify a file for the IOR string!");
            System.out.println("Property jacorb.imr.ior_file or use the -i switch");
            System.exit(-1);
        }
        if (string3 == null && (string3 = Environment.getProperty("jacorb.imr.backup_file")) == null) {
            System.out.println("WARNING: No backup file specified!\nWill create \"backup.dat\" in current directory, if necessary");
            string3 = "backup.dat";
        }
        object2 = new File(string3);
        try {
            if (((File)object2).exists()) {
                if (!((File)object2).canWrite()) {
                    System.out.println("WARNING: The backup file exists, but is not writable!");
                    System.out.println("Please check " + ((File)object2).getAbsolutePath());
                } else if (!bl) {
                    System.out.println("WARNING: The backup file already exists and might get overwritten!");
                    System.out.println("Please check " + ((File)object2).getAbsolutePath());
                }
            } else {
                object = new FileOutputStream((File)object2);
                ((FileOutputStream)object).close();
                ((File)object2).delete();
            }
        }
        catch (Exception exception) {
            System.out.println("WARNING: The backup file is not accessible!");
            System.out.println("Please check " + ((File)object2).getAbsolutePath());
        }
        orb = ORB.init(stringArray, null);
        try {
            object = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            object.the_POAManager().activate();
            Policy[] policyArray = new Policy[]{object.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), object.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
            POA pOA = object.create_POA("ImRPOA", object.the_POAManager(), policyArray);
            int n = 0;
            while (n < policyArray.length) {
                policyArray[n].destroy();
                ++n;
            }
            byte[] byArray = "ImR".getBytes();
            ImplementationRepositoryImpl implementationRepositoryImpl = new ImplementationRepositoryImpl(file, (File)object2, bl);
            pOA.activate_object_with_id(byArray, implementationRepositoryImpl);
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(new File(string2)));
            printWriter.println(orb.object_to_string(pOA.servant_to_reference(implementationRepositoryImpl)));
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            Debug.output(2050, exception);
            System.out.println("ERROR: Failed to write IOR to file.\nPlease check the path.");
            System.out.println("Property jacorb.imr.ior_file or -i <file> switch");
            System.exit(-1);
        }
        orb.run();
    }

    private final void restartServer(ImRServerInfo imRServerInfo) throws ServerStartupFailed {
        imRServerInfo.awaitRelease();
        if (!imRServerInfo.active) {
            Debug.output(2050, "ImR: server " + imRServerInfo.name + " is down");
            if (imRServerInfo.command.length() == 0) {
                throw new ServerStartupFailed("Server " + imRServerInfo.name + " can't be restarted because" + " of missing startup command");
            }
            if (imRServerInfo.shouldBeRestarted()) {
                try {
                    ImRHostInfo imRHostInfo = this.server_table.getHost(imRServerInfo.host);
                    if (imRHostInfo == null) {
                        throw new ServerStartupFailed("Unknown host: >>" + imRServerInfo.host + "<<");
                    }
                    Debug.output(2050, "ImR: will restart " + imRServerInfo.name);
                    imRHostInfo.startServer(imRServerInfo.command, orb);
                }
                catch (ServerStartupFailed serverStartupFailed) {
                    imRServerInfo.setNotRestarting();
                    throw serverStartupFailed;
                }
                catch (Exception exception) {
                    imRServerInfo.setNotRestarting();
                    Debug.output(2050, exception);
                    this.server_table.removeHost(imRServerInfo.host);
                    throw new ServerStartupFailed("Failed to connect to host!");
                }
            } else {
                Debug.output(2050, "ImR: somebody else is restarting " + imRServerInfo.name);
            }
        } else {
            Debug.output(2050, "ImR: server " + imRServerInfo.name + " is active");
        }
    }

    private final void addShutdownHook(Thread thread) {
        Method method = this.getHookMethod("addShutdownHook");
        if (method != null) {
            this.invokeHookMethod(method, thread);
        }
    }

    private final Method getHookMethod(String string) {
        Method method = null;
        Class[] classArray = new Class[]{class$Ljava$lang$Thread != null ? class$Ljava$lang$Thread : (class$Ljava$lang$Thread = ImplementationRepositoryImpl.class$("java.lang.Thread"))};
        try {
            method = (class$Ljava$lang$Runtime != null ? class$Ljava$lang$Runtime : (class$Ljava$lang$Runtime = ImplementationRepositoryImpl.class$("java.lang.Runtime"))).getMethod(string, classArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return method;
    }

    private final void invokeHookMethod(Method method, Thread thread) {
        java.lang.Object[] objectArray = new java.lang.Object[]{thread};
        try {
            method.invoke((java.lang.Object)Runtime.getRuntime(), objectArray);
        }
        catch (Throwable throwable) {
            Debug.output(2050, "Failed to invoke Runtime." + method.getName() + " and exception " + throwable);
        }
    }

    private static final boolean checkServerActive(String string, int n, byte[] byArray) {
        ConnectionManager connectionManager = null;
        ClientConnection clientConnection = null;
        LocateRequestOutputStream locateRequestOutputStream = null;
        ReplyPlaceholder replyPlaceholder = null;
        LocateReplyInputStream locateReplyInputStream = null;
        boolean bl = false;
        connectionManager = ((org.jacorb.orb.ORB)orb).getConnectionManager();
        clientConnection = connectionManager.getConnection(string + ":" + n, false);
        Debug.output(2051, "Pinging " + string + " / " + n);
        try {
            try {
                locateRequestOutputStream = new LocateRequestOutputStream(byArray, clientConnection.getId(), 2);
                replyPlaceholder = new ReplyPlaceholder();
                clientConnection.sendRequest(locateRequestOutputStream, replyPlaceholder, locateRequestOutputStream.getRequestId());
                locateReplyInputStream = (LocateReplyInputStream)replyPlaceholder.getInputStream();
                switch (locateReplyInputStream.rep_hdr.locate_status.value()) {
                    default: 
                }
                bl = true;
            }
            catch (Throwable throwable) {
                bl = false;
                java.lang.Object var10_10 = null;
                connectionManager.releaseConnection(clientConnection);
            }
            java.lang.Object var10_9 = null;
            connectionManager.releaseConnection(clientConnection);
        }
        catch (Throwable throwable) {
            java.lang.Object var10_11 = null;
            connectionManager.releaseConnection(clientConnection);
            throw throwable;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ImplementationRepositoryImpl(File file, File file2, boolean bl) {
        java.lang.Object object;
        this.table_file = file;
        this.table_file_backup = file2;
        try {
            if (bl) {
                this.server_table = new ServerTable();
                this.save_server_table(file);
            } else {
                try {
                    object = new ObjectInputStream(new FileInputStream(file));
                    this.server_table = (ServerTable)((ObjectInputStream)object).readObject();
                    ((ObjectInputStream)object).close();
                }
                catch (Exception exception) {
                    Debug.output(2050, exception);
                    this.server_table = new ServerTable();
                    this.save_server_table(file);
                }
            }
        }
        catch (FileOpFailed fileOpFailed) {
            Debug.output(2050, fileOpFailed);
        }
        this.shutdownThread = new Shutdown();
        this.shutdownThread.setDaemon(true);
        this.shutdownThread.setName("Shutdown Thread");
        this.addShutdownHook(this.shutdownThread);
        this.wt = new WriteThread();
        this.wt.setName("IMR Write Thread");
        this.wt.setDaemon(true);
        this.wt.start();
        try {
            object = Environment.getProperty("jacorb.imr.object_activation_retries");
            if (object != null) {
                this.object_activation_retries = Integer.parseInt((String)object);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            object = Environment.getProperty("jacorb.imr.object_activation_sleep");
            if (object != null) {
                this.object_activation_sleep = Integer.parseInt((String)object);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        object = Environment.getProperty("jacorb.imr.allow_auto_register");
        if (object != null) {
            object = ((String)object).toLowerCase();
            this.allow_auto_register = "on".equals(object);
        }
        if ((object = Environment.getProperty("jacorb.imr.check_object_liveness")) != null) {
            object = ((String)object).toLowerCase();
            this.check_object_liveness = "on".equals(object);
        }
        this.listener = new SocketListener();
    }

    private class SocketListener
    extends Thread {
        private ServerSocket server_socket;
        private int port = 0;
        private String address;
        private int timeout = 0;
        private boolean run = true;
        private boolean wait = false;
        private MessageReceptorPool receptor_pool = null;
        private RequestListener request_listener = null;
        private ReplyListener reply_listener = null;

        public int getPort() {
            Debug.output(2050, "ImR Listener at " + this.port + ", " + this.address);
            return this.port;
        }

        public String getAddress() {
            return this.address;
        }

        public void setTimeout(int n) {
            this.timeout = n;
        }

        public void run() {
            Thread.currentThread().setPriority(10);
            while (this.run) {
                try {
                    Socket socket = this.server_socket.accept();
                    socket.setSoTimeout(this.timeout);
                    Server_TCP_IP_Transport server_TCP_IP_Transport = new Server_TCP_IP_Transport(socket, false);
                    GIOPConnection gIOPConnection = new GIOPConnection(server_TCP_IP_Transport, this.request_listener, this.reply_listener);
                    this.receptor_pool.connectionCreated(gIOPConnection);
                }
                catch (Exception exception) {
                    if (!this.run) continue;
                    Debug.output(2050, exception);
                }
            }
            orb.shutdown(this.wait);
        }

        public void stopListening(boolean bl) {
            this.run = false;
            this.wait = bl;
            try {
                this.server_socket.close();
            }
            catch (Exception exception) {
                Debug.output(2050, exception);
            }
        }

        public SocketListener() {
            try {
                this.server_socket = new ServerSocket(default_port);
                this.address = InetAddress.getLocalHost().toString();
                if (this.address.indexOf("/") >= 0) {
                    this.address = this.address.substring(this.address.indexOf("/") + 1);
                }
                this.port = this.server_socket.getLocalPort();
                Debug.output(2050, "ImR Listener at " + this.port + ", " + this.address);
                String string = Environment.getProperty("jacorb.imr.connection_timeout", "2000");
                try {
                    this.timeout = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.output(2049, "ERROR: Unable to build timeout int from string >>" + string + "<<");
                    Debug.output(2049, "Please check property \"jacorb.imr.connection_timeout\"");
                }
            }
            catch (Exception exception) {
                Debug.output(2049, exception);
                Debug.output(2049, "Listener: Couldn't init");
                System.exit(1);
            }
            this.setDaemon(true);
            this.receptor_pool = MessageReceptorPool.getInstance();
            ImplementationRepositoryImpl implementationRepositoryImpl2 = ImplementationRepositoryImpl.this;
            if (implementationRepositoryImpl2 == null) {
                throw null;
            }
            this.request_listener = implementationRepositoryImpl2.new ImRRequestListener();
            this.reply_listener = new NoBiDirServerReplyListener();
            this.start();
        }
    }

    private class ImRRequestListener
    implements RequestListener {
        public void requestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
            RequestInputStream requestInputStream = new RequestInputStream(orb, byArray);
            this.replyNewLocation(requestInputStream.req_hdr.target.object_key(), requestInputStream.req_hdr.request_id, requestInputStream.getGIOPMinor(), gIOPConnection);
        }

        public void locateRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
            LocateRequestInputStream locateRequestInputStream = new LocateRequestInputStream(orb, byArray);
            this.replyNewLocation(locateRequestInputStream.req_hdr.target.object_key(), locateRequestInputStream.req_hdr.request_id, locateRequestInputStream.getGIOPMinor(), gIOPConnection);
        }

        public void cancelRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        }

        public void fragmentReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        }

        public void connectionClosed() {
        }

        private final void replyNewLocation(byte[] byArray, int n, int n2, GIOPConnection gIOPConnection) {
            boolean bl;
            String string = POAUtil.extractImplName(byArray) + "/" + POAUtil.extractPOAName(byArray);
            ImRPOAInfo imRPOAInfo = ImplementationRepositoryImpl.this.server_table.getPOA(string);
            if (imRPOAInfo == null) {
                this.sendSysException(new OBJECT_NOT_EXIST("POA " + string + " unknown"), gIOPConnection, n, n2);
                return;
            }
            ImRServerInfo imRServerInfo = imRPOAInfo.server;
            Debug.output(2050, "ImR: Looking up: " + imRServerInfo.name);
            boolean bl2 = bl = imRServerInfo.command.length() != 0 && ImplementationRepositoryImpl.this.server_table.getHost(imRServerInfo.host) != null;
            if (imRServerInfo.active && (ImplementationRepositoryImpl.this.check_object_liveness || bl) && !ImplementationRepositoryImpl.checkServerActive(imRPOAInfo.host, imRPOAInfo.port, byArray)) {
                imRServerInfo.setDown();
            }
            try {
                ImplementationRepositoryImpl.this.restartServer(imRServerInfo);
            }
            catch (ServerStartupFailed serverStartupFailed) {
                Debug.output(2050, "Object (" + imRServerInfo.name + ") on " + imRPOAInfo.host + "/" + imRPOAInfo.port + " not reachable");
                this.sendSysException(new TRANSIENT(serverStartupFailed.reason), gIOPConnection, n, n2);
                return;
            }
            boolean bl3 = imRPOAInfo.active;
            if (!imRPOAInfo.awaitActivation()) {
                this.sendSysException(new TRANSIENT("Timeout exceeded"), gIOPConnection, n, n2);
                return;
            }
            ReplyOutputStream replyOutputStream = new ReplyOutputStream(n, ReplyStatusType_1_2.LOCATION_FORWARD, n2, false);
            IOR iOR = ParsedIOR.createObjectIOR(imRPOAInfo.host, (short)imRPOAInfo.port, byArray, n2);
            if (!bl3) {
                Object object = orb.string_to_object(new ParsedIOR(iOR).getIORString());
                int n3 = 0;
                while (n3 < ImplementationRepositoryImpl.this.object_activation_retries) {
                    try {
                        Thread.sleep(ImplementationRepositoryImpl.this.object_activation_sleep);
                        if (!object._non_existent()) {
                            break;
                        }
                    }
                    catch (Exception exception) {
                        Debug.output(2051, exception);
                    }
                    ++n3;
                }
            }
            try {
                replyOutputStream.write_IOR(iOR);
                Debug.output(2050, "ImR: Sending location forward for " + imRServerInfo.name);
                gIOPConnection.sendMessage(replyOutputStream);
            }
            catch (IOException iOException) {
                Debug.output(2050, iOException);
                this.sendSysException(new UNKNOWN(iOException.toString()), gIOPConnection, n, n2);
            }
        }

        private final void sendSysException(SystemException systemException, GIOPConnection gIOPConnection, int n, int n2) {
            ReplyOutputStream replyOutputStream = new ReplyOutputStream(n, ReplyStatusType_1_2.SYSTEM_EXCEPTION, n2, false);
            SystemExceptionHelper.write(replyOutputStream, systemException);
            try {
                gIOPConnection.sendMessage(replyOutputStream);
            }
            catch (IOException iOException) {
                Debug.output(2050, iOException);
            }
        }
    }

    private class WriteThread
    extends Thread {
        boolean done;

        public void run() {
            while (true) {
                try {
                    ImplementationRepositoryImpl.this.save_server_table(ImplementationRepositoryImpl.this.table_file);
                }
                catch (FileOpFailed fileOpFailed) {
                    Debug.output(2050, fileOpFailed);
                }
                if (this.done) break;
                if (ImplementationRepositoryImpl.this.updatePending) continue;
                try {
                    WriteThread writeThread = this;
                    synchronized (writeThread) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Debug.output(2050, "ImR: IMR write thread waking up to save server table... ");
            }
        }

        public void shutdown() {
            this.done = true;
        }
    }

    private class Shutdown
    extends Thread {
        public synchronized void run() {
            Debug.output(2050, "ImR: Shutting down");
            ImplementationRepositoryImpl.this.shutdown(true);
        }

        Shutdown() {
        }
    }
}

