/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.io.Serializable;
import org.jacorb.imr.ImRServerInfo;
import org.jacorb.imr.POAInfo;
import org.jacorb.imr.RegistrationPackage.IllegalPOAName;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;

public class ImRPOAInfo
implements Serializable {
    protected static long timeout = 120000L;
    protected int port;
    protected ImRServerInfo server;
    protected String host;
    protected String name;
    protected boolean active;

    public POAInfo toPOAInfo() {
        return new POAInfo(this.name, this.host, this.port, this.server.name, this.active);
    }

    public synchronized void reactivate(String string, int n) {
        this.host = string;
        this.port = n;
        this.active = true;
        this.server.active = true;
        this.server.restarting = false;
        this.notifyAll();
    }

    public synchronized boolean awaitActivation() {
        while (!this.active) {
            try {
                long l = System.currentTimeMillis();
                this.wait(timeout);
                if (this.active || System.currentTimeMillis() - l <= timeout) continue;
                Debug.output(2050, "awaitActivation, time_out");
                return false;
            }
            catch (Exception exception) {
                Debug.output(2050, exception);
            }
        }
        Debug.output(2050, "awaitActivation, returns true");
        return true;
    }

    public ImRPOAInfo(String string, String string2, int n, ImRServerInfo imRServerInfo) throws IllegalPOAName {
        if (string == null || string.length() == 0) {
            throw new IllegalPOAName(string);
        }
        this.name = string;
        this.host = string2;
        this.port = n;
        this.server = imRServerInfo;
        this.active = true;
    }

    static {
        String string = Environment.getProperty("jacorb.imr.timeout");
        if (string != null) {
            try {
                timeout = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

