/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.concurrency;

import org.jacorb.concurrency.TransactionCoordinator;
import org.omg.CosConcurrencyControl.LockNotHeld;
import org.omg.CosConcurrencyControl.lock_mode;

public class TransactionLocks {
    TransactionCoordinator current;
    private int read = 0;
    private int write = 0;
    private int upgrade = 0;
    private int intention_read = 0;
    private int intention_write = 0;

    synchronized boolean no_conflict(lock_mode lock_mode2) {
        if (lock_mode2.equals(lock_mode.read)) {
            return this.write == 0 && this.intention_write == 0;
        }
        if (lock_mode2.equals(lock_mode.write)) {
            return this.write == 0 && this.read == 0 && this.upgrade == 0 && this.intention_read == 0 && this.intention_write == 0;
        }
        if (lock_mode2.equals(lock_mode.upgrade)) {
            return this.upgrade == 0 && this.intention_write == 0 && this.write == 0;
        }
        if (lock_mode2.equals(lock_mode.intention_read)) {
            return this.write == 0;
        }
        if (lock_mode2.equals(lock_mode.intention_write)) {
            return this.write == 0 && this.read == 0 && this.upgrade == 0;
        }
        return false;
    }

    synchronized void lock(lock_mode lock_mode2) {
        if (lock_mode2.equals(lock_mode.read)) {
            ++this.read;
        } else if (lock_mode2.equals(lock_mode.write)) {
            ++this.write;
        } else if (lock_mode2.equals(lock_mode.upgrade)) {
            ++this.upgrade;
        } else if (lock_mode2.equals(lock_mode.intention_read)) {
            ++this.intention_read;
        } else if (lock_mode2.equals(lock_mode.intention_write)) {
            ++this.intention_write;
        }
    }

    synchronized void unlock(lock_mode lock_mode2) throws LockNotHeld {
        if (lock_mode2.equals(lock_mode.read)) {
            this.check_held(this.read);
            --this.read;
        } else if (lock_mode2.equals(lock_mode.write)) {
            this.check_held(this.write);
            --this.write;
        } else if (lock_mode2.equals(lock_mode.upgrade)) {
            this.check_held(this.upgrade);
            --this.upgrade;
        } else if (lock_mode2.equals(lock_mode.intention_read)) {
            this.check_held(this.intention_read);
            --this.intention_read;
        } else if (lock_mode2.equals(lock_mode.intention_write)) {
            this.check_held(this.intention_write);
            --this.intention_write;
        }
    }

    private final void check_held(int n) throws LockNotHeld {
        if (n == 0) {
            throw new LockNotHeld();
        }
    }

    boolean is_held(lock_mode lock_mode2) {
        if (lock_mode2.equals(lock_mode.read)) {
            return this.read > 0;
        }
        if (lock_mode2.equals(lock_mode.write)) {
            return this.write > 0;
        }
        if (lock_mode2.equals(lock_mode.upgrade)) {
            return this.upgrade > 0;
        }
        if (lock_mode2.equals(lock_mode.intention_read)) {
            return this.intention_read > 0;
        }
        if (lock_mode2.equals(lock_mode.intention_write)) {
            return this.intention_write > 0;
        }
        return false;
    }

    boolean any_locks() {
        return this.read != 0 || this.write != 0 || this.upgrade != 0 || this.intention_read != 0 || this.intention_write != 0;
    }

    public String toString() {
        return this.current.get_coordinator().get_transaction_name() + ": " + " read=" + this.read + " write=" + this.write + " upgrade=" + this.upgrade + " intention_read=" + this.intention_read + " intention_write=" + this.intention_write;
    }

    TransactionLocks(TransactionCoordinator transactionCoordinator) {
        this.current = transactionCoordinator;
    }
}

