/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DeviceHelper;
import fr.esrf.Tango.DeviceOperations;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoDs.DServer;
import fr.esrf.TangoDs.DServerClass;
import fr.esrf.TangoDs.DeviceClass;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.UtilPrint;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;

public class Util
implements TangoConst {
    private static Util _instance = null;
    private String ds_exec_name;
    private String ds_instance_name;
    private StringBuffer ds_name;
    static int _tracelevel = 0;
    public static UtilPrint out1;
    public static UtilPrint out2;
    public static UtilPrint out3;
    public static UtilPrint out4;
    public static boolean _UseDb;
    public static boolean _daemon;
    public static int _sleep_between_connect;
    private String db_host;
    private int db_port;
    private Database db;
    private String hostname;
    private String version_str;
    private int pid;
    private String pid_str;
    private Vector class_list;
    private ORB orb;
    private POA _poa;
    private String trace_output;
    private PrintStream out_tmp;
    private PrintStream file_stream;
    private Vector cmd_line_name_list = new Vector();
    private Vector class_name_list = new Vector();

    public static Util instance() {
        if (_instance == null) {
            System.err.println("Util is not initialised !!!");
            System.err.println("Exiting");
            System.exit(-1);
        }
        return _instance;
    }

    public static Util init(String[] stringArray, String string) {
        if (_instance == null) {
            _instance = new Util(stringArray, string);
        }
        return _instance;
    }

    protected Util(String[] stringArray, String string) {
        this.ds_exec_name = string;
        if (stringArray.length < 1) {
            this.print_usage();
            System.exit(-1);
        }
        this.check_args(stringArray);
        out1 = new UtilPrint(1);
        out2 = new UtilPrint(2);
        out3 = new UtilPrint(3);
        out4 = new UtilPrint(4);
        if (_UseDb) {
            this.read_env();
        }
        Properties properties = System.getProperties();
        properties.put("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        properties.put("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
        String string2 = System.getProperty("TANGO_TIMEOUT");
        if (string2 == null) {
            string2 = "3000";
        }
        properties.put("jacorb.connection.server_timeout", string2);
        System.setProperties(properties);
        this.orb = ORB.init(stringArray, properties);
        POA pOA = null;
        try {
            pOA = POAHelper.narrow(this.orb.resolve_initial_references("RootPOA"));
        }
        catch (InvalidName invalidName) {
            System.err.println("Can't intialise CORBA ORB !!!");
            System.err.println("Failed when trying to get root POA reference");
            System.exit(-1);
        }
        POA pOA2 = null;
        try {
            if (!_UseDb) {
                IdAssignmentPolicy idAssignmentPolicy = pOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID);
                Policy[] policyArray = new Policy[]{idAssignmentPolicy, pOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
                POAManager pOAManager = pOA.the_POAManager();
                pOA2 = pOA.create_POA("nodb_poa", pOAManager, policyArray);
            }
        }
        catch (AdapterAlreadyExists adapterAlreadyExists) {
            System.err.println("Can't create CORBA POA !!!");
            System.err.println("POA already exists");
            System.exit(-1);
        }
        catch (InvalidPolicy invalidPolicy) {
            System.err.println("Can't create CORBA POA !!!");
            System.err.println("Invalid policy");
            System.exit(-1);
        }
        this._poa = _UseDb ? pOA : pOA2;
        this.trace_output = "Initial Output";
        this.out_tmp = System.out;
        if (_UseDb) {
            this.connect_db();
            this.server_already_running();
        }
        this.misc_init();
        out4.println("Util object singleton constructed");
    }

    private void check_args(String[] stringArray) {
        if (stringArray[0].charAt(0) == '-') {
            this.print_usage();
            System.exit(-1);
        }
        this.ds_instance_name = stringArray[0];
        if (stringArray.length > 1) {
            int n = 1;
            block7: while (n < stringArray.length) {
                if (stringArray[n].charAt(0) == '-') {
                    switch (stringArray[n].charAt(1)) {
                        case 'v': {
                            if (stringArray[n].length() == 2) {
                                if (stringArray.length - 1 > n) {
                                    if (stringArray[n + 1].charAt(0) == '-') {
                                        this.set_trace_level(4);
                                    } else {
                                        this.print_usage();
                                        System.exit(-1);
                                    }
                                } else {
                                    this.set_trace_level(4);
                                }
                                ++n;
                                break;
                            }
                            String string = stringArray[n].substring(2);
                            int n2 = 0;
                            try {
                                n2 = Integer.parseInt(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.print_usage();
                                System.exit(-1);
                            }
                            this.set_trace_level(n2);
                            ++n;
                            break;
                        }
                        case 'n': {
                            if (!stringArray[n].equals("-nodb")) {
                                this.print_usage();
                                System.exit(-1);
                                break;
                            }
                            _UseDb = false;
                            ++n;
                            break;
                        }
                        case 'd': {
                            String string;
                            if (!stringArray[n].equals("-dlist")) {
                                this.print_usage();
                                System.exit(-1);
                                break;
                            }
                            if (_UseDb) {
                                this.print_usage();
                                System.exit(-1);
                            }
                            if (++n == stringArray.length) {
                                this.print_usage();
                                System.exit(-1);
                                break;
                            }
                            String string2 = stringArray[n];
                            int n2 = 0;
                            int n3 = 0;
                            while ((n3 = string2.indexOf(44, n2)) != -1) {
                                string = string2.substring(n2, n3);
                                n2 = n3 + 1;
                                this.cmd_line_name_list.addElement(string);
                            }
                            if (n2 != string2.length()) {
                                string = string2.substring(n2);
                                this.cmd_line_name_list.addElement(string);
                            }
                            int n4 = 0;
                            while (n4 < this.cmd_line_name_list.size()) {
                                int n5 = 0;
                                while (n5 < this.cmd_line_name_list.size()) {
                                    if (n4 != n5 && ((String)this.cmd_line_name_list.elementAt(n4)).equals((String)this.cmd_line_name_list.elementAt(n5))) {
                                        System.err.println("Each device name must have different name");
                                        System.exit(-1);
                                    }
                                    ++n5;
                                }
                                ++n4;
                            }
                            continue block7;
                        }
                        default: {
                            ++n;
                            break;
                        }
                    }
                    continue;
                }
                if (stringArray[n - 1].substring(0, 2).equals("-v")) {
                    this.print_usage();
                    System.exit(-1);
                }
                ++n;
            }
        }
        this.ds_exec_name = this.ds_exec_name.toLowerCase();
        this.ds_instance_name = this.ds_instance_name.toLowerCase();
        this.ds_name = new StringBuffer(this.ds_exec_name);
        this.ds_name.append("/");
        this.ds_name.append(this.ds_instance_name);
        if (this.ds_name.length() > 255) {
            System.err.println("The device server name is too long! Max length is 255 characters.");
            System.exit(-1);
        }
    }

    private void print_usage() {
        System.err.print("usage : " + this.ds_exec_name + " instance_name [-v[trace level]]");
        System.err.println(" [-nodb [-dlist <device name list>]]");
    }

    private void read_env() {
        String string;
        int n;
        String string2 = System.getProperty("TANGO_HOST");
        if (string2 == null) {
            System.err.println("TANGO_HOST system property not defined, exiting...");
            System.exit(-1);
        }
        if ((n = string2.indexOf(58)) == -1) {
            System.err.println("Wrong syntax for TANGO_HOST system property");
            System.err.println("Syntax = <host>:<port>");
            System.exit(-1);
        }
        this.db_host = string2.substring(0, n);
        if (this.db_host.length() == 0) {
            System.err.println("Wrong syntax for TANGO_HOST system property");
            System.err.println("Syntax = <host>:<port>");
            System.exit(-1);
        }
        if ((string = string2.substring(n + 1)).length() == 0) {
            System.err.println("Wrong syntax for TANGO_HOST system property");
            System.err.println("Syntax = <host>:<port>");
            System.exit(-1);
        }
        this.db_port = Integer.parseInt(string);
        out4.println("Db host = " + this.db_host + ", Db port = " + this.db_port);
    }

    private void misc_init() {
        this.pid = 0;
        this.pid_str = String.valueOf(this.pid);
        try {
            String string = InetAddress.getLocalHost().toString();
            int n = string.indexOf(47);
            String string2 = string.substring(0, n);
            n = string2.indexOf(46);
            this.hostname = n == -1 ? string2 : string2.substring(0, n);
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Cant retrieve server host name");
            System.exit(1);
        }
        out4.println("Hostname = " + this.hostname);
        this.version_str = String.valueOf(1);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void connect_db() {
        if (Util._daemon) {
            var1_1 = false;
            while (!var1_1) {
                try {
                    this.db = ApiUtil.get_db_obj();
                    if (this.db == null) {
                        Util.out4.println("Can't contact db server, will try later");
                        try {
                            this.wait(Util._sleep_between_connect * 1000);
                        }
                        catch (InterruptedException var2_4) {}
                        continue;
                    }
                    var1_1 = true;
                }
                catch (Exception var2_5) {
                    Util.out4.println("Can't contact db server, will try later");
                    try {
                        this.wait(Util._sleep_between_connect * 1000);
                    }
                    catch (InterruptedException var3_6) {
                        // empty catch block
                    }
                }
            }
        } else {
            try {
                this.db = ApiUtil.get_db_obj();
                if (this.db != null) ** GOTO lbl35
                System.err.println("Can't build connection to TANGO database server, exiting");
                System.err.println("DB server host = " + this.db_host);
                System.exit(-1);
            }
            catch (Exception var1_2) {
                System.err.println("Can't build connection to TANGO database server, exiting");
                System.err.println("DB server host = " + this.db_host);
                System.exit(-1);
            }
        }
lbl35:
        // 4 sources

        Util.out4.println("Connected to database");
    }

    private synchronized void server_already_running() {
        java.lang.Object object;
        out4.println("Entering Tango::server_already_running method");
        Random random = new Random();
        int n = random.nextInt(1000);
        try {
            this.wait(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer("dserver");
        stringBuffer.append('/');
        stringBuffer.append(this.ds_name);
        String string = new String(stringBuffer);
        DeviceOperations deviceOperations = null;
        try {
            object = this.db.import_device(string);
            if (!((DbDevImportInfo)object).exported) {
                out4.println("Leaving Tango::server_already_running method");
                return;
            }
            Object object2 = this.orb.string_to_object(((DbDevImportInfo)object).ior);
            deviceOperations = DeviceHelper.narrow(object2);
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("DB_DeviceNotDefined")) {
                System.err.println("This device server is not defined in database. Exiting!");
                System.exit(-1);
            }
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            System.err.println("Can't pack/unpack data sent to/from database in/to Any object");
            System.exit(-1);
        }
        catch (TRANSIENT tRANSIENT) {
            out4.println("Leaving Tango::server_already_running method");
            return;
        }
        catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
            out4.println("Leaving Tango::server_already_running method");
            return;
        }
        if (deviceOperations == null) {
            out4.println("Leaving Tango::server_already_running method");
            return;
        }
        try {
            object = deviceOperations.name();
            if (((String)object).equals(string)) {
                System.err.println("This server is already running, exiting!");
                System.exit(-1);
            }
        }
        catch (NO_RESPONSE nO_RESPONSE) {
            System.err.println("This server is already running but is blocked!");
            System.exit(-1);
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        out4.println("Leaving Tango::server_already_running method");
    }

    public void server_init() throws DevFailed {
        DServerClass.init();
    }

    public void server_run() {
        this.orb.run();
    }

    public Vector get_device_list_by_class(String string) throws DevFailed {
        Vector vector = this.class_list;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (((DeviceClass)vector.elementAt(n2)).get_name().equals(string)) break;
            ++n2;
        }
        if (n2 == n) {
            StringBuffer stringBuffer = new StringBuffer("Class ");
            stringBuffer.append(string);
            stringBuffer.append(" not found");
            Except.throw_exception("API_ClassNotFound", new String(stringBuffer), new String("Util::get_device_list_by_class()"));
        }
        return ((DeviceClass)vector.elementAt(n2)).get_device_list();
    }

    public DeviceImpl get_device_by_name(String string) throws DevFailed {
        Vector vector = this.class_list;
        Vector vector2 = this.get_device_list_by_class(((DeviceClass)vector.elementAt(0)).get_name());
        int n = vector.size();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        n4 = 0;
        while (n4 < n) {
            vector2 = this.get_device_list_by_class(((DeviceClass)vector.elementAt(n4)).get_name());
            n2 = vector2.size();
            n3 = 0;
            while (n3 < n2) {
                if (((DeviceImpl)vector2.elementAt(n3)).get_name().equals(string)) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (bl) break;
            ++n4;
        }
        if (n4 == n && n3 == n2) {
            StringBuffer stringBuffer = new StringBuffer("Device ");
            stringBuffer.append(string);
            stringBuffer.append(" not found");
            Except.throw_exception("API_DeviceNotFound", new String(stringBuffer), new String("Util::get_device_by_name()"));
        }
        return (DeviceImpl)vector2.elementAt(n3);
    }

    public DServer get_dserver_device() {
        return (DServer)DServerClass.instance().get_device_list().elementAt(0);
    }

    public void unregister_server() {
        out4.println("Entering Tango::unregister_server method");
        if (_UseDb) {
            try {
                this.db.unexport_server(this.ds_name.toString());
            }
            catch (SystemException systemException) {
                Except.print_exception(systemException);
                System.exit(-1);
            }
            catch (DevFailed devFailed) {
                Except.print_exception(devFailed);
                System.exit(-1);
            }
            catch (UserException userException) {
                Except.print_exception(userException);
                System.exit(-1);
            }
        }
        out4.println("Leaving Tango::unregister_server method");
    }

    public static Any return_empty_any(String string) throws DevFailed {
        Any any = null;
        try {
            any = Util.instance().get_orb().create_any();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(".execute");
            out3.println("Bad allocation while in " + string + ".execute()");
            Except.throw_exception("API_MemoryAllocation", new String("Can't allocate memory in server"), new String(stringBuffer));
        }
        out4.println("Leaving " + string + ".execute()");
        return any;
    }

    public void set_trace_level(int n) {
        _tracelevel = n;
    }

    public int get_trace_level() {
        return _tracelevel;
    }

    public String get_trace_output() {
        return this.trace_output;
    }

    public void set_trace_output(String string) {
        this.trace_output = string;
    }

    public String get_ds_inst_name() {
        return this.ds_instance_name;
    }

    public String get_ds_exec_name() {
        return this.ds_exec_name;
    }

    public String get_ds_name() {
        return new String(this.ds_name);
    }

    public String get_host_name() {
        return this.hostname;
    }

    public String get_version_str() {
        return this.version_str;
    }

    public Database get_database() {
        return this.db;
    }

    public PrintStream get_out() {
        return this.out_tmp;
    }

    public void set_trace_output_stream(PrintStream printStream) {
        this.file_stream = printStream;
    }

    public PrintStream get_trace_output_stream() {
        return this.file_stream;
    }

    public ORB get_orb() {
        return this.orb;
    }

    public POA get_poa() {
        return this._poa;
    }

    public String get_pid_str() {
        return this.pid_str;
    }

    public void set_class_list(Vector vector) {
        this.class_list = vector;
    }

    Vector get_class_list() {
        return this.class_list;
    }

    Vector get_cmd_line_name_list() {
        return this.cmd_line_name_list;
    }

    public void add_class(String string) {
        this.class_name_list.addElement(string);
    }

    public Vector get_class_name_list() {
        return this.class_name_list;
    }

    void registerDeviceForJacorb(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String[] stringArray = new String[3];
        int n = 0;
        while (n < 3 && stringTokenizer.countTokens() > 0) {
            stringArray[n] = stringTokenizer.nextToken().toString();
            ++n;
        }
        String string2 = "&%25";
        String string3 = new String("StandardImplName/nodb_poa/" + stringArray[0] + string2 + stringArray[1] + string2 + stringArray[2]);
        org.jacorb.orb.ORB oRB = (org.jacorb.orb.ORB)this.orb;
        oRB.putObjectKeyMap(string, string3);
    }

    static {
        _UseDb = true;
        _daemon = false;
        _sleep_between_connect = 60;
    }
}

