/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.TangoDs.TangoConst;
import org.omg.CORBA.SystemException;

public class Except
implements TangoConst {
    public static void print_exception(Exception ex) {
        String ex_name = ex.getClass().getName();
        int last_dot = ex_name.lastIndexOf(46);
        if (last_dot == -1) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            return;
        }
        String ex_last_name = ex_name.substring(last_dot + 1);
        if (ex_last_name.equals("DevFailed")) {
            DevFailed ex_dev = (DevFailed)ex;
            int i = 0;
            while (i < ex_dev.errors.length) {
                System.err.println("Tango exception");
                System.err.print("Severity -> ");
                switch (ex_dev.errors[i].severity.value()) {
                    case 0: {
                        System.err.println("WARNING ");
                        break;
                    }
                    case 1: {
                        System.err.println("ERROR ");
                        break;
                    }
                    case 2: {
                        System.err.println("PANIC ");
                        break;
                    }
                    default: {
                        System.err.println("Unknown severity code");
                    }
                }
                System.err.println("Desc -> " + ex_dev.errors[i].desc);
                System.err.println("Reason -> " + ex_dev.errors[i].reason);
                System.err.println("Origin -> " + ex_dev.errors[i].origin);
                ++i;
            }
        } else {
            int before_last_dot = ex_name.lastIndexOf(46, last_dot - 1);
            if (before_last_dot == -1) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
            } else {
                String ex_part_name = ex_name.substring(before_last_dot + 1, last_dot);
                if (ex_part_name.equals("CORBA")) {
                    SystemException ex_sys = (SystemException)ex;
                    System.err.println("CORBA system exception " + ex_last_name);
                    System.err.println(ex.getMessage());
                    System.err.print("Completed: ");
                    switch (ex_sys.completed.value()) {
                        case 0: {
                            System.err.println("yes");
                            break;
                        }
                        case 1: {
                            System.err.println("no");
                            break;
                        }
                        case 2: {
                            System.err.println("maybe");
                        }
                    }
                    System.err.println("Minor code: " + ex_sys.minor);
                } else {
                    System.err.println(ex.getMessage());
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void print_exception_stack(Exception ex) {
        Except.print_exception(ex);
        ex.printStackTrace();
    }

    public static void throw_exception(String reason, String desc, String origin) throws DevFailed {
        DevError[] err = new DevError[]{new DevError()};
        err[0].desc = desc;
        err[0].severity = ErrSeverity.ERR;
        err[0].reason = reason;
        err[0].origin = origin;
        throw new DevFailed(err);
    }

    public static void throw_exception(String reason, String desc, String origin, ErrSeverity sever) throws DevFailed {
        DevError[] err = new DevError[]{new DevError()};
        err[0].desc = desc;
        err[0].severity = sever;
        err[0].reason = reason;
        err[0].origin = origin;
        throw new DevFailed(err);
    }

    public static void re_throw_exception(DevFailed ex, String reason, String desc, String origin) throws DevFailed {
        int nb_error = ex.errors.length;
        DevError[] err = new DevError[nb_error + 1];
        int i = 0;
        while (i < nb_error) {
            err[i] = ex.errors[i];
            ++i;
        }
        err[nb_error] = new DevError();
        err[nb_error].desc = desc;
        err[nb_error].severity = ErrSeverity.ERR;
        err[nb_error].reason = reason;
        err[nb_error].origin = origin;
        throw new DevFailed(err);
    }

    public static void re_throw_exception(DevFailed ex, String reason, String desc, String origin, ErrSeverity sever) throws DevFailed {
        int nb_error = ex.errors.length;
        DevError[] err = new DevError[nb_error + 1];
        int i = 0;
        while (i < nb_error) {
            err[i] = ex.errors[i];
            ++i;
        }
        err[nb_error] = new DevError();
        err[nb_error].desc = desc;
        err[nb_error].severity = sever;
        err[nb_error].reason = reason;
        err[nb_error].origin = origin;
        throw new DevFailed(err);
    }

    public static void throw_exception(SystemException ex, String origin) throws DevFailed {
        DevError[] err = new DevError[]{new DevError()};
        err[0].desc = Except.print_CORBA_SystemException(ex);
        err[0].severity = ErrSeverity.ERR;
        err[0].reason = "API_CorbaSysException";
        err[0].origin = origin;
        throw new DevFailed(err);
    }

    public static String print_CORBA_SystemException(SystemException ex) {
        String ex_name = ex.getClass().getName();
        int last_dot = ex_name.lastIndexOf(46);
        if (last_dot == -1) {
            return new String("Unknown system exception !!!!!!!!");
        }
        String ex_last_name = ex_name.substring(last_dot + 1);
        int before_last_dot = ex_name.lastIndexOf(46, last_dot - 1);
        if (before_last_dot == -1) {
            return new String("Unknown system exception !!!!!!!!");
        }
        String ex_part_name = ex_name.substring(before_last_dot + 1, last_dot);
        if (ex_part_name.equals("CORBA")) {
            StringBuffer str = new StringBuffer("CORBA system exception ");
            str.append(ex_last_name);
            str.append(ex.getMessage());
            str.append("Completed: ");
            switch (ex.completed.value()) {
                case 0: {
                    str.append("yes");
                    break;
                }
                case 1: {
                    str.append("no");
                    break;
                }
                case 2: {
                    str.append("maybe");
                }
            }
            str.append("Minor code: ");
            str.append(ex.minor);
            return str.toString();
        }
        return new String("Unknown system exception !!!!!!!!");
    }
}

