/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.AttributeConfig;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.DevicePOA;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoDs.Attr;
import fr.esrf.TangoDs.Attribute;
import fr.esrf.TangoDs.BlackBox;
import fr.esrf.TangoDs.Command;
import fr.esrf.TangoDs.DeviceClass;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.MultiAttribute;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.Util;
import java.io.Serializable;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.PortableServer.POA;

public abstract class DeviceImpl
extends DevicePOA
implements TangoConst {
    protected BlackBox blackbox;
    protected int blackbox_depth;
    protected String device_name;
    protected String adm_device_name;
    protected String desc;
    protected String device_status;
    protected DevState device_state;
    protected byte[] access;
    protected int version;
    protected DeviceClass device_class;
    protected MultiAttribute dev_attr;
    protected DbDevice db_dev;
    private byte[] obj_id;
    private boolean exported = false;

    public DeviceImpl(DeviceClass deviceClass, String string, String string2, DevState devState, String string3) throws DevFailed {
        this.device_class = deviceClass;
        this.device_name = string;
        this.desc = string2;
        this.device_state = devState;
        this.device_status = string3;
        this.version = 1;
        this.blackbox_depth = 0;
        Util.instance();
        if (Util._UseDb) {
            this.db_dev = new DbDevice(this.device_name);
        }
        this.get_dev_system_resource();
        this.black_box_create();
        this.dev_attr = new MultiAttribute(this.device_name, this.device_class);
        StringBuffer stringBuffer = new StringBuffer("dserver/");
        stringBuffer.append(Util.instance().get_ds_name());
        this.adm_device_name = stringBuffer.toString();
    }

    public DeviceImpl(DeviceClass deviceClass, String string) throws DevFailed {
        this.device_class = deviceClass;
        this.device_name = string;
        this.desc = new String("A Tango device");
        this.device_state = DevState.UNKNOWN;
        this.device_status = new String("Not Initialised");
        this.version = 1;
        this.blackbox_depth = 0;
        Util.instance();
        if (Util._UseDb) {
            this.db_dev = new DbDevice(this.device_name);
        }
        this.get_dev_system_resource();
        this.black_box_create();
        this.dev_attr = new MultiAttribute(this.device_name, this.device_class);
        StringBuffer stringBuffer = new StringBuffer("dserver/");
        stringBuffer.append(Util.instance().get_ds_name());
        this.adm_device_name = stringBuffer.toString();
    }

    public DeviceImpl(DeviceClass deviceClass, String string, String string2) throws DevFailed {
        this.device_class = deviceClass;
        this.device_name = string;
        this.desc = string2;
        this.device_state = DevState.UNKNOWN;
        this.device_status = new String("Not Initialised");
        this.version = 1;
        this.blackbox_depth = 0;
        Util.instance();
        if (Util._UseDb) {
            this.db_dev = new DbDevice(this.device_name);
        }
        this.get_dev_system_resource();
        this.black_box_create();
        this.dev_attr = new MultiAttribute(this.device_name, this.device_class);
        StringBuffer stringBuffer = new StringBuffer("dserver/");
        stringBuffer.append(Util.instance().get_ds_name());
        this.adm_device_name = stringBuffer.toString();
    }

    private void black_box_create() {
        this.blackbox = this.blackbox_depth == 0 ? new BlackBox() : new BlackBox(this.blackbox_depth);
    }

    private void get_dev_system_resource() throws DevFailed {
        Util.instance();
        if (Util._UseDb) {
            try {
                String[] stringArray = new String[]{"blackbox_depth", "description"};
                DbDatum[] dbDatumArray = this.db_dev.get_property(stringArray);
                if (!dbDatumArray[0].is_empty()) {
                    this.blackbox_depth = dbDatumArray[0].extractLong();
                }
                if (!dbDatumArray[1].is_empty()) {
                    this.desc = dbDatumArray[1].extractString();
                }
            }
            catch (DevFailed devFailed) {
                StringBuffer stringBuffer = new StringBuffer("Database error while trying to retrieve device properties for device ");
                stringBuffer.append(this.device_name);
                Except.throw_exception("API_DatabaseAccess", stringBuffer.toString(), "DeviceImpl::get_dev_system_resource");
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                StringBuffer stringBuffer = new StringBuffer("Database error while trying to retrieve device properties for device ");
                stringBuffer.append(this.device_name);
                Except.throw_exception("API_DatabaseAccess", stringBuffer.toString(), "DeviceImpl::get_dev_system_resource");
            }
        }
    }

    public Any command_inout(String string, Any any) throws DevFailed {
        Util.out4.println("DeviceImpl.command_inout(): command received : " + string);
        this.blackbox.insert_cmd(string);
        Any any2 = this.device_class.command_handler(this, string, any);
        Util.out4.println("DeviceImpl.command_inout(): leaving method for command " + string);
        return any2;
    }

    public String name() {
        Util.out4.println("DeviceImpl.name() arrived");
        this.blackbox.insert_attr(1);
        Util.out4.println("Leaving DeviceImpl.name()");
        return this.device_name;
    }

    public String adm_name() {
        Util.out4.println("DeviceImpl.adm_name() arrived");
        this.blackbox.insert_attr(5);
        Util.out4.println("Leaving DeviceImpl.adm_name()");
        return this.adm_device_name;
    }

    public String description() {
        Util.out4.println("DeviceImpl.description() arrived");
        this.blackbox.insert_attr(2);
        Util.out4.println("Leaving DeviceImpl.description()");
        return this.desc;
    }

    public DevState state() {
        Util.out4.println("DeviceImpl.state() (attribute) arrived");
        this.blackbox.insert_attr(3);
        DevState devState = null;
        try {
            devState = this.dev_state();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        Util.out4.println("Leaving DeviceImpl.state() (attribute)");
        return devState;
    }

    public String status() {
        Util.out4.println("DeviceImpl.status() (attibute) arrived");
        this.blackbox.insert_attr(4);
        String string = null;
        try {
            string = this.dev_status();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        Util.out4.println("Leaving DeviceImpl.status() (attribute)");
        return string;
    }

    public String[] black_box(int n) throws DevFailed {
        Util.out4.println("DeviceImpl.black_box() arrived");
        String[] stringArray = this.blackbox.read(n);
        this.blackbox.insert_op(2);
        Util.out4.println("Leaving DeviceImpl.black_box()");
        return stringArray;
    }

    public DevCmdInfo[] command_list_query() {
        Util.out4.println("DeviceImpl.command_list_query() arrived");
        int n = this.device_class.get_command_list().size();
        Util.out4.println(n + " command(s) for device");
        DevCmdInfo[] devCmdInfoArray = new DevCmdInfo[n];
        int n2 = 0;
        while (n2 < n) {
            devCmdInfoArray[n2] = new DevCmdInfo();
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            devCmdInfoArray[n3].cmd_name = ((Command)this.device_class.get_command_list().elementAt(n3)).get_name();
            devCmdInfoArray[n3].cmd_tag = ((Command)this.device_class.get_command_list().elementAt(n3)).get_disp_type();
            devCmdInfoArray[n3].in_type = ((Command)this.device_class.get_command_list().elementAt(n3)).get_in_type();
            devCmdInfoArray[n3].out_type = ((Command)this.device_class.get_command_list().elementAt(n3)).get_out_type();
            String string = ((Command)this.device_class.get_command_list().elementAt(n3)).get_in_type_desc();
            devCmdInfoArray[n3].in_type_desc = string == null ? "Uninitialised" : string;
            string = ((Command)this.device_class.get_command_list().elementAt(n3)).get_out_type_desc();
            devCmdInfoArray[n3].out_type_desc = string == null ? "Uninitialised" : string;
            ++n3;
        }
        this.blackbox.insert_op(5);
        Util.out4.println("Leaving DeviceImpl.command_list_query()");
        return devCmdInfoArray;
    }

    public DevCmdInfo command_query(String string) throws DevFailed {
        CharSequence charSequence;
        Util.out4.println("DeviceImpl.command_query() arrived");
        DevCmdInfo devCmdInfo = new DevCmdInfo();
        int n = this.device_class.get_command_list().size();
        int n2 = 0;
        while (n2 < n) {
            if (((Command)this.device_class.get_command_list().elementAt(n2)).get_name().equals(string)) {
                devCmdInfo.cmd_name = string;
                devCmdInfo.cmd_tag = ((Command)this.device_class.get_command_list().elementAt(n2)).get_disp_type();
                devCmdInfo.in_type = ((Command)this.device_class.get_command_list().elementAt(n2)).get_in_type();
                devCmdInfo.out_type = ((Command)this.device_class.get_command_list().elementAt(n2)).get_out_type();
                charSequence = ((Command)this.device_class.get_command_list().elementAt(n2)).get_in_type_desc();
                devCmdInfo.in_type_desc = charSequence == null ? "Uninitialised" : charSequence;
                charSequence = ((Command)this.device_class.get_command_list().elementAt(n2)).get_out_type_desc();
                if (charSequence == null) {
                    devCmdInfo.out_type_desc = "Uninitialised";
                    break;
                }
                devCmdInfo.out_type_desc = charSequence;
                break;
            }
            ++n2;
        }
        if (n2 == n) {
            Util.out3.println("DeviceImpl.command_query(): operation " + string + " not found");
            charSequence = new StringBuffer("Command ");
            charSequence.append(string);
            charSequence.append(" not found");
            Except.throw_exception("API_CommandNotFound", new String((StringBuffer)charSequence), new String("DeviceImpl.command_query()"));
        }
        this.blackbox.insert_op(6);
        Util.out4.println("Leaving DeviceImpl.command_query()");
        return devCmdInfo;
    }

    public DevInfo info() {
        Util.out4.println("DeviceImpl.info() arrived");
        DevInfo devInfo = new DevInfo();
        Util util = Util.instance();
        devInfo.server_host = util.get_host_name();
        devInfo.dev_class = this.device_class.get_name();
        devInfo.server_id = util.get_ds_name();
        devInfo.server_version = 1;
        devInfo.doc_url = this.device_class.get_doc_url();
        this.blackbox.insert_op(4);
        Util.out4.println("Leaving DeviceImpl.info()");
        return devInfo;
    }

    public void ping() {
        Util.out4.println("DeviceImpl.ping() arrived");
        this.blackbox.insert_op(3);
        Util.out4.println("Leaving DeviceImpl.ping()");
    }

    public AttributeConfig[] get_attribute_config(String[] stringArray) throws DevFailed {
        Util.out4.println("DeviceImpl::get_attribute_config arrived");
        int n = stringArray.length;
        boolean bl = false;
        this.blackbox.insert_op(7);
        int n2 = this.dev_attr.get_attr_nb();
        if (n2 == 0) {
            Except.throw_exception("API_AttrNotFound", "The device does not have any attribute", "DeviceImpl.get_attribute_config");
        }
        if (n == 1 && stringArray[0].equals("All attributes")) {
            n = n2;
            bl = true;
        }
        AttributeConfig[] attributeConfigArray = null;
        try {
            attributeConfigArray = new AttributeConfig[n];
            int n3 = 0;
            while (n3 < n) {
                attributeConfigArray[n3] = new AttributeConfig();
                ++n3;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Util.out3.println("Bad allocation while in DeviceImpl.get_attribute_config");
            Except.throw_exception("API_MemoryAllocation", "Can't allocate memory in server", "DeviceImpl.get_attribute_config");
        }
        int n4 = 0;
        while (n4 < n) {
            Attribute attribute;
            if (bl) {
                attribute = this.dev_attr.get_attr_by_ind(n4);
                attribute.get_properties(attributeConfigArray[n4]);
            } else {
                attribute = this.dev_attr.get_attr_by_name(stringArray[n4]);
                attribute.get_properties(attributeConfigArray[n4]);
            }
            ++n4;
        }
        Util.out4.println("Leaving DeviceImpl.get_attribute_config");
        return attributeConfigArray;
    }

    /*
     * Unable to fully structure code
     */
    public void set_attribute_config(AttributeConfig[] var1_1) throws DevFailed {
        block11: {
            Util.out4.println("DeviceImpl.set_attribute_config arrived");
            this.blackbox.insert_op(8);
            var2_2 = this.dev_attr.get_attr_nb();
            if (var2_2 == 0) {
                Except.throw_exception("API_AttrNotFound", "The device does not have any attribute", "DeviceImpl.set_attribute_config");
            }
            var3_3 = var1_1.length;
            var4_4 = 0;
            try {
                var4_4 = 0;
                while (var4_4 < var3_3) {
                    var5_5 = this.dev_attr.get_attr_by_name(var1_1[var4_4].name);
                    if (Util._UseDb) {
                        var5_5.upd_database(var1_1[var4_4], this.device_name);
                    }
                    var5_5.set_properties(var1_1[var4_4], this.device_name);
                    ++var4_4;
                }
                break block11;
            }
            catch (DevFailed var5_6) {
                this.dev_attr.get_alarm_list().removeAllElements();
                var6_7 = 0;
                ** while (var6_7 < var2_2)
            }
lbl-1000:
            // 1 sources

            {
                if (this.dev_attr.get_attr_by_ind(var6_7).is_alarmed()) {
                    this.dev_attr.get_alarm_list().addElement(new Integer(var6_7));
                }
                ++var6_7;
                continue;
            }
lbl26:
            // 1 sources

            var7_8 = new StringBuffer(var5_6.errors[0].reason);
            if (var4_4 != 0) {
                var7_8.append("\nAll previous attribute(s) have been successfully updated");
            }
            if (var4_4 != var3_3 - 1) {
                var7_8.append("\nAll remaining attribute(s) have not been updated");
            }
            var5_6.errors[0].reason = var7_8.toString();
            throw var5_6;
        }
        this.dev_attr.get_alarm_list().removeAllElements();
        var4_4 = 0;
        while (var4_4 < var2_2) {
            if (this.dev_attr.get_attr_by_ind(var4_4).is_alarmed()) {
                this.dev_attr.get_alarm_list().addElement(new Integer(var4_4));
            }
            ++var4_4;
        }
        Util.out4.println("Leaving DeviceImpl.set_attribute_config");
    }

    public AttributeValue[] read_attributes(String[] stringArray) throws DevFailed {
        Object object;
        int n;
        int n2;
        Util.out4.println("DeviceImpl.read_attributes arrived");
        this.blackbox.insert_op(9);
        int n3 = this.dev_attr.get_attr_nb();
        if (n3 == 0) {
            Except.throw_exception("API_AttrNotFound", "The device does not have any attribute", "DeviceImpl.read_attributes");
        }
        String[] stringArray2 = null;
        int n4 = stringArray.length;
        if (n4 == 1) {
            if (stringArray[0].equals("All attributes")) {
                stringArray2 = new String[n3];
                n2 = 0;
                while (n2 < n3) {
                    stringArray2[n2] = this.dev_attr.get_attr_by_ind(n2).get_name();
                    ++n2;
                }
            } else {
                stringArray2 = stringArray;
            }
        } else {
            stringArray2 = stringArray;
        }
        n4 = stringArray2.length;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        n2 = 0;
        while (n2 < n4) {
            n = this.dev_attr.get_attr_ind_by_name(stringArray2[n2]);
            if (this.dev_attr.get_attr_by_ind(n).get_writable() == AttrWriteType.READ_WRITE) {
                vector2.addElement(new Integer(n));
                vector.addElement(new Integer(n));
                this.dev_attr.get_attr_by_ind((Integer)vector.lastElement()).set_value_flag(false);
            } else if (this.dev_attr.get_attr_by_ind(n).get_writable() == AttrWriteType.WRITE) {
                vector2.addElement(new Integer(n));
            } else {
                vector.addElement(new Integer(n));
                this.dev_attr.get_attr_by_ind((Integer)vector.lastElement()).set_value_flag(false);
            }
            ++n2;
        }
        n = vector.size();
        int n5 = vector2.size();
        if (n != 0) {
            this.read_attr_hardware(vector);
        }
        n2 = 0;
        while (n2 < n) {
            this.read_attr(this.dev_attr.get_attr_by_ind((Integer)vector.elementAt(n2)));
            ++n2;
        }
        n2 = 0;
        while (n2 < n5) {
            object = this.dev_attr.get_attr_by_ind((Integer)vector2.elementAt(n2)).get_writable();
            if (object == AttrWriteType.READ_WITH_WRITE || object == AttrWriteType.WRITE) {
                this.dev_attr.get_attr_by_ind((Integer)vector2.elementAt(n2)).set_value();
            }
            ++n2;
        }
        object = null;
        try {
            object = new AttributeValue[n4];
            n2 = 0;
            while (n2 < n4) {
                object[n2] = new AttributeValue();
                ++n2;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Except.throw_exception("API_MemoryAllocation", "Can't allocate memory in server", "DeviceImpl.read_attributes");
        }
        n2 = 0;
        while (n2 < n4) {
            Serializable serializable;
            Attribute attribute = this.dev_attr.get_attr_by_name(stringArray2[n2]);
            if (!attribute.get_value_flag()) {
                serializable = new StringBuffer("Read value for attribute ");
                ((StringBuffer)serializable).append(attribute.get_name());
                ((StringBuffer)serializable).append(" has not been updated");
                Except.throw_exception("API_AttrValueNotSet", ((StringBuffer)serializable).toString(), "DeviceImpl::read_attributes");
            } else {
                serializable = attribute.get_writable();
                if (serializable == AttrWriteType.READ || serializable == AttrWriteType.READ_WRITE || serializable == AttrWriteType.READ_WITH_WRITE) {
                    if (serializable == AttrWriteType.READ_WRITE || serializable == AttrWriteType.READ_WITH_WRITE) {
                        this.dev_attr.add_write_value(attribute);
                    }
                    if (attribute.is_alarmed() && attribute.get_quality().value() != 1) {
                        attribute.check_alarm();
                    }
                }
                object[n2].time = attribute.get_when();
                object[n2].quality = attribute.get_quality();
                object[n2].name = attribute.get_name();
                object[n2].dim_x = attribute.get_x();
                object[n2].dim_y = attribute.get_y();
                Util util = Util.instance();
                object[n2].value = util.get_orb().create_any();
                switch (attribute.get_data_type()) {
                    case 2: {
                        DevVarShortArrayHelper.insert(object[n2].value, attribute.get_short_value());
                        break;
                    }
                    case 3: {
                        DevVarLongArrayHelper.insert(object[n2].value, attribute.get_long_value());
                        break;
                    }
                    case 5: {
                        DevVarDoubleArrayHelper.insert(object[n2].value, attribute.get_double_value());
                        break;
                    }
                    case 8: {
                        DevVarStringArrayHelper.insert(object[n2].value, attribute.get_string_value());
                    }
                }
            }
            ++n2;
        }
        Util.out4.println("Leaving DeviceImpl.read_attributes");
        return object;
    }

    /*
     * Unable to fully structure code
     */
    public void write_attributes(AttributeValue[] var1_1) throws DevFailed {
        Util.out4.println("DeviceImpl.write_attributes arrived");
        this.blackbox.insert_op(10);
        var2_2 = this.dev_attr.get_attr_nb();
        if (var2_2 == 0) {
            Except.throw_exception("API_AttrNotFound", "The device does not have any attribute", "DeviceImpl.write_attributes");
        }
        var3_3 = var1_1.length;
        var5_4 = new Vector<Integer>();
        var6_5 = 0;
        var6_5 = 0;
        while ((long)var6_5 < var3_3) {
            var5_4.addElement(new Integer(this.dev_attr.get_attr_ind_by_name(var1_1[var6_5].name)));
            ++var6_5;
        }
        var6_5 = 0;
        while ((long)var6_5 < var3_3) {
            if (this.dev_attr.get_attr_by_ind((Integer)var5_4.elementAt(var6_5)).get_writable() == AttrWriteType.READ || this.dev_attr.get_attr_by_ind((Integer)var5_4.elementAt(var6_5)).get_writable() == AttrWriteType.READ_WITH_WRITE) {
                var7_6 = new StringBuffer("Attribute ");
                var7_6.append(this.dev_attr.get_attr_by_ind((Integer)var5_4.elementAt(var6_5)).get_name());
                var7_6.append(" is not writable");
                Except.throw_exception("API_AttrNotWritable", var7_6.toString(), "DeviceImpl.write_attributes");
            }
            ++var6_5;
        }
        var6_5 = 0;
        while ((long)var6_5 < var3_3) {
            block8: {
                try {
                    this.dev_attr.get_w_attr_by_ind((Integer)var5_4.elementAt(var6_5)).set_write_value(var1_1[var6_5].value);
                    break block8;
                }
                catch (DevFailed var7_7) {
                    var8_8 = 0;
                    ** while (var8_8 < var6_5)
                }
lbl-1000:
                // 1 sources

                {
                    this.dev_attr.get_w_attr_by_ind((Integer)var5_4.elementAt(var8_8)).rollback();
                    ++var8_8;
                    continue;
                }
lbl36:
                // 1 sources

                throw var7_7;
            }
            ++var6_5;
        }
        this.write_attr_hardware(var5_4);
        Util.out4.println("Leaving DeviceImpl.write_attributes");
    }

    public void add_attribute(Attr attr) throws DevFailed {
        Vector vector = this.device_class.get_class_attr().get_attr_list();
        int n = vector.size();
        String string = attr.get_name();
        boolean bl = true;
        try {
            this.dev_attr.get_attr_by_name(string);
        }
        catch (DevFailed devFailed) {
            bl = false;
        }
        if (bl) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            if (((Attr)vector.elementAt(n2)).get_name().equals(string)) break;
            ++n2;
        }
        if (n2 == n) {
            vector.addElement(attr);
            this.device_class.get_class_attr().init_class_attribute(this.device_class.get_name(), n);
        }
        this.dev_attr.add_attribute(this.device_name, this.device_class, n2);
    }

    public DevState dev_state() throws DevFailed {
        Vector vector;
        int n;
        if ((this.device_state.value() == 0 || this.device_state.value() == 11) && (n = (vector = this.dev_attr.get_alarm_list()).size()) != 0) {
            this.read_attr_hardware(vector);
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute = this.dev_attr.get_attr_by_ind((Integer)vector.elementAt(n2));
                attribute.wanted_date(false);
                try {
                    this.read_attr(attribute);
                }
                catch (DevFailed devFailed) {
                    attribute.wanted_date(true);
                    throw devFailed;
                }
                attribute.wanted_date(true);
                ++n2;
            }
            if (this.dev_attr.check_alarm()) {
                this.device_state = DevState.ALARM;
            }
        }
        return this.device_state;
    }

    public String dev_status() throws DevFailed {
        if (this.device_state.value() == 11 || this.device_state.value() == 0) {
            StringBuffer stringBuffer = new StringBuffer(this.device_status);
            this.dev_attr.read_alarm(stringBuffer);
            return stringBuffer.toString();
        }
        return this.device_status;
    }

    public void read_attr_hardware(Vector vector) throws DevFailed {
    }

    public void read_attr(Attribute attribute) throws DevFailed {
    }

    public void write_attr_hardware(Vector vector) throws DevFailed {
    }

    public void always_executed_hook() throws DevFailed {
    }

    public abstract void init_device() throws DevFailed;

    public POA _default_POA() {
        return Util.instance().get_poa();
    }

    public String get_status() {
        return this.device_status;
    }

    public void set_status(String string) {
        this.device_status = string;
    }

    public DevState get_state() {
        return this.device_state;
    }

    public void set_state(DevState devState) {
        this.device_state = devState;
    }

    public String get_name() {
        return this.device_name;
    }

    public DeviceClass get_device_class() {
        return this.device_class;
    }

    public void set_device_attr(MultiAttribute multiAttribute) {
        this.dev_attr = multiAttribute;
    }

    public DbDevice get_db_device() {
        return this.db_dev;
    }

    public byte[] get_obj_id() {
        return this.obj_id;
    }

    public void set_obj_id(byte[] byArray) {
        this.obj_id = byArray;
    }

    void set_exported_flag(boolean bl) {
        this.exported = bl;
    }

    boolean get_exported_flag() {
        return this.exported;
    }
}

