/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.Device;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoDs.Command;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.MultiClassAttribute;
import fr.esrf.TangoDs.StateCmd;
import fr.esrf.TangoDs.StatusCmd;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.Util;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.PortableServer.POA;

public abstract class DeviceClass
implements TangoConst {
    protected String name;
    protected String doc_url;
    protected Vector command_list;
    protected Vector device_list;
    protected DbClass db_class;
    protected MultiClassAttribute class_attr;
    private Vector nodb_name_list = new Vector();

    protected DeviceClass(String string) throws DevFailed {
        this.name = string;
        Util.instance();
        if (Util._UseDb) {
            this.db_class = new DbClass(this.name);
        }
        this.command_list = new Vector();
        this.device_list = new Vector();
        this.command_list.addElement(new StatusCmd(new String("Status"), 0, 8, new String("Device status")));
        this.command_list.addElement(new StateCmd(new String("State"), 0, 19, new String("Device state")));
        this.get_class_system_resource();
        this.class_attr = new MultiClassAttribute();
    }

    private void get_class_system_resource() {
        block6: {
            Util.instance();
            if (Util._UseDb) {
                try {
                    DbDatum dbDatum = this.db_class.get_property(new String("doc_url"));
                    if (dbDatum.is_empty()) {
                        Util.out4.println("doc_url property for class " + this.name + " is not defined in database");
                        this.doc_url = "http://www.esrf.fr/tango";
                        break block6;
                    }
                    this.doc_url = dbDatum.extractString();
                }
                catch (DevFailed devFailed) {
                    this.doc_url = "http://www.esrf.fr/tango";
                }
                catch (BAD_OPERATION bAD_OPERATION) {
                    this.doc_url = "http://www.esrf.fr/tango";
                }
            } else {
                this.doc_url = "http://www.esrf.fr/tango";
            }
        }
    }

    protected void export_device(DeviceImpl deviceImpl) throws DevFailed {
        Util.out4.println("DeviceClass::export_device() arrived");
        Util util = Util.instance();
        ORB oRB = util.get_orb();
        Device device = deviceImpl._this(oRB);
        byte[] byArray = null;
        POA pOA = util.get_poa();
        try {
            byArray = pOA.reference_to_id(device);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Can't get CORBA reference ID for device ");
            stringBuffer.append(deviceImpl.get_name());
            Except.throw_exception("API_CantGetDevObjectID", stringBuffer.toString(), "DeviceClass.export_device()");
        }
        deviceImpl.set_obj_id(byArray);
        if (!Util._UseDb) {
            return;
        }
        DbDevExportInfo dbDevExportInfo = new DbDevExportInfo(deviceImpl.get_name(), oRB.object_to_string(device), util.get_host_name(), util.get_version_str());
        util.get_database().export_device(dbDevExportInfo);
        Util.out4.println("Leaving DeviceClass::export_device method()");
        deviceImpl.set_exported_flag(true);
    }

    protected void export_device(DeviceImpl deviceImpl, String string) throws DevFailed {
        Object object;
        IDLEntity iDLEntity;
        Util.out4.println("DeviceClass::export_device() arrived");
        Util.out4.println("name = " + string);
        byte[] byArray = string.getBytes();
        Util util = Util.instance();
        try {
            iDLEntity = util.get_poa();
            iDLEntity.activate_object_with_id(byArray, deviceImpl);
        }
        catch (Exception exception) {
            object = new StringBuffer("Can't activate device for device ");
            ((StringBuffer)object).append(deviceImpl.get_name());
            Except.throw_exception("API_CantBindDevice", ((StringBuffer)object).toString(), "DeviceClass.export_device()");
        }
        object = util.get_orb();
        iDLEntity = deviceImpl._this((ORB)object);
        deviceImpl.set_obj_id(byArray);
        util.registerDeviceForJacorb(string);
        deviceImpl.set_exported_flag(true);
        Util.out4.println("Leaving DeviceClass::export_device method()");
    }

    public Any command_handler(DeviceImpl deviceImpl, String string, Any any) throws DevFailed {
        StringBuffer stringBuffer;
        Any any2 = Util.instance().get_orb().create_any();
        Util.out4.println("Entering DeviceClass::command_handler() method");
        int n = 0;
        while (n < this.command_list.size()) {
            if (((Command)this.command_list.elementAt(n)).get_name().equals(string)) {
                deviceImpl.always_executed_hook();
                if (!((Command)this.command_list.elementAt(n)).is_allowed(deviceImpl, any)) {
                    stringBuffer = new StringBuffer("Command ");
                    stringBuffer.append(string);
                    stringBuffer.append(" not allowed when the device is in ");
                    stringBuffer.append(TangoConst.Tango_DevStateName[deviceImpl.get_state().value()]);
                    stringBuffer.append(" state");
                    Except.throw_exception("API_CommandNotAllowed", new String(stringBuffer), new String("DeviceClass.command_handler"));
                }
                any2 = ((Command)this.command_list.elementAt(n)).execute(deviceImpl, any);
                break;
            }
            ++n;
        }
        if (n == this.command_list.size()) {
            Util.out3.println("DeviceClass.command_handler(): command " + string + " not found");
            stringBuffer = new StringBuffer("Command ");
            stringBuffer.append(string);
            stringBuffer.append(" not found");
            Except.throw_exception("API_CommandNotFound", new String(stringBuffer), new String("DeviceClass.command_handler"));
        }
        Util.out4.println("Leaving DeviceClass.command_handler() method");
        return any2;
    }

    public abstract void command_factory();

    public void attribute_factory(Vector vector) throws DevFailed {
    }

    public void device_name_factory(Vector vector) {
    }

    public abstract void device_factory(String[] var1) throws DevFailed;

    public Vector get_command_list() {
        return this.command_list;
    }

    public Vector get_device_list() {
        return this.device_list;
    }

    public String get_name() {
        return this.name;
    }

    public String get_doc_url() {
        return this.doc_url;
    }

    public MultiClassAttribute get_class_attr() {
        return this.class_attr;
    }

    public DbClass get_db_class() {
        return this.db_class;
    }

    public Vector get_nodb_name_list() {
        return this.nodb_name_list;
    }
}

