/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoDs.Except;
import java.net.MalformedURLException;
import java.net.URL;

public class TangoUrl
implements ApiDefs {
    int protocol = 0;
    String host = null;
    String strport = null;
    int port = -1;
    String devname = null;
    boolean use_db = true;

    public TangoUrl(String string) throws DevFailed {
        try {
            int n;
            String string2 = new String(ApiDefs.protocol_name[0] + ":");
            int n2 = string.indexOf(string2);
            if (n2 >= 0) {
                this.protocol = 0;
            } else {
                string2 = new String(ApiDefs.protocol_name[1] + ":");
                n2 = string.indexOf(string2);
                if (n2 >= 0) {
                    this.protocol = 1;
                }
            }
            if (n2 < 0) {
                n = 0;
                n2 = 0;
            } else {
                n = ApiDefs.protocol_name[this.protocol].length() + 1;
            }
            String string3 = new String("http:" + string.substring(n2 + n));
            URL uRL = new URL(string3);
            this.host = uRL.getHost();
            this.port = uRL.getPort();
            this.strport = new String("" + this.port);
            this.devname = uRL.getFile();
            if (this.protocol == 0 && (this.host == null || this.host.length() == 0)) {
                this.setFromEnv();
            }
            if (this.protocol == 0 && this.port < 0) {
                Except.throw_exception("TangoApi_TANGO_HOST_NOT_SET", "Cannot parse port number", "TangoUrl()");
            }
            while ((n2 = this.devname.indexOf(47)) == 0) {
                this.devname = this.devname.substring(1);
            }
            if (this.devname.length() > 0) {
                int n3 = 0;
                int n4 = 0;
                while (n4 < this.devname.length()) {
                    if (this.devname.charAt(n4) == '/') {
                        ++n3;
                    }
                    ++n4;
                }
                if (n3 != 2) {
                    Except.throw_exception("TangoApi_BAD_DEVICE_NAME", new String("Device name (" + this.devname + ") wromg definition."), "TangoUrl()");
                }
            }
            if ((string2 = uRL.getRef()) != null && string2.indexOf("dbase=no") == 0) {
                this.use_db = false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Except.throw_exception("TangoApi_BAD_URL", "Bad url parameter", "TangoUrl()");
        }
    }

    public TangoUrl() throws DevFailed {
        this.setFromEnv();
    }

    private void setFromEnv() throws DevFailed {
        int n;
        this.host = System.getProperty("TANGO_HOST");
        if (this.host == null) {
            Except.throw_exception("TangoApi_TANGO_HOST_NOT_SET", "Property \"TANGO_HOST\" not exported", "TangoUrl()");
        }
        if ((n = this.host.indexOf(":")) < 0) {
            Except.throw_exception("TangoApi_TANGO_HOST_NOT_SET", "Unknown \"TANGO_HOST\" property " + this.host, "TangoUrl()");
        }
        this.strport = this.host.substring(n + 1);
        this.port = Integer.parseInt(this.strport);
        this.host = this.host.substring(0, n);
    }

    public void trace() {
        System.out.println("\tprotocol = " + ApiDefs.protocol_name[this.protocol]);
        if (this.host != null) {
            System.out.println("\thost name= " + this.host);
        }
        System.out.println("\tport num = " + this.strport);
        System.out.println("\tdevice   = " + this.devname);
        if (this.use_db) {
            System.out.println("\tuse database");
        } else {
            System.out.println("\tDo NOT use database");
        }
        System.out.println();
    }
}

